/*
 * Decompiled with CFR 0.152.
 */
package risingskills.gui;

import net.risingworld.api.Timer;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.style.Pivot;

public class LoggingProgressUI
extends UIElement
implements Runnable {
    private static final long serialVersionUID = 3333143736542091406L;
    private Timer hideLoggingProgressTimer;
    private Player owner;
    private boolean visible;
    private int damageCollected;
    private int healthTotal;
    private UIElement ProgressBarFill;

    public LoggingProgressUI(Player player) {
        this.owner = player;
        this.visible = true;
        this.setPosition(50.0f, 90.0f, true);
        this.setSize(30.0f, 0.5f, true);
        this.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.2f);
        this.setOpacity(1.0f);
        this.setPivot(Pivot.LowerCenter);
        this.ProgressBarFill = new UIElement();
        this.ProgressBarFill.setPosition(0.0f, 0.0f, true);
        this.ProgressBarFill.setPivot(Pivot.UpperLeft);
        this.ProgressBarFill.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.9f);
        this.ProgressBarFill.setOpacity(1.0f);
        this.ProgressBarFill.setSize(66.0f, 100.0f, true);
        this.addChild(this.ProgressBarFill);
    }

    @Override
    public void run() {
        this.visible = false;
        this.damageCollected = 0;
        this.healthTotal = 0;
        this.setVisible(this.visible);
        this.updateStyle();
        System.out.println("Hiding Logging Progress bar");
    }

    public void show(int damage_done, int total_damage) {
        if (this.healthTotal != total_damage) {
            this.damageCollected = 0;
            this.healthTotal = total_damage;
        }
        this.damageCollected += damage_done;
        int sizepercent = this.damageCollected * 100 / this.healthTotal;
        this.show(sizepercent);
    }

    public void show(int percent) {
        this.visible = true;
        this.setVisible(this.visible);
        if (this.hideLoggingProgressTimer != null && !this.hideLoggingProgressTimer.isKilled()) {
            this.hideLoggingProgressTimer.kill();
        }
        this.hideLoggingProgressTimer = new Timer(1.0f, 0.0f, 0, (Runnable)this);
        this.hideLoggingProgressTimer.start();
        this.ProgressBarFill.setSize((float)percent, 100.0f, true);
        this.ProgressBarFill.setVisible(this.visible);
        if (this.damageCollected > this.healthTotal) {
            System.out.println("Something is wrong let's hide the bar");
            this.visible = false;
            this.setVisible(this.visible);
        }
        this.updateStyle();
        System.out.println("Logging Progress bar show: " + this.damageCollected + "/" + this.healthTotal + " " + percent + "%");
    }
}

