/*
 * Decompiled with CFR 0.152.
 */
package risingskills;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.definitions.Crafting;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerGameObjectHitEvent;
import net.risingworld.api.events.player.PlayerHitItemEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryItemEditEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryToStorageEvent;
import net.risingworld.api.events.player.inventory.PlayerStorageMoveItemEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectInfoEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.events.player.world.PlayerHitObjectEvent;
import net.risingworld.api.events.player.world.PlayerHitTerrainEvent;
import net.risingworld.api.events.player.world.PlayerHitVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Key;
import org.yaml.snakeyaml.Yaml;
import risingskills.CraftingSpec;
import risingskills.gui.SkillUI;
import risingskills.hacks.LogfileParser;
import risingskills.skills.Carpentry;
import risingskills.skills.DefaultCraftingSkill;
import risingskills.skills.Herbalist;
import risingskills.skills.Logging;
import risingskills.skills.Mining;
import risingskills.skills.Smelting;

public class SkillManager
extends Plugin
implements Listener,
Runnable {
    private Timer saveTimer;
    private boolean immediateSave;
    private String PluginVersion = "0.0.2";
    private Database skilldatabase;
    private String SkillUI_Attr_Key = "RISING_SKILLS_UI";
    private HashMap<SkillEnum, Object> skills;
    private HashMap<String, HashMap<String, String>> i18nData;
    private DefaultCraftingSkill defaultcraftingskill;
    private LogfileParser logfileparser;

    public void persistPlayerData(Player player) {
        System.out.println(this.getName() + ":  persistPlayerData player: " + player.getName());
        String playerid = player.getUID();
        SkillEnum[] skillEnumArray = SkillEnum.values();
        int n = skillEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillEnum skill = skillEnumArray[n2];
            String skillid = skill.name();
            int experience = (Integer)player.getAttribute(skillid);
            try {
                String query = "UPDATE `SkillTable` SET `experience`=" + experience + " WHERE `playeruid`='" + playerid + "' AND `skillid`='" + skillid + "';";
                this.skilldatabase.execute(query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public Object getSkill(SkillEnum skill) {
        return this.skills.get((Object)skill);
    }

    @Override
    public void run() {
        this.persistSkillData();
    }

    public void onEnable() {
        System.out.println(this.getName() + " version " + this.PluginVersion + " initializing");
        this.initializeDatabase();
        if (Server.getType() == Server.Type.Singleplayer) {
            System.out.println(this.getName() + " Singleplayermode detected saving skill data immediately");
            this.immediateSave = true;
        } else {
            this.saveTimer = new Timer(60.0f, 60.0f, -1, (Runnable)this);
            this.saveTimer.start();
            this.immediateSave = false;
        }
        this.loadi18n();
        this.skills = new HashMap();
        Logging logging = new Logging(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_LOGGING, logging);
        this.registerEventListener(logging);
        Mining mining = new Mining(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_MINING, mining);
        this.registerEventListener(mining);
        Herbalist herbalist = new Herbalist(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_HERBALIST, herbalist);
        this.registerEventListener(herbalist);
        Carpentry carpentry = new Carpentry(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_CARPENTRY, carpentry);
        this.registerEventListener(carpentry);
        Smelting smelting = new Smelting(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_SMELTING, smelting);
        this.registerEventListener(smelting);
        if (!Files.exists(Paths.get(this.getPath() + "/disable_crafting_delay", new String[0]), new LinkOption[0])) {
            this.defaultcraftingskill = new DefaultCraftingSkill();
            this.skills.put(SkillEnum.RISING_SKILLS_CRAFTING_DEFAULT, this.defaultcraftingskill);
        }
        this.registerEventListener(this);
        String logfilepath = this.getPath() + "/../../Logs/Player.log";
        this.logfileparser = new LogfileParser(this, logfilepath);
    }

    public void onDisable() {
        if (this.skilldatabase != null) {
            this.persistSkillData();
            this.skilldatabase.close();
        } else {
            System.out.println("Rising Skills Plugin strange we didn't have a valid skill database");
        }
        System.out.println("Rising Skills Plugin disabled");
    }

    public String geti18nFormat(String key, Player player) {
        HashMap<String, String> languagedata;
        if (this.i18nData == null) {
            return "";
        }
        String language = player.getLanguage();
        if (!this.i18nData.containsKey(language)) {
            language = "default";
        }
        if ((languagedata = this.i18nData.get(language)) != null && languagedata.containsKey(key)) {
            return languagedata.get(key);
        }
        return "";
    }

    public void processLogfileParserEvent(LogfileParser.LogFileParserEvent event) {
        if (event instanceof LogfileParser.LogFileParserTransformEvent) {
            ((Smelting)this.skills.get((Object)SkillEnum.RISING_SKILLS_SMELTING)).processSkillEvent(event);
        } else if (event instanceof LogfileParser.LogFileParserPlaceEvent) {
            ((Smelting)this.skills.get((Object)SkillEnum.RISING_SKILLS_SMELTING)).processSkillEvent(event);
        } else if (event instanceof LogfileParser.LogFileParserFiretouchEvent) {
            ((Smelting)this.skills.get((Object)SkillEnum.RISING_SKILLS_SMELTING)).processSkillEvent(event);
        } else if (event instanceof LogfileParser.LogFileParserItemRemovedEvent) {
            ((Smelting)this.skills.get((Object)SkillEnum.RISING_SKILLS_SMELTING)).processSkillEvent(event);
        }
    }

    private void loadi18n() {
        String i18npath = this.getPath() + "/i18n.yml";
        this.i18nData = new HashMap();
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(i18npath, new String[0])));
            Map i18ndata = (Map)yaml.load(yamlraw);
            ArrayList languages = (ArrayList)i18ndata.get("languages");
            for (String language : languages) {
                HashMap languagedata = new HashMap();
                this.i18nData.put(language, languagedata);
            }
            ArrayList keys = (ArrayList)i18ndata.get("keys");
            int i = 0;
            while (i < keys.size()) {
                HashMap formats = (HashMap)keys.get(i);
                String keyname = (String)formats.get("name");
                for (String language : languages) {
                    if (formats.containsKey(language)) {
                        this.i18nData.get(language).put(keyname, (String)formats.get(language));
                        continue;
                    }
                    System.out.println(this.getName() + ": missing " + language + " translation for " + keyname);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println(this.getName() + ": \"" + i18npath + "\" isn't a valid yaml file for internationalization => no text available");
            return;
        }
        System.out.println(this.getName() + ": loaded " + this.i18nData.size() + " languages");
    }

    private void persistSkillData() {
        Player[] playerArray = Server.getAllPlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.persistPlayerData(player);
            ++n2;
        }
    }

    private void initializeDatabase() {
        this.skilldatabase = this.getSQLiteConnection(this.getPath() + "/skills.db");
        String query = "CREATE TABLE IF NOT EXISTS `SkillTable` (`playeruid` VARCHAR(255) NOT NULL, `skillid` VARCHAR(255) NOT NULL, `experience` BIGINT, PRIMARY KEY(playeruid, skillid));";
        this.skilldatabase.execute(query);
    }

    private int getDBAttributeData(String playerid, SkillEnum skill) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (ResultSet result = this.skilldatabase.executeQuery("SELECT * FROM `SkillTable` WHERE `playeruid` = '" + playerid + "' AND `skillid` = '" + skill.name() + "';");){
                if (result.next()) {
                    int experience = result.getInt("experience");
                    return experience;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String query = "INSERT INTO `SkillTable` (`playeruid`, `skillid`, `experience`) VALUES ('" + playerid + "', '" + skill.name() + "', 0);";
            this.skilldatabase.execute(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private void initializePlayerSkillAttributes(Player player, boolean initialize) {
        String playerid = player.getUID();
        SkillEnum[] skillEnumArray = SkillEnum.values();
        int n = skillEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillEnum skill = skillEnumArray[n2];
            if (initialize) {
                player.setAttribute(skill.name(), (Object)0);
            } else {
                try {
                    int experience = this.getDBAttributeData(playerid, skill);
                    player.setAttribute(skill.name(), (Object)experience);
                    System.out.println(this.getName() + ":  skill " + skill.name() + ": " + experience);
                }
                catch (Exception e) {
                    player.setAttribute(skill.name(), (Object)0);
                }
            }
            ++n2;
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String command = event.getCommand();
        System.out.println(this.getName() + ":  onPlayerCommand command: " + command);
        if (command == "/resetskills") {
            Player player = event.getPlayer();
            this.initializePlayerSkillAttributes(player, true);
        }
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        if (event.isNewPlayer()) {
            this.initializePlayerSkillAttributes(player, true);
        } else {
            this.initializePlayerSkillAttributes(player, false);
        }
        player.registerKeys(new Key[]{Key.J, Key.Escape});
        player.setListenForKeyInput(true);
        SkillUI skillui = new SkillUI(player, this);
        player.setAttribute(this.SkillUI_Attr_Key, (Object)skillui);
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent event) {
        System.out.println(this.getName() + ":  onKeyInput");
        if (event.isPressed()) {
            if (event.getKey() == Key.J) {
                Player player = event.getPlayer();
                SkillUI skillui = (SkillUI)player.getAttribute(this.SkillUI_Attr_Key);
                skillui.toggle();
            } else if (event.getKey() == Key.Escape) {
                Player player = event.getPlayer();
                SkillUI skillui = (SkillUI)player.getAttribute(this.SkillUI_Attr_Key);
                skillui.hide();
            }
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) {
        this.persistPlayerData(event.getPlayer());
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
    }

    @EventMethod
    public void onPlayerGameObjectHitEvent(PlayerGameObjectHitEvent event) {
        System.out.println(this.getName() + ":  onPlayerGameObjectHitEvent id: " + event.getGameObject().getID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitItemEvent(PlayerHitItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitItemEvent id:" + event.getItem().getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitObjectEvent(PlayerHitObjectEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitObjectEvent id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitTerrainEvent(PlayerHitTerrainEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitTerrainEven (main)");
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerPickupItemEvent (main)");
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerCraftItemEvent recipe category: " + event.getRecipe().category.name());
        if (this.defaultcraftingskill != null && !event.isCancelled()) {
            boolean isBlockRecipe;
            Crafting.Recipe recipe = event.getRecipe();
            boolean isConstructionRecipe = recipe.type == Crafting.RecipeType.Construction;
            boolean isClothingRecipe = recipe.type == Crafting.RecipeType.Clothing;
            boolean bl = isBlockRecipe = recipe.type == Crafting.RecipeType.Block;
            if (isConstructionRecipe || isClothingRecipe || isBlockRecipe) {
                return;
            }
            Player player = event.getPlayer();
            Item item = event.getItem();
            CraftingSpec defaultSpec = new CraftingSpec();
            defaultSpec.minSkill = 0;
            defaultSpec.optimalSkill = 0;
            defaultSpec.craftingTime = 1.0;
            event.setCancelled(true);
            defaultSpec.variant = item.getVariant();
            if (this.defaultcraftingskill.startCrafting(player, recipe)) {
                System.out.println(this.getName() + ":  onPlayerCraftItemEvent: " + recipe.name + "|" + item.getName() + " " + String.valueOf(item));
                this.defaultcraftingskill.startCraftingUI(player, this, SkillEnum.RISING_SKILLS_CRAFTING_DEFAULT, recipe, defaultSpec, event.getAmount());
            } else {
                String i18nformat = this.geti18nFormat("NOT_ENOUGH_RESOURCES_TO_CRAFT", player);
                player.sendTextMessage(String.format(i18nformat, recipe.name));
            }
        }
    }

    @EventMethod
    public void onPlayerHitVegetation(PlayerHitVegetationEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitVegetation id: " + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerRemoveVegetation(PlayerRemoveVegetationEvent event) {
        System.out.println(this.getName() + ":  onPlayerRemoveVegetation id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerRemoveObject(PlayerRemoveObjectEvent event) {
        System.out.println(this.getName() + ":  onPlayerRemoveObject id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerRemoveConstruction(PlayerRemoveConstructionEvent event) {
        System.out.println(this.getName() + ":  onPlayerRemoveConstruction id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerChangeObjectInfoEvent(PlayerChangeObjectInfoEvent event) {
        System.out.println(this.getName() + ":  onPlayerChangeObjectInfoEvent id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerChangeObjectStatusEvent(PlayerChangeObjectStatusEvent event) {
        System.out.println(this.getName() + ":  onPlayerChangeObjectStatusEvent id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerInventoryToStorageEvent(PlayerInventoryToStorageEvent event) {
        System.out.println(this.getName() + ":  onPlayerInventoryToStorageEvent (main)");
    }

    @EventMethod
    public void onPlayerStorageMoveItemEvent(PlayerStorageMoveItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerStorageMoveItemEvent (main)");
    }

    @EventMethod
    public void onPlayerInventoryItemEditEvent(PlayerInventoryItemEditEvent event) {
        System.out.println(this.getName() + ":  onPlayerInventoryItemEditEvent (main)");
    }

    public static enum SkillEnum {
        RISING_SKILLS_LOGGING,
        RISING_SKILLS_CARPENTRY,
        RISING_SKILLS_HERBALIST,
        RISING_SKILLS_MINING,
        RISING_SKILLS_SMELTING,
        RISING_SKILLS_SMITHING,
        RISING_SKILLS_CRAFTING_DEFAULT;

    }
}

