/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.objects.MetaObject;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.objects.world.ObjectElement;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import org.yaml.snakeyaml.Yaml;
import risingskills.SkillLevelHelper;
import risingskills.SkillManager;
import risingskills.hacks.LogfileParser;

public class Smelting
implements Listener {
    private String skillName;
    private boolean immediateSave;
    private SkillManager skillManager;
    private Map<String, Object> config;
    private Integer baseLearningAmount;
    SkillManager.SkillEnum skill;
    private int maxTrackedItems;
    private int minNotificationDistance;
    private int perLevelDistanceIncrease;
    private int detailedNotificationLevel;
    private LinkedList<ItemInFurnace> itemsInFurnace;
    private HashMap<Long, PickupItemAction> itemsPickedUp;
    private HashMap<Long, TransformAction> itemsTransformed;
    private HashMap<Long, Vector3f> knownFurnaceLocations;
    private HashMap<Long, completedCraft> finishedCrafts;

    public Smelting(SkillManager manager, boolean saveimmediatelly) {
        this.immediateSave = saveimmediatelly;
        this.skillManager = manager;
        this.skillName = "Smelting";
        this.skill = SkillManager.SkillEnum.RISING_SKILLS_SMELTING;
        String ymlpath = manager.getPath() + "/smelting.yml";
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(ymlpath, new String[0])));
            this.config = (Map)yaml.load(yamlraw);
            this.baseLearningAmount = (Integer)this.config.get("baseLearnAmount");
            this.minNotificationDistance = (Integer)this.config.get("minNotificationDistance");
            this.perLevelDistanceIncrease = (Integer)this.config.get("perLevelDistanceIncrease");
            this.detailedNotificationLevel = (Integer)this.config.get("detailedNotificationLevel");
            SkillLevelHelper.setBaseXPAmount(this.skill, (Integer)this.config.get("baseXPAmount"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println(manager.getName() + " " + this.skillName + ": \"" + ymlpath + "\" isn't a valid yaml file => no " + this.skillName + " skill available");
            return;
        }
        this.maxTrackedItems = 200;
        this.itemsInFurnace = new LinkedList();
        this.itemsPickedUp = new HashMap();
        this.itemsTransformed = new HashMap();
        this.knownFurnaceLocations = new HashMap();
        this.finishedCrafts = new HashMap();
    }

    public String getName() {
        return this.skillName;
    }

    private void processItemPlaced(LogfileParser.LogFileParserPlaceEvent event, long tsNow) {
        ItemInFurnace toadd = new ItemInFurnace();
        toadd.placedItem = event.placedName;
        toadd.timeStamp = event.timeStamp;
        toadd.metaObjectID = event.placedToMetaObjectID;
        Items.ItemDefinition itemDef = Definitions.getItemDefinition((String)event.placedName);
        if (itemDef.type != Items.Type.Ore) {
            return;
        }
        MetaObject furnace = World.getMetaObject((long)event.placedToMetaObjectID);
        if (furnace == null) {
            return;
        }
        ObjectElement furnace_obj = furnace.getRelatedObject();
        if (furnace_obj.getDefinition().type != Objects.Type.Furnace) {
            return;
        }
        this.knownFurnaceLocations.put(event.placedToMetaObjectID, furnace.getWorldPosition());
        Player player = Server.findNearestPlayer((Vector3f)furnace.getWorldPosition());
        toadd.playerName = player.getName();
        if (this.itemsInFurnace.size() >= this.maxTrackedItems) {
            this.removeOldestElementFromItemsInFurnace(tsNow, null);
        }
        this.itemsInFurnace.addLast(toadd);
    }

    private boolean removeOldestElementFromItemsInFurnace(long tsNow, ItemInFurnace toremove) {
        long oldest_element = tsNow;
        int oldest_element_index = -1;
        int index = 0;
        for (ItemInFurnace entry : this.itemsInFurnace) {
            if (toremove != null && (!entry.placedItem.equals(toremove.placedItem) || !entry.playerName.equals(toremove.playerName) || !entry.metaObjectID.equals(toremove.metaObjectID))) continue;
            if (entry.timeStamp < oldest_element) {
                oldest_element = entry.timeStamp;
                oldest_element_index = index;
            }
            ++index;
        }
        if (oldest_element_index >= 0) {
            this.itemsInFurnace.remove(oldest_element_index);
            return true;
        }
        return false;
    }

    private ArrayList<Long> getFurnaceInRange(Vector3f pos, float distance) {
        ArrayList<Long> retval = new ArrayList<Long>();
        for (Long key : this.knownFurnaceLocations.keySet()) {
            Vector3f furnacepos = this.knownFurnaceLocations.get(key);
            float distance_calculated = Utils.MathUtils.distance((float)pos.x, (float)pos.y, (float)pos.z, (float)furnacepos.x, (float)furnacepos.y, (float)furnacepos.z);
            if (!(distance_calculated < distance)) continue;
            retval.add(key);
        }
        return retval;
    }

    private ArrayList<ItemInFurnace> getItemsInFurnace(Long FurnaceID) {
        ArrayList<ItemInFurnace> retval = new ArrayList<ItemInFurnace>();
        for (ItemInFurnace element : this.itemsInFurnace) {
            if (!element.metaObjectID.equals(FurnaceID)) continue;
            retval.add(element);
        }
        return retval;
    }

    private void processItemRemoved(LogfileParser.LogFileParserItemRemovedEvent event, long tsNow) {
        MetaObject furnace = World.getMetaObject((long)event.removedFromMetaObjectID);
        if (furnace == null) {
            return;
        }
        ObjectElement furnace_obj = furnace.getRelatedObject();
        if (furnace_obj.getDefinition().type != Objects.Type.Furnace) {
            return;
        }
        Player player = null;
        if (!this.itemsPickedUp.containsKey(event.itemID)) {
            return;
        }
        player = Server.getPlayerByName((String)this.itemsPickedUp.get((Object)event.itemID).playerName);
        Player playerclose = Server.findNearestPlayer((Vector3f)furnace.getWorldPosition());
        if (!playerclose.getName().equals(player.getName())) {
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": sorry but player picking up (" + player.getName() + ") and players close (" + playerclose.getName() + ") to furnace aren't same can't process this");
        }
        Items.ItemDefinition itemDef = this.itemsPickedUp.get((Object)event.itemID).itemDef;
        if (itemDef.type != Items.Type.Ingot && itemDef.type == Items.Type.Ore) {
            ItemInFurnace toremove = new ItemInFurnace();
            toremove.metaObjectID = event.removedFromMetaObjectID;
            toremove.playerName = player.getName();
            toremove.placedItem = event.itemName;
            this.removeOldestElementFromItemsInFurnace(tsNow, toremove);
        }
        this.itemsPickedUp.remove(event.itemID);
    }

    private void processItemPickedUp(PlayerPickupItemEvent event, long tsNow) {
        Long itemID;
        for (Long key : this.itemsPickedUp.keySet()) {
            if (this.itemsPickedUp.get((Object)key).timeStamp + 10L >= tsNow) continue;
            this.itemsPickedUp.remove(key);
        }
        PickupItemAction toadd = new PickupItemAction();
        toadd.timeStamp = tsNow;
        toadd.playerName = event.getPlayer().getName();
        toadd.itemDef = event.getItem().getDefinition();
        if (toadd.itemDef.type == Items.Type.Ore) {
            this.itemsPickedUp.put(event.getItem().getGlobalID(), toadd);
        }
        if (this.finishedCrafts.containsKey(itemID = Long.valueOf(event.getItem().getGlobalID()))) {
            this.processCraftingComplete(event, this.finishedCrafts.get(itemID), tsNow);
            this.finishedCrafts.remove(itemID);
            event.setCancelled(true);
        }
    }

    private void processCraftingComplete(PlayerPickupItemEvent event, completedCraft craftresult, Long ts) {
        Player player = event.getPlayer();
        ItemInFurnace toremove = new ItemInFurnace();
        toremove.placedItem = craftresult.originName;
        toremove.playerName = player.getName();
        toremove.metaObjectID = craftresult.furnaceID;
        if (this.removeOldestElementFromItemsInFurnace(ts, toremove)) {
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": player: " + craftresult.playerName + " finished smelting " + craftresult.transformedName);
            int currentSkillExperience = (Integer)player.getAttribute(this.skill.name());
            int levelbefore = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
            int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, 0);
            player.setAttribute(this.skill.name(), (Object)(currentSkillExperience += experiencegain));
            int levelafter = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
            if (levelbefore < levelafter) {
                String i18nformat = this.skillManager.geti18nFormat("LEVEL_UP_MESSAGE", player);
                String i18nSkillname = this.skillManager.geti18nFormat(this.skill.name() + "_TITLE", player);
                player.sendTextMessage(String.format(i18nformat, i18nSkillname, levelafter));
            }
            if (player != null && this.immediateSave) {
                this.skillManager.persistPlayerData(player);
            }
        } else {
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": strange we did already find this item so why can't we remove it");
        }
    }

    private void processItemTransform(LogfileParser.LogFileParserTransformEvent event, Long tsNow) {
        for (Long key : this.itemsTransformed.keySet()) {
            if (this.itemsTransformed.get((Object)key).timeStamp + 10L >= tsNow) continue;
            this.itemsTransformed.remove(key);
        }
        TransformAction toadd = new TransformAction();
        toadd.originName = event.originalName;
        toadd.transformedName = event.transformedName;
        this.itemsTransformed.put(tsNow, toadd);
    }

    private TransformAction removeItemTransformEvent(String name) {
        Long oldestKey = 0L;
        for (Long key : this.itemsTransformed.keySet()) {
            if (!this.itemsTransformed.get((Object)key).transformedName.equals(name)) continue;
            if (oldestKey == 0L) {
                oldestKey = key;
                continue;
            }
            if (key >= oldestKey) continue;
            oldestKey = key;
        }
        if (oldestKey != 0L) {
            TransformAction retval = this.itemsTransformed.get(oldestKey);
            this.itemsTransformed.remove(oldestKey);
            return retval;
        }
        return null;
    }

    private void notifyPlayer(completedCraft craftresult) {
        int currentSkillExperience;
        int level;
        Player player = Server.getPlayerByName((String)craftresult.playerName);
        if (player == null) {
            return;
        }
        MetaObject furnace = World.getMetaObject((long)craftresult.furnaceID);
        if (furnace == null) {
            return;
        }
        Vector3f ppos = player.getPosition();
        Vector3f fpos = furnace.getWorldPosition();
        float distance = Utils.MathUtils.distance((float)ppos.x, (float)ppos.y, (float)ppos.z, (float)fpos.x, (float)fpos.y, (float)fpos.z);
        if (distance > (float)(this.minNotificationDistance + (level = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience = ((Integer)player.getAttribute(this.skill.name())).intValue())) * this.perLevelDistanceIncrease)) {
            return;
        }
        if (level > this.detailedNotificationLevel) {
            String i18nformat = this.skillManager.geti18nFormat("SMELTING_COMPLETED", player);
            player.sendTextMessage(String.format(i18nformat, new Object[0]));
        } else if (level > this.detailedNotificationLevel * 2) {
            String i18nformat = this.skillManager.geti18nFormat("SMELTING_COMPLETED_NAMED", player);
            player.sendTextMessage(String.format(i18nformat, craftresult.originName, craftresult.transformedName));
        }
    }

    private void processItemTouchesFireEvent(LogfileParser.LogFileParserFiretouchEvent event, Long ts) {
        TransformAction action = this.removeItemTransformEvent(event.itemName);
        if (action == null) {
            return;
        }
        WorldItem item = World.getItem((long)event.itemID);
        if (item == null) {
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": sorry but we didn't find this item in the world id: " + String.valueOf(event.itemID));
        }
        Items.ItemDefinition itemDef = item.getDefinition();
        System.out.println(this.skillManager.getName() + " " + this.skillName + ": ItemID: " + String.valueOf(event.itemID) + " is of type: " + itemDef.type.toString());
        if (itemDef.type == Items.Type.Ingot) {
            ArrayList<Long> furnaces_nearby = this.getFurnaceInRange(item.getPosition(), 2.0f);
            if (furnaces_nearby.size() == 1) {
                Long furnaceID = furnaces_nearby.get(0);
                ArrayList<ItemInFurnace> items = this.getItemsInFurnace(furnaceID);
                System.out.println(this.skillManager.getName() + " " + this.skillName + ": we do know about " + items.size() + " items in furnace");
                String playername = null;
                for (ItemInFurnace inFurnaceItem : items) {
                    if (!inFurnaceItem.placedItem.equals(action.originName)) continue;
                    playername = inFurnaceItem.playerName;
                    break;
                }
                if (playername != null) {
                    completedCraft finished = new completedCraft();
                    finished.timeStamp = ts;
                    finished.originName = action.originName;
                    finished.transformedName = event.itemName;
                    finished.furnaceID = furnaceID;
                    finished.playerName = playername;
                    finished.itemID = event.itemID;
                    this.notifyPlayer(finished);
                    this.finishedCrafts.put(finished.itemID, finished);
                }
            }
        } else {
            if (itemDef.type == Items.Type.Ore) {
                return;
            }
            return;
        }
    }

    public void processSkillEvent(Object event) {
        if (this.config == null) {
            return;
        }
        Object player = null;
        long ts = Instant.now().getEpochSecond();
        if (event instanceof LogfileParser.LogFileParserPlaceEvent) {
            this.processItemPlaced((LogfileParser.LogFileParserPlaceEvent)event, ts);
        }
        if (event instanceof LogfileParser.LogFileParserItemRemovedEvent) {
            this.processItemRemoved((LogfileParser.LogFileParserItemRemovedEvent)event, ts);
        }
        if (event instanceof PlayerPickupItemEvent) {
            this.processItemPickedUp((PlayerPickupItemEvent)event, ts);
        }
        if (event instanceof LogfileParser.LogFileParserTransformEvent) {
            this.processItemTransform((LogfileParser.LogFileParserTransformEvent)event, ts);
        }
        if (event instanceof LogfileParser.LogFileParserFiretouchEvent) {
            this.processItemTouchesFireEvent((LogfileParser.LogFileParserFiretouchEvent)event, ts);
        }
    }

    private int calculateExperience(int baseXP, int skilllevel, int resourcetier) {
        return baseXP;
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        this.processSkillEvent(event);
    }

    @EventMethod
    public void onPlayerChangeObjectStatusEvent(PlayerChangeObjectStatusEvent event) {
        this.processSkillEvent(event);
    }

    private class ItemInFurnace {
        public long timeStamp;
        public String playerName;
        public String placedItem;
        public Long metaObjectID;

        private ItemInFurnace() {
        }
    }

    private class PickupItemAction {
        public long timeStamp;
        public String playerName;
        public Items.ItemDefinition itemDef;

        private PickupItemAction() {
        }
    }

    private class TransformAction {
        public long timeStamp;
        public String originName;
        public String transformedName;

        private TransformAction() {
        }
    }

    private class completedCraft {
        public long timeStamp;
        public String originName;
        public String transformedName;
        public Long furnaceID;
        public String playerName;
        public Long itemID;

        private completedCraft() {
        }
    }
}

