/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Plants;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.world.PlayerHitVegetationEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.world.Plant;
import net.risingworld.api.ui.UIElement;
import org.yaml.snakeyaml.Yaml;
import risingskills.SkillLevelHelper;
import risingskills.SkillManager;
import risingskills.gui.LoggingProgressUI;

public class Logging
implements Listener {
    private String ProgressUIAttibuteID;
    private boolean immediateSave;
    private String skillName;
    private SkillManager skillManager;
    private Map<String, Object> config;
    private HashMap<String, Integer> hardness;
    private HashMap<String, Integer> toolTier;
    private Integer baseLearningAmount;
    private float lastToolTierWarning = 0.0f;
    SkillManager.SkillEnum skill;

    public Logging(SkillManager manager, boolean saveimmediatelly) {
        this.immediateSave = saveimmediatelly;
        this.skillManager = manager;
        this.ProgressUIAttibuteID = "RISING_SKILLS_LOGGING_PROGRESS";
        this.hardness = new HashMap();
        this.toolTier = new HashMap();
        String ymlpath = manager.getPath() + "/logging.yml";
        this.skillName = "Logging";
        this.skill = SkillManager.SkillEnum.RISING_SKILLS_LOGGING;
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(ymlpath, new String[0])));
            this.config = (Map)yaml.load(yamlraw);
            this.baseLearningAmount = (Integer)this.config.get("baseLearnAmount");
            SkillLevelHelper.setBaseXPAmount(this.skill, (Integer)this.config.get("baseXPAmount"));
            this.validateTreeTierConfiguration();
            this.validateToolTierConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println(manager.getName() + ": \"" + ymlpath + "\" isn't a valid yaml file => no logging skill available");
            return;
        }
    }

    public String getName() {
        return this.skillName;
    }

    private void validateTreeTierConfiguration() {
        Plants.PlantDefinition[] allplants;
        if (this.config == null) {
            return;
        }
        Object trees_obj = this.config.get("trees");
        if (trees_obj == null) {
            System.out.println("Missing tree configuration for logging skill");
            return;
        }
        try {
            ArrayList trees = (ArrayList)trees_obj;
            for (HashMap entry : trees) {
                String name = (String)entry.get("name");
                Integer hardnessvalue = (Integer)entry.get("hardness");
                if (name != null && hardnessvalue != null) {
                    this.hardness.put(name, hardnessvalue);
                    continue;
                }
                System.out.println(this.skillManager.getName() + " Logging: tree tier entry is malformed some trees might not be configured correctly");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception:" + e.getLocalizedMessage());
            System.out.println("Missing tree hardness array in yaml config");
        }
        Object trunk_obj = this.config.get("trunks");
        if (trunk_obj == null) {
            System.out.println("Missing trunks configuration for logging skill");
        } else {
            try {
                ArrayList trunks = (ArrayList)trunk_obj;
                for (HashMap entry : trunks) {
                    String name = (String)entry.get("name");
                    Integer hardnessvalue = (Integer)entry.get("hardness");
                    if (name != null && hardnessvalue != null) {
                        this.hardness.put(name, hardnessvalue);
                        continue;
                    }
                    System.out.println(this.skillManager.getName() + " Logging: trunk tier entry is malformed some trunks might not be configured correctly");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Exception:" + e.getLocalizedMessage());
                System.out.println("Missing trunks hardness array in yaml config");
            }
        }
        System.out.println(this.skillManager.getName() + " " + this.skillName + ": " + this.hardness.size() + " trees loaded");
        Plants.PlantDefinition[] plantDefinitionArray = allplants = Definitions.getAllPlantDefinitions();
        int n = allplants.length;
        int n2 = 0;
        while (n2 < n) {
            Plants.PlantDefinition plant = plantDefinitionArray[n2];
            if (plant != null && (plant.type == Plants.Type.Tree || plant.type == Plants.Type.FruitTree || plant.type == Plants.Type.Trunk)) {
                this.getTreeTier(plant);
            }
            ++n2;
        }
    }

    private int getTreeTier(Plants.PlantDefinition plant) {
        int hardnessvalue = 0;
        boolean found = false;
        for (String key : this.hardness.keySet()) {
            if (!plant.name.startsWith(key, 0)) continue;
            hardnessvalue = this.hardness.get(key);
            found = true;
            break;
        }
        if (!found) {
            System.out.println(this.skillManager.getName() + ": missing hardness configuration for " + plant.name);
        }
        int tier = Math.floorDiv(hardnessvalue, 500);
        if (plant.cangrow) {
            tier = Math.max(0, tier - 1);
        }
        return tier;
    }

    private int getToolTier(String name) {
        if (this.toolTier.containsKey(name)) {
            return this.toolTier.get(name);
        }
        return -1;
    }

    private void validateToolTierConfiguration() {
        if (this.config == null) {
            return;
        }
        Object tools_obj = this.config.get("tools");
        if (tools_obj == null) {
            System.out.println("Missing tree configuration for logging skill");
            return;
        }
        try {
            ArrayList tool_tiers = (ArrayList)tools_obj;
            for (HashMap entry : tool_tiers) {
                String name = (String)entry.get("name");
                if (name != null) {
                    Items.ItemDefinition item = Definitions.getItemDefinition((String)name);
                    if (item != null) {
                        int tier = (int)Math.floor(item.pickingInfo.damagetrees / 15);
                        this.toolTier.put(name, tier);
                        continue;
                    }
                    System.out.println(this.skillManager.getName() + " " + this.skillName + ": " + name + " is NOT a valid item");
                    continue;
                }
                System.out.println(this.skillManager.getName() + " Logging: tree tier entry is malformed some trees might not be configured correctly");
            }
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": " + tool_tiers.size() + " tools loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processLoggingEvent(PlayerHitVegetationEvent event) {
        LoggingProgressUI progressUI;
        if (this.config == null) {
            return;
        }
        Player player = event.getPlayer();
        Plants.PlantDefinition plant = event.getPlantDefinition();
        Integer TreeTier = this.getTreeTier(plant);
        Item equippedItem = player.getEquippedItem();
        Integer ToolTier = this.getToolTier(equippedItem.getName());
        int currentSkillExperience = (Integer)player.getAttribute(this.skill.name());
        int levelbefore = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
        short initial_damage = event.getDamage();
        int currentDurability = equippedItem.getDurability();
        Plant treeobject = World.getPlant((long)event.getGlobalID(), (int)event.getChunkPositionX(), (int)event.getChunkPositionY(), (int)event.getChunkPositionZ());
        short final_damage = this.calculateDamage(player, initial_damage, levelbefore, TreeTier, ToolTier, currentDurability);
        int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, TreeTier, (float)final_damage / (float)initial_damage);
        event.setDamage(final_damage);
        player.setAttribute(this.skill.name(), (Object)(currentSkillExperience += experiencegain));
        int levelafter = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
        System.out.println("Current tool durability: " + currentDurability);
        equippedItem.setDurability(currentDurability - this.calculateWear(levelbefore, TreeTier, ToolTier));
        if (levelbefore < levelafter) {
            String i18nformat = this.skillManager.geti18nFormat("LEVEL_UP_MESSAGE", player);
            String i18nSkillname = this.skillManager.geti18nFormat(this.skill.name() + "_TITLE", player);
            player.sendTextMessage(String.format(i18nformat, i18nSkillname, levelafter));
        }
        if (this.immediateSave) {
            this.skillManager.persistPlayerData(player);
        }
        if (!player.hasAttribute(this.ProgressUIAttibuteID)) {
            progressUI = new LoggingProgressUI(player);
            player.addUIElement((UIElement)progressUI);
            player.setAttribute(this.ProgressUIAttibuteID, (Object)progressUI);
        } else {
            progressUI = (LoggingProgressUI)player.getAttribute(this.ProgressUIAttibuteID);
        }
        short totalHealth = event.getPlantDefinition().strength;
        short currentHealth = (short)Math.max(0, treeobject.getStrength() - final_damage);
        progressUI.show(100 - currentHealth * 100 / totalHealth);
    }

    private int calculateExperience(int baseXP, int skilllevel, int planttier, double damagefraction) {
        int leveldiff = skilllevel - planttier;
        if (++leveldiff < 1) {
            leveldiff = 1;
        }
        int resultingxp = Math.floorDiv(baseXP, leveldiff);
        resultingxp = (int)((double)resultingxp * Math.min(damagefraction, 1.0));
        resultingxp = Math.max(1, resultingxp);
        return resultingxp;
    }

    private short calculateDamage(Player player, short basedamage, int skillevel, int planttier, int tooltier, int durability) {
        if (tooltier < 0) {
            return 0;
        }
        if (durability <= 0) {
            String i18nformat = this.skillManager.geti18nFormat("TOOL_BROKEN_WARNING_GENERIC", player);
            player.sendTextMessage(String.format(i18nformat, new Object[0]));
            return 0;
        }
        if (planttier > tooltier) {
            basedamage = (short)((double)basedamage * 0.5);
            float now = Server.getRunningTime();
            if (now > this.lastToolTierWarning + 10.0f) {
                String i18nformat = this.skillManager.geti18nFormat("TOOL_TIER_INSUFFICIENT", player);
                player.sendTextMessage(String.format(i18nformat, new Object[0]));
            }
            this.lastToolTierWarning = now;
        }
        if (tooltier == 0) {
            return basedamage;
        }
        int resulting_damage = basedamage + basedamage * (skillevel / (tooltier * 3));
        if (skillevel > 6 * tooltier) {
            resulting_damage = basedamage + (int)Math.floor((double)(2 * basedamage) + (double)(skillevel - 6) * 0.1 * (double)basedamage);
        }
        System.out.println("calculateDamage: base=" + basedamage + " calculated=" + resulting_damage + " skillevel=" + skillevel + " tooltier=" + tooltier);
        return (short)resulting_damage;
    }

    private int calculateWear(int skillevel, int planttier, int tooltier) {
        float wear = 2.0f;
        if (planttier > tooltier) {
            wear = (float)((double)wear * 1.5);
        }
        float skilllevelcorrection = (float)Math.pow(0.9, skillevel - planttier);
        if (skillevel > planttier) {
            wear *= skilllevelcorrection;
        }
        wear = Math.round(wear);
        System.out.println("Wear: skillcorrection=" + skilllevelcorrection + " planttier=" + planttier + " tooltier=" + tooltier + " wear=" + wear);
        return (int)wear;
    }

    @EventMethod
    public void onVegetationHit(PlayerHitVegetationEvent event) {
        Plants.PlantDefinition hitplant = event.getPlantDefinition();
        switch (hitplant.type) {
            case API: {
                break;
            }
            case Crop: {
                break;
            }
            case Plant: {
                break;
            }
            case Rock: {
                break;
            }
            case Tree: 
            case FruitTree: 
            case Trunk: {
                this.processLoggingEvent(event);
                break;
            }
            case Undefined: {
                break;
            }
            case Underwater: {
                break;
            }
            case Water: {
                break;
            }
        }
    }
}

