/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.definitions.Plants;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import org.yaml.snakeyaml.Yaml;
import risingskills.SkillLevelHelper;
import risingskills.SkillManager;

public class Herbalist
implements Listener {
    private String skillName;
    private boolean immediateSave;
    private SkillManager skillManager;
    private Map<String, Object> config;
    private Integer baseLearningAmount;
    private HashMap<String, Tool> tools;
    private Map<String, Herb> herbs;
    SkillManager.SkillEnum skill;

    public Herbalist(SkillManager manager, boolean saveimmediatelly) {
        this.immediateSave = saveimmediatelly;
        this.skillManager = manager;
        this.tools = new HashMap();
        this.herbs = new HashMap<String, Herb>();
        this.skillName = "herbalist";
        this.skill = SkillManager.SkillEnum.RISING_SKILLS_HERBALIST;
        String ymlpath = manager.getPath() + "/herbalist.yml";
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(ymlpath, new String[0])));
            this.config = (Map)yaml.load(yamlraw);
            this.baseLearningAmount = (Integer)this.config.get("baseLearnAmount");
            SkillLevelHelper.setBaseXPAmount(this.skill, (Integer)this.config.get("baseXPAmount"));
            this.validateResourceTierConfiguration();
            this.validateToolTierConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println(manager.getName() + " " + this.skillName + ": \"" + ymlpath + "\" isn't a valid yaml file => no " + this.skillName + " skill available");
            return;
        }
    }

    public String getName() {
        return this.skillName;
    }

    private void validateToolTierConfiguration() {
        if (this.config == null) {
            return;
        }
    }

    private void validateResourceTierConfiguration() {
        if (this.config == null) {
            return;
        }
    }

    private int getToolTier(String name, ToolType type) {
        if (this.tools.containsKey(name)) {
            Tool tool = this.tools.get(name);
            if (tool.toolTier.containsKey((Object)type)) {
                return tool.toolTier.get((Object)type);
            }
        }
        return -1;
    }

    private Herb getHerbDef(Plants.PlantDefinition herb) {
        return new Herb();
    }

    private void processSkillEvent(Event event) {
        if (this.config == null) {
            return;
        }
        Player player = null;
        int levelbefore = 0;
        int levelafter = 0;
        if (event instanceof PlayerRemoveVegetationEvent) {
            PlayerRemoveVegetationEvent evt = (PlayerRemoveVegetationEvent)event;
            player = evt.getPlayer();
            Item equippedItem = player.getEquippedItem();
            Plants.PlantDefinition resource = evt.getPlantDefinition();
            Herb herb = this.getHerbDef(resource);
            Integer ToolTier = this.getToolTier(equippedItem.getName(), herb.requiredTool);
            int currentSkillExperience = (Integer)player.getAttribute(this.skill.name());
            levelbefore = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
            if (!this.skillSufficient(levelbefore, equippedItem, resource)) {
                evt.setCancelled(true);
            } else {
                int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, herb.requiredSkillLevel, 1.0);
                player.setAttribute(this.skill.name(), (Object)(currentSkillExperience += experiencegain));
                if (this.isToolUsed(resource, equippedItem)) {
                    int currentDurability = equippedItem.getDurability();
                    equippedItem.setDurability(currentDurability - this.calculateWear(levelbefore, herb.requiredSkillLevel, ToolTier));
                }
                levelafter = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
            }
        }
        if (levelbefore < levelafter) {
            String i18nformat = this.skillManager.geti18nFormat("LEVEL_UP_MESSAGE", player);
            String i18nSkillname = this.skillManager.geti18nFormat(this.skill.name() + "_TITLE", player);
            player.sendTextMessage(String.format(i18nformat, i18nSkillname, levelafter));
        }
        if (player != null && this.immediateSave) {
            this.skillManager.persistPlayerData(player);
        }
    }

    private int calculateExperience(int baseXP, int skilllevel, int requiredskill, double damagefraction) {
        return 0;
    }

    private int calculateWear(int skillevel, int requiredskill, int tooltier) {
        float wear = 2.0f;
        if (requiredskill > tooltier) {
            wear = (float)((double)wear * 1.5);
        }
        float skilllevelcorrection = (float)Math.pow(0.9, skillevel - requiredskill);
        if (skillevel > requiredskill) {
            wear *= skilllevelcorrection;
        }
        wear = Math.round(wear);
        return (int)wear;
    }

    private boolean skillSufficient(int skillevel, Item equippedItem, Plants.PlantDefinition resource) {
        return false;
    }

    private boolean isToolUsed(Plants.PlantDefinition resource, Item equippedItem) {
        return false;
    }

    @EventMethod
    public void onRemoveVegetation(PlayerRemoveVegetationEvent event) {
        if (event.getPlantDefinition().type == Plants.Type.Plant) {
            this.processSkillEvent((Event)event);
        }
    }

    private class Herb {
        public String name;
        public ToolType requiredTool;
        public int requiredSkillLevel;

        private Herb() {
        }
    }

    private class Tool {
        public String name;
        public HashMap<ToolType, Integer> toolTier;

        private Tool() {
        }
    }

    private static enum ToolType {
        HerbShovel,
        Sickle;

    }
}

