/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import net.risingworld.api.definitions.Crafting;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import risingskills.CraftingSpec;
import risingskills.SkillManager;
import risingskills.gui.CraftingProgress;
import risingskills.skills.CraftingSkill;

public class DefaultCraftingSkill
implements CraftingSkill {
    public String ProgressUIAttibuteID = SkillManager.SkillEnum.RISING_SKILLS_CRAFTING_DEFAULT.name() + "_PROGRESS";

    @Override
    public boolean startCrafting(Player player, Crafting.Recipe recipe) {
        if (!this.hasAllIngredients(player, recipe.ingredients)) {
            return false;
        }
        this.takeAllIngredients(player, recipe.ingredients);
        return true;
    }

    @Override
    public void craftingFinished(Player player, Crafting.Recipe recipe, CraftingSpec spec) {
        boolean isBlockRecipe;
        boolean isConstructionRecipe = recipe.type == Crafting.RecipeType.Construction;
        boolean isObjectRecipe = recipe.type == Crafting.RecipeType.Object;
        boolean isClothingRecipe = recipe.type == Crafting.RecipeType.Clothing;
        boolean bl = isBlockRecipe = recipe.type == Crafting.RecipeType.Block;
        if (!isConstructionRecipe) {
            if (isObjectRecipe) {
                Objects.ObjectDefinition objdef = Definitions.getObjectDefinition((String)recipe.name);
                Item.ObjectItem objectItem = player.getInventory().addObjectItem(objdef.id, spec.variant, recipe.amount);
            } else if (!isClothingRecipe && !isBlockRecipe) {
                Item added = player.getInventory().addItem(recipe.itemDef.id, spec.variant, recipe.amount);
                added.setDurability(recipe.itemDef.durability);
            }
        }
    }

    private boolean hasAllIngredients(Player player, Crafting.Recipe.Ingredient[] ingredients) {
        Inventory inventory = player.getInventory();
        Item[] itemlist = inventory.getAllItems();
        Crafting.Recipe.Ingredient[] ingredientArray = ingredients;
        int n = ingredients.length;
        int n2 = 0;
        while (n2 < n) {
            Crafting.Recipe.Ingredient ingredient = ingredientArray[n2];
            int amountrequired = ingredient.count;
            Item[] itemArray = itemlist;
            int n3 = itemlist.length;
            int n4 = 0;
            while (n4 < n3) {
                Item elem = itemArray[n4];
                if (elem != null) {
                    if (ingredient.itemDef != null) {
                        if (elem.getTypeID() == ingredient.itemDef.id) {
                            amountrequired -= Math.min(elem.getStack(), amountrequired);
                        }
                    } else if (ingredient.group != null && elem.getDefinition().group == ingredient.group) {
                        amountrequired -= Math.min(elem.getStack(), amountrequired);
                    }
                    if (amountrequired <= 0) break;
                }
                ++n4;
            }
            if (amountrequired > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void takeAllIngredients(Player player, Crafting.Recipe.Ingredient[] ingredients) {
        Inventory inventory = player.getInventory();
        Crafting.Recipe.Ingredient[] ingredientArray = ingredients;
        int n = ingredients.length;
        int n2 = 0;
        while (n2 < n) {
            Crafting.Recipe.Ingredient ingredient = ingredientArray[n2];
            int amountrequired = ingredient.count;
            int maxloop = 1000;
            while (amountrequired > 0 && maxloop > 0) {
                int slot;
                Item inslot;
                int canbetaken;
                int slot2;
                Item inslot2;
                int canbetaken2;
                Item inslot3;
                int slot3;
                int n3;
                int n4;
                int[] nArray;
                int[] slots;
                if (ingredient.itemDef != null) {
                    nArray = slots = inventory.findAllItems(ingredient.itemDef.id, -1, Inventory.SlotType.Inventory);
                    n4 = slots.length;
                    n3 = 0;
                    while (n3 < n4) {
                        slot3 = nArray[n3];
                        inslot3 = inventory.getItem(slot3, Inventory.SlotType.Inventory);
                        if (inslot3 != null) {
                            canbetaken2 = Math.min(amountrequired, inslot3.getStack());
                            inventory.removeItem(slot3, Inventory.SlotType.Inventory, canbetaken2);
                            amountrequired -= canbetaken2;
                        }
                        ++n3;
                    }
                }
                if (ingredient.itemDef != null) {
                    nArray = slots = inventory.findAllItems(ingredient.itemDef.id, -1, Inventory.SlotType.Quickslot);
                    n4 = slots.length;
                    n3 = 0;
                    while (n3 < n4) {
                        slot3 = nArray[n3];
                        inslot3 = inventory.getItem(slot3, Inventory.SlotType.Inventory);
                        if (inslot3 != null) {
                            canbetaken2 = Math.min(amountrequired, inslot3.getStack());
                            inventory.removeItem(slot3, Inventory.SlotType.Inventory, canbetaken2);
                            amountrequired -= canbetaken2;
                        }
                        ++n3;
                    }
                }
                if (ingredient.group != null && (inslot2 = inventory.getItem(slot2 = inventory.findItemByGroup(ingredient.group, Inventory.SlotType.Inventory), Inventory.SlotType.Inventory)) != null) {
                    canbetaken = Math.min(amountrequired, inslot2.getStack());
                    inventory.removeItem(slot2, Inventory.SlotType.Inventory, canbetaken);
                    amountrequired -= canbetaken;
                }
                if (ingredient.group == null || (inslot = inventory.getItem(slot = inventory.findItemByGroup(ingredient.group, Inventory.SlotType.Quickslot), Inventory.SlotType.Inventory)) == null) continue;
                canbetaken = Math.min(amountrequired, inslot.getStack());
                inventory.removeItem(slot, Inventory.SlotType.Inventory, canbetaken);
                amountrequired -= canbetaken;
            }
            if (maxloop <= 0) {
                System.out.println("takeAllIngredients wasn't able to fetch all required ingredients that's not supposed to happen!");
            }
            ++n2;
        }
    }

    @Override
    public void startCraftingUI(Player player, SkillManager manager, SkillManager.SkillEnum skill, Crafting.Recipe recipe, CraftingSpec spec, int amount) {
        CraftingProgress progressUI;
        if (!player.hasAttribute(this.ProgressUIAttibuteID)) {
            progressUI = new CraftingProgress(player, manager, skill);
            player.addUIElement((UIElement)progressUI);
            player.setAttribute(this.ProgressUIAttibuteID, (Object)progressUI);
        } else {
            progressUI = (CraftingProgress)player.getAttribute(this.ProgressUIAttibuteID);
        }
        if (!progressUI.isActive()) {
            progressUI.startCrafting(recipe, spec, amount);
        }
    }
}

