/*
 * Decompiled with CFR 0.152.
 */
package risingskills.hacks;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import net.risingworld.api.Timer;
import risingskills.SkillManager;

public class LogfileParser
implements Runnable {
    private Timer readTimer;
    private String fileName;
    private int bytesRead;
    private SkillManager skillManager;

    public LogfileParser(SkillManager manager, String filename) {
        this.fileName = filename;
        this.skillManager = manager;
        this.readTimer = new Timer(1.0f, 0.0f, -1, (Runnable)this);
        this.readTimer.start();
    }

    @Override
    public void run() {
        long ts = Instant.now().getEpochSecond();
        try {
            String data;
            RandomAccessFile logfile = new RandomAccessFile(this.fileName, "r");
            logfile.seek(this.bytesRead);
            while ((data = logfile.readLine()) != null) {
                LogFileParserEvent event;
                String[] parts;
                if (data.startsWith("Transform item")) {
                    parts = data.split(" ", 10);
                    event = new LogFileParserTransformEvent();
                    event.transformedName = parts[4];
                    event.originalName = parts[2];
                    event.timeStamp = ts;
                    this.skillManager.processLogfileParserEvent(event);
                }
                if (data.startsWith("CLIENT: Place item")) {
                    parts = data.split(" ", 10);
                    event = new LogFileParserPlaceEvent();
                    ((LogFileParserPlaceEvent)event).placedName = parts[3];
                    ((LogFileParserPlaceEvent)event).placedToName = parts[6];
                    ((LogFileParserPlaceEvent)event).placedToMetaObjectID = Long.valueOf(parts[7].substring(1, parts[7].length() - 1));
                    ((LogFileParserPlaceEvent)event).timeStamp = ts;
                    this.skillManager.processLogfileParserEvent(event);
                }
                if (data.contains("TOUCHES FIRE!")) {
                    parts = data.split(" ", 10);
                    event = new LogFileParserFiretouchEvent();
                    ((LogFileParserFiretouchEvent)event).itemName = parts[1];
                    ((LogFileParserFiretouchEvent)event).itemID = Long.valueOf(parts[2].substring(1, parts[2].length() - 1));
                    ((LogFileParserFiretouchEvent)event).timeStamp = ts;
                    this.skillManager.processLogfileParserEvent(event);
                }
                if (data.startsWith("Remove item") && data.contains("from meta object")) {
                    parts = data.split(" ", 10);
                    event = new LogFileParserItemRemovedEvent();
                    ((LogFileParserItemRemovedEvent)event).itemName = parts[2];
                    ((LogFileParserItemRemovedEvent)event).removedFromMetaObjectID = Long.valueOf(parts[7]);
                    ((LogFileParserItemRemovedEvent)event).itemID = Long.valueOf(parts[3].substring(1, parts[3].length() - 1));
                    ((LogFileParserItemRemovedEvent)event).timeStamp = ts;
                    this.skillManager.processLogfileParserEvent(event);
                }
                this.bytesRead += data.length();
            }
            logfile.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class LogFileParserEvent {
        public long timeStamp;
    }

    public class LogFileParserFiretouchEvent
    extends LogFileParserEvent {
        public String itemName;
        public Long itemID;
    }

    public class LogFileParserItemRemovedEvent
    extends LogFileParserEvent {
        public String itemName;
        public Long itemID;
        public Long removedFromMetaObjectID;
    }

    public class LogFileParserPlaceEvent
    extends LogFileParserEvent {
        public String placedName;
        public String placedToName;
        public Long placedToMetaObjectID;
    }

    public class LogFileParserTransformEvent
    extends LogFileParserEvent {
        public String originalName;
        public String transformedName;
    }
}

