/*
 * Decompiled with CFR 0.152.
 */
package risingskills.gui;

import net.risingworld.api.Timer;
import net.risingworld.api.definitions.Crafting;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.Pivot;
import risingskills.CraftingSpec;
import risingskills.SkillManager;
import risingskills.skills.DefaultCraftingSkill;

public class CraftingProgress
extends UIElement
implements Runnable {
    private static final long serialVersionUID = 425295557261685367L;
    private Timer updateProgressTimer;
    private Player owner;
    private boolean visible;
    private SkillManager skillManager;
    private SkillManager.SkillEnum connectedSkill;
    private UIElement ProgressBarFill;
    private UILabel progressBarText;
    private CraftingSpec activeCraftingSpec;
    private Crafting.Recipe activeRecipe;
    private Integer amountToCraft;
    private float timePassed;

    public CraftingProgress(Player player, SkillManager manager, SkillManager.SkillEnum skill) {
        this.owner = player;
        this.skillManager = manager;
        this.connectedSkill = skill;
        this.visible = false;
        this.setVisible(false);
        this.setPosition(48.0f, 85.0f, true);
        this.setSize(30.0f, 2.0f, true);
        this.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.3f);
        this.setOpacity(1.0f);
        this.setPivot(Pivot.LowerCenter);
        this.ProgressBarFill = new UIElement();
        this.ProgressBarFill.setPosition(0.0f, 0.0f, true);
        this.ProgressBarFill.setPivot(Pivot.UpperLeft);
        this.ProgressBarFill.setBackgroundColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.ProgressBarFill.setOpacity(0.5f);
        this.addChild(this.ProgressBarFill);
        this.progressBarText = new UILabel();
        this.progressBarText.setPosition(50.0f, 100.0f, true);
        this.progressBarText.setPivot(Pivot.LowerCenter);
        this.progressBarText.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.progressBarText.setFont(Font.DefaultBold);
        this.progressBarText.setOpacity(1.0f);
        this.addChild((UIElement)this.progressBarText);
    }

    private void restartTimer(float time) {
        if (this.updateProgressTimer != null && !this.updateProgressTimer.isKilled()) {
            this.updateProgressTimer.kill();
        }
        this.updateProgressTimer = new Timer(time, 0.0f, 0, (Runnable)this);
        this.updateProgressTimer.start();
    }

    @Override
    public void run() {
        float sleeptime = this.getSleepTime();
        this.timePassed += sleeptime;
        if ((double)this.timePassed < this.activeCraftingSpec.craftingTime) {
            this.restartTimer(sleeptime);
            int percent = (int)Math.round((double)((int)(this.timePassed * 100.0f)) / this.activeCraftingSpec.craftingTime);
            this.ProgressBarFill.setSize((float)percent, 100.0f, true);
            this.updateStyle();
        } else {
            if (this.activeCraftingSpec == null || this.activeRecipe == null) {
                this.amountToCraft = 0;
                return;
            }
            this.amountToCraft = this.amountToCraft - 1;
            DefaultCraftingSkill craftingskill = (DefaultCraftingSkill)this.skillManager.getSkill(this.connectedSkill);
            craftingskill.craftingFinished(this.owner, this.activeRecipe, this.activeCraftingSpec);
            if (this.amountToCraft > 0) {
                if (!craftingskill.startCrafting(this.owner, this.activeRecipe)) {
                    String i18nformat = this.skillManager.geti18nFormat("NOT_ENOUGH_RESOURCES_TO_CRAFT", this.owner);
                    this.owner.sendTextMessage(String.format(i18nformat, this.activeRecipe.name));
                    this.amountToCraft = 0;
                } else {
                    this.timePassed = 0.0f;
                    this.restartTimer(sleeptime);
                    this.ProgressBarFill.setSize(100.0f, 100.0f, true);
                    this.updateStyle();
                }
            }
            if (this.amountToCraft <= 0) {
                this.visible = false;
                this.setVisible(this.visible);
                this.updateStyle();
            }
        }
    }

    public void startCrafting(Crafting.Recipe recipe, CraftingSpec spec, Integer amount) {
        this.activeCraftingSpec = spec;
        this.activeRecipe = recipe;
        this.amountToCraft = amount;
        this.timePassed = 0.0f;
        this.show();
    }

    public void abortCrafting() {
        this.activeRecipe = null;
        this.activeCraftingSpec = null;
        this.amountToCraft = null;
        if (this.updateProgressTimer != null && !this.updateProgressTimer.isKilled()) {
            this.updateProgressTimer.kill();
        }
        this.visible = false;
        this.setVisible(this.visible);
        this.updateStyle();
    }

    public boolean isActive() {
        return this.visible;
    }

    private float getSleepTime() {
        Double sleeptime = this.activeCraftingSpec.craftingTime / 20.0;
        return (float)Math.min(0.2, sleeptime);
    }

    private void show() {
        this.visible = true;
        this.setVisible(this.visible);
        this.progressBarText.setText(this.activeRecipe.name);
        float sleeptime = this.getSleepTime();
        if (this.updateProgressTimer != null && !this.updateProgressTimer.isKilled()) {
            this.updateProgressTimer.kill();
        }
        this.updateProgressTimer = new Timer(sleeptime, 0.0f, 0, (Runnable)this);
        this.updateProgressTimer.start();
        this.ProgressBarFill.setSize(0.0f, 100.0f, true);
        this.ProgressBarFill.setVisible(this.visible);
        this.updateStyle();
    }
}

