/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.risingworld.api.definitions.Crafting;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Key;
import org.yaml.snakeyaml.Yaml;
import risingskills.CraftingSpec;
import risingskills.SkillLevelHelper;
import risingskills.SkillManager;
import risingskills.gui.CraftingProgress;
import risingskills.skills.DefaultCraftingSkill;

public class Carpentry
extends DefaultCraftingSkill
implements Listener {
    private String skillName;
    private boolean immediateSave;
    private SkillManager skillManager;
    private Map<String, Object> config;
    private Integer baseLearningAmount;
    private HashMap<String, CraftingSpec> craftingSpecs;
    SkillManager.SkillEnum skill;

    public Carpentry(SkillManager manager, boolean saveimmediatelly) {
        this.immediateSave = saveimmediatelly;
        this.skillManager = manager;
        this.ProgressUIAttibuteID = "RISING_SKILLS_CARPENTRY_PROGRESS";
        this.skillName = "Carpentry";
        this.skill = SkillManager.SkillEnum.RISING_SKILLS_CARPENTRY;
        this.craftingSpecs = new HashMap();
        String ymlpath = manager.getPath() + "/carpentry.yml";
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(ymlpath, new String[0])));
            this.config = (Map)yaml.load(yamlraw);
            this.baseLearningAmount = (Integer)this.config.get("baseLearnAmount");
            SkillLevelHelper.setBaseXPAmount(this.skill, (Integer)this.config.get("baseXPAmount"));
            this.validateSpecConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.out.println(manager.getName() + " " + this.skillName + ": \"" + ymlpath + "\" isn't a valid yaml file => no " + this.skillName + " skill available");
            return;
        }
    }

    public String getName() {
        return this.skillName;
    }

    @Override
    public void craftingFinished(Player player, Crafting.Recipe recipe, CraftingSpec spec) {
        int currentSkillExperience = (Integer)player.getAttribute(this.skill.name());
        int levelbefore = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
        int perElementExperience = this.calculateExperience(this.baseLearningAmount, levelbefore, recipe, spec) / recipe.amount;
        int i = 0;
        while (i < recipe.amount) {
            if (this.getCraftingSuccessfull(levelbefore, spec)) {
                Random rand = new Random();
                int variantselected = rand.nextInt(recipe.itemDef.variations + 1);
                player.getInventory().addItem(recipe.itemDef.id, recipe.itemDef.variants[variantselected].variant, 1);
                currentSkillExperience += perElementExperience;
            }
            ++i;
        }
        player.setAttribute(this.skill.name(), (Object)currentSkillExperience);
        int levelafter = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
        if (this.immediateSave) {
            this.skillManager.persistPlayerData(player);
        }
        if (levelbefore < levelafter) {
            String i18nformat = this.skillManager.geti18nFormat("LEVEL_UP_MESSAGE", player);
            String i18nSkillname = this.skillManager.geti18nFormat(this.skill.name() + "_TITLE", player);
            player.sendTextMessage(String.format(i18nformat, i18nSkillname, levelafter));
        }
    }

    private void validateSpecConfiguration() {
        if (this.config == null) {
            return;
        }
        Object craftingspecs_obj = this.config.get("craftingspecs");
        if (craftingspecs_obj == null) {
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": missing configuration");
            return;
        }
        try {
            ArrayList specs = (ArrayList)craftingspecs_obj;
            for (HashMap entry : specs) {
                String categoryname2;
                CraftingSpec toadd = new CraftingSpec();
                toadd.name = (String)entry.get("name");
                toadd.minSkill = (Integer)entry.get("minSkillLevel");
                toadd.optimalSkill = (Integer)entry.get("optimalSkillLevel");
                toadd.craftingTime = (Double)entry.get("craftingTime");
                try {
                    categoryname2 = (String)entry.get("category");
                    toadd.category = Crafting.Category.valueOf((String)categoryname2);
                }
                catch (Exception categoryname2) {
                    // empty catch block
                }
                try {
                    categoryname2 = (String)entry.get("subCategory");
                    toadd.subCategory = Crafting.SubCategory.valueOf((String)categoryname2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (toadd.name != null && toadd.minSkill != null && toadd.optimalSkill != null && toadd.craftingTime != null) {
                    this.craftingSpecs.put(toadd.name, toadd);
                    continue;
                }
                System.out.println(this.skillManager.getName() + " " + this.skillName + " invalid crafting spec in config ignored");
            }
            System.out.println(this.skillManager.getName() + " " + this.skillName + ": " + this.craftingSpecs.size() + " crafting specs loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception:" + e.getLocalizedMessage());
        }
    }

    private void processSkillEvent(PlayerCraftItemEvent event) {
        if (this.config == null) {
            return;
        }
        Player player = event.getPlayer();
        Crafting.Recipe recipe = event.getRecipe();
        CraftingSpec spec = this.getCraftingSpec(event.getItem(), recipe);
        int amount = event.getAmount();
        if (spec == null) {
            return;
        }
        if (spec.category != null && spec.category != recipe.category) {
            return;
        }
        if (spec.subCategory != null && spec.subCategory != recipe.subCategory) {
            return;
        }
        event.setCancelled(true);
        int currentSkillExperience = (Integer)player.getAttribute(this.skill.name());
        int levelbefore = SkillLevelHelper.getSkillLevel(this.skill, currentSkillExperience);
        if (levelbefore < spec.minSkill) {
            String i18nformat = this.skillManager.geti18nFormat("SKILL_LEVEL_INSUFFICIENT", player);
            String i18nSkillname = this.skillManager.geti18nFormat(this.skill.name() + "_TITLE", player);
            player.sendTextMessage(String.format(i18nformat, i18nSkillname));
            return;
        }
        if (this.startCrafting(player, recipe)) {
            this.startCraftingUI(player, this.skillManager, this.skill, recipe, spec, amount);
        } else {
            String i18nformat = this.skillManager.geti18nFormat("NOT_ENOUGH_RESOURCES_TO_CRAFT", player);
            player.sendTextMessage(String.format(i18nformat, recipe.name));
        }
    }

    private CraftingSpec getCraftingSpec(Item itemcrafted, Crafting.Recipe recipeused) {
        if (this.craftingSpecs.containsKey(recipeused.name)) {
            return this.craftingSpecs.get(recipeused.name);
        }
        return null;
    }

    private int calculateExperience(int baseXP, int skilllevel, Crafting.Recipe recipeused, CraftingSpec specused) {
        int leveldiff = skilllevel - specused.optimalSkill;
        if (leveldiff <= 0) {
            return baseXP;
        }
        int resultingxp = Math.floorDiv(baseXP, leveldiff);
        resultingxp = Math.max(1, resultingxp);
        return resultingxp;
    }

    private boolean getCraftingSuccessfull(int skilllevel, CraftingSpec spec) {
        int successchance = 500;
        Random rand = new Random();
        return rand.nextInt(1000) < (successchance += (skilllevel - spec.minSkill) * 500 / (spec.optimalSkill - spec.minSkill));
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        this.processSkillEvent(event);
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent event) {
        if (event.getKey() == Key.Escape && event.getPlayer().hasAttribute(this.ProgressUIAttibuteID)) {
            CraftingProgress progressUI = (CraftingProgress)event.getPlayer().getAttribute(this.ProgressUIAttibuteID);
            progressUI.abortCrafting();
        }
    }
}

