/*
 * Decompiled with CFR 0.152.
 */
package risingskills.gui;

import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.Pivot;

public class SkillUIElement {
    private UIElement container;
    private UILabel SkillText;
    private UILabel SkillLevel;
    private UILabel SkillProgress;
    private UIElement SkillProgressBarTotal;
    private UIElement SkillProgressBarFill;
    private String SkillDescription;
    private String SkillName;
    int xpInNextLevel;
    int xpForNextLevel;

    public SkillUIElement(String name, String description) {
        this.SkillName = name;
        this.SkillDescription = description;
        this.container = new UIElement();
        this.SkillText = new UILabel(this.SkillName);
        this.SkillLevel = new UILabel("0");
        this.SkillProgress = new UILabel("(0/0)");
        this.SkillProgressBarTotal = new UIElement();
        this.SkillProgressBarFill = new UIElement();
        this.container.setPivot(Pivot.UpperLeft);
        this.container.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.005f);
        this.container.setOpacity(1.0f);
        this.SkillText.setPosition(2.0f, 0.0f, true);
        this.SkillText.setPivot(Pivot.UpperLeft);
        this.SkillText.setFontSize(20.0f);
        this.SkillText.setFont(Font.DefaultBold);
        this.SkillLevel.setPosition(98.0f, 0.0f, true);
        this.SkillLevel.setPivot(Pivot.UpperRight);
        this.SkillLevel.setFontSize(20.0f);
        this.SkillLevel.setFont(Font.DefaultBold);
        this.SkillProgress.setPosition(50.0f, 100.0f, true);
        this.SkillProgress.setPivot(Pivot.LowerCenter);
        this.SkillProgressBarTotal.setPosition(50.0f, 67.0f, true);
        this.SkillProgressBarTotal.setSize(96.0f, 10.0f, true);
        this.SkillProgressBarTotal.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.1f);
        this.SkillProgressBarTotal.setOpacity(1.0f);
        this.SkillProgressBarTotal.setPivot(Pivot.LowerCenter);
        this.SkillProgressBarFill.setPosition(0.0f, 0.0f, true);
        this.SkillProgressBarFill.setPivot(Pivot.UpperLeft);
        this.SkillProgressBarFill.setBackgroundColor(1.0f, 1.0f, 1.0f, 0.9f);
        this.SkillProgressBarFill.setOpacity(1.0f);
        this.SkillProgressBarFill.setSize(66.0f, 100.0f, true);
        this.container.addChild((UIElement)this.SkillText);
        this.container.addChild((UIElement)this.SkillLevel);
        this.container.addChild(this.SkillProgressBarTotal);
        this.SkillProgressBarTotal.addChild(this.SkillProgressBarFill);
        this.container.addChild((UIElement)this.SkillProgress);
        this.container.updateStyle();
    }

    public UIElement uiElement() {
        return this.container;
    }

    public void setWidth(float width) {
        this.container.setSize(width, 50.0f, false);
        this.container.updateStyle();
    }

    public void setPosition(float x, float y, boolean percent) {
        this.container.setPosition(x, y, percent);
    }

    public void setLevel(int toset) {
        this.SkillLevel.setText(String.valueOf(toset));
    }

    public void setXPForLevel(int toset) {
        this.xpForNextLevel = toset;
        this.SkillProgress.setText("(" + String.valueOf(this.xpInNextLevel) + "/" + this.xpForNextLevel + ")");
        this.drawProgressBar();
    }

    public void setXPInLevel(int toset) {
        this.xpInNextLevel = toset;
        this.SkillProgress.setText("(" + String.valueOf(this.xpInNextLevel) + "/" + this.xpForNextLevel + ")");
        this.drawProgressBar();
    }

    private void drawProgressBar() {
        this.SkillProgressBarFill.setSize((float)(100 * this.xpInNextLevel / this.xpForNextLevel), 100.0f, true);
        this.container.updateStyle();
    }
}

