/*
 * Decompiled with CFR 0.152.
 */
package risingskills.skills;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Plants;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerHitTerrainEvent;
import net.risingworld.api.events.player.world.PlayerHitVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.world.ChunkPart;
import net.risingworld.api.ui.UIElement;
import org.yaml.snakeyaml.Yaml;
import risingskills.SkillHelper;
import risingskills.SkillLevelHelper;
import risingskills.SkillManager;
import risingskills.gui.LoggingProgressUI;

public class Mining
implements Listener {
    private String ProgressUIAttibuteID;
    private boolean immediateSave;
    private SkillManager skillManager;
    private Map<String, Object> config;
    private HashMap<String, Tool> tools;
    private Integer baseLearningAmount;
    private HashMap<String, Integer> rockhardness;
    private HashMap<String, Terrain> terrains;
    private float lastToolTierWarning = 0.0f;

    public Mining(SkillManager manager, boolean saveimmediatelly) {
        this.immediateSave = saveimmediatelly;
        this.skillManager = manager;
        this.ProgressUIAttibuteID = "RISING_SKILLS_MINING_PROGRESS";
        this.rockhardness = new HashMap();
        this.tools = new HashMap();
        this.terrains = new HashMap();
        String path = manager.getPath() + "/mining.yml";
        try {
            Yaml yaml = new Yaml();
            String yamlraw = new String(Files.readAllBytes(Paths.get(path, new String[0])));
            this.config = (Map)yaml.load(yamlraw);
            this.baseLearningAmount = (Integer)this.config.get("baseLearnAmount");
            SkillLevelHelper.setBaseXPAmount(SkillManager.SkillEnum.RISING_SKILLS_MINING, (Integer)this.config.get("baseXPAmount"));
            this.validateToolTierConfiguration();
            this.validateRockTierConfiguration();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println(this.skillManager.getName() + ": \"" + path + "\" isn't a valid json file => no mining skill available");
        }
    }

    @EventMethod
    public void onPlayerHitTerrainEvent(PlayerHitTerrainEvent event) {
        this.processMiningEvent((Event)event);
    }

    @EventMethod
    public void onPlayerDestroyTerrainEvent(PlayerDestroyTerrainEvent event) {
        this.processMiningEvent((Event)event);
    }

    @EventMethod
    public void onVegetationHit(PlayerHitVegetationEvent event) {
        this.processMiningEvent((Event)event);
    }

    @EventMethod
    public void onRemoveVegetation(PlayerRemoveVegetationEvent event) {
        this.processMiningEvent((Event)event);
    }

    private int calculateExperience(int baseXP, int skilllevel, int interactionobject, double damagefraction) {
        int leveldiff = skilllevel - interactionobject;
        if (++leveldiff < 1) {
            leveldiff = 1;
        }
        int resultingxp = Math.floorDiv(baseXP, leveldiff);
        resultingxp = (int)((double)resultingxp * Math.min(damagefraction, 1.0));
        resultingxp = Math.max(1, resultingxp);
        return resultingxp;
    }

    private short calculateDamage(Player player, short basedamage, int skillevel, int objecttier, int tooltier, int durability) {
        if (tooltier < 0) {
            return 0;
        }
        if (durability <= 0) {
            String tool_broken_warning = "Tool broken";
            player.sendTextMessage(tool_broken_warning);
            return 0;
        }
        if (objecttier > tooltier) {
            basedamage = (short)((double)basedamage * 0.5);
            float now = Server.getRunningTime();
            if (now > this.lastToolTierWarning + 10.0f) {
                String tool_tier_warning = "This tool tier isn't suitable for the rock";
                player.sendTextMessage(tool_tier_warning);
            }
            this.lastToolTierWarning = now;
        }
        if (tooltier == 0) {
            return basedamage;
        }
        int resulting_damage = basedamage * (skillevel / (tooltier * 3));
        if (skillevel > 6 * tooltier) {
            resulting_damage = (int)Math.floor((double)(2 * basedamage) + (double)(skillevel - 6) * 0.1 * (double)basedamage);
        }
        return (short)resulting_damage;
    }

    private int calculateWear(int skillevel, int obecttier, int tooltier) {
        float wear = 2.0f;
        if (obecttier > tooltier) {
            wear = (float)((double)wear * 1.5);
        }
        float skilllevelcorrection = (float)Math.pow(0.9, skillevel - obecttier);
        if (skillevel > obecttier) {
            wear *= skilllevelcorrection;
        }
        wear = Math.round(wear);
        System.out.println("Wear: skillcorrection=" + skilllevelcorrection + " objecttier=" + obecttier + " tooltier=" + tooltier + " wear=" + wear);
        return (int)wear;
    }

    private int getToolTier(String name, TerrainType type) {
        if (type == TerrainType.Sand) {
            if (this.tools.containsKey(name)) {
                return this.tools.get((Object)"name").shoveltier;
            }
        } else if (type == TerrainType.Solid && this.tools.containsKey(name)) {
            return this.tools.get((Object)name).pickaxetier;
        }
        return -1;
    }

    private int getObjectTier(Plants.PlantDefinition object) {
        int hardnessvalue = 0;
        boolean found = false;
        for (String key : this.rockhardness.keySet()) {
            if (!object.name.startsWith(key, 0)) continue;
            hardnessvalue = this.rockhardness.get(key);
            found = true;
            break;
        }
        if (!found) {
            System.out.println(this.skillManager.getName() + ": missing hardness configuration for " + object.name);
        }
        int tier = Math.floorDiv(hardnessvalue, 500);
        return tier;
    }

    private int getTerrainTier(String terrainname) {
        int hardnessvalue = 0;
        boolean found = false;
        for (String key : this.terrains.keySet()) {
            if (!terrainname.startsWith(key, 0)) continue;
            hardnessvalue = this.terrains.get((Object)key).hardness;
            found = true;
            break;
        }
        if (!found) {
            System.out.println(this.skillManager.getName() + ": missing hardness configuration for terrain " + terrainname);
        }
        int tier = Math.floorDiv(hardnessvalue, 500);
        return tier;
    }

    private TerrainType getTerrainType(String terrainname) {
        if (this.terrains.containsKey(terrainname)) {
            return this.terrains.get((Object)terrainname).type;
        }
        return TerrainType.Unnown;
    }

    private boolean isPickableMineral(Plants.PlantDefinition object) {
        return this.rockhardness.containsKey(object.name);
    }

    private void processMiningEvent(Event event) {
        if (this.config == null) {
            return;
        }
        SkillManager.SkillEnum skill = SkillManager.SkillEnum.RISING_SKILLS_MINING;
        int levelbefore = 0;
        int levelafter = 0;
        Player player = null;
        if (event instanceof PlayerHitTerrainEvent) {
            PlayerHitTerrainEvent evt = (PlayerHitTerrainEvent)event;
            ChunkPart chunkpart = World.getChunkPart((int)evt.getChunkPositionX(), (int)evt.getChunkPositionY(), (int)evt.getChunkPositionZ());
            int terrainID = chunkpart.getTerrainID(evt.getBlockPositionX(), evt.getBlockPositionY(), evt.getBlockPositionZ());
            Plants.TerrainMaterialType materialtype = Plants.TerrainMaterialType.get((int)terrainID);
            TerrainType terraintype = this.getTerrainType(materialtype.name());
            int terrainttier = this.getTerrainTier(materialtype.name());
            player = evt.getPlayer();
            int currentSkillExperience = (Integer)player.getAttribute(skill.name());
            levelbefore = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            Item tool = player.getEquippedItem();
            short initial_damage = evt.getDamage();
            int currentDurability = tool.getDurability();
            int tooltier = this.getToolTier(tool.getName(), terraintype);
            short final_damage = this.calculateDamage(player, initial_damage, levelbefore, terrainttier, tooltier, currentDurability);
            int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, terrainttier, (float)final_damage / (float)initial_damage);
            player.setAttribute(skill.name(), (Object)(currentSkillExperience += experiencegain));
            levelafter = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            int wear = this.calculateWear(levelbefore, terrainttier, tooltier);
            tool.setDurability(currentDurability - wear);
            System.out.println(this.skillManager.getName() + ":  Mining processMiningEvent hit terrain. TerrainID: " + terrainID + " mt: " + materialtype.name());
        } else if (event instanceof PlayerDestroyTerrainEvent) {
            PlayerDestroyTerrainEvent evt = (PlayerDestroyTerrainEvent)event;
            ChunkPart chunkpart = World.getChunkPart((int)evt.getChunkPositionX(), (int)evt.getChunkPositionY(), (int)evt.getChunkPositionZ());
            int prevterrainID = chunkpart.getTerrainID(evt.getBlockPositionX(), evt.getBlockPositionY(), evt.getBlockPositionZ());
            Plants.TerrainMaterialType prevmaterialtype = Plants.TerrainMaterialType.get((int)prevterrainID);
            System.out.println(this.skillManager.getName() + ":  Mining processMiningEvent destroy terrain. prev: TerrainID: " + prevterrainID + " mt: " + prevmaterialtype.name());
            int terrainID = evt.getTerrainID();
            Plants.TerrainMaterialType materialtype = Plants.TerrainMaterialType.get((int)terrainID);
            TerrainType terraintype = this.getTerrainType(materialtype.name());
            int terrainttier = this.getTerrainTier(materialtype.name());
            player = evt.getPlayer();
            int currentSkillExperience = (Integer)player.getAttribute(skill.name());
            levelbefore = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            Item tool = player.getEquippedItem();
            int currentDurability = tool.getDurability();
            int tooltier = this.getToolTier(tool.getName(), terraintype);
            int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, terrainttier, 1.0);
            player.setAttribute(skill.name(), (Object)(currentSkillExperience += experiencegain));
            levelafter = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            int wear = this.calculateWear(levelbefore, terrainttier, tooltier);
            tool.setDurability(currentDurability - wear);
        } else if (event instanceof PlayerHitVegetationEvent) {
            LoggingProgressUI progressUI;
            PlayerHitVegetationEvent evt = (PlayerHitVegetationEvent)event;
            player = evt.getPlayer();
            int currentSkillExperience = (Integer)player.getAttribute(skill.name());
            levelbefore = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            Plants.PlantDefinition def = evt.getPlantDefinition();
            Item tool = player.getEquippedItem();
            short initial_damage = evt.getDamage();
            int currentDurability = tool.getDurability();
            int tooltier = this.getToolTier(tool.getName(), TerrainType.Solid);
            int objecttier = this.getObjectTier(def);
            short final_damage = this.calculateDamage(player, initial_damage, levelbefore, objecttier, tooltier, currentDurability);
            int experiencegain = this.calculateExperience(this.baseLearningAmount, levelbefore, objecttier, (float)final_damage / (float)initial_damage);
            evt.setDamage(final_damage);
            player.setAttribute(skill.name(), (Object)(currentSkillExperience += experiencegain));
            levelafter = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            int wear = this.calculateWear(levelbefore, objecttier, tooltier);
            tool.setDurability(currentDurability - wear);
            if (!player.hasAttribute(this.ProgressUIAttibuteID)) {
                progressUI = new LoggingProgressUI(player);
                player.addUIElement((UIElement)progressUI);
                player.setAttribute(this.ProgressUIAttibuteID, (Object)progressUI);
            } else {
                progressUI = (LoggingProgressUI)player.getAttribute(this.ProgressUIAttibuteID);
            }
            short totalhealth = evt.getPlantDefinition().strength;
            progressUI.show(final_damage, totalhealth);
        } else if (event instanceof PlayerRemoveVegetationEvent) {
            PlayerRemoveVegetationEvent evt = (PlayerRemoveVegetationEvent)event;
            player = evt.getPlayer();
            int currentSkillExperience = (Integer)player.getAttribute(skill.name());
            levelbefore = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
            Plants.PlantDefinition def = evt.getPlantDefinition();
            if (this.isPickableMineral(def)) {
                int experiencegain = 1;
                player.setAttribute(skill.name(), (Object)(currentSkillExperience += experiencegain));
            } else {
                System.out.println(this.skillManager.getName() + ":  " + def.name + " isn't relevant for mining skill");
            }
            levelafter = SkillLevelHelper.getSkillLevel(skill, currentSkillExperience);
        } else {
            System.out.println(this.skillManager.getName() + ":  Mining processMiningEvent called with unexpected event");
        }
        if (player != null && levelbefore < levelafter) {
            player.sendTextMessage("Mining Skill is now at level " + levelafter);
        }
        if (player != null && this.immediateSave) {
            this.skillManager.persistPlayerData(player);
        }
    }

    private void validateToolTierConfiguration() {
        if (this.config == null) {
            return;
        }
        Object tools_obj = this.config.get("tools");
        if (tools_obj == null) {
            System.out.println("Missing tool configuration for mining skill");
            return;
        }
        try {
            ArrayList tool_tiers = (ArrayList)tools_obj;
            for (HashMap entry : tool_tiers) {
                String name = (String)entry.get("name");
                Integer shoveltier = (Integer)entry.get("shovel");
                Integer pickaxetier = (Integer)entry.get("pickaxe");
                if (name != null && shoveltier != null && pickaxetier != null) {
                    if (!SkillHelper.itemExists(name)) {
                        System.out.println(name + ": shoveltier " + String.valueOf(shoveltier) + " pickaxetier " + String.valueOf(pickaxetier) + " is NOT a valid item");
                        continue;
                    }
                    System.out.println(name + ": shoveltier " + String.valueOf(shoveltier) + " pickaxetier " + String.valueOf(pickaxetier));
                    Tool toadd = new Tool();
                    toadd.name = name;
                    toadd.shoveltier = shoveltier;
                    toadd.pickaxetier = pickaxetier;
                    this.tools.put(name, toadd);
                    continue;
                }
                System.out.println(this.skillManager.getName() + " Mining: tool tier entry is malformed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateRockTierConfiguration() {
        if (this.config == null) {
            return;
        }
        Object rocks_obj = this.config.get("rocks");
        if (rocks_obj == null) {
            System.out.println(this.skillManager.getName() + " Mining: missing rock configuration for mining skill");
            return;
        }
        try {
            ArrayList rocks = (ArrayList)rocks_obj;
            for (HashMap entry : rocks) {
                String name = (String)entry.get("name");
                Integer hardnessvalue = (Integer)entry.get("hardness");
                if (name != null && hardnessvalue != null) {
                    this.rockhardness.put(name, hardnessvalue);
                    System.out.println(this.skillManager.getName() + " Mining: adding hardness for: " + name + "=" + String.valueOf(hardnessvalue));
                    continue;
                }
                System.out.println(this.skillManager.getName() + " Mining: rock tier entry is malformed some rocks might not be configured correctly");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception:" + e.getLocalizedMessage());
            System.out.println("Missing rock hardness array in yaml config");
        }
        Plants.PlantDefinition[] allrocks = Definitions.getAllPlantDefinitions();
        Plants.PlantDefinition[] plantDefinitionArray = allrocks;
        int name = allrocks.length;
        int n = 0;
        while (n < name) {
            Plants.PlantDefinition plant = plantDefinitionArray[n];
            if (plant != null && plant.type == Plants.Type.Rock) {
                this.getObjectTier(plant);
            }
            ++n;
        }
        Object terrains_obj = this.config.get("terrain");
        if (terrains_obj == null) {
            System.out.println(this.skillManager.getName() + " Mining: missing terrain configuration for mining skill");
            return;
        }
        try {
            HashMap terrainconfig = (HashMap)terrains_obj;
            for (String terraintype : terrainconfig.keySet()) {
                Terrain toadd;
                Integer hardnessvalue;
                String terrainname;
                HashMap entry;
                int i;
                ArrayList terrainlist = (ArrayList)terrainconfig.get(terraintype);
                if (terrainlist == null) continue;
                if (terraintype.equals("sands")) {
                    i = 0;
                    while (i < terrainlist.size()) {
                        entry = (HashMap)terrainlist.get(i);
                        terrainname = (String)entry.get("name");
                        hardnessvalue = (Integer)entry.get("hardness");
                        if (terrainname != null && hardnessvalue != null) {
                            toadd = new Terrain();
                            toadd.name = terrainname;
                            toadd.hardness = hardnessvalue;
                            toadd.type = TerrainType.Sand;
                            System.out.println(this.skillManager.getName() + " Adding sand terraintype: " + terrainname);
                            this.terrains.put(terrainname, toadd);
                        }
                        ++i;
                    }
                    continue;
                }
                if (terraintype.equals("solids")) {
                    i = 0;
                    while (i < terrainlist.size()) {
                        entry = (HashMap)terrainlist.get(i);
                        terrainname = (String)entry.get("name");
                        hardnessvalue = (Integer)entry.get("hardness");
                        if (terrainname != null && hardnessvalue != null) {
                            toadd = new Terrain();
                            toadd.name = terrainname;
                            toadd.hardness = hardnessvalue;
                            toadd.type = TerrainType.Solid;
                            System.out.println(this.skillManager.getName() + " Adding solid terraintype: " + terrainname);
                            this.terrains.put(terrainname, toadd);
                        }
                        ++i;
                    }
                    continue;
                }
                System.out.println(this.skillManager.getName() + " Mining: unknown terrain config element: " + terraintype);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception:" + e.getLocalizedMessage());
            System.out.println("Missing terrain config element in yaml config");
        }
    }

    private class Terrain {
        public String name;
        public int hardness;
        public TerrainType type;

        private Terrain() {
        }
    }

    private static enum TerrainType {
        Unnown,
        Solid,
        Sand;

    }

    private class Tool {
        public String name;
        public int shoveltier;
        public int pickaxetier;

        private Tool() {
        }
    }
}

