/*
 * Decompiled with CFR 0.152.
 */
package risingskills;

import java.sql.ResultSet;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerGameObjectHitEvent;
import net.risingworld.api.events.player.PlayerHitItemEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.world.PlayerHitObjectEvent;
import net.risingworld.api.events.player.world.PlayerHitTerrainEvent;
import net.risingworld.api.events.player.world.PlayerHitVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Key;
import risingskills.gui.SkillUI;
import risingskills.skills.Logging;
import risingskills.skills.Mining;

public class SkillManager
extends Plugin
implements Listener,
Runnable {
    private Timer saveTimer;
    private boolean immediateSave;
    private String PluginVersion = "0.0.1";
    private Database skilldatabase;
    private String SkillUI_Attr_Key = "RISING_SKILLS_UI";
    private HashMap<String, Object> skills;

    @Override
    public void run() {
        this.persistSkillData();
    }

    public void persistPlayerData(Player player) {
        String playerid = player.getUID();
        SkillEnum[] skillEnumArray = SkillEnum.values();
        int n = skillEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            String query;
            SkillEnum skill = skillEnumArray[n2];
            String skillid = skill.name();
            int experience = (Integer)player.getAttribute(skillid);
            boolean done = false;
            try {
                query = "UPDATE `SkillTable` SET `experience`=" + experience + " WHERE `playeruid`='" + playerid + "' AND `skillid`='" + skillid + "';";
                this.skilldatabase.execute(query);
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!done) {
                try {
                    query = "INSERT INTO `SkillTable` (`playeruid`, `skillid`, `experience`) VALUES ('" + playerid + "', '" + skillid + "', " + experience + ");";
                    this.skilldatabase.execute(query);
                    done = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void persistSkillData() {
        Player[] playerArray = Server.getAllPlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.persistPlayerData(player);
            ++n2;
        }
    }

    private void initializeDatabase() {
        this.skilldatabase = this.getSQLiteConnection(this.getPath() + "/skills.db");
        String query = "CREATE TABLE IF NOT EXISTS `SkillTable` (`playeruid` VARCHAR(255) NOT NULL, `skillid` VARCHAR(255) NOT NULL, `experience` BIGINT, PRIMARY KEY(playeruid, skillid));";
        this.skilldatabase.execute(query);
    }

    public void onEnable() {
        this.initializeDatabase();
        if (Server.getType() == Server.Type.Singleplayer) {
            this.immediateSave = true;
        } else {
            this.saveTimer = new Timer(60.0f, 60.0f, -1, (Runnable)this);
            this.saveTimer.start();
            this.immediateSave = false;
        }
        this.registerEventListener(this);
        this.skills = new HashMap();
        Logging logging = new Logging(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_LOGGING.name(), logging);
        this.registerEventListener(logging);
        Mining mining = new Mining(this, this.immediateSave);
        this.skills.put(SkillEnum.RISING_SKILLS_MINING.name(), mining);
        this.registerEventListener(mining);
        System.out.println(this.getName() + " version " + this.PluginVersion + " has been initialized");
    }

    public void onDisable() {
        if (this.skilldatabase != null) {
            this.persistSkillData();
            this.skilldatabase.close();
        } else {
            System.out.println("Rising Skills Plugin strange we didn't have a valid skill database");
        }
        System.out.println("Rising Skills Plugin disabled");
    }

    private int getDBAttributeData(String playerid, SkillEnum skill) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet result = this.skilldatabase.executeQuery("SELECT * FROM `SkillTable` WHERE `playeruid` = '" + playerid + "' AND `skillid` = '" + skill.name() + "';");){
                if (result.next()) {
                    int experience = result.getInt("experience");
                    return experience;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private void initializePlayerSkillAttributes(Player player, boolean initialize) {
        String playerid = player.getUID();
        SkillEnum[] skillEnumArray = SkillEnum.values();
        int n = skillEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SkillEnum skill = skillEnumArray[n2];
            if (initialize) {
                player.setAttribute(skill.name(), (Object)0);
            } else {
                try {
                    int experience = this.getDBAttributeData(playerid, skill);
                    player.setAttribute(skill.name(), (Object)experience);
                    System.out.println(this.getName() + ":  skill " + skill.name() + ": " + experience);
                }
                catch (Exception e) {
                    player.setAttribute(skill.name(), (Object)0);
                }
            }
            ++n2;
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String command = event.getCommand();
        System.out.println(this.getName() + ":  onPlayerCommand command: " + command);
        if (command == "/resetskills") {
            Player player = event.getPlayer();
            this.initializePlayerSkillAttributes(player, true);
        }
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        if (event.isNewPlayer()) {
            this.initializePlayerSkillAttributes(player, true);
        } else {
            this.initializePlayerSkillAttributes(player, false);
        }
        player.registerKeys(new Key[]{Key.J, Key.Escape});
        player.setListenForKeyInput(true);
        SkillUI skillui = new SkillUI(player);
        player.setAttribute(this.SkillUI_Attr_Key, (Object)skillui);
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent event) {
        System.out.println(this.getName() + ":  onKeyInput");
        if (event.isPressed()) {
            if (event.getKey() == Key.J) {
                Player player = event.getPlayer();
                SkillUI skillui = (SkillUI)player.getAttribute(this.SkillUI_Attr_Key);
                skillui.toggle();
            } else if (event.getKey() == Key.Escape) {
                Player player = event.getPlayer();
                SkillUI skillui = (SkillUI)player.getAttribute(this.SkillUI_Attr_Key);
                skillui.hide();
            }
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) {
        this.persistPlayerData(event.getPlayer());
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
    }

    @EventMethod
    public void onPlayerGameObjectHitEvent(PlayerGameObjectHitEvent event) {
        System.out.println(this.getName() + ":  onPlayerGameObjectHitEvent id: " + event.getGameObject().getID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitItemEvent(PlayerHitItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitItemEvent id:" + event.getItem().getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitObjectEvent(PlayerHitObjectEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitObjectEvent id:" + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onPlayerHitTerrainEvent(PlayerHitTerrainEvent event) {
        System.out.println(this.getName() + ":  onPlayerHitTerrainEven (main)");
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerPickupItemEvent (main)");
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        System.out.println(this.getName() + ":  onPlayerCraftItemEvent (main)");
    }

    @EventMethod
    public void onVegetationHit(PlayerHitVegetationEvent event) {
        System.out.println(this.getName() + ":  onVegetationHit id: " + event.getGlobalID() + " (main)");
    }

    @EventMethod
    public void onRemoveVegetation(PlayerRemoveVegetationEvent event) {
        System.out.println(this.getName() + ":  onPlayerRemoveVegetationEvent id:" + event.getGlobalID() + " (main)");
    }

    public static enum SkillEnum {
        RISING_SKILLS_LOGGING,
        RISING_SKILLS_CARPENTRY,
        RISING_SKILLS_HERBALIST,
        RISING_SKILLS_MINING,
        RISING_SKILLS_SMELTING,
        RISING_SKILLS_SMITHING;

    }
}

