/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.jiw.unity.runtime.PluginManager;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.DatabaseType;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteOpenMode;

public final class SQLiteDatabase
implements Database {
    private int pluginID;
    private String path;
    private Connection connection;
    private Statement statement;

    public SQLiteDatabase(int pluginID, String database) throws SQLException {
        SQLiteConfig config = new SQLiteConfig();
        config.setOpenMode(SQLiteOpenMode.FULLMUTEX);
        config.setPragma(SQLiteConfig.Pragma.JOURNAL_MODE, "WAL");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + (database == null ? "" : database), config.toProperties());
        this.statement = this.connection.createStatement();
        this.path = database;
        this.pluginID = pluginID;
    }

    public DatabaseType getType() {
        return DatabaseType.SQLite;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void execute(String sql) {
        try {
            this.statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeUpdate(String sql) {
        try {
            this.statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.statement.executeQuery(sql);
    }

    public void close() {
        try {
            this.statement.close();
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PluginManager.cachedSQLDatabases.remove(SQLiteDatabase.getIdentifier(this.pluginID, this.path));
    }

    public static String getIdentifier(int pluginID, String database) {
        return pluginID + "::" + database;
    }
}

