/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIMesh;
import net.risingworld.api.ui.UIPainter2D;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.UITarget;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.Style;
import net.risingworld.api.ui.style.StyleColor;
import net.risingworld.api.ui.style.StyleEnum;
import net.risingworld.api.ui.style.StyleFloat;
import net.risingworld.api.ui.style.StyleImage;
import net.risingworld.api.ui.style.StyleLength;
import net.risingworld.api.ui.style.StyleTransformOrigin;
import net.risingworld.api.ui.style.StyleTranslate;

public final class PluginUIManager {
    public static final ArrayList<Field> StyleFields = new ArrayList(64);

    public static boolean registerUIElementForPlayer(UIElement element, UITarget target, int playerDbID, boolean sendPacket) {
        return PluginUIManager.registerUIElementForPlayer(element, String.valueOf(target.ordinal()), playerDbID, sendPacket);
    }

    public static boolean registerUIElementForPlayer(UIElement element, String target, int playerDbID, boolean sendPacket) {
        boolean result = PluginUIManager.registerUIElementForPlayer(element, element.getID(), element.getParent() == null ? -1 : element.getParent().getID(), target, playerDbID, sendPacket);
        List childs = element.getChilds();
        if (childs != null) {
            for (UIElement child : childs) {
                PluginUIManager.registerUIElementForPlayer(child, target, playerDbID, sendPacket);
            }
        }
        return result;
    }

    private static native boolean registerUIElementForPlayer(UIElement var0, int var1, int var2, String var3, int var4, boolean var5);

    public static boolean unregisterUIElementForPlayer(UIElement element, int playerDbID, boolean sendPacket) {
        List childs = element.getChilds();
        if (childs != null) {
            for (UIElement child : childs) {
                PluginUIManager.unregisterUIElementForPlayer(child, playerDbID, sendPacket);
            }
        }
        return PluginUIManager.unregisterUIElementForPlayer(element.getID(), playerDbID, sendPacket);
    }

    private static native boolean unregisterUIElementForPlayer(int var0, int var1, boolean var2);

    public static void unregisterUIElementForAllPlayers(UIElement element, boolean sendPacket) {
        List childs = element.getChilds();
        if (childs != null) {
            for (UIElement child : childs) {
                PluginUIManager.unregisterUIElementForAllPlayers(child, sendPacket);
            }
        }
        PluginUIManager.unregisterUIElementForAllPlayers(element.getID(), sendPacket);
    }

    private static native void unregisterUIElementForAllPlayers(int var0, boolean var1);

    public static native UIElement[] getAllUIElementsOfPlayer(int var0, boolean var1);

    public static void updateHierarchy(UIElement parent, UIElement newChild) {
        PluginUIManager.updateHierarchy(parent, parent.getID(), newChild, newChild.getID());
        List childs = newChild.getChilds();
        if (childs != null) {
            for (UIElement child : childs) {
                PluginUIManager.updateHierarchy(newChild, child);
            }
        }
    }

    private static native void updateHierarchy(UIElement var0, int var1, UIElement var2, int var3);

    public static native void updateUIElementClickable(UIElement var0, int var1, boolean var2);

    public static native void updateUIElementPickable(UIElement var0, int var1, boolean var2);

    public static native void updateUIElementStyle(UIElement var0, int var1, Style var2, Style var3);

    public static native void updateUIElementStyleSheets(UIElement var0, int var1);

    public static native void updateUILabel(UILabel var0, int var1);

    public static native void updateUIPainter2D(UIPainter2D var0, int var1);

    public static native void updateUIMesh(UIMesh var0, int var1);

    public static native void updateUIScrollView(UIScrollView var0, int var1);

    public static native void updateUITextField(UITextField var0, int var1, boolean var2);

    public static native void getUITextFieldText(int var0, UITextField var1, int var2, Callback<String> var3);

    private static void initialize() {
        System.out.println("Initialize plugin UI manager");
        try {
            Field[] fields;
            StyleFields.clear();
            int totalBytes = 4;
            for (Field f : fields = Style.class.getFields()) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                Class<?> c = f.getType();
                ++totalBytes;
                if (c == StyleLength.class) {
                    totalBytes += 6;
                } else if (c == StyleFloat.class) {
                    totalBytes += 5;
                } else if (c == StyleColor.class) {
                    totalBytes += 5;
                } else if (c == StyleEnum.class) {
                    totalBytes += 2;
                } else if (c == StyleTransformOrigin.class || c == StyleTranslate.class) {
                    totalBytes += 11;
                } else if (c == StyleImage.class) {
                    totalBytes += 5;
                } else {
                    throw new ExceptionInInitializerError("Unknown style field type: " + String.valueOf(c) + " (" + f.getName() + ")");
                }
                StyleFields.add(f);
            }
            Field bytesField = Style.class.getDeclaredField("BYTES");
            bytesField.setAccessible(true);
            bytesField.setInt(null, totalBytes);
            bytesField.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Unable to initialize UI manager: " + e.toString());
        }
    }
}

