/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.util.concurrent.ConcurrentHashMap;
import net.jiw.unity.runtime.PluginManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.Timer;

public final class PluginTimerManager {
    private static final ConcurrentHashMap<Integer, Timer> timers = new ConcurrentHashMap(5, 0.9f, 1);

    public static void addTimer(Timer timer) {
        timers.put(timer.getID(), timer);
    }

    public static void removeTimer(int id) {
        timers.remove(id);
    }

    public static void removeTimer(Timer timer) {
        timers.remove(timer.getID());
    }

    public static boolean timerExists(int id) {
        return timers.containsKey(id);
    }

    public static Timer getTimer(int id) {
        return timers.get(id);
    }

    public static void removeAllTimers() {
        timers.clear();
    }

    protected static void reset() {
        PluginTimerManager.removeAllTimers();
    }

    protected static void update(float tpf) {
        try {
            if (!timers.isEmpty()) {
                for (Timer timer : timers.values()) {
                    try {
                        float tick;
                        if (!timer.isActive() || timer.isPaused()) continue;
                        float delay = timer.getInitialDelay();
                        if (delay > 0.0f) {
                            if ((delay -= tpf) <= 0.0f) {
                                timer.setInitialDelay(0.0f);
                                timer.setTick(timer.getInterval());
                            } else {
                                timer.setInitialDelay(delay);
                                continue;
                            }
                        }
                        if ((tick = timer.getTick() + tpf) >= timer.getInterval()) {
                            timer.setTick(tick - timer.getInterval());
                            Runnable task = timer.getTask();
                            if (task != null) {
                                task.run();
                            }
                            if (timer.getRepetitions() > 0) {
                                timer.setRepetitions(timer.getRepetitions() - 1);
                                continue;
                            }
                            if (timer.getRepetitions() != 0) continue;
                            timer.kill();
                            continue;
                        }
                        timer.setTick(tick);
                    }
                    catch (Exception e) {
                        Throwable exception = e.getCause() == null ? e : e.getCause();
                        String stacktrace = InternalUtils.GeneralUtils.stackTraceToString(exception);
                        PluginManager.sendAdminMessage(0xCC0000, "PLUGIN ERROR OCCURRED WHILE EXECUTING TIMER");
                        PluginManager.sendAdminMessage(0xCC0000, "-> " + stacktrace);
                        System.err.println("\nPLUGIN EXCEPTION ----> \n" + InternalUtils.GeneralUtils.stackTraceToString(exception));
                        System.out.println("##Exception: " + exception.getMessage());
                        System.out.println("##Exception: " + String.valueOf(exception));
                        timer.kill();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

