/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.utils.Vector2i;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.utils.Vector4f;

public class InternalUtils {
    public static final String ROOT_DIR = System.getProperty("user.dir");
    public static final String HOME_DIR = System.getProperty("user.home");
    public static final String PLUGINS_FOLDER = ROOT_DIR + "/Plugins";

    public static native Object getCommon(String var0);

    public static class ByteBufferUtils {
        public static boolean getBoolean(ByteBuffer buffer) {
            return buffer.get() == 1;
        }

        public static void putBoolean(ByteBuffer buffer, boolean set) {
            if (set) {
                buffer.put((byte)1);
            } else {
                buffer.put((byte)0);
            }
        }

        public static String getString(ByteBuffer buffer) {
            int len = buffer.getShort();
            if (len < 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                sb.append(buffer.getChar());
            }
            return sb.toString();
        }

        public static void putString(ByteBuffer buffer, String s) {
            if (s == null) {
                buffer.putShort((short)-1);
                return;
            }
            int len = s.length();
            buffer.putShort((short)len);
            for (int i = 0; i < len; ++i) {
                buffer.putChar(s.charAt(i));
            }
        }

        public static Vector2f getVector2f(ByteBuffer buffer) {
            return new Vector2f(buffer.getFloat(), buffer.getFloat());
        }

        public static void putVector2f(ByteBuffer buffer, Vector2f v) {
            if (v == null) {
                buffer.putFloat(0.0f).putFloat(0.0f);
            } else {
                buffer.putFloat(v.x).putFloat(v.y);
            }
        }

        public static Vector2i getVector2i(ByteBuffer buffer) {
            return new Vector2i(buffer.getInt(), buffer.getInt());
        }

        public static void putVector2i(ByteBuffer buffer, Vector2i v) {
            if (v == null) {
                buffer.putInt(0).putInt(0);
            } else {
                buffer.putInt(v.x).putInt(v.y);
            }
        }

        public static Vector3f getVector3f(ByteBuffer buffer) {
            return new Vector3f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        public static void putVector3f(ByteBuffer buffer, Vector3f v) {
            if (v == null) {
                buffer.putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
            } else {
                buffer.putFloat(v.x).putFloat(v.y).putFloat(v.z);
            }
        }

        public static Vector3i getVector3i(ByteBuffer buffer) {
            return new Vector3i(buffer.getInt(), buffer.getInt(), buffer.getInt());
        }

        public static void putVector3i(ByteBuffer buffer, Vector3i v) {
            if (v == null) {
                buffer.putInt(0).putInt(0).putInt(0);
            } else {
                buffer.putInt(v.x).putInt(v.y).putInt(v.z);
            }
        }

        public static Vector4f getVector4f(ByteBuffer buffer) {
            return new Vector4f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        public static void putVector4f(ByteBuffer buffer, Vector4f q) {
            if (q == null) {
                buffer.putFloat(0.0f).putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
            } else {
                buffer.putFloat(q.x).putFloat(q.y).putFloat(q.z).putFloat(q.w);
            }
        }

        public static Quaternion getQuaternion(ByteBuffer buffer) {
            return new Quaternion(buffer.getFloat(), buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        public static void putQuaternion(ByteBuffer buffer, Quaternion q) {
            if (q == null) {
                buffer.putFloat(0.0f).putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
            } else {
                buffer.putFloat(q.x).putFloat(q.y).putFloat(q.z).putFloat(q.w);
            }
        }

        public static void putColorRGBA(ByteBuffer buffer, ColorRGBA color) {
            if (color == null) {
                buffer.putFloat(0.0f).putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
            } else {
                buffer.putFloat(color.r).putFloat(color.g).putFloat(color.b).putFloat(color.a);
            }
        }

        public static void putColor32(ByteBuffer buffer, ColorRGBA color) {
            if (color == null) {
                buffer.put((byte)0).put((byte)0).put((byte)0).put((byte)0);
            } else {
                buffer.put((byte)Utils.MathUtils.clamp((float)0.0f, (float)255.0f, (float)(color.r * 255.0f))).put((byte)Utils.MathUtils.clamp((float)0.0f, (float)255.0f, (float)(color.g * 255.0f))).put((byte)Utils.MathUtils.clamp((float)0.0f, (float)255.0f, (float)(color.b * 255.0f))).put((byte)Utils.MathUtils.clamp((float)0.0f, (float)255.0f, (float)(color.a * 255.0f)));
            }
        }
    }

    public static class ImageUtils {
        public static byte[] bufferedImageToByteArray(BufferedImage bufferedImage, String format) {
            byte[] byArray;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                byte[] array;
                ImageIO.write((RenderedImage)bufferedImage, format, out);
                out.flush();
                byArray = array = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("Unable to convert BufferedImage to ByteArray");
                    e.printStackTrace();
                    return null;
                }
            }
            out.close();
            return byArray;
        }

        public static BufferedImage byteArrayToBufferedImage(byte[] bytes) {
            BufferedImage bufferedImage;
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                BufferedImage bufferedImage2;
                bufferedImage = bufferedImage2 = ImageIO.read(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("Unable to convert ByteArray to BufferedImage");
                    e.printStackTrace();
                    return null;
                }
            }
            in.close();
            return bufferedImage;
        }

        public static void convertRGBAToABGR(ByteBuffer rgba, BufferedImage out) {
            WritableRaster wr = out.getRaster();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] cpuArray = db.getData();
            rgba.clear();
            rgba.get(cpuArray);
            rgba.clear();
            int width = wr.getWidth();
            int height = wr.getHeight();
            for (int y = 0; y < height / 2; ++y) {
                for (int x = 0; x < width; ++x) {
                    int inPtr = (y * width + x) * 4;
                    int outPtr = ((height - y - 1) * width + x) * 4;
                    byte r1 = cpuArray[inPtr + 0];
                    byte g1 = cpuArray[inPtr + 1];
                    byte b1 = cpuArray[inPtr + 2];
                    byte a1 = cpuArray[inPtr + 3];
                    byte r2 = cpuArray[outPtr + 0];
                    byte g2 = cpuArray[outPtr + 1];
                    byte b2 = cpuArray[outPtr + 2];
                    byte a2 = cpuArray[outPtr + 3];
                    cpuArray[outPtr + 0] = a1;
                    cpuArray[outPtr + 1] = b1;
                    cpuArray[outPtr + 2] = g1;
                    cpuArray[outPtr + 3] = r1;
                    cpuArray[inPtr + 0] = a2;
                    cpuArray[inPtr + 1] = b2;
                    cpuArray[inPtr + 2] = g2;
                    cpuArray[inPtr + 3] = r2;
                }
            }
        }
    }

    public static class HttpUtils {
        private static final int CONNECT_TIMEOUT = 5000;
        private static final int READ_TIMEOUT = 5000;

        public static String sendPost(String url) throws Exception {
            return HttpUtils.sendPost(url, 5000, 5000);
        }

        public static String sendPost(String url, int connectTimeout, int readTimeout) throws Exception {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setConnectTimeout(connectTimeout);
            con.setReadTimeout(readTimeout);
            con.setUseCaches(false);
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setRequestProperty("Connection", "close");
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                StringBuilder sb = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                String string = sb.toString();
                return string;
            }
        }

        public static String sendPost(String url, HashMap<String, String> map) throws IOException {
            return HttpUtils.sendPost(url, map, 5000, 5000);
        }

        public static String sendPost(String url, HashMap<String, String> map, int connectTimeout, int readTimeout) throws IOException {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setConnectTimeout(connectTimeout);
            con.setReadTimeout(readTimeout);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setRequestProperty("Connection", "close");
            if (map != null) {
                String post = HttpUtils.hashMapToQuery(map);
                con.setRequestProperty("Content-Length", String.valueOf(post.length()));
                con.setDoOutput(true);
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(post);
                    wr.flush();
                    wr.close();
                }
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                StringBuilder sb = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                String string = sb.toString();
                return string;
            }
        }

        private static String hashMapToQuery(HashMap<String, String> map) {
            StringBuilder query = new StringBuilder();
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (query.length() == 0) {
                    query.append('&');
                }
                query.append((Object)e.getKey()).append('=').append((Object)e.getValue());
            }
            return query.toString();
        }
    }

    public static class GeneralUtils {
        public static String stackTraceToString(Throwable t) {
            if (t == null) {
                return "null";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace(pw);
            }
            return sw.toString();
        }
    }

    public static class SystemUtils {
        public static String getOSName() {
            return System.getProperty("os.name");
        }

        public static boolean isWindowsOS() {
            return System.getProperty("os.name").toLowerCase().contains("windows");
        }

        public static boolean isMacOS() {
            return System.getProperty("os.name").toLowerCase().contains("mac");
        }

        public static boolean isLinuxOS() {
            String os = System.getProperty("os.name").toLowerCase();
            return !os.contains("windows") && !os.contains("mac");
        }

        public static Thread getThreadByName(String name) {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().equals(name)) continue;
                return thread;
            }
            return null;
        }
    }

    public static class StringUtils {
        public static boolean isNumeric(String string) {
            return string != null && string.matches("[-]?([\\d]+[.]?[\\d]*)[f]?");
        }

        public static boolean isInteger(String string) {
            return string != null && string.matches("[-]{0,1}[\\d]+");
        }

        public static boolean isHex(String string) {
            return string != null && string.matches("0x[0-9A-Fa-f]+");
        }

        public static boolean isBoolean(String string) {
            return string != null && string.matches("(true)|(false)");
        }

        public static boolean getBoolean(String bool) {
            return Boolean.parseBoolean(bool);
        }

        public static int getInteger(String integer) {
            return Integer.parseInt(integer);
        }

        public static float getFloat(String floatingnumber) {
            return Float.parseFloat(floatingnumber);
        }

        public static long getLong(String longnumber) {
            return Long.parseLong(longnumber);
        }

        public static String removeAllNonWordCharacters(String string) {
            return string.replaceAll("[\\W]*", "");
        }

        public static String removeAllNonNumericCharacters(String string) {
            return string.replaceAll("[^0-9.]", "");
        }

        public static String[] explode(String string, String separator) {
            return string.split(separator);
        }

        public static int indexOf(String regex, int startfrom, String string) {
            Matcher matcher = Pattern.compile(regex).matcher(string);
            return matcher.find(startfrom) ? matcher.start() : -1;
        }

        public static String removeLeadingWhitespaces(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            int index = 0;
            for (int i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
                ++index;
            }
            if (index == 0) {
                return string;
            }
            if (index >= string.length()) {
                return "";
            }
            return string.substring(index, string.length());
        }

        public static String removeTrailingWhitespaces(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            int index = string.length();
            for (int i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
                --index;
            }
            if (index == 0) {
                return "";
            }
            if (index >= string.length()) {
                return string;
            }
            return string.substring(0, index);
        }

        public static String removeLeadingAndTrailingWhitespaces(String string) {
            int i;
            if (string == null || string.isEmpty()) {
                return string;
            }
            int startIndex = 0;
            int endIndex = string.length();
            for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
                ++startIndex;
            }
            for (i = string.length() - 1; i >= startIndex && string.charAt(i) == ' '; --i) {
                --endIndex;
            }
            if (startIndex >= endIndex) {
                return "";
            }
            if (startIndex == 0 && endIndex == string.length()) {
                return string;
            }
            return string.substring(startIndex, endIndex);
        }

        public static String removeLeadingLineBreaks(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            int index = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\n') {
                    ++index;
                    continue;
                }
                if (string.charAt(i) != '\r') break;
                ++index;
            }
            return index == 0 ? string : string.substring(index, string.length());
        }

        public static String removeTrailingLineBreaks(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            int index = string.length();
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) == '\n') {
                    --index;
                    continue;
                }
                if (string.charAt(i) != '\r') break;
                --index;
            }
            return index == string.length() ? string : string.substring(0, index);
        }

        public static String removeQuotationMarks(String string) {
            if (string == null || string.length() < 2) {
                return string;
            }
            boolean s = string.startsWith("\"");
            boolean e = string.endsWith("\"");
            if (s && e) {
                return string.substring(1, string.length() - 1);
            }
            if (s) {
                return string.substring(1);
            }
            if (e) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }

        public static String getHexString(int integer) {
            return String.format("%06X", integer);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static String compress(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                String string;
                try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                    gzip.write(str.getBytes());
                    gzip.close();
                    string = out.toString("ISO-8859-1");
                }
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public static String decompress(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            try {
                String line;
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(str.getBytes("ISO-8859-1")));
                BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "ISO-8859-1"));
                Object outStr = "";
                while ((line = bf.readLine()) != null) {
                    outStr = (String)outStr + line;
                }
                return outStr;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public static String readString(InputStream is) {
            String string;
            InputStreamReader in = new InputStreamReader(is);
            try {
                int nRead;
                char[] buffer = new char[2048];
                StringBuilder sb = new StringBuilder();
                while ((nRead = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                    sb.append(buffer, 0, nRead);
                }
                string = sb.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)in).close();
            return string;
        }

        public static String getMd5(String string) {
            if (string == null) {
                return null;
            }
            try {
                byte[] bytes = string.getBytes();
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] array = md.digest(bytes);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.length; ++i) {
                    sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                }
                return sb.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static String vector3fToString(float x, float y, float z) {
            StringBuilder builder = new StringBuilder(16);
            builder.append(x).append(" ").append(y).append(" ").append(z);
            return builder.toString();
        }
    }

    public static class FileUtils {
        public static boolean writeToFile(String text, String filename) {
            return FileUtils.writeToFile(text, new File(filename));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static boolean writeToFile(String text, File file) {
            try (FileWriter filewrite = new FileWriter(file);){
                boolean bl;
                try (BufferedWriter out = new BufferedWriter(filewrite);){
                    out.write(text);
                    out.close();
                    bl = true;
                }
                return bl;
            }
            catch (Exception e) {
                System.out.println("Unable to write to file: " + e.toString());
                return false;
            }
        }

        public static boolean writeBytesToFile(byte[] bytes, String filename) {
            return FileUtils.writeBytesToFile(bytes, new File(filename));
        }

        public static boolean writeBytesToFile(byte[] bytes, File file) {
            boolean bl;
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(bytes);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("Unable to write bytes to file: " + e.toString());
                    return false;
                }
            }
            fos.close();
            return bl;
        }

        public static byte[] readBytesFromFile(String filename) {
            return FileUtils.readBytesFromFile(new File(filename));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static byte[] readBytesFromResource(InputStream inputStream) {
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                byte[] bytes;
                int nRead;
                if (inputStream == null) {
                    System.err.println("Cannot read bytes from resource: input stream is null");
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] data = new byte[2048];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] byArray = bytes = buffer.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static byte[] readBytesFromFile(File file) {
            byte[] byArray;
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] data = new byte[(int)file.length()];
                fis.read(data);
                byArray = data;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            fis.close();
            return byArray;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static String readFromFile(File file) {
            try (FileReader fileread = new FileReader(file);){
                String string;
                try (BufferedReader in = new BufferedReader(fileread);){
                    int len = (int)file.length();
                    char[] chars = new char[len];
                    in.read(chars, 0, len);
                    string = new String(chars);
                }
                return string;
            }
            catch (Exception e) {
                System.out.println("Unable to read from file: " + e.toString());
                return "";
            }
        }

        public static String getMd5(String file) {
            File f = new File(file);
            return FileUtils.getMd5(f);
        }

        public static String getMd5(File file) {
            String string;
            if (file == null || !file.exists()) {
                return "";
            }
            FileInputStream fis = new FileInputStream(file);
            try {
                string = FileUtils.getMd5(fis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }
            fis.close();
            return string;
        }

        public static String getMd5(InputStream is) {
            try {
                int nread;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] dataBytes = new byte[1024];
                while ((nread = is.read(dataBytes)) != -1) {
                    md.update(dataBytes, 0, nread);
                }
                byte[] mdbytes = md.digest();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mdbytes.length; ++i) {
                    sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
                }
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void copy(File src, File dest) {
            if (src.isDirectory()) {
                String[] files;
                if (!dest.exists()) {
                    dest.mkdir();
                    System.out.println("Copied directory from " + String.valueOf(src) + " to " + String.valueOf(dest));
                }
                for (String file : files = src.list()) {
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    FileUtils.copy(srcFile, destFile);
                }
            } else {
                if (dest.isDirectory()) {
                    dest = new File(dest, src.getName());
                }
                if (dest.exists()) {
                    dest.delete();
                } else {
                    File parent = dest.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                }
                try (FileInputStream in = new FileInputStream(src);
                     FileOutputStream out = new FileOutputStream(dest);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                    System.out.println("Copied file from " + String.valueOf(src) + " to " + String.valueOf(dest));
                }
                catch (IOException e) {
                    System.err.println("Unable to copy file " + String.valueOf(src) + " to " + String.valueOf(dest));
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ByteUtils {
        public static void compress(ByteBuffer input, int start, int len) throws IOException {
            if (input == null) {
                return;
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 GZIPOutputStream zos = new GZIPOutputStream(out);){
                byte[] binput = input.array();
                zos.write(binput, start, len);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static byte[] compress(byte[] input) {
            if (input == null) {
                return null;
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                byte[] byArray;
                try (GZIPOutputStream zos = new GZIPOutputStream(out);){
                    zos.write(input);
                    zos.close();
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                System.out.println("Unable to compress byte array: " + e.toString());
                return null;
            }
        }

        public static byte[] decompress(byte[] input) {
            return ByteUtils.decompress(input, 2048);
        }

        /*
         * Exception decompiling
         */
        public static byte[] decompress(byte[] input, int length) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static int unsignedByteToInt(byte b) {
            return b & 0xFF;
        }

        public static String getMd5(byte[] bytes) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] array = md.digest(bytes);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.length; ++i) {
                    sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                }
                return sb.toString();
            }
            catch (Exception e) {
                System.out.println("Unable to generate md5 hash: " + e.toString());
                return null;
            }
        }

        public static byte[] encrypt(byte[] array, String key) throws Exception {
            if (key == null) {
                key = "59Kdm3Pl1Ug1n4p1";
            } else if (((String)key).length() > 16) {
                key = ((String)key).substring(0, 16);
            } else if (((String)key).length() < 16) {
                key = (String)key + "59Kdm3Pl1Ug1n4p1".substring(((String)key).length());
            }
            SecretKeySpec k = new SecretKeySpec(((String)key).getBytes(), "AES");
            SecretKeySpec kkey = new SecretKeySpec(k.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, kkey);
            return cipher.doFinal(array);
        }

        public static byte[] decrypt(byte[] encryptedarray, String key) throws Exception {
            if (key == null) {
                key = "59Kdm3Pl1Ug1n4p1";
            } else if (((String)key).length() > 16) {
                key = ((String)key).substring(0, 16);
            } else if (((String)key).length() < 16) {
                key = (String)key + "59Kdm3Pl1Ug1n4p1".substring(((String)key).length());
            }
            SecretKeySpec k = new SecretKeySpec(((String)key).getBytes(), "AES");
            SecretKeySpec kkey = new SecretKeySpec(k.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, kkey);
            return cipher.doFinal(encryptedarray);
        }

        public static String byteToHex(byte b) {
            int i = b & 0xFF;
            return Integer.toHexString(i);
        }
    }

    public static class MathUtils {
        public static native Quaternion quaternionLookRotation(float var0, float var1, float var2, float var3, float var4, float var5);

        public static native void quaternionLookRotation(Quaternion var0, float var1, float var2, float var3, float var4, float var5, float var6);

        public static native Quaternion quaternionFromAngles(float var0, float var1, float var2);

        public static native void quaternionFromAngles(Quaternion var0, float var1, float var2, float var3);

        public static native float[] quaternionToAngles(float var0, float var1, float var2, float var3);

        public static native float quaternionToAngle(float var0, float var1, float var2, float var3, int var4);

        public static native float angleBetweenQuaternions(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7);

        public static native Quaternion quaternionAngleAxis(float var0, float var1, float var2, float var3);
    }
}

