/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime.database;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.jiw.unity.Loader;
import net.jiw.unity.runtime.PluginManager;

public final class PluginResultSet
implements ResultSet,
ResultSetMetaData {
    private long handle;
    private int row = 0;
    private int lastColum = -1;
    private Map<String, Integer> columNameToIndex = null;
    protected final int SQLITE_INTEGER = 1;
    protected final int SQLITE_FLOAT = 2;
    protected final int SQLITE_TEXT = 3;
    protected final int SQLITE_BLOB = 4;
    protected final int SQLITE_NULL = 5;

    private PluginResultSet(long handle) {
        this.handle = handle;
        PluginManager.cleaner.register(this, () -> {
            if (this.handle != 0L) {
                this.close();
            }
        });
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    public int getColumType(int index) {
        return this.getColumType(this.handle, index);
    }

    @Override
    public boolean next() throws SQLException {
        ++this.row;
        return this.next(this.handle);
    }

    @Override
    public void close() {
        if (this.handle == 0L) {
            return;
        }
        if (Loader.DEVMODE) {
            System.out.println("Closing ResultSet " + this.handle + "...");
        }
        this.row = 0;
        this.lastColum = -1;
        this.close(this.handle);
        this.handle = 0L;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed(this.handle);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getColumType(this.handle, this.lastColum) != 5;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int findColumn(String column) throws SQLException {
        if (this.columNameToIndex != null) {
            if (this.columNameToIndex.containsKey(column)) {
                return this.columNameToIndex.get(column);
            }
            throw new SQLException("no such column: " + column);
        }
        int targetColumn = -1;
        int count = this.columnCount(this.handle);
        this.columNameToIndex = new HashMap<String, Integer>(count);
        for (int i = 1; i <= count; ++i) {
            String name = this.columnName(this.handle, i);
            this.columNameToIndex.put(name, i);
            if (targetColumn != -1 || !column.equals(name)) continue;
            targetColumn = i;
        }
        if (targetColumn == -1) {
            throw new SQLException("no such column: " + column);
        }
        return targetColumn;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        int columType = this.getColumType(this.handle, index);
        switch (columType) {
            case 1: {
                long value = this.getLong(this.handle, index);
                if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                    return value;
                }
                return (int)value;
            }
            case 2: {
                return this.getDouble(this.handle, index);
            }
            case 4: {
                return this.getBytes(this.handle, index);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(this.handle, index);
    }

    @Override
    public Object getObject(String column) throws SQLException {
        return this.getObject(this.findColumn(column));
    }

    @Override
    public String getString(int index) throws SQLException {
        this.lastColum = index;
        return this.getString(this.handle, index);
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.lastColum = index;
        return this.getBoolean(this.handle, index);
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.lastColum = index;
        return (byte)this.getInt(this.handle, index);
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.lastColum = index;
        return (short)this.getInt(this.handle, index);
    }

    @Override
    public int getInt(int index) throws SQLException {
        this.lastColum = index;
        return this.getInt(this.handle, index);
    }

    @Override
    public long getLong(int index) throws SQLException {
        this.lastColum = index;
        return this.getLong(this.handle, index);
    }

    @Override
    public float getFloat(int index) throws SQLException {
        this.lastColum = index;
        return this.getFloat(this.handle, index);
    }

    @Override
    public double getDouble(int index) throws SQLException {
        this.lastColum = index;
        return this.getDouble(this.handle, index);
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        this.lastColum = index;
        return this.getBytes(this.handle, index);
    }

    @Override
    public String getString(String column) throws SQLException {
        return this.getString(this.handle, this.findColumn(column));
    }

    @Override
    public boolean getBoolean(String column) throws SQLException {
        return this.getBoolean(this.handle, this.findColumn(column));
    }

    @Override
    public byte getByte(String column) throws SQLException {
        return (byte)this.getInt(this.handle, this.findColumn(column));
    }

    @Override
    public short getShort(String column) throws SQLException {
        return (short)this.getInt(this.handle, this.findColumn(column));
    }

    @Override
    public int getInt(String column) throws SQLException {
        return this.getInt(this.handle, this.findColumn(column));
    }

    @Override
    public long getLong(String column) throws SQLException {
        return this.getLong(this.handle, this.findColumn(column));
    }

    @Override
    public float getFloat(String column) throws SQLException {
        return this.getFloat(this.handle, this.findColumn(column));
    }

    @Override
    public double getDouble(String column) throws SQLException {
        return this.getDouble(this.handle, this.findColumn(column));
    }

    @Override
    public byte[] getBytes(String column) throws SQLException {
        return this.getBytes(this.handle, this.findColumn(column));
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        String data = this.getString(i);
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    @Override
    public Reader getNCharacterStream(String column) throws SQLException {
        return this.getNCharacterStream(this.findColumn(column));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        return this.getNCharacterStream(i);
    }

    @Override
    public Reader getCharacterStream(String column) throws SQLException {
        return this.getNCharacterStream(column);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        int columnType = this.getColumType(this.handle, index);
        if (columnType == 1) {
            long decimal = this.getLong(index);
            return BigDecimal.valueOf(decimal);
        }
        return new BigDecimal(this.getLong(index));
    }

    @Override
    public BigDecimal getBigDecimal(String column) throws SQLException {
        return this.getBigDecimal(this.findColumn(column));
    }

    @Override
    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(String column, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(column), scale);
    }

    @Override
    public Date getDate(int index) throws SQLException {
        return new Date(this.getLong(index));
    }

    @Override
    public Time getTime(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        return new Timestamp(this.getLong(index));
    }

    @Override
    public InputStream getAsciiStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public InputStream getUnicodeStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public InputStream getBinaryStream(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Date getDate(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Time getTime(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public InputStream getAsciiStream(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public InputStream getUnicodeStream(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public InputStream getBinaryStream(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean relative(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateNull(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBoolean(int i, boolean bln) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateByte(int i, byte b) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateShort(int i, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateInt(int i, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateLong(int i, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateFloat(int i, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateDouble(int i, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal bd) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateString(int i, String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBytes(int i, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateDate(int i, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateTime(int i, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(int i, Timestamp tmstmp) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int i, InputStream in, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int i, InputStream in, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateObject(int i, Object o, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateObject(int i, Object o) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateNull(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBoolean(String column, boolean bln) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateByte(String column, byte b) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateShort(String column, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateInt(String column, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateLong(String column, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateFloat(String column, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateDouble(String column, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(String column, BigDecimal bd) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateString(String column, String column1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBytes(String column, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateDate(String column, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateTime(String column, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(String column, Timestamp tmstmp) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String column, InputStream in, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String column, InputStream in, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String column, Reader reader, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateObject(String column, Object o, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateObject(String column, Object o) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Object getObject(String column, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Ref getRef(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Blob getBlob(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Clob getClob(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Array getArray(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Date getDate(int i, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Date getDate(String column, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Time getTime(int i, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Time getTime(String column, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Timestamp getTimestamp(String column, Calendar clndr) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount(this.handle);
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        return this.columnType(this.handle, index);
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        return this.columnTypeName(this.handle, index);
    }

    @Override
    public boolean isAutoIncrement(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCaseSensitive(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSearchable(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCurrency(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int isNullable(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getColumnDisplaySize(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getColumnLabel(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getColumnName(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSchemaName(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getScale(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTableName(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCatalogName(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isReadOnly(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWritable(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isDefinitelyWritable(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getColumnClassName(int i) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int i, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String column, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int i, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String column, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int i, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String column, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int i, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String column, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int i, RowId rowid) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String column, RowId rowid) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int i, String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String column, String column1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int i, NClob nclob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String column, NClob nclob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int i, SQLXML sqlxml) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String column, SQLXML sqlxml) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String column, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String column, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String column, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String column, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int i, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String column, InputStream in, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String column, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String column, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String column, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int i, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int i, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String column, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String column, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String column, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int i, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String column, InputStream in) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String column, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String column, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int i, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public <T> T getObject(String column, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    private native int getColumType(long var1, int var3);

    private native boolean next(long var1);

    private native void close(long var1);

    private native boolean isClosed(long var1);

    private native int columnCount(long var1);

    private native int columnType(long var1, int var3);

    private native String columnTypeName(long var1, int var3);

    private native String columnName(long var1, int var3);

    private native String getString(long var1, int var3);

    private native boolean getBoolean(long var1, int var3);

    private native int getInt(long var1, int var3);

    private native long getLong(long var1, int var3);

    private native float getFloat(long var1, int var3);

    private native double getDouble(long var1, int var3);

    private native byte[] getBytes(long var1, int var3);
}

