/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jiw.unity.runtime.JavaPlugin;
import net.jiw.unity.runtime.PluginManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.jiw.unity.runtime.utils.LocalEvent;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.general.UpdateEvent;

public class PluginEventHandler {
    private static HashMap<Class, CopyOnWriteArrayList<Handler>> eventMap = new HashMap();
    private static boolean requiresUpdateEvent = false;
    private static int numberOfTriggeredEvents = 0;

    protected static void initialize() {
        System.out.println("Initialize event handler (" + Listener.class.getName() + ")");
    }

    public static synchronized void registerEventListener(int pluginID, Listener listener) {
        try {
            Method[] methods;
            System.out.println("API: REGISTER LISTENER " + String.valueOf(listener.getClass()));
            for (Method method : methods = listener.getClass().getMethods()) {
                Class<?> p;
                Class<?>[] parameter;
                if (method.getParameterCount() != 1 || (parameter = method.getParameterTypes()).length != 1 || parameter[0] == null || !Event.class.isAssignableFrom(p = parameter[0])) continue;
                if (method.isAnnotationPresent(EventMethod.class)) {
                    CopyOnWriteArrayList<Object> listeners;
                    EventMethod annotation = method.getAnnotation(EventMethod.class);
                    if (eventMap.containsKey(p)) {
                        listeners = eventMap.get(p);
                        boolean contains = false;
                        for (int i = 0; i < listeners.size(); ++i) {
                            Handler handler = (Handler)listeners.get(i);
                            if (handler == null || handler.pluginID != pluginID || handler.listener != listener || handler.method != method) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        listeners.add(new Handler(pluginID, listener, method, annotation.value()));
                        continue;
                    }
                    listeners = new CopyOnWriteArrayList();
                    listeners.add(new Handler(pluginID, listener, method, annotation.value()));
                    eventMap.put(p, listeners);
                    System.out.println("    -> Event: " + p.getName());
                    if (!p.isAnnotationPresent(LocalEvent.class)) {
                        PluginEventHandler.onRegisterEvent(p.getName());
                    }
                    if (p != UpdateEvent.class) continue;
                    requiresUpdateEvent = true;
                    continue;
                }
                if (method.getName().equals("triggerEvent")) continue;
                JavaPlugin plugin = PluginManager.getPlugin(pluginID);
                String name = plugin == null ? String.valueOf(pluginID) : plugin.name;
                System.err.println("Plugin " + name + ": Missing @EventMethod annotation for method " + method.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static synchronized void unregisterEventListener(int pluginID, Listener listener) {
        try {
            Method[] methods;
            System.out.println("API: UNREGISTER LISTENER " + listener.getClass().getSimpleName());
            for (Method method : methods = listener.getClass().getMethods()) {
                Class<?> p;
                Class<?>[] parameter;
                if (method.getParameterCount() != 1 || !method.isAnnotationPresent(EventMethod.class) || (parameter = method.getParameterTypes()).length != 1 || parameter[0] == null || !(p = parameter[0]).getGenericSuperclass().getClass().isInstance(Event.class) || !eventMap.containsKey(p)) continue;
                ArrayList<Handler> handlersToRemove = new ArrayList<Handler>();
                CopyOnWriteArrayList<Handler> listeners = eventMap.get(p);
                for (int i = 0; i < listeners.size(); ++i) {
                    Handler handler = listeners.get(i);
                    if (handler == null || handler.listener != listener || !handler.method.equals(method)) continue;
                    handlersToRemove.add(handler);
                }
                if (handlersToRemove.isEmpty()) continue;
                listeners.removeAll(handlersToRemove);
                if (!listeners.isEmpty()) continue;
                eventMap.remove(p);
                System.out.println("  - no more listeners for event " + p.getSimpleName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean triggerEvent(Event event) {
        if (!PluginManager.isActive()) {
            return true;
        }
        CopyOnWriteArrayList<Handler> listener = eventMap.get(event.getClass());
        if (listener != null) {
            for (int i = 0; i < listener.size(); ++i) {
                Handler handler = listener.get(i);
                if (handler == null) continue;
                try {
                    switch (handler.threading) {
                        case Async: {
                            ++numberOfTriggeredEvents;
                            handler.method.invoke(handler.listener, event);
                            break;
                        }
                        default: {
                            Handler handler2 = handler;
                            synchronized (handler2) {
                                ++numberOfTriggeredEvents;
                                handler.method.invoke(handler.listener, event);
                                break;
                            }
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    JavaPlugin plugin = PluginManager.getPlugin(handler.pluginID);
                    if (plugin != null) {
                        ++plugin.errors;
                        Throwable exception = e.getCause() == null ? e : e.getCause();
                        String stacktrace = InternalUtils.GeneralUtils.stackTraceToString(exception);
                        System.err.println("\nPLUGIN EXCEPTION (" + plugin.name + ", " + plugin.version + ", " + plugin.author + ") ----> \n" + stacktrace);
                        PluginManager.sendAdminMessage(0xFF0000, "EXCEPTION OCCURRED IN PLUGIN '" + plugin.name + "' (AUTHOR: " + plugin.author + ") \n-> " + stacktrace);
                        if (plugin.errors < PluginManager.getPluginErrorThreshold()) continue;
                        StringBuilder sb = new StringBuilder(512);
                        sb.append("An exception was caused by a plugin!").append("\n");
                        sb.append("Plugin: ").append(plugin.name).append(" (v").append(plugin.version).append("  by ").append(plugin.author).append("\n");
                        if (plugin.contact != null && !plugin.contact.isBlank()) {
                            sb.append("Contact: ").append(plugin.contact).append("\n");
                        }
                        if (plugin.website != null && !plugin.website.isBlank()) {
                            sb.append("Website: ").append(plugin.website).append("\n");
                        }
                        sb.append("\n");
                        sb.append("Error: ").append(stacktrace);
                        String msg = "An exception was caused by a plugin! \nPlugin: " + plugin.name + "  (v" + plugin.version + ") \n     Creator: " + plugin.author + " \n     Contact: " + plugin.contact + " \n     Website: " + plugin.website + "\n\n-> " + stacktrace;
                        PluginManager.handleError(msg);
                        continue;
                    }
                    e.printStackTrace();
                }
            }
            if (event instanceof Cancellable) {
                return !((Cancellable)event).isCancelled();
            }
        }
        return true;
    }

    public static boolean hasEvent(Class eventClass) {
        return eventMap.containsKey(eventClass);
    }

    public static boolean requiresUpdateEvent() {
        return requiresUpdateEvent;
    }

    public static int getNumberOfTriggeredEvents() {
        return numberOfTriggeredEvents;
    }

    public static void reset() {
        eventMap.clear();
        requiresUpdateEvent = false;
    }

    private static native void onRegisterEvent(String var0);

    private static class Handler {
        public int pluginID;
        public Object listener;
        public Method method;
        public Threading threading;

        public Handler(int pluginID, Object listener, Method method, Threading threading) {
            block2: {
                this.pluginID = pluginID;
                this.listener = listener;
                this.method = method;
                this.threading = threading;
                try {
                    this.method.setAccessible(true);
                }
                catch (SecurityException e) {
                    if (this.method.canAccess(listener)) break block2;
                    System.err.println("Unable to make event method accessible");
                }
            }
        }
    }
}

