/*
 * Decompiled with CFR 0.152.
 */
package portals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.assets.PrefabAsset;
import net.risingworld.api.assets.SoundAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeBlockPositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;
import net.risingworld.api.worldelements.Text3D;
import portals.CreateDatabase;
import portals.PortalUI;

public class Portals
extends Plugin
implements Listener {
    public Timer timer;
    public Database database;
    public GameObject gameObject;
    public ArrayList<Prefab> EntrancePortals = new ArrayList();
    public ArrayList<Text3D> EntrancePortalNames = new ArrayList();
    public ArrayList<Prefab> ExitPortals = new ArrayList();
    public ArrayList<Text3D> ExitPortalNames = new ArrayList();
    public ArrayList<String> setPortalEntranceLocationBlockpos = new ArrayList();
    public ArrayList<String> setPortalExitLocationBlockpos = new ArrayList();

    public void onEnable() {
        Vector3f textlocation;
        float getz;
        float gety;
        float getx;
        PrefabAsset asset;
        AssetBundle bundle;
        Vector3f portalPosition;
        String PortalColourID;
        Quaternion Rotation;
        String PortalName;
        String endpos;
        ResultSet result;
        String WorldName = World.getName();
        System.out.println("-- PORTALS PLUGIN ENABLED --");
        this.database = this.getSQLiteConnection(this.getPath() + "/" + WorldName + "/database.db");
        CreateDatabase CreateDatabase2 = new CreateDatabase(this);
        CreateDatabase2.CreateDatabase();
        try {
            result = this.database.executeQuery("SELECT * FROM `Portals`");
            try {
                while (result.next()) {
                    endpos = result.getString("PortalEntranceLocation");
                    PortalName = result.getString("PortalNameEntrance");
                    String PortalEntranceLocationChunkpos = result.getString("PortalEntranceLocationChunkpos");
                    String PortalEntranceLocationBlockpos = result.getString("PortalEntranceLocationBlockpos");
                    String PortalEntranceRotation = result.getString("PortalEntranceRotation");
                    Rotation = new Quaternion().fromString(PortalEntranceRotation);
                    PortalColourID = result.getString("PortalColour");
                    portalPosition = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                    bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/portal.bundle"));
                    asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PortalColourID);
                    Prefab EntrancePortal = new Prefab(asset);
                    EntrancePortal.setLocalRotation(0.0f, Rotation.getYaw(), 0.0f);
                    EntrancePortal.setLocalPosition(portalPosition);
                    this.setPortalEntranceLocationBlockpos.add(PortalEntranceLocationBlockpos);
                    this.EntrancePortals.add(EntrancePortal);
                    getx = portalPosition.x;
                    gety = portalPosition.y + 4.0f;
                    getz = portalPosition.z;
                    Text3D EntrancePortalName = new Text3D("", false);
                    EntrancePortalName.setLocalPosition(getx, gety, getz);
                    EntrancePortalName.setFontSize(0.8f);
                    EntrancePortalName.setBillboard(true);
                    EntrancePortalName.setText(PortalName);
                    this.EntrancePortalNames.add(EntrancePortalName);
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            result = this.database.executeQuery("SELECT * FROM `Portals`");
            try {
                while (result.next()) {
                    endpos = result.getString("PortalExitLocation");
                    PortalName = result.getString("PortalNameExit");
                    String PortalExitLocationChunkpos = result.getString("PortalExitLocationChunkpos");
                    String PortalExitLocationBlockpos = result.getString("PortalExitLocationBlockpos");
                    String PortalExitRotation = result.getString("PortalExitRotation");
                    Rotation = new Quaternion().fromString(PortalExitRotation);
                    PortalColourID = result.getString("PortalColour");
                    portalPosition = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                    bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/portal.bundle"));
                    asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PortalColourID);
                    Prefab ExitPortal = new Prefab(asset);
                    ExitPortal.setLocalRotation(0.0f, Rotation.getYaw(), 0.0f);
                    ExitPortal.setLocalPosition(portalPosition);
                    this.setPortalExitLocationBlockpos.add(PortalExitLocationBlockpos);
                    this.ExitPortals.add(ExitPortal);
                    getx = portalPosition.x;
                    gety = portalPosition.y + 4.0f;
                    getz = portalPosition.z;
                    Text3D ExitPortalName = new Text3D("", false);
                    ExitPortalName.setLocalPosition(getx, gety, getz);
                    ExitPortalName.setFontSize(0.8f);
                    ExitPortalName.setBillboard(true);
                    ExitPortalName.setText(PortalName);
                    this.ExitPortalNames.add(ExitPortalName);
                }
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Prefab EntrancePortal : this.EntrancePortals) {
            this.database.executeUpdate("UPDATE Portals SET ObjectEntrancePortalID = '" + EntrancePortal.getID() + "' WHERE PortalEntranceLocation = '" + String.valueOf(EntrancePortal.getLocalPosition()) + "'");
        }
        for (Text3D EntrancePortalName : this.EntrancePortalNames) {
            float getX = EntrancePortalName.getLocalPosition().x;
            float getY = EntrancePortalName.getLocalPosition().y - 4.0f;
            float getZ = EntrancePortalName.getLocalPosition().z;
            textlocation = new Vector3f(getX, getY, getZ);
            System.out.println("entrance text location" + String.valueOf(textlocation));
            this.database.executeUpdate("UPDATE Portals SET ObjectEntranceTextID = '" + EntrancePortalName.getID() + "' WHERE PortalEntranceLocation = '" + String.valueOf(textlocation) + "'");
        }
        for (Prefab ExitPortal : this.ExitPortals) {
            this.database.executeUpdate("UPDATE Portals SET ObjectExitPortalID = '" + ExitPortal.getID() + "' WHERE PortalExitLocation = '" + String.valueOf(ExitPortal.getLocalPosition()) + "'");
        }
        for (Text3D ExitPortalName : this.ExitPortalNames) {
            float getX = ExitPortalName.getLocalPosition().x;
            float getY = ExitPortalName.getLocalPosition().y - 4.0f;
            float getZ = ExitPortalName.getLocalPosition().z;
            textlocation = new Vector3f(getX, getY, getZ);
            System.out.println("exit text location" + String.valueOf(textlocation));
            this.database.executeUpdate("UPDATE Portals SET ObjectExitTextID = '" + ExitPortalName.getID() + "' WHERE PortalExitLocation = '" + String.valueOf(textlocation) + "'");
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
        System.out.println("-- TESTPLUGIN DISABLED --");
        if (this.database != null) {
            this.database.close();
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        for (Prefab EntrancePortal : this.EntrancePortals) {
            player.removeGameObject((GameObject)EntrancePortal);
        }
        for (Text3D EntrancePortalName : this.EntrancePortalNames) {
            player.removeGameObject((GameObject)EntrancePortalName);
        }
        for (Prefab ExitPortal : this.ExitPortals) {
            player.removeGameObject((GameObject)ExitPortal);
        }
        for (Text3D ExitPortalName : this.ExitPortalNames) {
            player.removeGameObject((GameObject)ExitPortalName);
        }
        Timer AllowPlayerTPTimer = (Timer)player.getAttribute("AllowPlayerTPTimer");
        if (AllowPlayerTPTimer != null) {
            AllowPlayerTPTimer.kill();
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        int list = 0;
        player.setAttribute("list", (Object)list);
        player.setAttribute("PortalColour", (Object)"PortalGREEN.prefab");
        String Backclick = "Notclicked";
        player.setAttribute("BackClicked", (Object)Backclick);
        String Nextclick = "Notclicked";
        player.setAttribute("NextClicked", (Object)Nextclick);
        player.setAttribute("PortalPlaced", (Object)false);
        player.setAttribute("PortalID", (Object)0);
        Timer AllowPlayerTPTimer = new Timer(5.0f, 0.0f, -1, null);
        Runnable AllowPlayerTPTask = () -> {
            try (ResultSet result = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");){
                if (result.next()) {
                    int PlayerTpAllowed = result.getInt("PlayerTpAllowed");
                    if (PlayerTpAllowed == 0) {
                        player.setAttribute("AllowPlayerTP", (Object)false);
                    } else if (PlayerTpAllowed == 1) {
                        player.setAttribute("AllowPlayerTP", (Object)true);
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
            }
        };
        AllowPlayerTPTimer.setTask(AllowPlayerTPTask);
        AllowPlayerTPTimer.start();
        player.setAttribute("AllowPlayerTPTimer", (Object)AllowPlayerTPTimer);
        for (Prefab EntrancePortal : this.EntrancePortals) {
            player.addGameObject((GameObject)EntrancePortal);
        }
        for (Text3D EntrancePortalName : this.EntrancePortalNames) {
            player.addGameObject((GameObject)EntrancePortalName);
        }
        for (Prefab ExitPortal : this.ExitPortals) {
            player.addGameObject((GameObject)ExitPortal);
        }
        for (Text3D ExitPortalName : this.ExitPortalNames) {
            player.addGameObject((GameObject)ExitPortalName);
        }
        PortalUI PortalUI2 = new PortalUI(this);
        PortalUI2.PortalUI(player);
        player.registerKeys(new Key[]{Key.P, Key.O, Key.LeftShift});
        player.setListenForKeyInput(true);
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent evt) {
        String[] cmd = evt.getCommand().split(" ");
        Player player = evt.getPlayer();
    }

    @EventMethod
    public void onPlayerKeyInputEvent(PlayerKeyEvent evt) {
        Player player = evt.getPlayer();
        Vector3f playerPos = player.getPosition();
        int posx = (int)playerPos.x;
        int posy = (int)playerPos.y;
        int posz = (int)playerPos.z;
        Vector3i Chunkpos = new Vector3i(posx, posy, posz);
        Vector3i Blockpos = new Vector3i(posx, posy, posz);
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)player.getPosition(), (Vector3i)Chunkpos, (Vector3i)Blockpos);
        if (evt.isPressed() && evt.getKey() == Key.P && player.isKeyPressed(Key.LeftShift)) {
            if (player.isAdmin()) {
                UIElement MainPortalPanel = (UIElement)player.getAttribute("MainPortalPanel");
                MainPortalPanel.setVisible(true);
                player.setMouseCursorVisible(true);
            } else if (!player.isAdmin()) {
                if (Boolean.TRUE.equals(player.getAttribute("AllowPlayerTP"))) {
                    UIElement PlayerTPPortalPanel = (UIElement)player.getAttribute("PlayerTPPortalPanel");
                    PlayerTPPortalPanel.setVisible(true);
                    player.setMouseCursorVisible(true);
                } else {
                    player.sendTextMessage("This teleport feature is turned off!! ask an admin to turn it on in settings");
                }
            }
        }
    }

    @EventMethod
    public void onPlayerChangeBlockPositionEvent(PlayerChangeBlockPositionEvent event) throws SQLException {
        SoundAsset soundfile;
        float NEWPositionZ;
        float NEWPositionY;
        float NEWPositionX;
        Quaternion Rotation;
        String getRotation;
        String endpos;
        ResultSet result;
        Player player = event.getPlayer();
        Vector3f playerPos = player.getPosition();
        int posx = (int)playerPos.x;
        int posy = (int)playerPos.y;
        int posz = (int)playerPos.z;
        Vector3i Chunkpos = new Vector3i(posx, posy, posz);
        Vector3i Blockpos = new Vector3i(posx, posy, posz);
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)player.getPosition(), (Vector3i)Chunkpos, (Vector3i)Blockpos);
        for (String PortalEntranceLocationBlockpos : this.setPortalEntranceLocationBlockpos) {
            if (!Blockpos.toString().equals(PortalEntranceLocationBlockpos) || !Boolean.FALSE.equals(player.getAttribute("PortalPlaced"))) continue;
            try {
                result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalEntranceLocationChunkpos` = '" + String.valueOf(Chunkpos) + "' AND `PortalEntranceLocationBlockpos` = '" + String.valueOf(Blockpos) + "'");
                try {
                    if (!result.next()) continue;
                    endpos = result.getString("PortalExitLocation");
                    getRotation = result.getString("PortalExitRotation");
                    Rotation = new Quaternion().fromString(getRotation);
                    Vector3f ExitLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                    Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 2.0f));
                    NEWPositionX = ExitLocation.x + viewDir.x;
                    NEWPositionY = ExitLocation.y + viewDir.y + 0.5f;
                    NEWPositionZ = ExitLocation.z + viewDir.z;
                    player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                    player.setRotation(Rotation);
                    soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                    player.playSound(soundfile);
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (String PortalExitLocationBlockpos : this.setPortalExitLocationBlockpos) {
            if (!Blockpos.toString().equals(PortalExitLocationBlockpos) || !Boolean.FALSE.equals(player.getAttribute("PortalPlaced"))) continue;
            try {
                result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalExitLocationChunkpos` = '" + String.valueOf(Chunkpos) + "' AND `PortalExitLocationBlockpos` = '" + String.valueOf(Blockpos) + "'");
                try {
                    if (!result.next()) continue;
                    endpos = result.getString("PortalEntranceLocation");
                    getRotation = result.getString("PortalEntranceRotation");
                    Rotation = new Quaternion().fromString(getRotation);
                    Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 2.0f));
                    Vector3f EntranceLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                    NEWPositionX = EntranceLocation.x + viewDir.x;
                    NEWPositionY = EntranceLocation.y + viewDir.y + 0.5f;
                    NEWPositionZ = EntranceLocation.z + viewDir.z;
                    player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                    player.setRotation(Rotation);
                    soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                    player.playSound(soundfile);
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @EventMethod
    public void onPlayerUIEClick(PlayerUIElementClickEvent event) throws SQLException {
        int PlayerTPTeleportEntranceButtonID;
        int PlayerTPTeleportExitButtonID;
        int PlayerTPBackButtonID;
        int AllowPlayerTPMenuButtonID;
        int MainMenuButtonID;
        int SettingsButtonID;
        int PlaceExitPortalButtonID;
        int PlacePortalButtonID;
        int PortalID;
        ResultSet Result;
        int list;
        if (event.getUIElement() == null) {
            return;
        }
        Player player = event.getPlayer();
        int eventID = 0;
        Vector3f playerPos = player.getPosition();
        int posx = (int)playerPos.x;
        int posy = (int)playerPos.y;
        int posz = (int)playerPos.z;
        Vector3i Chunkpos = new Vector3i(posx, posy, posz);
        Vector3i Blockpos = new Vector3i(posx, posy, posz);
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)player.getPosition(), (Vector3i)Chunkpos, (Vector3i)Blockpos);
        eventID = event.getUIElement().getID();
        int exitPortalbuttonID = (Integer)player.getAttribute("exitPortalbuttonID");
        int MainPortalPanelID = (Integer)player.getAttribute("MainPortalPanelID");
        int PortalEnterNameButtonID = (Integer)player.getAttribute("PortalEnterNameButtonID");
        int PortalColourGreenButtonID = (Integer)player.getAttribute("PortalColourGreenButtonID");
        int PortalColourRedButtonID = (Integer)player.getAttribute("PortalColourRedButtonID");
        int PortalColourBlueButtonID = (Integer)player.getAttribute("PortalColourBlueButtonID");
        int PortalColourYellowButtonID = (Integer)player.getAttribute("PortalColourYellowButtonID");
        int PortalColourClearButtonID = (Integer)player.getAttribute("PortalColourClearButtonID");
        int exitSettingsPortalbuttonID = (Integer)player.getAttribute("exitSettingsPortalbuttonID");
        int DeletePortalButtonID = (Integer)player.getAttribute("DeletePortalButtonID");
        int UpdatePortalButtonID = (Integer)player.getAttribute("UpdatePortalButtonID");
        int PortalTeleportEntranceButtonID = (Integer)player.getAttribute("PortalTeleportEntranceButtonID");
        int PortalTeleportExitButtonID = (Integer)player.getAttribute("PortalTeleportExitButtonID");
        int PortalNextButtonID = (Integer)player.getAttribute("PortalNextButtonID");
        int PortalBackButtonID = (Integer)player.getAttribute("PortalBackButtonID");
        UITextField EntrancePortalNameTextField = (UITextField)player.getAttribute("EntrancePortalNameTextField");
        int EntrancePortalNameTextFieldID = EntrancePortalNameTextField.getID();
        UITextField ExitPortalNameTextField = (UITextField)player.getAttribute("ExitPortalNameTextField");
        int ExitPortalNameTextFieldID = ExitPortalNameTextField.getID();
        UITextField SettingsEntrancePortalNameTextField = (UITextField)player.getAttribute("SettingsEntrancePortalNameTextField");
        int SettingsEntrancePortalNameTextFieldID = SettingsEntrancePortalNameTextField.getID();
        UITextField SettingsExitPortalNameTextField = (UITextField)player.getAttribute("SettingsExitPortalNameTextField");
        int SettingsExitPortalNameTextFieldID = SettingsExitPortalNameTextField.getID();
        UIElement MainPortalPanel = (UIElement)player.getAttribute("MainPortalPanel");
        UIElement SettingsPortalPanel = (UIElement)player.getAttribute("SettingsPortalPanel");
        UILabel AllowPlayerTPMenuButton = (UILabel)player.getAttribute("AllowPlayerTPMenuButton");
        if (eventID == exitPortalbuttonID) {
            player.setMouseCursorVisible(false);
            MainPortalPanel.setVisible(false);
        }
        if (eventID == ExitPortalNameTextFieldID) {
            ExitPortalNameTextField.setText("");
            MainPortalPanel.addChild((UIElement)ExitPortalNameTextField);
            player.addUIElement((UIElement)ExitPortalNameTextField);
        }
        if (eventID == EntrancePortalNameTextFieldID) {
            EntrancePortalNameTextField.setText("");
            MainPortalPanel.addChild((UIElement)EntrancePortalNameTextField);
            player.addUIElement((UIElement)EntrancePortalNameTextField);
        }
        if (eventID == PortalEnterNameButtonID) {
            EntrancePortalNameTextField.getCurrentText(player, EntrancePortalNameText -> {
                if (EntrancePortalNameText.equals("")) {
                    player.sendTextMessage("you must enter a name for the Entrance portal");
                    return;
                }
                if (EntrancePortalNameText.equals("Entrance Portal Name Here")) {
                    player.sendTextMessage("you must enter a name for the Entrance portal");
                    return;
                }
                this.database.executeUpdate("UPDATE Portals SET PortalNameEntrance = '" + EntrancePortalNameText + "' WHERE PortalExitLocation = 'Exit'");
                player.sendTextMessage("Entrance Portal Name Set: " + EntrancePortalNameText);
            });
            ExitPortalNameTextField.getCurrentText(player, ExitPortalNameText -> {
                if (ExitPortalNameText.equals("")) {
                    player.sendTextMessage("you must enter a name for the Entrance portal");
                    return;
                }
                if (ExitPortalNameText.equals("Exit Portal Name Here")) {
                    player.sendTextMessage("you must enter a name for the Exit portal");
                    return;
                }
                this.database.executeUpdate("UPDATE Portals SET PortalNameExit = '" + ExitPortalNameText + "' WHERE PortalExitLocation = 'Exit'");
                player.sendTextMessage("Exit Portal Name Set: " + ExitPortalNameText);
            });
        }
        if (eventID == PortalColourGreenButtonID) {
            player.sendTextMessage("Portal Colour set Green");
            player.setAttribute("PortalColour", (Object)"PortalGREEN.prefab");
        }
        if (eventID == PortalColourRedButtonID) {
            player.sendTextMessage("Portal Colour set Red");
            player.setAttribute("PortalColour", (Object)"PortalRED.prefab");
        }
        if (eventID == PortalColourBlueButtonID) {
            player.sendTextMessage("Portal Colour set Blue");
            player.setAttribute("PortalColour", (Object)"PortalBLUE.prefab");
        }
        if (eventID == PortalColourYellowButtonID) {
            player.sendTextMessage("Portal Colour set Yellow");
            player.setAttribute("PortalColour", (Object)"PortalYELLOW.prefab");
        }
        if (eventID == PortalColourClearButtonID) {
            player.sendTextMessage("Portal Colour set Clear");
            player.setAttribute("PortalColour", (Object)"");
        }
        if (eventID == exitSettingsPortalbuttonID) {
            player.setMouseCursorVisible(false);
            SettingsPortalPanel.setVisible(false);
        }
        if (eventID == PortalNextButtonID) {
            try (ResultSet Result2 = this.database.executeQuery("SELECT count(*) FROM `Portals`");){
                if (Result2.next()) {
                    int CountRows = Result2.getInt(1);
                    player.setAttribute("CountRows", (Object)CountRows);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            list = (Integer)player.getAttribute("list");
            String Backclicked = (String)player.getAttribute("BackClicked");
            if (Backclicked == "Clicked") {
                ++list;
            }
            if (list <= -1) {
                list = 0;
            }
            try {
                Result = this.database.executeQuery("SELECT * FROM `Portals` LIMIT '" + list + "', 1 ");
                try {
                    if (Result.next()) {
                        String PortalNameEntrance = Result.getString("PortalNameEntrance");
                        String PortalNameExit = Result.getString("PortalNameExit");
                        player.setAttribute("PortalID", (Object)Result.getInt("ID"));
                        int RowNumver = list + 1;
                        SettingsEntrancePortalNameTextField.setText(PortalNameEntrance);
                        SettingsExitPortalNameTextField.setText(PortalNameExit);
                        ++list;
                        Object Rows = player.getAttribute("CountRows");
                        int CountRows = (Integer)Rows;
                        if (RowNumver == CountRows) {
                            list = 0;
                        }
                        player.setAttribute("list", (Object)list);
                        String Backclick = "NotClicked";
                        player.setAttribute("BackClicked", (Object)Backclick);
                        String Nextclick = "Clicked";
                        player.setAttribute("NextClicked", (Object)Nextclick);
                        return;
                    }
                }
                finally {
                    if (Result != null) {
                        Result.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (eventID == PortalBackButtonID) {
            try (ResultSet Result3 = this.database.executeQuery("SELECT count(*) FROM `Portals`");){
                if (Result3.next()) {
                    int CountRows = Result3.getInt(1);
                    player.setAttribute("CountRows", (Object)CountRows);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            list = (Integer)player.getAttribute("list");
            String Nextclicked = (String)player.getAttribute("NextClicked");
            if (Nextclicked == "Clicked") {
                --list;
            }
            if (list <= -1) {
                list = 0;
            }
            --list;
            try {
                Result = this.database.executeQuery("SELECT * FROM `Portals` LIMIT '" + list + "', 1 ");
                try {
                    if (Result.next()) {
                        String PortalNameEntrance = Result.getString("PortalNameEntrance");
                        String PortalNameExit = Result.getString("PortalNameExit");
                        player.setAttribute("PortalID", (Object)Result.getInt("ID"));
                        int RowNumver = list + 1;
                        SettingsEntrancePortalNameTextField.setText(PortalNameEntrance);
                        SettingsExitPortalNameTextField.setText(PortalNameExit);
                        Object Rows = player.getAttribute("CountRows");
                        int CountRows = (Integer)Rows;
                        if (RowNumver == 1) {
                            list = CountRows;
                        }
                        player.setAttribute("list", (Object)list);
                        String Nextclick = "NotClicked";
                        player.setAttribute("NextClicked", (Object)Nextclick);
                        String Backclick = "Clicked";
                        player.setAttribute("BackClicked", (Object)Backclick);
                        return;
                    }
                }
                finally {
                    if (Result != null) {
                        Result.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (player.isAdmin() && eventID == DeletePortalButtonID) {
            PortalID = (Integer)player.getAttribute("PortalID");
            if (PortalID != 0) {
                SettingsEntrancePortalNameTextField.getCurrentText(player, EntrancePortalNameText -> SettingsExitPortalNameTextField.getCurrentText(player, ExitPortalNameText -> {
                    try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalNameEntrance` = '" + EntrancePortalNameText + "' AND `ID` = '" + PortalID + "'");){
                        if (result.next()) {
                            String Portals2;
                            int ObjectExitTextID = result.getInt("ObjectExitTextID");
                            int ObjectExitPortalID = result.getInt("ObjectExitPortalID");
                            int ObjectEntranceTextID = result.getInt("ObjectEntranceTextID");
                            int ObjectEntrancePortalID = result.getInt("ObjectEntrancePortalID");
                            String PortalEntranceLocationChunkpos = result.getString("PortalEntranceLocationChunkpos");
                            String PortalEntranceLocationBlockpos = result.getString("PortalEntranceLocationBlockpos");
                            String PortalExitLocationChunkpos = result.getString("PortalExitLocationChunkpos");
                            String PortalExitLocationBlockpos = result.getString("PortalExitLocationBlockpos");
                            for (Prefab EntrancePortal : this.EntrancePortals) {
                                if (EntrancePortal.getID() != ObjectEntrancePortalID) continue;
                                for (Player AllPlayers : Server.getAllPlayers()) {
                                    AllPlayers.removeGameObject((GameObject)EntrancePortal);
                                }
                            }
                            for (Text3D EntrancePortalName : this.EntrancePortalNames) {
                                if (EntrancePortalName.getID() != ObjectEntranceTextID) continue;
                                for (Player AllPlayers : Server.getAllPlayers()) {
                                    AllPlayers.removeGameObject((GameObject)EntrancePortalName);
                                }
                            }
                            for (Prefab ExitPortal : this.ExitPortals) {
                                if (ExitPortal.getID() != ObjectExitPortalID) continue;
                                for (Player AllPlayers : Server.getAllPlayers()) {
                                    AllPlayers.removeGameObject((GameObject)ExitPortal);
                                }
                            }
                            for (Text3D ExitPortalName : this.ExitPortalNames) {
                                if (ExitPortalName.getID() != ObjectExitTextID) continue;
                                for (Player AllPlayers : Server.getAllPlayers()) {
                                    AllPlayers.removeGameObject((GameObject)ExitPortalName);
                                }
                            }
                            Iterator<String> RemovePortal = this.setPortalEntranceLocationBlockpos.iterator();
                            while (RemovePortal.hasNext()) {
                                Portals2 = RemovePortal.next();
                                if (!Portals2.equals(PortalEntranceLocationBlockpos)) continue;
                                RemovePortal.remove();
                            }
                            RemovePortal = this.setPortalExitLocationBlockpos.iterator();
                            while (RemovePortal.hasNext()) {
                                Portals2 = RemovePortal.next();
                                if (!Portals2.equals(PortalExitLocationBlockpos)) continue;
                                RemovePortal.remove();
                            }
                            this.database.executeUpdate("DELETE FROM `Portals` WHERE `PortalNameEntrance` = '" + EntrancePortalNameText + "' AND `PortalNameExit` = '" + ExitPortalNameText + "'");
                            SettingsEntrancePortalNameTextField.setText("deleted");
                            SettingsExitPortalNameTextField.setText("deleted");
                            player.sendTextMessage("deleted Portals " + EntrancePortalNameText + " And " + ExitPortalNameText);
                        } else {
                            player.sendTextMessage("error no portal found");
                        }
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }));
            } else {
                player.sendTextMessage("error no portal found");
            }
        }
        if (player.isAdmin() && eventID == UpdatePortalButtonID) {
            PortalID = (Integer)player.getAttribute("PortalID");
            SettingsEntrancePortalNameTextField.getCurrentText(player, EntrancePortalNameText -> SettingsExitPortalNameTextField.getCurrentText(player, ExitPortalNameText -> {
                this.database.executeUpdate("UPDATE Portals SET PortalNameEntrance = '" + EntrancePortalNameText + "', PortalNameExit = '" + ExitPortalNameText + "' WHERE ID = '" + PortalID + "'");
                player.sendTextMessage("Exit Portal Name Set: " + ExitPortalNameText);
                player.sendTextMessage("Entrance Portal Name Set: " + EntrancePortalNameText);
                SettingsEntrancePortalNameTextField.setText("Updated");
                SettingsExitPortalNameTextField.setText("Updated");
            }));
        }
        if (eventID == PortalTeleportEntranceButtonID) {
            PortalID = (Integer)player.getAttribute("PortalID");
            SettingsEntrancePortalNameTextField.getCurrentText(player, EntrancePortalNameText -> {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalNameEntrance` = '" + EntrancePortalNameText + "' AND `ID` = '" + PortalID + "'");){
                    if (result.next()) {
                        String endpos = result.getString("PortalEntranceLocation");
                        String getRotation = result.getString("PortalEntranceRotation");
                        Quaternion Rotation = new Quaternion().fromString(getRotation);
                        Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 1.0f));
                        Vector3f EntranceLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                        float NEWPositionX = EntranceLocation.x + viewDir.x;
                        float NEWPositionY = EntranceLocation.y + viewDir.y;
                        float NEWPositionZ = EntranceLocation.z + viewDir.z;
                        player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                        player.setRotation(Rotation);
                        SoundAsset soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                        player.playSound(soundfile);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        if (eventID == PortalTeleportExitButtonID) {
            PortalID = (Integer)player.getAttribute("PortalID");
            SettingsExitPortalNameTextField.getCurrentText(player, ExitPortalNameText -> {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalNameExit` = '" + ExitPortalNameText + "' AND `ID` = '" + PortalID + "'");){
                    if (result.next()) {
                        String endpos = result.getString("PortalExitLocation");
                        String getRotation = result.getString("PortalExitRotation");
                        Quaternion Rotation = new Quaternion().fromString(getRotation);
                        Vector3f ExitLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                        Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 1.0f));
                        float NEWPositionX = ExitLocation.x + viewDir.x;
                        float NEWPositionY = ExitLocation.y + viewDir.y;
                        float NEWPositionZ = ExitLocation.z + viewDir.z;
                        player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                        player.setRotation(Rotation);
                        SoundAsset soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                        player.playSound(soundfile);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        if (eventID == (PlacePortalButtonID = ((Integer)player.getAttribute("PlacePortalButtonID")).intValue())) {
            if (Boolean.FALSE.equals(player.getAttribute("PortalPlaced"))) {
                EntrancePortalNameTextField.getCurrentText(player, EntrancePortalNameText -> {
                    if (EntrancePortalNameText.equals("")) {
                        player.sendTextMessage("you must enter a name for the Entrance portal!!! Then click enter");
                        return;
                    }
                    if (EntrancePortalNameText.equals("Entrance Portal Name Here")) {
                        player.sendTextMessage("you must enter a name for the Entrance portal!!! Then click enter");
                        player.setAttribute("PortalPlaced", (Object)false);
                        return;
                    }
                    ExitPortalNameTextField.getCurrentText(player, ExitPortalNameText -> {
                        if (ExitPortalNameText.equals("")) {
                            player.sendTextMessage("you must enter a name for the Entrance portal!!! Then click enter");
                            return;
                        }
                        if (ExitPortalNameText.equals("Exit Portal Name Here")) {
                            player.sendTextMessage("you must enter a name for the Exit portal!!! Then click enter");
                            player.setAttribute("PortalPlaced", (Object)false);
                            return;
                        }
                        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/portal.bundle"));
                        String PortalColour = (String)player.getAttribute("PortalColour");
                        PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PortalColour);
                        Prefab prefab = new Prefab(asset);
                        prefab.setLayer(6);
                        prefab.setLocalPosition(player.getPosition());
                        prefab.setLocalRotation(0.0f, player.getRotation().getYaw(), 0.0f);
                        this.EntrancePortals.add(prefab);
                        for (Player AllPlayers : Server.getAllPlayers()) {
                            AllPlayers.addGameObject((GameObject)prefab);
                        }
                        float getx = player.getPosition().x;
                        float gety = player.getPosition().y + 4.0f;
                        float getz = player.getPosition().z;
                        Text3D EntrancePortalName = new Text3D("", false);
                        EntrancePortalName.setLocalPosition(getx, gety, getz);
                        EntrancePortalName.setFontSize(0.8f);
                        EntrancePortalName.setBillboard(true);
                        EntrancePortalName.setText(EntrancePortalNameText);
                        this.EntrancePortalNames.add(EntrancePortalName);
                        for (Player AllPlayers : Server.getAllPlayers()) {
                            AllPlayers.addGameObject((GameObject)EntrancePortalName);
                        }
                        this.setPortalEntranceLocationBlockpos.add(Blockpos.toString());
                        this.database.executeUpdate("INSERT INTO `Portals` (PortalNameEntrance, PortalNameExit, PortalColour, PortalEntranceLocation, PortalEntranceLocationChunkpos, PortalEntranceLocationBlockpos, PortalExitLocation, PortalExitLocationChunkpos, PortalExitLocationBlockpos, PortalEntranceRotation, PortalExitRotation, ObjectEntranceTextID, ObjectEntrancePortalID) VALUES ('PortalEntrance','Exit','" + String.valueOf(player.getAttribute("PortalColour")) + "','" + String.valueOf(player.getPosition()) + "','" + String.valueOf(Chunkpos) + "','" + String.valueOf(Blockpos) + "','Exit','Chunkpos','Blockpos','" + String.valueOf(player.getRotation()) + "','" + String.valueOf(player.getRotation()) + "','" + EntrancePortalName.getID() + "','" + prefab.getID() + "');");
                        player.sendTextMessage("Entrance Portal Made");
                        this.database.executeUpdate("UPDATE Portals SET PortalNameEntrance = '" + EntrancePortalNameText + "' WHERE PortalExitLocation = 'Exit'");
                        player.sendTextMessage("Entrance Portal Name Set: " + EntrancePortalNameText);
                        this.database.executeUpdate("UPDATE Portals SET PortalNameExit = '" + ExitPortalNameText + "' WHERE PortalExitLocation = 'Exit'");
                        player.sendTextMessage("Exit Portal Name Set: " + ExitPortalNameText);
                        player.setAttribute("PortalPlaced", (Object)true);
                    });
                });
            } else {
                player.sendTextMessage("No Exit portal made First finish setting up your last portal");
            }
        }
        if (eventID == (PlaceExitPortalButtonID = ((Integer)player.getAttribute("PlaceExitPortalButtonID")).intValue())) {
            if (Boolean.TRUE.equals(player.getAttribute("PortalPlaced"))) {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalExitLocation` = 'Exit'");){
                    if (result.next()) {
                        String PortalNameExit = result.getString("PortalNameExit");
                        AssetBundle bundle = AssetBundle.loadFromFile((String)(this.getPath() + "/assets/portal.bundle"));
                        String PortalColour = (String)player.getAttribute("PortalColour");
                        PrefabAsset asset = PrefabAsset.loadFromAssetBundle((AssetBundle)bundle, (String)PortalColour);
                        Prefab prefab = new Prefab(asset);
                        prefab.setLayer(6);
                        prefab.setLocalPosition(player.getPosition());
                        prefab.setLocalRotation(0.0f, player.getRotation().getYaw(), 0.0f);
                        this.ExitPortals.add(prefab);
                        for (Player AllPlayers : Server.getAllPlayers()) {
                            AllPlayers.addGameObject((GameObject)prefab);
                        }
                        float getx = player.getPosition().x;
                        float gety = player.getPosition().y + 4.0f;
                        float getz = player.getPosition().z;
                        Text3D ExitPortalName = new Text3D("", false);
                        ExitPortalName.setLocalPosition(getx, gety, getz);
                        ExitPortalName.setFontSize(0.8f);
                        ExitPortalName.setBillboard(true);
                        ExitPortalName.setText(PortalNameExit);
                        this.ExitPortalNames.add(ExitPortalName);
                        for (Player AllPlayers : Server.getAllPlayers()) {
                            AllPlayers.addGameObject((GameObject)ExitPortalName);
                        }
                        player.setAttribute("StartPortal", (Object)"Stop");
                        Timer timer5sec = new Timer(5.0f, 0.0f, 0, null);
                        Runnable timerTask5sec = () -> player.setAttribute("StartPortal", (Object)"Start");
                        timer5sec.setTask(timerTask5sec);
                        timer5sec.start();
                        this.setPortalExitLocationBlockpos.add(Blockpos.toString());
                        this.database.executeUpdate("UPDATE Portals SET PortalExitLocation = '" + String.valueOf(player.getPosition()) + "', PortalColour = '" + String.valueOf(player.getAttribute("PortalColour")) + "', PortalExitLocationChunkpos = '" + String.valueOf(Chunkpos) + "', PortalExitLocationBlockpos = '" + String.valueOf(Blockpos) + "', PortalExitRotation = '" + String.valueOf(player.getRotation()) + "', ObjectExitTextID = '" + ExitPortalName.getID() + "', ObjectExitPortalID = '" + prefab.getID() + "' WHERE PortalExitLocation = 'Exit'");
                        player.sendTextMessage("Exit Portal Made");
                        player.setAttribute("PortalPlaced", (Object)false);
                    } else {
                        player.sendTextMessage("No Entrance portal made");
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                player.sendTextMessage("No Entrace portal made First finish setting up your entrance portal");
            }
        }
        if (eventID == (SettingsButtonID = ((Integer)player.getAttribute("SettingsButtonID")).intValue())) {
            MainPortalPanel.setVisible(false);
            SettingsPortalPanel.setVisible(true);
            try (ResultSet result = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");){
                if (result.next()) {
                    int PlayerTpAllowed = result.getInt("PlayerTpAllowed");
                    if (PlayerTpAllowed == 0) {
                        player.setAttribute("AllowPlayerTP", (Object)false);
                        AllowPlayerTPMenuButton.setText("<b> Allow Player TP Menu (Off)</b>");
                    } else if (PlayerTpAllowed == 1) {
                        player.setAttribute("AllowPlayerTP", (Object)true);
                        AllowPlayerTPMenuButton.setText("<b> Allow Player TP Menu (On)</b>");
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (eventID == (MainMenuButtonID = ((Integer)player.getAttribute("MainMenuButtonID")).intValue())) {
            MainPortalPanel.setVisible(true);
            SettingsPortalPanel.setVisible(false);
        }
        if (eventID == (AllowPlayerTPMenuButtonID = ((Integer)player.getAttribute("AllowPlayerTPMenuButtonID")).intValue())) {
            if (Boolean.FALSE.equals(player.getAttribute("AllowPlayerTP"))) {
                player.setAttribute("AllowPlayerTP", (Object)true);
                AllowPlayerTPMenuButton.setText("<b> Allow Player TP Menu (On)</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET PlayerTpAllowed = '1' WHERE ID = '1'");
            } else if (Boolean.TRUE.equals(player.getAttribute("AllowPlayerTP"))) {
                player.setAttribute("AllowPlayerTP", (Object)false);
                AllowPlayerTPMenuButton.setText("<b> Allow Player TP Menu (Off)</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET PlayerTpAllowed = '0' WHERE ID = '1'");
            }
        }
        UITextField PlayerTPExitPortalNameTextField = (UITextField)player.getAttribute("PlayerTPExitPortalNameTextField");
        int PlayerTPExitPortalNameTextFieldID = PlayerTPExitPortalNameTextField.getID();
        UITextField PlayerTPEntrancePortalNameTextField = (UITextField)player.getAttribute("PlayerTPEntrancePortalNameTextField");
        int PlayerTPEntrancePortalNameTextFieldID = PlayerTPEntrancePortalNameTextField.getID();
        int PlayerTPNextButtonID = (Integer)player.getAttribute("PlayerTPNextButtonID");
        if (eventID == PlayerTPNextButtonID) {
            try (ResultSet Result4 = this.database.executeQuery("SELECT count(*) FROM `Portals`");){
                if (Result4.next()) {
                    int CountRows = Result4.getInt(1);
                    player.setAttribute("CountRows", (Object)CountRows);
                }
            }
            int list2 = (Integer)player.getAttribute("list");
            String Backclicked = (String)player.getAttribute("BackClicked");
            if (Backclicked == "Clicked") {
                ++list2;
            }
            if (list2 <= -1) {
                list2 = 0;
            }
            try (ResultSet Result5 = this.database.executeQuery("SELECT * FROM `Portals` LIMIT '" + list2 + "', 1 ");){
                if (Result5.next()) {
                    String PortalNameEntrance = Result5.getString("PortalNameEntrance");
                    String PortalNameExit = Result5.getString("PortalNameExit");
                    player.setAttribute("PortalID", (Object)Result5.getInt("ID"));
                    int RowNumver = list2 + 1;
                    PlayerTPEntrancePortalNameTextField.setText(PortalNameEntrance);
                    PlayerTPExitPortalNameTextField.setText(PortalNameExit);
                    ++list2;
                    Object Rows = player.getAttribute("CountRows");
                    int CountRows = (Integer)Rows;
                    if (RowNumver == CountRows) {
                        list2 = 0;
                    }
                    player.setAttribute("list", (Object)list2);
                    String Backclick = "NotClicked";
                    player.setAttribute("BackClicked", (Object)Backclick);
                    String Nextclick = "Clicked";
                    player.setAttribute("NextClicked", (Object)Nextclick);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (eventID == (PlayerTPBackButtonID = ((Integer)player.getAttribute("PlayerTPBackButtonID")).intValue())) {
            try (ResultSet Result6 = this.database.executeQuery("SELECT count(*) FROM `Portals`");){
                if (Result6.next()) {
                    int CountRows = Result6.getInt(1);
                    player.setAttribute("CountRows", (Object)CountRows);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int list3 = (Integer)player.getAttribute("list");
            String Nextclicked = (String)player.getAttribute("NextClicked");
            if (Nextclicked == "Clicked") {
                --list3;
            }
            if (list3 <= -1) {
                list3 = 0;
            }
            --list3;
            try (ResultSet Result7 = this.database.executeQuery("SELECT * FROM `Portals` LIMIT '" + list3 + "', 1 ");){
                if (Result7.next()) {
                    String PortalNameEntrance = Result7.getString("PortalNameEntrance");
                    String PortalNameExit = Result7.getString("PortalNameExit");
                    player.setAttribute("PortalID", (Object)Result7.getInt("ID"));
                    int RowNumver = list3 + 1;
                    PlayerTPEntrancePortalNameTextField.setText(PortalNameEntrance);
                    PlayerTPExitPortalNameTextField.setText(PortalNameExit);
                    Object Rows = player.getAttribute("CountRows");
                    int CountRows = (Integer)Rows;
                    if (RowNumver == 1) {
                        list3 = CountRows;
                    }
                    player.setAttribute("list", (Object)list3);
                    String Nextclick = "NotClicked";
                    player.setAttribute("NextClicked", (Object)Nextclick);
                    String Backclick = "Clicked";
                    player.setAttribute("BackClicked", (Object)Backclick);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        UIElement PlayerTPPortalPanel = (UIElement)player.getAttribute("PlayerTPPortalPanel");
        int exitPlayerTPPortalbuttonID = (Integer)player.getAttribute("exitPlayerTPPortalbuttonID");
        if (eventID == exitPlayerTPPortalbuttonID) {
            player.setMouseCursorVisible(false);
            PlayerTPPortalPanel.setVisible(false);
        }
        if (eventID == (PlayerTPTeleportExitButtonID = ((Integer)player.getAttribute("PlayerTPTeleportExitButtonID")).intValue())) {
            int PortalID2 = (Integer)player.getAttribute("PortalID");
            PlayerTPExitPortalNameTextField.getCurrentText(player, PlayerTPExitPortalNameText -> {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalNameExit` = '" + PlayerTPExitPortalNameText + "' AND `ID` = '" + PortalID2 + "'");){
                    if (result.next()) {
                        String endpos = result.getString("PortalExitLocation");
                        String getRotation = result.getString("PortalExitRotation");
                        Quaternion Rotation = new Quaternion().fromString(getRotation);
                        Vector3f ExitLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                        Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 1.0f));
                        float NEWPositionX = ExitLocation.x + viewDir.x;
                        float NEWPositionY = ExitLocation.y + viewDir.y;
                        float NEWPositionZ = ExitLocation.z + viewDir.z;
                        player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                        player.setRotation(Rotation);
                        SoundAsset soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                        player.playSound(soundfile);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        if (eventID == (PlayerTPTeleportEntranceButtonID = ((Integer)player.getAttribute("PlayerTPTeleportEntranceButtonID")).intValue())) {
            int PortalID3 = (Integer)player.getAttribute("PortalID");
            PlayerTPEntrancePortalNameTextField.getCurrentText(player, PlayerTPEntrancePortalNameText -> {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `Portals` WHERE `PortalNameEntrance` = '" + PlayerTPEntrancePortalNameText + "' AND `ID` = '" + PortalID3 + "'");){
                    if (result.next()) {
                        String endpos = result.getString("PortalEntranceLocation");
                        String getRotation = result.getString("PortalEntranceRotation");
                        Quaternion Rotation = new Quaternion().fromString(getRotation);
                        Vector3f viewDir = Rotation.multLocal(new Vector3f(0.0f, 0.0f, 1.0f));
                        Vector3f EntranceLocation = new Vector3f().add(Vector3f.ONE).fromString(endpos);
                        float NEWPositionX = EntranceLocation.x + viewDir.x;
                        float NEWPositionY = EntranceLocation.y + viewDir.y;
                        float NEWPositionZ = EntranceLocation.z + viewDir.z;
                        player.setPosition(NEWPositionX, NEWPositionY, NEWPositionZ);
                        player.setRotation(Rotation);
                        SoundAsset soundfile = SoundAsset.loadFromFile((String)(this.getPath() + "/assets/warp.mp3"));
                        player.playSound(soundfile);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Portals.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
    }
}

