/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.world.batch;

import java.util.ArrayList;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class ConstructionPlaceBatch {
    private ArrayList<Entry> entries;

    public ConstructionPlaceBatch() {
        this(32);
    }

    public ConstructionPlaceBatch(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    public void add(int shape, int texture, float textureScale, int color, Vector3f worldPosition, Quaternion rotation, Vector3f scale, Vector3f surfaceOffset, Vector3f surfaceScale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float posx = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float posy = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float posz = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        this.entries.add(new Entry(shape, cx, cy, cz, texture, textureScale, color, new Vector3f(posx, posy, posz), rotation.copy(), scale, surfaceOffset, surfaceScale, 0));
    }

    public int count() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    private byte[] serialize() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    record Entry(int shape, int cx, int cy, int cz, int texture, float textureScale, int color, Vector3f pos, Quaternion rot, Vector3f scale, Vector3f surfaceOffset, Vector3f surfaceScale, int flags) {
    }
}

