/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

public class Vector4f {
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Vector4f UNIT_X = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Y = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Z = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f UNIT_W = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(Vector4f copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
        this.w = copy.w;
    }

    public Vector4f copy() {
        return new Vector4f(this.x, this.y, this.z, this.w);
    }

    public Vector4f set(Vector4f vector) {
        return this.set(vector.x, vector.y, vector.z, vector.w);
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f setX(float x) {
        this.x = x;
        return this;
    }

    public Vector4f setY(float y) {
        this.y = y;
        return this;
    }

    public Vector4f setZ(float z) {
        this.z = z;
        return this;
    }

    public Vector4f setW(float w) {
        this.w = w;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public float dot(Vector4f other) {
        return this.dot(other.x, other.y, other.z, other.w);
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float distance(Vector4f other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y, other.z, other.w));
    }

    public float distance(float x, float y, float z, float w) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    public float distanceSquared(Vector4f other) {
        return this.distanceSquared(other.x, other.y, other.z, other.w);
    }

    public float distanceSquared(float x, float y, float z, float w) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        double dw = this.w - w;
        return (float)(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public Vector4f add(Vector4f other) {
        return new Vector4f(this).addLocal(other);
    }

    public Vector4f add(float addX, float addY, float addZ, float addW) {
        return new Vector4f(this).addLocal(addX, addY, addZ, addW);
    }

    public Vector4f addLocal(Vector4f other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        this.w += other.w;
        return this;
    }

    public Vector4f addLocal(float addX, float addY, float addZ, float addW) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        this.w += addW;
        return this;
    }

    public Vector4f subtract(Vector4f other) {
        return new Vector4f(this).subtractLocal(other);
    }

    public Vector4f subtract(float subtractX, float subtractY, float subtractZ, float subtractW) {
        return new Vector4f(this).subtractLocal(subtractX, subtractY, subtractZ, subtractW);
    }

    public Vector4f subtractLocal(Vector4f other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        this.w -= other.w;
        return this;
    }

    public Vector4f subtractLocal(float subtractX, float subtractY, float subtractZ, float subtractW) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        this.w -= subtractW;
        return this;
    }

    public Vector4f mult(float scalar) {
        return new Vector4f(this).multLocal(scalar);
    }

    public Vector4f mult(Vector4f other) {
        return new Vector4f(this).multLocal(other);
    }

    public Vector4f mult(float multX, float multY, float multZ, float multW) {
        return new Vector4f(this).multLocal(multX, multY, multZ, multW);
    }

    public Vector4f multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Vector4f multLocal(Vector4f other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        this.w *= other.z;
        return this;
    }

    public Vector4f multLocal(float multX, float multY, float multZ, float multW) {
        this.x *= multX;
        this.y *= multY;
        this.z *= multZ;
        this.w *= multW;
        return this;
    }

    public Vector4f divide(Vector4f other) {
        return new Vector4f(this).divideLocal(other);
    }

    public Vector4f divideLocal(float scalar) {
        float s = 1.0f / scalar;
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        return this;
    }

    public Vector4f divideLocal(Vector4f other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        this.w /= other.w;
        return this;
    }

    public Vector4f negate() {
        return new Vector4f(this).negateLocal();
    }

    public Vector4f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4f normalizeLocal() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
        this.w /= l;
        return this;
    }

    public float angleBetween(Vector4f other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public Vector4f zero() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public Vector4f interpolateLocal(Vector4f finalVector, float mu) {
        this.x = (1.0f - mu) * this.x + mu * finalVector.x;
        this.y = (1.0f - mu) * this.y + mu * finalVector.y;
        this.z = (1.0f - mu) * this.z + mu * finalVector.z;
        this.w = (1.0f - mu) * this.w + mu * finalVector.w;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector4f) {
            Vector4f v = (Vector4f)o;
            return this.equals(v.x, v.y, v.z, v.w);
        }
        return false;
    }

    public boolean equals(float x, float y, float z, float w) {
        return this.x == x && this.y == y && this.z == z && this.w == w;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Float.floatToIntBits(this.x);
        hash = 47 * hash + Float.floatToIntBits(this.y);
        hash = 47 * hash + Float.floatToIntBits(this.z);
        hash = 47 * hash + Float.floatToIntBits(this.w);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

