/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.definitions.Clothing;
import net.risingworld.api.definitions.Constructions;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.utils.Vector3f;

public class Item {
    final long handle;
    ConcurrentHashMap<String, Object> attributes = null;

    private Item(long handle) {
        this.handle = handle;
    }

    public boolean isValid() {
        return this.isValid(this.handle);
    }

    private native boolean isValid(long var1);

    public Items.ItemDefinition getDefinition() {
        return Definitions.getItemDefinition(this.getTypeID());
    }

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public short getTypeID() {
        return this.getTypeID(this.handle);
    }

    private native short getTypeID(long var1);

    public int getVariant() {
        return this.getVariant(this.handle);
    }

    private native int getVariant(long var1);

    public int getStack() {
        return this.getStack(this.handle);
    }

    private native int getStack(long var1);

    public void setStack(int stack) {
        this.setStack(this.handle, stack);
    }

    private native void setStack(long var1, int var3);

    public int getMaxStackSize() {
        return this.getMaxStackSize(this.handle);
    }

    private native int getMaxStackSize(long var1);

    public float getValue() {
        return this.getValue(this.handle);
    }

    private native float getValue(long var1);

    public void setValue(float value) {
        this.setValue(this.handle, value);
    }

    private native void setValue(long var1, float var3);

    public short getStatus() {
        return this.getStatus(this.handle);
    }

    private native short getStatus(long var1);

    public void setStatus(short status) {
        this.setStatus(this.handle, status);
    }

    private native void setStatus(long var1, short var3);

    public Items.Modifier getModifier() {
        return Items.Modifier.get(this.getModifier(this.handle));
    }

    private native int getModifier(long var1);

    public void setModifier(Items.Modifier modifier) {
        this.setModifier(this.handle, modifier.value);
    }

    private native void setModifier(long var1, int var3);

    public int getDurability() {
        return this.getDurability(this.handle);
    }

    private native int getDurability(long var1);

    public void setDurability(int durability) {
        this.setDurability(this.handle, durability);
    }

    private native void setDurability(long var1, int var3);

    public boolean equals(Object o) {
        if (o instanceof Item) {
            Item item = (Item)o;
            return item.handle == this.handle;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (int)(this.handle ^ this.handle >>> 32);
        return hash;
    }

    public static class BlueprintItem
    extends Item {
        private BlueprintItem(long handle) {
            super(handle);
        }

        public long getBlueprintID() {
            return this.getBlueprintID(this.handle);
        }

        private native long getBlueprintID(long var1);

        public String getBlueprintName() {
            return this.getBlueprintName(this.handle);
        }

        private native String getBlueprintName(long var1);

        public String getBlueprintCreatorName() {
            return this.getBlueprintCreatorName(this.handle);
        }

        private native String getBlueprintCreatorName(long var1);

        public String getBlueprintCreatorUID() {
            return this.getBlueprintCreatorUID(this.handle);
        }

        private native String getBlueprintCreatorUID(long var1);

        public long getBlueprintCreationDate() {
            return this.getBlueprintCreationDate(this.handle);
        }

        private native long getBlueprintCreationDate(long var1);

        public int getBlueprintConstructionCount() {
            return this.getBlueprintConstructionCount(this.handle);
        }

        private native int getBlueprintConstructionCount(long var1);

        public int getBlueprintPlantCount() {
            return this.getBlueprintPlantCount(this.handle);
        }

        private native int getBlueprintPlantCount(long var1);

        public int getBlueprintObjectCount() {
            return this.getBlueprintObjectCount(this.handle);
        }

        private native int getBlueprintObjectCount(long var1);

        public int getBlueprintTotalElementCount() {
            return this.getBlueprintTotalElementCount(this.handle);
        }

        private native int getBlueprintTotalElementCount(long var1);
    }

    public static class ClothingItem
    extends Item {
        private ClothingItem(long handle) {
            super(handle);
        }

        public short getClothingID() {
            return this.getClothingID(this.handle);
        }

        private native short getClothingID(long var1);

        public String getClothingName() {
            return this.getClothingName(this.handle);
        }

        private native String getClothingName(long var1);

        public Clothing.ClothingDefinition getClothingDefinition() {
            return Definitions.getClothingDefinition(this.getClothingID());
        }

        public long getInfoID() {
            return this.getInfoID(this.handle);
        }

        private native long getInfoID(long var1);

        private native int getColor(long var1);
    }

    public static class ConstructionItem
    extends Item {
        private ConstructionItem(long handle) {
            super(handle);
        }

        public byte getConstructionID() {
            return this.getConstructionID(this.handle);
        }

        private native byte getConstructionID(long var1);

        public String getConstructionName() {
            return this.getConstructionName(this.handle);
        }

        private native String getConstructionName(long var1);

        public Constructions.ConstructionDefinition getConstructionDefinition() {
            return Definitions.getConstructionDefinition(this.getConstructionID());
        }

        public int getColor() {
            return this.getColor(this.handle);
        }

        private native int getColor(long var1);

        public long getInfoID() {
            return this.getInfoID(this.handle);
        }

        private native long getInfoID(long var1);

        public Vector3f getSize() {
            return this.getSize(this.handle);
        }

        private native Vector3f getSize(long var1);
    }

    public static class ObjectItem
    extends Item {
        private ObjectItem(long handle) {
            super(handle);
        }

        public short getObjectID() {
            return this.getObjectID(this.handle);
        }

        private native short getObjectID(long var1);

        public String getObjectName() {
            return this.getObjectName(this.handle);
        }

        private native String getObjectName(long var1);

        public Objects.ObjectDefinition getObjectDefinition() {
            return Definitions.getObjectDefinition(this.getObjectID());
        }
    }
}

