/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.jiw.unity.runtime.PluginGameObjectManager;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.GameObject;

public class Light
extends GameObject {
    Type type;
    int color = 0xFFFFFF;
    float intensity = 1000.0f;
    float range = 20.0f;
    float radius = 0.1f;
    float visibleDistance = 100.0f;
    float spotAngle;
    float spotInnerAngle;
    boolean volumetrics = false;
    float volumetricsIntensity = 1.0f;
    boolean shadows = false;
    int shadowResolution = 128;
    float shadowIntensity = 1.0f;
    boolean isManaged = false;
    private static final int TYPE = 5;

    public Light(Type type) {
        this.type = type;
    }

    public Light(Type type, float intensity, float range, int color) {
        this.type = type;
        this.intensity = intensity;
        this.range = range;
        this.color = color;
    }

    @Override
    int getType() {
        return 5;
    }

    public Type getLightType() {
        return this.type;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateLight();
        }
    }

    public void setIntensity(float intensity) {
        if (this.intensity != intensity) {
            this.intensity = intensity;
            this.updateLight();
        }
    }

    public void setRange(float range) {
        if (this.range != range) {
            this.range = range;
            this.updateLight();
        }
    }

    public void setRadius(float radius) {
        if (this.radius != radius) {
            this.radius = radius;
            this.updateLight();
        }
    }

    public void setVisibleDistance(float distance) {
        if (this.visibleDistance != distance) {
            this.visibleDistance = distance;
            this.updateLight();
        }
    }

    public void setSpotAngle(float angle) {
        if (this.spotAngle != (angle = Utils.MathUtils.clamp(1.0f, 179.0f, angle))) {
            this.spotAngle = angle;
            this.updateLight();
        }
    }

    public void setSpotInnerAngle(float angle) {
        if (this.spotInnerAngle != (angle = Utils.MathUtils.clamp(1.0f, 179.0f, angle))) {
            this.spotInnerAngle = angle;
            this.updateLight();
        }
    }

    public void setVolumetrics(boolean set) {
        if (this.volumetrics != set) {
            this.volumetrics = set;
            this.updateLight();
        }
    }

    public void setVolumetricsIntensity(float intensity) {
        if (this.volumetricsIntensity != intensity) {
            this.volumetricsIntensity = intensity;
            this.updateLight();
        }
    }

    public void setShadowsEnabled(boolean set) {
        if (this.shadows != set) {
            this.shadows = set;
            this.updateLight();
        }
    }

    public void setShadowsMapResolution(int resolution) {
        if (this.shadowResolution != resolution) {
            this.shadowResolution = resolution;
            this.updateLight();
        }
    }

    public void setShadowIntensity(float intensity) {
        if (this.shadowIntensity != intensity) {
            this.shadowIntensity = intensity;
            this.updateLight();
        }
    }

    private void updateLight() {
        PluginGameObjectManager.updateObject((GameObject)this, (int)this.id, (boolean)false);
    }

    public static enum Type {
        Point,
        Spot;

    }
}

