/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui;

import java.util.Objects;
import net.jiw.unity.runtime.PluginUIManager;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.ui.style.Unit;
import net.risingworld.api.ui.style.WhiteSpace;
import net.risingworld.api.utils.Utils;

public class UILabel
extends UIElement {
    String text;
    boolean enableRichText = true;
    private static final int TYPE = 1;

    public UILabel() {
        this("");
    }

    public UILabel(String text) {
        this.text = text;
        this.enableRichText = true;
    }

    public void setText(String text) {
        if (!Objects.equals(this.text, text)) {
            this.text = text;
            this.updateLabel();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setRichTextEnabled(boolean set) {
        if (this.enableRichText != set) {
            this.enableRichText = set;
            this.updateLabel();
        }
    }

    public boolean isRichTextEnabled() {
        return this.enableRichText;
    }

    public void setFont(Font font) {
        this.style.font.set(font);
        this.updateStyle();
    }

    public void setFontSize(float size) {
        this.style.fontSize.set(size);
        this.updateStyle();
    }

    public void setFontSize(float size, Unit unit) {
        this.style.fontSize.set(size, unit);
        this.updateStyle();
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setFontColor(int rgba) {
        this.style.color.set(rgba);
        this.updateStyle();
    }

    public void setTextAlign(TextAnchor anchor) {
        this.style.textAlign.set(anchor);
        this.updateStyle();
    }

    public void setTextWrap(boolean wrap) {
        this.style.whiteSpace.set(wrap ? WhiteSpace.Normal : WhiteSpace.NoWrap);
        this.updateStyle();
    }

    @Override
    public void setPivot(Pivot pivot) {
        switch (pivot) {
            case UpperLeft: {
                this.style.textAlign.set(TextAnchor.UpperLeft);
                break;
            }
            case UpperCenter: {
                this.style.textAlign.set(TextAnchor.UpperCenter);
                break;
            }
            case UpperRight: {
                this.style.textAlign.set(TextAnchor.UpperRight);
                break;
            }
            case MiddleLeft: {
                this.style.textAlign.set(TextAnchor.MiddleLeft);
                break;
            }
            case MiddleCenter: {
                this.style.textAlign.set(TextAnchor.MiddleCenter);
                break;
            }
            case MiddleRight: {
                this.style.textAlign.set(TextAnchor.MiddleRight);
                break;
            }
            case LowerLeft: {
                this.style.textAlign.set(TextAnchor.LowerLeft);
                break;
            }
            case LowerCenter: {
                this.style.textAlign.set(TextAnchor.LowerCenter);
                break;
            }
            case LowerRight: {
                this.style.textAlign.set(TextAnchor.LowerRight);
                break;
            }
            default: {
                this.style.textAlign.set(TextAnchor.UpperLeft);
            }
        }
        super.setPivot(pivot);
    }

    @Override
    int getType() {
        return 1;
    }

    private void updateLabel() {
        PluginUIManager.updateUILabel((UILabel)this, (int)this.id);
    }
}

