/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jiw.unity.runtime.PluginGameObjectManager;
import net.jiw.unity.runtime.PluginUIManager;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.assets.Asset;
import net.risingworld.api.assets.SoundAsset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Clothes;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Skin;
import net.risingworld.api.objects.Vehicle;
import net.risingworld.api.sounds.Sound;
import net.risingworld.api.ui.MessageBoxButtons;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UITarget;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.Layer;
import net.risingworld.api.utils.OS;
import net.risingworld.api.utils.Platform;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.RaycastResult;
import net.risingworld.api.utils.SpawnPointType;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.GameObject;

public final class Player {
    private final int handle;
    private Skin skin = null;
    private Clothes clothes = null;
    private ConcurrentHashMap<String, Object> attributes = null;
    private static AtomicInteger soundIDCounter = new AtomicInteger(1);

    private Player(int handle) {
        this.handle = handle;
    }

    private void reset() {
        this.skin = null;
        this.clothes = null;
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public int getID() {
        return this.getID(this.handle);
    }

    private native int getID(int var1);

    public String getUID() {
        return this.getUID(this.handle);
    }

    private native String getUID(int var1);

    public int getDbID() {
        return this.handle;
    }

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(int var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(int var1, String var2);

    public long getLastTimeOnline() {
        return this.getLastTimeOnline(this.handle);
    }

    private native long getLastTimeOnline(int var1);

    public int getCurrentPlayTime() {
        return this.getCurrentPlayTime(this.handle);
    }

    private native int getCurrentPlayTime(int var1);

    public int getTotalPlayTime() {
        return this.getTotalPlayTime(this.handle);
    }

    private native int getTotalPlayTime(int var1);

    public String getPermissionGroup() {
        return this.getPermissionGroupName(this.handle);
    }

    private native String getPermissionGroupName(int var1);

    public void setPermissionGroup(String groupName) {
        this.setPermissionGroup(this.handle, groupName);
    }

    private native void setPermissionGroup(int var1, String var2);

    public String getActiveAreaPermission() {
        return this.getActiveAreaPermissionName(this.handle);
    }

    private native String getActiveAreaPermissionName(int var1);

    public Object getPermissionValue(String key, boolean includeAreas) {
        return this.getPermissionValue(this.handle, key, includeAreas);
    }

    private native Object getPermissionValue(int var1, String var2, boolean var3);

    public void setPermissionValue(String key, Object value) {
        this.setPermissionValue(this.handle, key, value);
    }

    private native void setPermissionValue(int var1, String var2, Object var3);

    public boolean isAdmin() {
        return this.isAdmin(this.handle);
    }

    private native boolean isAdmin(int var1);

    public void setAdmin(boolean set) {
        this.setAdmin(this.handle, set);
    }

    private native void setAdmin(int var1, boolean var2);

    public Inventory getInventory() {
        return this.getInventory(this.handle);
    }

    private native Inventory getInventory(int var1);

    public Item getEquippedItem() {
        return this.getEquippedItem(this.handle);
    }

    private native Item getEquippedItem(int var1);

    public void setEquippedItem(int quickslot) {
        this.setEquippedItem(this.handle, quickslot, Inventory.SlotType.Quickslot.ordinal());
    }

    public void setEquippedItem(int slot, Inventory.SlotType slotType) {
        this.setEquippedItem(this.handle, slot, slotType.value);
    }

    private native void setEquippedItem(int var1, int var2, int var3);

    public int getStatistic(String name) {
        return this.getStatistic(this.handle, name);
    }

    private native int getStatistic(int var1, String var2);

    public void setStatistic(String name, int value) {
        this.setStatistic(this.handle, name, value);
    }

    private native void setStatistic(int var1, String var2, int var3);

    public void sendTextMessage(String message) {
        this.sendTextMessage(this.handle, message);
    }

    private native void sendTextMessage(int var1, String var2);

    public void sendYellMessage(String message, float duration, boolean pulsate) {
        this.sendYellMessage(this.handle, message, duration, pulsate);
    }

    private native void sendYellMessage(int var1, String var2, float var3, boolean var4);

    public void showStatusMessage(String message, int duration) {
        this.showStatusMessage(this.handle, message, duration);
    }

    private native void showStatusMessage(int var1, String var2, int var3);

    public void setOption(String setting, Object value) {
        this.setOption(this.handle, setting, value == null ? null : value.toString());
    }

    private native void setOption(int var1, String var2, String var3);

    public void getOption(String setting, Callback<String> callback) {
        this.getOption(this.handle, setting, callback);
    }

    private native void getOption(int var1, String var2, Callback<String> var3);

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean hasAttribute(String key, Class type) {
        if (this.attributes == null) {
            return false;
        }
        Object attribute = this.attributes.get(key);
        return attribute != null && attribute.getClass() == type;
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }

    public Set<Map.Entry<String, Object>> getAttributes() {
        return this.attributes.entrySet();
    }

    public String getLanguage() {
        return this.getLanguage(this.handle);
    }

    private native String getLanguage(int var1);

    public String getSystemLanguage() {
        return this.getSystemLanguage(this.handle);
    }

    private native String getSystemLanguage(int var1);

    public OS getOperatingSystem() {
        return OS.get(this.getOperatingSystem(this.handle));
    }

    private native int getOperatingSystem(int var1);

    public Platform getPlatform() {
        return Platform.get(this.getPlatform(this.handle));
    }

    private native int getPlatform(int var1);

    public Vector3f getPosition() {
        return this.getPosition(this.handle);
    }

    private native Vector3f getPosition(int var1);

    public void setPosition(Vector3f position) {
        this.setPosition(this.handle, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(this.handle, x, y, z);
    }

    private native void setPosition(int var1, float var2, float var3, float var4);

    public void moveTo(Vector3f position, float speed) {
        this.moveTo(this.handle, position.x, position.y, position.z, speed);
    }

    public void moveTo(float x, float y, float z, float speed) {
        this.moveTo(this.handle, x, y, z, speed);
    }

    private native void moveTo(int var1, float var2, float var3, float var4, float var5);

    public Vector3i getChunkPosition() {
        return this.getChunkPosition(this.handle);
    }

    private native Vector3i getChunkPosition(int var1);

    public Vector3i getBlockPosition() {
        return this.getBlockPosition(this.handle);
    }

    private native Vector3i getBlockPosition(int var1);

    public void setChunkAndBlockPosition(Vector3i chunkPosition, Vector3i blockPosition) {
        this.setChunkAndBlockPosition(this.handle, chunkPosition.x, chunkPosition.y, chunkPosition.z, blockPosition.x, blockPosition.y, blockPosition.z);
    }

    public void setChunkAndBlockPosition(int cx, int cy, int cz, int bx, int by, int bz) {
        this.setChunkAndBlockPosition(this.handle, cx, cy, cz, bx, by, bz);
    }

    private native void setChunkAndBlockPosition(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Quaternion getRotation() {
        return this.getRotation(this.handle);
    }

    private native Quaternion getRotation(int var1);

    public void setRotation(Quaternion quaternion) {
        this.setRotation(this.handle, quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    private native void setRotation(int var1, float var2, float var3, float var4, float var5);

    public void setRotation(float pitch, float yaw, float roll) {
        this.setRotation(this.handle, pitch, yaw, roll);
    }

    private native void setRotation(int var1, float var2, float var3, float var4);

    public Vector3f getViewPosition() {
        return this.getViewPosition(this.handle);
    }

    private native Vector3f getViewPosition(int var1);

    public Vector3f getViewDirection() {
        return this.getViewDirection(this.handle);
    }

    private native Vector3f getViewDirection(int var1);

    public void setViewDirection(Vector3f direction) {
        this.setViewDirection(this.handle, direction.x, direction.y, direction.z);
    }

    public void setViewDirection(float directionx, float directiony, float directionz) {
        this.setViewDirection(this.handle, directionx, directiony, directionz);
    }

    private native void setViewDirection(int var1, float var2, float var3, float var4);

    public float getHeading() {
        return this.getHeading(this.handle);
    }

    private native float getHeading(int var1);

    public String getCardinalDirection() {
        return this.getCardinalDirection(this.handle);
    }

    private native String getCardinalDirection(int var1);

    public Area getCurrentArea() {
        return this.getCurrentArea(this.handle);
    }

    private native Area getCurrentArea(int var1);

    public Area[] getCurrentAreas() {
        return this.getCurrentAreas(this.handle);
    }

    private native Area[] getCurrentAreas(int var1);

    public void showLocationTicker(String text, float duration) {
        this.showLocationTicker(this.handle, text, false, duration);
    }

    private native void showLocationTicker(int var1, String var2, boolean var3, float var4);

    public void shake(float intensity, float duration) {
        this.shake(this.handle, intensity, duration);
    }

    private native void shake(int var1, float var2, float var3);

    public boolean isSpawned() {
        return this.isSpawned(this.handle);
    }

    private native boolean isSpawned(int var1);

    public boolean isInVehicle() {
        return this.isInVehicle(this.handle);
    }

    private native boolean isInVehicle(int var1);

    public boolean isOnMount() {
        return this.isOnMount(this.handle);
    }

    private native boolean isOnMount(int var1);

    public boolean isSprinting() {
        return this.isSprinting(this.handle);
    }

    private native boolean isSprinting(int var1);

    public boolean isWalking() {
        return this.isWalking(this.handle);
    }

    private native boolean isWalking(int var1);

    public boolean isCrouching() {
        return this.isCrouching(this.handle);
    }

    private native boolean isCrouching(int var1);

    public boolean isSwimming() {
        return this.isSwimming(this.handle);
    }

    private native boolean isSwimming(int var1);

    public boolean isLying() {
        return this.isLying(this.handle);
    }

    private native boolean isLying(int var1);

    public boolean isSitting() {
        return this.isSitting(this.handle);
    }

    private native boolean isSitting(int var1);

    public State getState() {
        return State.get(this.getState(this.handle));
    }

    private native int getState(int var1);

    public boolean isInWater() {
        return this.isInWater(this.handle);
    }

    private native boolean isInWater(int var1);

    public boolean isUnderwater() {
        return this.isUnderwater(this.handle);
    }

    private native boolean isUnderwater(int var1);

    public boolean isOnGround() {
        return this.isOnGround(this.handle);
    }

    private native boolean isOnGround(int var1);

    public boolean isIndoor() {
        return this.isIndoor(this.handle);
    }

    private native boolean isIndoor(int var1);

    public boolean isInCave() {
        return this.isInCave(this.handle);
    }

    private native boolean isInCave(int var1);

    public boolean isSleeping() {
        return this.isSleeping(this.handle);
    }

    private native boolean isSleeping(int var1);

    public void setCreativeModeEnabled(boolean set) {
        this.setCreativeModeEnabled(this.handle, set);
    }

    private native void setCreativeModeEnabled(int var1, boolean var2);

    public boolean isCreativeModeEnabled() {
        return this.isCreativeModeEnabled(this.handle);
    }

    private native boolean isCreativeModeEnabled(int var1);

    public int getMaxHealth() {
        return this.getMaxHealth(this.handle);
    }

    private native int getMaxHealth(int var1);

    public void setMaxHealth(int maxHealth) {
        this.setMaxHealth(this.handle, maxHealth);
    }

    private native void setMaxHealth(int var1, int var2);

    public int getHealth() {
        return this.getHealth(this.handle);
    }

    private native int getHealth(int var1);

    public void setHealth(int health) {
        this.setHealth(this.handle, health);
    }

    private native void setHealth(int var1, int var2);

    public void addDamage(int damage) {
        this.addDamage(this.handle, damage);
    }

    private native void addDamage(int var1, int var2);

    public int getArmor() {
        return this.getArmor(this.handle);
    }

    private native int getArmor(int var1);

    public int getMaxArmor() {
        return this.getMaxArmor(this.handle);
    }

    private native int getMaxArmor(int var1);

    public int getHunger() {
        return this.getHunger(this.handle);
    }

    private native int getHunger(int var1);

    public void setHunger(int hunger) {
        this.setHunger(this.handle, hunger);
    }

    private native void setHunger(int var1, int var2);

    public int getThirst() {
        return this.getThirst(this.handle);
    }

    private native int getThirst(int var1);

    public void setThirst(int thirst) {
        this.setThirst(this.handle, thirst);
    }

    private native void setThirst(int var1, int var2);

    public boolean hasBrokenBones() {
        return this.hasBrokenBones(this.handle);
    }

    private native boolean hasBrokenBones(int var1);

    public void setBrokenBones(boolean set) {
        this.setBrokenBones(this.handle, set);
    }

    private native void setBrokenBones(int var1, boolean var2);

    public boolean hasHealedBones() {
        return this.hasHealedBones(this.handle);
    }

    private native boolean hasHealedBones(int var1);

    public boolean isBleeding() {
        return this.isBleeding(this.handle);
    }

    private native boolean isBleeding(int var1);

    public void setBleeding(boolean set) {
        this.setBleeding(this.handle, set);
    }

    private native void setBleeding(int var1, boolean var2);

    public int getMaxStamina() {
        return this.getMaxStamina(this.handle);
    }

    private native int getMaxStamina(int var1);

    public void setMaxStamina(int maxStamina) {
        this.setMaxStamina(this.handle, maxStamina);
    }

    private native void setMaxStamina(int var1, int var2);

    public int getStamina() {
        return this.getStamina(this.handle);
    }

    private native int getStamina(int var1);

    public void setStamina(int stamina) {
        this.setStamina(this.handle, stamina);
    }

    private native void setStamina(int var1, int var2);

    public int getBreath() {
        return this.getBreath(this.handle);
    }

    private native int getBreath(int var1);

    public void setBreath(int breath) {
        this.setBreath(this.handle, breath);
    }

    private native void setBreath(int var1, int var2);

    public int getWetness() {
        return this.getWetness(this.handle);
    }

    private native int getWetness(int var1);

    public void setWetness(int wetness) {
        this.setWetness(this.handle, wetness);
    }

    private native void setWetness(int var1, int var2);

    public boolean isFlying() {
        return this.isFlying(this.handle);
    }

    private native boolean isFlying(int var1);

    public void setFlying(boolean set) {
        this.setFlying(this.handle, set);
    }

    private native void setFlying(int var1, boolean var2);

    public boolean isDead() {
        return this.isDead(this.handle);
    }

    private native boolean isDead(int var1);

    public void kill() {
        this.kill(this.handle);
    }

    private native void kill(int var1);

    public boolean respawn(SpawnPointType spawnPoint) {
        return this.respawn(this.handle, spawnPoint.ordinal());
    }

    private native boolean respawn(int var1, int var2);

    public void respawn(Vector3f position, Quaternion rotation) {
        this.respawn(this.handle, position, rotation);
    }

    private native void respawn(int var1, Vector3f var2, Quaternion var3);

    public Vector3f getSpawnPosition(SpawnPointType spawnPoint) {
        return this.getSpawnPosition(this.handle, spawnPoint.ordinal());
    }

    private native Vector3f getSpawnPosition(int var1, int var2);

    public Quaternion getSpawnRotation(SpawnPointType spawnPoint) {
        return this.getSpawnRotation(this.handle, spawnPoint.ordinal());
    }

    private native Quaternion getSpawnRotation(int var1, int var2);

    public String getSpawnName(SpawnPointType spawnPoint) {
        return this.getSpawnName(this.handle, spawnPoint.ordinal());
    }

    private native String getSpawnName(int var1, int var2);

    public void setSpawnPoint(SpawnPointType spawnPoint, Vector3f position, Quaternion rotation, String name) {
        this.setSpawnPoint(this.handle, spawnPoint.ordinal(), position, rotation, name, -1L, 0, 0, 0);
    }

    public void setSpawnPoint(SpawnPointType spawnPoint, Vector3f position, Quaternion rotation, String name, long relatedObjectID, int chunkPosX, int chunkPosY, int chunkPosZ) {
        this.setSpawnPoint(this.handle, spawnPoint.ordinal(), position, rotation, name, relatedObjectID, chunkPosX, chunkPosY, chunkPosZ);
    }

    private native void setSpawnPoint(int var1, int var2, Vector3f var3, Quaternion var4, String var5, long var6, int var8, int var9, int var10);

    public int getTemperature() {
        return this.getTemperature(this.handle);
    }

    private native int getTemperature(int var1);

    public void setTemperature(int temperature) {
        this.setTemperature(this.handle, temperature);
    }

    private native void setTemperature(int var1, int var2);

    public boolean isInvisible() {
        return this.isInvisible(this.handle);
    }

    private native boolean isInvisible(int var1);

    public void setInvisible(boolean set) {
        this.setInvisible(this.handle, set);
    }

    private native void setInvisible(int var1, boolean var2);

    public int getIdleTime() {
        return this.getIdleTime(this.handle);
    }

    private native int getIdleTime(int var1);

    public Npc getMount() {
        return this.getMount(this.handle);
    }

    private native Npc getMount(int var1);

    public Vehicle getVehicle() {
        return this.getVehicle(this.handle);
    }

    private native Vehicle getVehicle(int var1);

    public void setWalkSpeed(float speed) {
        this.setWalkSpeed(this.handle, speed);
    }

    private native void setWalkSpeed(int var1, float var2);

    public void setMoveSpeed(float speed) {
        this.setMoveSpeed(this.handle, speed);
    }

    private native void setMoveSpeed(int var1, float var2);

    public void setSprintSpeed(float speed) {
        this.setSprintSpeed(this.handle, speed);
    }

    private native void setSprintSpeed(int var1, float var2);

    public void setJumpSpeed(float speed) {
        this.setJumpSpeed(this.handle, speed);
    }

    private native void setJumpSpeed(int var1, float var2);

    public void setFlyingSpeed(float speed) {
        this.setFlyingSpeed(this.handle, speed);
    }

    private native void setFlyingSpeed(int var1, float var2);

    public void setSwimmingSpeed(float speed) {
        this.setSwimmingSpeed(this.handle, speed);
    }

    private native void setSwimmingSpeed(int var1, float var2);

    public void setGravity(float gravity) {
        this.setGravity(this.handle, gravity);
    }

    private native void setGravity(int var1, float var2);

    public Skin getSkin() {
        if (this.skin == null) {
            this.skin = new Skin(this.handle, false);
        }
        return this.skin;
    }

    public Clothes getClothes() {
        if (this.clothes == null) {
            this.clothes = new Clothes(this.handle, false);
        }
        return this.clothes;
    }

    private native void showMap(int var1, boolean var2);

    private native void showMap(int var1, boolean var2, float var3, float var4, float var5, boolean var6);

    private native void hideMap(int var1);

    public void showJournal() {
        this.showJournal(this.handle);
    }

    private native void showJournal(int var1);

    public void hideJournal() {
        this.hideJournal(this.handle);
    }

    private native void hideJournal(int var1);

    public void showInventory() {
        this.showInventory(this.handle);
    }

    private native void showInventory(int var1);

    public void hideInventory() {
        this.hideInventory(this.handle);
    }

    private native void hideInventory(int var1);

    public void showStorage(long storageID) {
        this.showStorage(this.handle, storageID);
    }

    private native void showStorage(int var1, long var2);

    public void hideStorage() {
        this.hideStorage(this.handle);
    }

    private native void hideStorage(int var1);

    public void showChat(boolean focus) {
        this.showChat(this.handle, focus, null);
    }

    public void showChat(String text) {
        this.showChat(this.handle, true, text);
    }

    private native void showChat(int var1, boolean var2, String var3);

    public void hideChat(float fadeDuration) {
        this.hideChat(this.handle, fadeDuration);
    }

    private native void hideChat(int var1, float var2);

    public void showBlueprints() {
        this.showBlueprints(this.handle);
    }

    private native void showBlueprints(int var1);

    public void hideBlueprints() {
        this.hideBlueprints(this.handle);
    }

    private native void hideBlueprints(int var1);

    public void showCrafting() {
        this.showCrafting(this.handle);
    }

    private native void showCrafting(int var1);

    public void hideCrafting() {
        this.hideCrafting(this.handle);
    }

    private native void hideCrafting(int var1);

    public void showContextMenu(String[] entries, Callback<String> callback) {
        this.showContextMenu(this.handle, entries, callback);
    }

    private native void showContextMenu(int var1, String[] var2, Callback<String> var3);

    public void stopInput(boolean stopMovement, boolean stopActions) {
        this.stopInput(this.handle, stopMovement, stopActions, (byte)0);
    }

    public void stopInput(Key key) {
        this.stopInput(this.handle, false, false, (byte)key.ordinal());
    }

    private native void stopInput(int var1, boolean var2, boolean var3, byte var4);

    public void registerKeys(Key ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int[] keyCodes = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            keyCodes[i] = keys[i].getKeyCode();
        }
        this.registerKeys(this.handle, keyCodes);
    }

    private native void registerKeys(int var1, int[] var2);

    public void unregisterKeys(Key ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int[] keyCodes = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            keyCodes[i] = keys[i].getKeyCode();
        }
        this.unregisterKeys(this.handle, keyCodes);
    }

    private native void unregisterKeys(int var1, int[] var2);

    public boolean isKeyRegistered(Key key, boolean global) {
        return this.isKeyRegistered(this.handle, key.getKeyCode(), global);
    }

    private native boolean isKeyRegistered(int var1, int var2, boolean var3);

    public boolean isKeyPressed(Key key) {
        return this.isKeyPressed(this.handle, key.getKeyCode());
    }

    private native boolean isKeyPressed(int var1, int var2);

    public Key[] getRegisteredKeys(boolean global) {
        int[] keyCodes = this.getRegisteredKeys(this.handle, global);
        if (keyCodes == null || keyCodes.length == 0) {
            return null;
        }
        Key[] keys = new Key[keyCodes.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Key.fromKeyCode(keyCodes[i]);
        }
        return keys;
    }

    private native int[] getRegisteredKeys(int var1, boolean var2);

    public void setListenForKeyInput(boolean set) {
        this.setListenForKeyInput(this.handle, set);
    }

    private native void setListenForKeyInput(int var1, boolean var2);

    public boolean isListeningForKeyInput(boolean global) {
        return this.isListeningForKeyInput(this.handle, global);
    }

    private native boolean isListeningForKeyInput(int var1, boolean var2);

    public void setListenForMouseInput(boolean set) {
        this.setListenForMouseInput(this.handle, set);
    }

    private native void setListenForMouseInput(int var1, boolean var2);

    public boolean isListeningForMouseInput(boolean global) {
        return this.isListeningForMouseInput(this.handle, global);
    }

    private native boolean isListeningForMouseInput(int var1, boolean var2);

    public void disableClientsideKeys(Key ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int[] keyCodes = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            keyCodes[i] = keys[i].getKeyCode();
        }
        this.disableClientsideKeys(this.handle, keyCodes);
    }

    private native void disableClientsideKeys(int var1, int[] var2);

    public void enableClientsideKeys() {
        this.enableClientsideKeys(this.handle);
    }

    private native void enableClientsideKeys(int var1);

    public void enableClientsideKeys(Key ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int[] keyCodes = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            keyCodes[i] = keys[i].getKeyCode();
        }
        this.enableClientsideKeys(this.handle, keyCodes);
    }

    private native void enableClientsideKeys(int var1, int[] var2);

    public void setMouseCursorVisible(boolean set) {
        this.setMouseCursorVisible(this.handle, set);
    }

    private native void setMouseCursorVisible(int var1, boolean var2);

    public void setMouseCursorCoordinates(float x, float y, boolean relative) {
        this.setMouseCursorCoordinates(this.handle, x, y, relative);
    }

    private native void setMouseCursorCoordinates(int var1, float var2, float var3, boolean var4);

    public void executeCommand(String command) {
        this.executeCommand(this.handle, command);
    }

    private native void executeCommand(int var1, String var2);

    public boolean isConnected() {
        return this.isConnected(this.handle);
    }

    private native boolean isConnected(int var1);

    public int getPing() {
        return this.getPing(this.handle);
    }

    private native int getPing(int var1);

    public String getIP() {
        return this.getIP(this.handle);
    }

    private native String getIP(int var1);

    public void kick(String reason) {
        this.kick(this.handle, reason);
    }

    private native void kick(int var1, String var2);

    public void ban(String reason) {
        this.ban(this.handle, reason, -1);
    }

    public void ban(String reason, int duration) {
        this.ban(this.handle, reason, duration);
    }

    private native void ban(int var1, String var2, int var3);

    public void enableAreaSelectionTool() {
        this.enableAreaSelectionTool(this.handle);
    }

    private native void enableAreaSelectionTool(int var1);

    public void setAreaSelectionData(Area area) {
        this.setAreaSelectionData(this.handle, area);
    }

    private native void setAreaSelectionData(int var1, Area var2);

    public void getAreaSelectionData(Callback<Area> callback) {
        this.getAreaSelectionData(this.handle, callback);
    }

    private native void getAreaSelectionData(int var1, Callback<Area> var2);

    public void disableAreaSelectionTool() {
        this.disableAreaSelectionTool(this.handle);
    }

    private native void disableAreaSelectionTool(int var1);

    public void raycast(int layerMask, Callback<RaycastResult> callback) {
        this.raycast(this.handle, -1.0f, layerMask, false, callback);
    }

    public void raycast(float distance, int layerMask, boolean includeTriggers, Callback<RaycastResult> callback) {
        this.raycast(this.handle, distance, layerMask, includeTriggers, callback);
    }

    private native void raycast(int var1, float var2, int var3, boolean var4, Callback<RaycastResult> var5);

    public void raycast(Vector3f direction, float distance, int layerMask, boolean includeTriggers, Callback<RaycastResult> callback) {
        this.raycast(this.handle, direction.x, direction.y, direction.z, distance, layerMask, includeTriggers, callback);
    }

    private native void raycast(int var1, float var2, float var3, float var4, float var5, int var6, boolean var7, Callback<RaycastResult> var8);

    public void raycastFromScreenPosition(float x, float y, boolean relative, float distance, int layerMask, boolean includeTriggers, Callback<RaycastResult> callback) {
        this.raycastFromScreenPosition(this.handle, x, y, relative, distance, layerMask, includeTriggers, callback);
    }

    private native void raycastFromScreenPosition(int var1, float var2, float var3, boolean var4, float var5, int var6, boolean var7, Callback<RaycastResult> var8);

    public void raycastFromWorldPosition(Vector3f position, Vector3f direction, float distance, int layerMask, boolean includeTriggers, Callback<RaycastResult> callback) {
        this.raycastFromWorldPosition(this.handle, position.x, position.y, position.z, direction.x, direction.y, direction.z, distance, layerMask, includeTriggers, callback);
    }

    private native void raycastFromWorldPosition(int var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, int var9, boolean var10, Callback<RaycastResult> var11);

    public void getAreaInLineOfSight(float distance, Callback<Area> callback) {
        this.raycast(distance, Layer.getBitmask(6), true, result -> {
            long id;
            Area area;
            if (result != null && result.getLayer() == 6 && (area = Server.getArea(id = result.getObjectGlobalID())) != null) {
                callback.onCall(area);
                return;
            }
            callback.onCall(null);
        });
    }

    public void getNpcInLineOfSight(float distance, Callback<Npc> callback) {
        this.raycast(distance, Layer.getBitmask(21), true, result -> {
            long id;
            Npc npc;
            if (result != null && result.getLayer() == 21 && (npc = World.getNpc(id = result.getObjectGlobalID())) != null) {
                callback.onCall(npc);
                return;
            }
            callback.onCall(null);
        });
    }

    public void addUIElement(UIElement element) {
        if (element == null) {
            return;
        }
        if (element.getParent() != null) {
            return;
        }
        PluginUIManager.registerUIElementForPlayer((UIElement)element, (UITarget)UITarget.HUD, (int)this.handle, (boolean)true);
    }

    public void addUIElement(UIElement element, UITarget target) {
        if (element == null) {
            return;
        }
        if (element.getParent() != null) {
            return;
        }
        PluginUIManager.registerUIElementForPlayer((UIElement)element, (UITarget)target, (int)this.handle, (boolean)true);
    }

    public void removeUIElement(UIElement element) {
        if (element == null) {
            return;
        }
        if (element.getParent() != null) {
            return;
        }
        PluginUIManager.unregisterUIElementForPlayer((UIElement)element, (int)this.handle, (boolean)true);
    }

    public int getScreenResolutionX() {
        return this.getScreenResolutionX(this.handle);
    }

    private native int getScreenResolutionX(int var1);

    public int getScreenResolutionY() {
        return this.getScreenResolutionY(this.handle);
    }

    private native int getScreenResolutionY(int var1);

    public void showMessageBox(MessageBoxButtons buttons, String title, String message, int timeout, Callback<Integer> callback) {
        this.showMessageBox(this.handle, buttons.ordinal(), title, message, timeout, callback);
    }

    private native void showMessageBox(int var1, int var2, String var3, String var4, int var5, Callback<Integer> var6);

    public void showInputMessageBox(String title, String message, String text, Callback<String> callback) {
        this.showInputMessageBox(this.handle, title, message, text, -1, callback);
    }

    private native void showInputMessageBox(int var1, String var2, String var3, String var4, int var5, Callback<String> var6);

    public void showSuccessMessageBox(String title, String message) {
        this.showSuccessMessageBox(this.handle, title, message);
    }

    private native void showSuccessMessageBox(int var1, String var2, String var3);

    public void showInfoMessageBox(String title, String message) {
        this.showInfoMessageBox(this.handle, title, message);
    }

    private native void showInfoMessageBox(int var1, String var2, String var3);

    public void showWarningMessageBox(String title, String message) {
        this.showWarningMessageBox(this.handle, title, message);
    }

    private native void showWarningMessageBox(int var1, String var2, String var3);

    public void showErrorMessageBox(String title, String message) {
        this.showErrorMessageBox(this.handle, title, message);
    }

    private native void showErrorMessageBox(int var1, String var2, String var3);

    public void showColorPicker(String title, int initialColor, Callback<Integer> callback) {
        this.showColorPicker(this.handle, title, initialColor, callback);
    }

    private native void showColorPicker(int var1, String var2, int var3, Callback<Integer> var4);

    public void showRadialMenu(TextureAsset[] icons, String[] descriptions, String[] overrideTexts, boolean closeOnSelect, Callback<Integer> callback) {
        if (icons == null && descriptions == null) {
            throw new IllegalArgumentException("icons and descriptions must not be null");
        }
        this.showRadialMenu(this.handle, icons, descriptions, overrideTexts, closeOnSelect, callback);
    }

    private native void showRadialMenu(int var1, Asset[] var2, String[] var3, String[] var4, boolean var5, Callback<Integer> var6);

    public void hideRadialMenu(boolean immediately) {
        this.hideRadialMenu(this.handle, immediately);
    }

    private native void hideRadialMenu(int var1, boolean var2);

    public void addGameObject(GameObject gameObject) {
        if (gameObject == null) {
            return;
        }
        if (gameObject.getParent() != null) {
            return;
        }
        PluginGameObjectManager.registerGameObjectForPlayer((GameObject)gameObject, (int)this.handle, (boolean)true);
    }

    public void removeGameObject(GameObject gameObject) {
        if (gameObject == null) {
            return;
        }
        if (gameObject.getParent() != null) {
            return;
        }
        PluginGameObjectManager.unregisterGameObjectForPlayer((GameObject)gameObject, (int)this.handle, (boolean)true);
    }

    public Sound playSound(SoundAsset sound) {
        return this.playSound(sound, null);
    }

    public Sound playSound(SoundAsset sound, Vector3f position) {
        return this.playSound(sound, false, 1.0f, 1.0f, position);
    }

    public Sound playSound(SoundAsset sound, boolean loop, float volume, float pitch, Vector3f position) {
        return this.playSound(sound, loop, volume, pitch, 1.0f, 50.0f, position);
    }

    public Sound playSound(SoundAsset sound, boolean loop, float volume, float pitch, float minDistance, float maxDistance, Vector3f position) {
        return this.playCustomSound(this.handle, soundIDCounter.getAndIncrement(), sound.getHandle(), sound.isStreamed(), loop, volume, pitch, minDistance, maxDistance, position, null, null);
    }

    private native Sound playCustomSound(int var1, int var2, int var3, boolean var4, boolean var5, float var6, float var7, float var8, float var9, Vector3f var10, Vector3f var11, Vector3f var12);

    public void stopSound(Sound sound) {
        this.stopSound(this.handle, sound.getID());
    }

    public void stopSound(int id) {
        this.stopSound(this.handle, id);
    }

    private native void stopSound(int var1, int var2);

    private native int playGameSound(int var1, int var2, String var3, float var4, float var5, float var6, float var7, float var8, float var9, String var10, float var11, String var12, float var13);

    public void enableGameMusic() {
        this.enableGameMusic(this.handle);
    }

    private native void enableGameMusic(int var1);

    public void disableGameMusic() {
        this.disableGameMusic(this.handle);
    }

    private native void disableGameMusic(int var1);

    public void connectToOtherServer(String target, String password, Callback<Boolean> callback) {
        this.connectToOtherServer(this.handle, target, password, callback);
    }

    private native void connectToOtherServer(int var1, String var2, String var3, Callback<Boolean> var4);

    public void connectToTeamSpeak(String ip, int port, String channel) {
        this.connectToTeamSpeak(this.handle, ip, port, channel, null);
    }

    private native void connectToTeamSpeak(int var1, String var2, int var3, String var4, Callback<Boolean> var5);

    public void connectToDiscord(String url) {
        this.connectToDiscord(this.handle, url, null);
    }

    private native void connectToDiscord(int var1, String var2, Callback<Boolean> var3);

    public void createScreenshot(float sizeFactor, float quality, boolean includeUI, Callback<BufferedImage> callback) {
        this.createScreenshot(this.handle, null, null, 0, 0, 0, sizeFactor, quality, includeUI, callback);
    }

    public void createScreenshot(int width, int height, float quality, boolean includeUI, Callback<BufferedImage> callback) {
        this.createScreenshot(this.handle, null, null, 0, width, height, 1.0f, quality, includeUI, callback);
    }

    public void createScreenshot(Vector3f position, Vector3f direction, int width, int height, float quality, boolean includeUI, Callback<BufferedImage> callback) {
        this.createScreenshot(this.handle, position, direction, 0, width, height, 1.0f, quality, includeUI, callback);
    }

    private native void createScreenshot(int var1, Vector3f var2, Vector3f var3, int var4, int var5, int var6, float var7, float var8, boolean var9, Callback<BufferedImage> var10);

    public static enum State {
        Uninitialized,
        Default,
        Crouching,
        Flying,
        Swimming,
        ClimbingLadder,
        Sitting,
        Lying,
        Sleeping,
        Piano,
        Mount,
        Vehicle,
        Dead;

        private static State[] values;

        public static State get(int ordinal) {
            if (values == null) {
                values = State.values();
            }
            return values[ordinal];
        }
    }
}

