/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.collider;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.collider.Collider;
import net.risingworld.api.utils.Vector3f;

public class SphereCollider
extends Collider {
    private Vector3f center;
    private float radius;
    private boolean isTrigger;

    public SphereCollider(float radius) {
        this(0.0f, 0.0f, 0.0f, radius);
    }

    public SphereCollider(float x, float y, float z, float radius) {
        super(Collider.Type.Box);
        this.center = new Vector3f(x, y, z);
        this.radius = radius;
    }

    public SphereCollider(float x, float y, float z, float radius, boolean isTrigger) {
        super(Collider.Type.Box);
        this.center = new Vector3f(x, y, z);
        this.radius = radius;
        this.isTrigger = isTrigger;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isTrigger() {
        return this.isTrigger;
    }

    @Override
    final byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(18);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)this.getType().ordinal());
        InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.center);
        buffer.putFloat(this.radius);
        buffer.put((byte)(this.isTrigger ? 1 : 0));
        return buffer.array();
    }
}

