/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.PluginUIManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector2f;

public class UIMesh
extends UIElement {
    private TextureAsset texture;
    private ArrayList<UIVertex> vertices = new ArrayList();
    private ArrayList<Short> indices = new ArrayList();
    private static final int TYPE = 4;

    public void setTexture(TextureAsset texture) {
        this.texture = texture;
    }

    public void setNextVertex(Vector2f position, Vector2f uv) {
        this.setNextVertex(position, uv, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setNextVertex(Vector2f position, float r, float g, float b, float a) {
        this.setNextVertex(position, null, r, g, b, a);
    }

    public void setNextVertex(Vector2f position, ColorRGBA color) {
        this.setNextVertex(position, null, color.r, color.g, color.b, color.a);
    }

    public void setNextVertex(Vector2f position, Vector2f uv, float r, float g, float b, float a) {
        this.vertices.add(new UIVertex(this, position, uv, Utils.GeneralUtils.colorRGBAToInt(r, g, b, a)));
    }

    public void setNextIndex(short index) {
        this.indices.add(index);
    }

    public void clear() {
        this.vertices.clear();
        this.indices.clear();
        this.texture = null;
    }

    public void update() {
        this.updateUIMesh();
    }

    private byte[] serialize() {
        try {
            int i;
            ByteBuffer buffer = ByteBuffer.allocate(8 + this.vertices.size() * 20 + 4 + this.indices.size() * 2);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.texture == null ? -1 : this.texture.getHandle());
            buffer.putInt(this.vertices.size());
            buffer.putInt(this.indices.size());
            int len = this.vertices.size();
            for (i = 0; i < len; ++i) {
                UIVertex v = this.vertices.get(i);
                InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)v.position);
                InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)buffer, (Vector2f)v.uv);
                buffer.putInt(v.tint);
            }
            len = this.indices.size();
            for (i = 0; i < len; ++i) {
                buffer.putShort(this.indices.get(i));
            }
            byte[] array = new byte[buffer.position()];
            buffer.flip();
            buffer.get(array);
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    int getType() {
        return 4;
    }

    private void updateUIMesh() {
        PluginUIManager.updateUIMesh((UIMesh)this, (int)this.id);
    }

    private class UIVertex {
        public static final int SIZE = 20;
        public Vector2f position;
        public Vector2f uv;
        public int tint;

        public UIVertex(UIMesh uIMesh, Vector2f position, Vector2f uv, int tint) {
            if (position == null) {
                position = new Vector2f();
            }
            if (uv == null) {
                uv = new Vector2f();
            }
            this.position = position;
            this.uv = uv;
            this.tint = tint;
        }
    }
}

