/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import net.risingworld.api.definitions.Items;
import net.risingworld.api.objects.Item;

public final class Inventory {
    private final int handle;

    private Inventory(int handle) {
        this.handle = handle;
    }

    public int getPlayerDbID() {
        return this.handle;
    }

    public int getQuickslotFocus() {
        return this.getQuickslotFocus(this.handle);
    }

    private native int getQuickslotFocus(int var1);

    public int getInventoryHashCode() {
        return this.getInventoryHashCode(this.handle);
    }

    private native int getInventoryHashCode(int var1);

    public int getSlotCount(SlotType slotType) {
        return this.getSlotCount(this.handle, slotType.value);
    }

    private native int getSlotCount(int var1, int var2);

    public int getMaxSlotCount(SlotType slotType) {
        return this.getMaxSlotCount(this.handle, slotType.value);
    }

    private native int getMaxSlotCount(int var1, int var2);

    public Item[] getItems(SlotType slotType) {
        return this.getItems(this.handle, slotType.value);
    }

    private native Item[] getItems(int var1, int var2);

    public Item[] getAllItems() {
        return this.getAllItems(this.handle);
    }

    private native Item[] getAllItems(int var1);

    public Item getItem(int slot, SlotType slotType) {
        return this.getItem(this.handle, slot, slotType.value);
    }

    private native Item getItem(int var1, int var2, int var3);

    public int findItem(short itemID, int variant, SlotType slotType) {
        return this.findItem(this.handle, itemID, variant, slotType.value);
    }

    private native int findItem(int var1, short var2, int var3, int var4);

    public int findItemByGroup(Items.Group group, SlotType slotType) {
        return this.findItemByGroup(this.handle, group.value, slotType.value);
    }

    private native int findItemByGroup(int var1, int var2, int var3);

    public int findItemByType(Items.Type type, SlotType slotType) {
        return this.findItemByType(this.handle, type.value, slotType.value);
    }

    private native int findItemByType(int var1, int var2, int var3);

    public int[] findAllItems(short itemID, int variant, SlotType slotType) {
        return this.findAllItems(this.handle, itemID, variant, slotType.value);
    }

    private native int[] findAllItems(int var1, short var2, int var3, int var4);

    public Item addItem(short itemID, int variant, int stack) {
        return this.addItem(this.handle, itemID, variant, stack, -1, Items.Modifier.Normal.value, -1, -1);
    }

    public Item addItemToSlot(short itemID, int variant, int stack, int slot, SlotType slotType) {
        return this.addItem(this.handle, itemID, variant, stack, -1, Items.Modifier.Normal.value, slot, slotType.value);
    }

    private native Item addItem(int var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public Item.ObjectItem addObjectItem(short objectID, int variant, int stack) {
        return this.addObjectItem(this.handle, objectID, variant, stack, -1, -1);
    }

    public Item.ObjectItem addObjectItemToSlot(short objectID, int variant, int stack, int slot, SlotType slotType) {
        return this.addObjectItem(this.handle, objectID, variant, stack, slot, slotType.value);
    }

    private native Item.ObjectItem addObjectItem(int var1, short var2, int var3, int var4, int var5, int var6);

    public Item.ConstructionItem addConstructionItem(byte constructionID, int texture, int stack, int color) {
        return this.addConstructionItem(this.handle, constructionID, texture, stack, color, -1, -1);
    }

    public Item.ConstructionItem addConstructionItemToSlot(byte constructionID, int texture, int stack, int color, int slot, SlotType slotType) {
        return this.addConstructionItem(this.handle, constructionID, texture, stack, color, slot, slotType.value);
    }

    private native Item.ConstructionItem addConstructionItem(int var1, byte var2, int var3, int var4, int var5, int var6, int var7);

    public Item.ClothingItem addClothingItem(short clothingID, int variant, int stack, int color, long infoID) {
        return this.addClothingItem(this.handle, clothingID, variant, stack, color, infoID, -1, -1);
    }

    public Item.ClothingItem addClothingItemToSlot(short clothingID, int variant, int stack, int color, long infoID, int slot, SlotType slotType) {
        return this.addClothingItem(this.handle, clothingID, variant, stack, color, infoID, slot, slotType.value);
    }

    private native Item.ClothingItem addClothingItem(int var1, short var2, int var3, int var4, int var5, long var6, int var8, int var9);

    public boolean removeItem(int slot, SlotType slotType) {
        return this.removeItem(this.handle, slot, slotType.value, -1);
    }

    public boolean removeItem(int slot, SlotType slotType, int amount) {
        return this.removeItem(this.handle, slot, slotType.value, amount);
    }

    private native boolean removeItem(int var1, int var2, int var3, int var4);

    public void sort(boolean mergeStacks) {
        this.sort(this.handle, mergeStacks);
    }

    private native void sort(int var1, boolean var2);

    public void mergeStacks() {
        this.mergeStacks(this.handle);
    }

    private native void mergeStacks(int var1);

    private native void syncWithClient(int var1);

    public void clear() {
        this.clear(this.handle);
    }

    private native void clear(int var1);

    public static enum SlotType {
        Quickslot(1),
        Equipment(2),
        Inventory(3);

        public final int value;
        private static SlotType[] values;

        private SlotType(int value) {
            this.value = value;
        }

        public static SlotType get(int value) {
            if (values == null) {
                values = SlotType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (SlotType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

