/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.world;

import net.risingworld.api.World;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.Event;
import net.risingworld.api.objects.MetaObject;
import net.risingworld.api.objects.WorldItem;

final class ItemTransformEvent
extends Event
implements Cancellable {
    private ItemTransformEvent(long pointer) {
        super(pointer);
    }

    public WorldItem getItem() {
        this.CheckIsValid();
        return this.getItem(this.pointer);
    }

    public short getNewTypeID() {
        this.CheckIsValid();
        return this.getNewTypeID(this.pointer);
    }

    public int getNewStack() {
        this.CheckIsValid();
        return this.getNewStack(this.pointer);
    }

    public void setNewTypeID(short newTypeID) {
        this.CheckIsValid();
        this.setNewTypeID(this.pointer, newTypeID);
    }

    public void setNewStack(int newStack) {
        this.CheckIsValid();
        this.setNewStack(this.pointer, newStack);
    }

    public long getObjectID() {
        this.CheckIsValid();
        return this.getObjectID(this.pointer);
    }

    public short getObjectTypeID() {
        this.CheckIsValid();
        return this.getObjectTypeID(this.pointer);
    }

    public Trigger getTrigger() {
        this.CheckIsValid();
        return Trigger.get(this.getTrigger(this.pointer));
    }

    public MetaObject getMetaObject() {
        return World.getMetaObject(this.getObjectID());
    }

    public Objects.ObjectInfoDefinition getObjectInfoDefinition() {
        return Definitions.getObjectInfoDefinitionByTypeID(this.getObjectTypeID());
    }

    public Items.ItemInfoType getProcessingType() {
        Objects.ObjectInfoDefinition infoDef;
        this.CheckIsValid();
        short typeID = this.getObjectTypeID(this.pointer);
        if (typeID > 0 && (infoDef = Definitions.getObjectInfoDefinitionByTypeID(typeID)) != null) {
            return infoDef.processingtype;
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native WorldItem getItem(long var1);

    private native short getNewTypeID(long var1);

    private native void setNewTypeID(long var1, short var3);

    private native int getNewStack(long var1);

    private native void setNewStack(long var1, int var3);

    private native long getObjectID(long var1);

    private native short getObjectTypeID(long var1);

    private native byte getTrigger(long var1);

    public static enum Trigger {
        Player,
        MetaObject;

        private static Trigger[] values;

        private static Trigger get(int ordinal) {
            if (values == null) {
                values = Trigger.values();
            }
            return values[ordinal];
        }
    }
}

