/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class Plants {
    private Plants() {
    }

    public static enum Size {
        None(0),
        Tiny(1),
        SmallLight(2),
        Small(3),
        Medium(4),
        MediumLarge(5),
        Large(6),
        Huge(7);

        public final int value;
        private static Size[] values;

        private Size(int i) {
            this.value = i;
        }

        public static Size get(int value) {
            if (values == null) {
                values = Size.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Size.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum TerrainMaterialType {
        Air(0),
        Stone(1),
        Gravel(2),
        Soil(3),
        Sand(4),
        Snow(5),
        Ice(6),
        Cobble(7),
        Ore(8),
        Grass(9),
        Water(10),
        Null(11);

        public final int value;
        private static TerrainMaterialType[] values;

        private TerrainMaterialType(int i) {
            this.value = i;
        }

        public static TerrainMaterialType get(int value) {
            if (values == null) {
                values = TerrainMaterialType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (TerrainMaterialType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public final class PlantDefinition {
        public short id;
        public String name;
        public Type type;
        public Stage stage;
        public String assetpath;
        public short strength;
        public Size extent;
        public int windparam;
        public float windaffection;
        public float slopeadjustment;
        public TerrainMaterialType[] spawngroundtypes;
        public float spawnoffsety;
        public float centerofmassoffset;
        public float minspawnsize;
        public float maxspawnsize;
        public int touchdamage;
        public String treelog;
        public int treelogvariant;
        public int treelogcount;
        public String sapling;
        public int saplingvariant;
        public int saplingcountmin;
        public int saplingcountmax;
        public String pickupitem;
        public int pickupitemcount;
        public String pickuprestplant;
        public boolean harvestable;
        public String harvestrestplant;
        public String harvestitem;
        public int harvestitemcount;
        public boolean harvestpickupitem;
        public String destroyrestplant;
        public String destroyrestobject;
        public String destroyitem;
        public int destroyitemcount;
        public boolean scaleitemcount;
        public boolean hasbirds;
        public float treetop;
        public int fallingleavescount;
        public float fallingleavesradius;
        public float fallingleavessize;
        public float fallingleavesbrightness;
        public int fallingleavesspawnsubmesh;
        public String fallingleavestexture;
        public String treelogassetpath;
        public String stumpassetpath;
        public String debrisassetpath;
        public String hitdecal;
        public float cutedge;
        public boolean cangrow;
        public String nextgrowthstage;
        public int growthtime;
        public boolean randomgrowthrotation;
        public boolean requiresfarmland;
        public boolean requireswater;
        public boolean requiressunlight;
        public Vector3f boundscale;
        public float renderscale;
        public float renderoffset;
        public Quaternion renderrotation;
        public String hitsound;
        public String breaksound;
        public String fallsound;
        public String collidesound;
        public String placesound;

        private PlantDefinition(Plants this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.stage = Stage.get(buffer.getInt());
            this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.strength = buffer.getShort();
            this.extent = Size.get(buffer.getInt());
            this.windparam = buffer.getInt();
            this.windaffection = buffer.getFloat();
            this.slopeadjustment = buffer.getFloat();
            int ispawngroundtypes = buffer.getInt();
            if (ispawngroundtypes == -1) {
                this.spawngroundtypes = null;
            } else if (ispawngroundtypes >= 0) {
                this.spawngroundtypes = new TerrainMaterialType[ispawngroundtypes];
                for (int i = 0; i < ispawngroundtypes; ++i) {
                    this.spawngroundtypes[i] = TerrainMaterialType.get(buffer.getInt());
                }
            }
            this.spawnoffsety = buffer.getFloat();
            this.centerofmassoffset = buffer.getFloat();
            this.minspawnsize = buffer.getFloat();
            this.maxspawnsize = buffer.getFloat();
            this.touchdamage = buffer.getInt();
            this.treelog = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.treelogvariant = buffer.getInt();
            this.treelogcount = buffer.getInt();
            this.sapling = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.saplingvariant = buffer.getInt();
            this.saplingcountmin = buffer.getInt();
            this.saplingcountmax = buffer.getInt();
            this.pickupitem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.pickupitemcount = buffer.getInt();
            this.pickuprestplant = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.harvestable = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.harvestrestplant = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.harvestitem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.harvestitemcount = buffer.getInt();
            this.harvestpickupitem = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.destroyrestplant = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.destroyrestobject = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.destroyitem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.destroyitemcount = buffer.getInt();
            this.scaleitemcount = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.hasbirds = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.treetop = buffer.getFloat();
            this.fallingleavescount = buffer.getInt();
            this.fallingleavesradius = buffer.getFloat();
            this.fallingleavessize = buffer.getFloat();
            this.fallingleavesbrightness = buffer.getFloat();
            this.fallingleavesspawnsubmesh = buffer.getInt();
            this.fallingleavestexture = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.treelogassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.stumpassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.debrisassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.hitdecal = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.cutedge = buffer.getFloat();
            this.cangrow = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.nextgrowthstage = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.growthtime = buffer.getInt();
            this.randomgrowthrotation = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requiresfarmland = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requireswater = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requiressunlight = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.boundscale = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.renderscale = buffer.getFloat();
            this.renderoffset = buffer.getFloat();
            this.renderrotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.hitsound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.breaksound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.fallsound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.collidesound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.placesound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.stage == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.stage.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
            buffer.putShort(this.strength);
            if (this.extent == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.extent.value);
            buffer.putInt(this.windparam);
            buffer.putFloat(this.windaffection);
            buffer.putFloat(this.slopeadjustment);
            if (this.spawngroundtypes == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.spawngroundtypes.length);
                for (int i = 0; i < this.spawngroundtypes.length; ++i) {
                    if (this.spawngroundtypes[i] == null) {
                        throw new IllegalArgumentException("Enumeration must not be null!");
                    }
                    buffer.putInt(this.spawngroundtypes[i].value);
                }
            }
            buffer.putFloat(this.spawnoffsety);
            buffer.putFloat(this.centerofmassoffset);
            buffer.putFloat(this.minspawnsize);
            buffer.putFloat(this.maxspawnsize);
            buffer.putInt(this.touchdamage);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.treelog);
            buffer.putInt(this.treelogvariant);
            buffer.putInt(this.treelogcount);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.sapling);
            buffer.putInt(this.saplingvariant);
            buffer.putInt(this.saplingcountmin);
            buffer.putInt(this.saplingcountmax);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.pickupitem);
            buffer.putInt(this.pickupitemcount);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.pickuprestplant);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.harvestable);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.harvestrestplant);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.harvestitem);
            buffer.putInt(this.harvestitemcount);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.harvestpickupitem);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.destroyrestplant);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.destroyrestobject);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.destroyitem);
            buffer.putInt(this.destroyitemcount);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.scaleitemcount);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasbirds);
            buffer.putFloat(this.treetop);
            buffer.putInt(this.fallingleavescount);
            buffer.putFloat(this.fallingleavesradius);
            buffer.putFloat(this.fallingleavessize);
            buffer.putFloat(this.fallingleavesbrightness);
            buffer.putInt(this.fallingleavesspawnsubmesh);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.fallingleavestexture);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.treelogassetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.stumpassetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.debrisassetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.hitdecal);
            buffer.putFloat(this.cutedge);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.cangrow);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.nextgrowthstage);
            buffer.putInt(this.growthtime);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.randomgrowthrotation);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requiresfarmland);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requireswater);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requiressunlight);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.boundscale);
            buffer.putFloat(this.renderscale);
            buffer.putFloat(this.renderoffset);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.renderrotation);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.hitsound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.breaksound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.fallsound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.collidesound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.placesound);
        }

        private int getSize() {
            int size = 159;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.assetpath != null) {
                size += this.assetpath.length() * 2;
            }
            size += 4;
            if (this.spawngroundtypes != null) {
                size += this.spawngroundtypes.length * 4;
            }
            size += 2;
            if (this.treelog != null) {
                size += this.treelog.length() * 2;
            }
            size += 2;
            if (this.sapling != null) {
                size += this.sapling.length() * 2;
            }
            size += 2;
            if (this.pickupitem != null) {
                size += this.pickupitem.length() * 2;
            }
            size += 2;
            if (this.pickuprestplant != null) {
                size += this.pickuprestplant.length() * 2;
            }
            size += 2;
            if (this.harvestrestplant != null) {
                size += this.harvestrestplant.length() * 2;
            }
            size += 2;
            if (this.harvestitem != null) {
                size += this.harvestitem.length() * 2;
            }
            size += 2;
            if (this.destroyrestplant != null) {
                size += this.destroyrestplant.length() * 2;
            }
            size += 2;
            if (this.destroyrestobject != null) {
                size += this.destroyrestobject.length() * 2;
            }
            size += 2;
            if (this.destroyitem != null) {
                size += this.destroyitem.length() * 2;
            }
            size += 2;
            if (this.fallingleavestexture != null) {
                size += this.fallingleavestexture.length() * 2;
            }
            size += 2;
            if (this.treelogassetpath != null) {
                size += this.treelogassetpath.length() * 2;
            }
            size += 2;
            if (this.stumpassetpath != null) {
                size += this.stumpassetpath.length() * 2;
            }
            size += 2;
            if (this.debrisassetpath != null) {
                size += this.debrisassetpath.length() * 2;
            }
            size += 2;
            if (this.hitdecal != null) {
                size += this.hitdecal.length() * 2;
            }
            size += 2;
            if (this.nextgrowthstage != null) {
                size += this.nextgrowthstage.length() * 2;
            }
            size += 2;
            if (this.hitsound != null) {
                size += this.hitsound.length() * 2;
            }
            size += 2;
            if (this.breaksound != null) {
                size += this.breaksound.length() * 2;
            }
            size += 2;
            if (this.fallsound != null) {
                size += this.fallsound.length() * 2;
            }
            size += 2;
            if (this.collidesound != null) {
                size += this.collidesound.length() * 2;
            }
            size += 2;
            if (this.placesound != null) {
                size += this.placesound.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizePlantDefinition(this.serialize());
        }
    }

    public static enum Extent {
        Small(0),
        Medium(1),
        Large(2),
        Huge(3);

        public final int value;
        private static Extent[] values;

        private Extent(int i) {
            this.value = i;
        }

        public static Extent get(int value) {
            if (values == null) {
                values = Extent.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Extent.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Category {
        Undefined(0),
        Plants(1),
        PlantSaplings(2),
        Crops(3),
        CropSaplings(4),
        Trees(5),
        TreesYoung(6),
        TreesDead(7),
        Water(8),
        Underwater(9),
        Misc(10),
        Other(11),
        API(12);

        public final int value;
        private static Category[] values;

        private Category(int i) {
            this.value = i;
        }

        public static Category get(int value) {
            if (values == null) {
                values = Category.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Category.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Stage {
        Default(0),
        Dead(1),
        Sapling(2),
        Growing(3);

        public final int value;
        private static Stage[] values;

        private Stage(int i) {
            this.value = i;
        }

        public static Stage get(int value) {
            if (values == null) {
                values = Stage.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Stage.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        Undefined(0),
        Plant(1),
        Tree(2),
        FruitTree(3),
        Crop(4),
        Water(5),
        Underwater(6),
        Rock(7),
        Trunk(8),
        API(9);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

