/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;

public final class Npcs {
    private Npcs() {
    }

    public final class NpcDefinition {
        public short id;
        public String name;
        public Type type;
        public int variations;
        public Gender gender;
        public boolean ischild;
        public short health;
        public short stamina;
        public short hitdamage;
        public float attackrange;
        public float attackdot;
        public Behaviour behaviour;
        public AttackReaction attackreaction;
        public int aggroradius;
        public int fov;
        public int sight;
        public int hearingrange;
        public float eyeheight;
        public float rayoffset;
        public float spherecastradius;
        public float scale;
        public float grounddot;
        public boolean hasalertanim;
        public boolean istransient;
        public float walkspeed;
        public float runspeed;
        public float rotatespeed;
        public float animspeed;
        public int footstepvariant;
        public boolean sleeps;
        public boolean canswim;
        public int lifetime;
        public int herdmin;
        public int herdmax;
        public String adult;
        public String child;
        public String relative;
        public float adapttoterrain;
        public CorpseType corpsetype;
        public LootType loottype;

        private NpcDefinition(Npcs this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.variations = buffer.getInt();
            this.gender = Gender.get(buffer.getInt());
            this.ischild = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.health = buffer.getShort();
            this.stamina = buffer.getShort();
            this.hitdamage = buffer.getShort();
            this.attackrange = buffer.getFloat();
            this.attackdot = buffer.getFloat();
            this.behaviour = Behaviour.get(buffer.getInt());
            this.attackreaction = AttackReaction.get(buffer.getInt());
            this.aggroradius = buffer.getInt();
            this.fov = buffer.getInt();
            this.sight = buffer.getInt();
            this.hearingrange = buffer.getInt();
            this.eyeheight = buffer.getFloat();
            this.rayoffset = buffer.getFloat();
            this.spherecastradius = buffer.getFloat();
            this.scale = buffer.getFloat();
            this.grounddot = buffer.getFloat();
            this.hasalertanim = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.istransient = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.walkspeed = buffer.getFloat();
            this.runspeed = buffer.getFloat();
            this.rotatespeed = buffer.getFloat();
            this.animspeed = buffer.getFloat();
            this.footstepvariant = buffer.getInt();
            this.sleeps = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.canswim = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.lifetime = buffer.getInt();
            this.herdmin = buffer.getInt();
            this.herdmax = buffer.getInt();
            this.adult = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.child = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.relative = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.adapttoterrain = buffer.getFloat();
            this.corpsetype = CorpseType.get(buffer.getInt());
            this.loottype = LootType.get(buffer.getInt());
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putInt(this.variations);
            if (this.gender == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.gender.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.ischild);
            buffer.putShort(this.health);
            buffer.putShort(this.stamina);
            buffer.putShort(this.hitdamage);
            buffer.putFloat(this.attackrange);
            buffer.putFloat(this.attackdot);
            if (this.behaviour == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.behaviour.value);
            if (this.attackreaction == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.attackreaction.value);
            buffer.putInt(this.aggroradius);
            buffer.putInt(this.fov);
            buffer.putInt(this.sight);
            buffer.putInt(this.hearingrange);
            buffer.putFloat(this.eyeheight);
            buffer.putFloat(this.rayoffset);
            buffer.putFloat(this.spherecastradius);
            buffer.putFloat(this.scale);
            buffer.putFloat(this.grounddot);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasalertanim);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.istransient);
            buffer.putFloat(this.walkspeed);
            buffer.putFloat(this.runspeed);
            buffer.putFloat(this.rotatespeed);
            buffer.putFloat(this.animspeed);
            buffer.putInt(this.footstepvariant);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.sleeps);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.canswim);
            buffer.putInt(this.lifetime);
            buffer.putInt(this.herdmin);
            buffer.putInt(this.herdmax);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.adult);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.child);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.relative);
            buffer.putFloat(this.adapttoterrain);
            if (this.corpsetype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.corpsetype.value);
            if (this.loottype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.loottype.value);
        }

        private int getSize() {
            int size = 123;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.adult != null) {
                size += this.adult.length() * 2;
            }
            size += 2;
            if (this.child != null) {
                size += this.child.length() * 2;
            }
            size += 2;
            if (this.relative != null) {
                size += this.relative.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeNpcDefinition(this.serialize());
        }

        public final class NpcLootInfo {
            public LootType type;
            public Items.ItemDefinition itemDef;
            public int itemTexture;
            public Items.Type requiredItemType;
            public int minCount;
            public int maxCount;
            public float chance;
            public String transform;
            public int transformvariant;

            private NpcLootInfo(NpcDefinition this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.type = LootType.get(buffer.getInt());
                int itemDef_id = buffer.getInt();
                this.itemDef = itemDef_id == -1 ? null : Definitions.getItemDefinition(itemDef_id);
                this.itemTexture = buffer.getInt();
                this.requiredItemType = Items.Type.get(buffer.getInt());
                this.minCount = buffer.getInt();
                this.maxCount = buffer.getInt();
                this.chance = buffer.getFloat();
                this.transform = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.transformvariant = buffer.getInt();
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.type == null) {
                    throw new IllegalArgumentException("Enumeration must not be null!");
                }
                buffer.putInt(this.type.value);
                if (this.itemDef == null) {
                    buffer.putInt(-1);
                } else {
                    buffer.putInt(this.itemDef.id);
                }
                buffer.putInt(this.itemTexture);
                if (this.requiredItemType == null) {
                    throw new IllegalArgumentException("Enumeration must not be null!");
                }
                buffer.putInt(this.requiredItemType.value);
                buffer.putInt(this.minCount);
                buffer.putInt(this.maxCount);
                buffer.putFloat(this.chance);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.transform);
                buffer.putInt(this.transformvariant);
            }

            private int getSize() {
                int size = 32;
                size += 2;
                if (this.transform != null) {
                    size += this.transform.length() * 2;
                }
                return size;
            }
        }

        public final class Variant {
            public NpcDefinition npc;
            public int variant;
            public String name;
            public float spawnchance;
            public short health;
            public short hitdamage;
            public String assetpath;
            public String corpsepath;

            private Variant(NpcDefinition this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int npc_id = buffer.getInt();
                this.npc = npc_id == -1 ? null : Definitions.getNpcDefinition(npc_id);
                this.variant = buffer.getInt();
                this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.spawnchance = buffer.getFloat();
                this.health = buffer.getShort();
                this.hitdamage = buffer.getShort();
                this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.corpsepath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.npc == null) {
                    buffer.putInt(-1);
                } else {
                    buffer.putInt(this.npc.id);
                }
                buffer.putInt(this.variant);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
                buffer.putFloat(this.spawnchance);
                buffer.putShort(this.health);
                buffer.putShort(this.hitdamage);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.corpsepath);
            }

            private int getSize() {
                int size = 16;
                size += 2;
                if (this.name != null) {
                    size += this.name.length() * 2;
                }
                size += 2;
                if (this.assetpath != null) {
                    size += this.assetpath.length() * 2;
                }
                size += 2;
                if (this.corpsepath != null) {
                    size += this.corpsepath.length() * 2;
                }
                return size;
            }
        }
    }

    public static enum LootType {
        None(0),
        Inventory(1),
        Skinning(2),
        Drop(3),
        Interaction(4);

        public final int value;
        private static LootType[] values;

        private LootType(int i) {
            this.value = i;
        }

        public static LootType get(int value) {
            if (values == null) {
                values = LootType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (LootType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum CorpseType {
        None(0),
        Ragdoll(1),
        Debris(2),
        Animation(3);

        public final int value;
        private static CorpseType[] values;

        private CorpseType(int i) {
            this.value = i;
        }

        public static CorpseType get(int value) {
            if (values == null) {
                values = CorpseType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (CorpseType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Gender {
        Undefined(0),
        Male(1),
        Female(2);

        public final int value;
        private static Gender[] values;

        private Gender(int i) {
            this.value = i;
        }

        public static Gender get(int value) {
            if (values == null) {
                values = Gender.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Gender.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum AttackReaction {
        Escape(0),
        Attack(1),
        Ignore(2);

        public final int value;
        private static AttackReaction[] values;

        private AttackReaction(int i) {
            this.value = i;
        }

        public static AttackReaction get(int value) {
            if (values == null) {
                values = AttackReaction.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (AttackReaction.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Behaviour {
        Default(0),
        Shy(1),
        Aggressive(2),
        Dummy(3);

        public final int value;
        private static Behaviour[] values;

        private Behaviour(int i) {
            this.value = i;
        }

        public static Behaviour get(int value) {
            if (values == null) {
                values = Behaviour.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Behaviour.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        Animal(0),
        Mount(1),
        Human(2);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

