/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.assets;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.PluginAssetManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.Asset;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector4f;

public class MeshAsset
extends Asset {
    private ArrayList<Vector3f> vertices = null;
    private ArrayList<Vector3f> normals = null;
    private ArrayList<Vector4f> tangents = null;
    private ArrayList<Vector2f>[] uvs = null;
    private ArrayList<ColorRGBA> colors = null;
    private ArrayList<Integer> indices = null;
    private boolean cleanupNextTime = false;

    public static MeshAsset create(String name, int initialVertexCount, int initialIndexCount) {
        MeshAsset asset = new MeshAsset(initialVertexCount, initialIndexCount);
        asset.source = Asset.Source.Raw;
        asset.setupFileInfo(-1, -1, null, name, "mesh_" + name + "_" + System.currentTimeMillis(), "asset", String.valueOf(System.currentTimeMillis()));
        return asset;
    }

    MeshAsset(int initialVertexCount, int initialIndexCount) {
        super(Asset.Type.Mesh);
        this.vertices = new ArrayList(initialVertexCount);
        this.normals = new ArrayList(initialVertexCount);
        this.tangents = new ArrayList(initialVertexCount);
        this.colors = new ArrayList(initialVertexCount);
        this.indices = new ArrayList(initialIndexCount);
        this.uvs = new ArrayList[4];
        for (int i = 0; i < this.uvs.length; ++i) {
            this.uvs[i] = new ArrayList(initialVertexCount);
        }
    }

    public void ensureCapacity(int vertexCount, int indexCount) {
        this.indices.ensureCapacity(indexCount);
        this.vertices.ensureCapacity(vertexCount);
        this.normals.ensureCapacity(vertexCount);
        this.tangents.ensureCapacity(vertexCount);
        this.colors.ensureCapacity(vertexCount);
        for (ArrayList<Vector2f> uv : this.uvs) {
            uv.ensureCapacity(vertexCount);
        }
    }

    public int getVertexCount() {
        return this.vertices == null ? 0 : this.vertices.size();
    }

    public int getIndexCount() {
        return this.indices == null ? 0 : this.indices.size();
    }

    public int getSubMeshCount() {
        return 0;
    }

    public ArrayList<Integer> getIndices() {
        return this.indices;
    }

    public ArrayList<Vector3f> getVertices() {
        return this.vertices;
    }

    public ArrayList<Vector3f> getNormals() {
        return this.normals;
    }

    public ArrayList<Vector4f> getTangents() {
        return this.tangents;
    }

    public ArrayList<Vector2f> getUVs(int channel) {
        if (channel < 0 || channel >= 4) {
            throw new IndexOutOfBoundsException("Only 4 UV channels are supported!");
        }
        return this.uvs[channel];
    }

    public ArrayList<ColorRGBA> getColors() {
        return this.colors;
    }

    public void addVertex(float x, float y, float z) {
        this.vertices.add(new Vector3f(x, y, z));
    }

    public void addVertex(Vector3f vertex) {
        this.vertices.add(vertex);
    }

    public void addNormal(Vector3f normal) {
        this.normals.add(normal);
    }

    public void addTangent(Vector4f tangent) {
        this.tangents.add(tangent);
    }

    public void addUV(float u, float v) {
        this.addUV(0, u, v);
    }

    public void addUV(Vector2f uv) {
        this.addUV(0, uv);
    }

    public void addUV(int channel, float u, float v) {
        this.addUV(channel, new Vector2f(u, v));
    }

    public void addUV(int channel, Vector2f uv) {
        if (channel < 0 || channel >= 4) {
            throw new IndexOutOfBoundsException("Only 4 UV channels are supported!");
        }
        this.uvs[channel].add(uv);
    }

    public void addColor(ColorRGBA color) {
        this.colors.add(color);
    }

    public void addIndex(int index) {
        this.indices.add(index);
    }

    public void addIndices(int ... indices) {
        for (int i = 0; i < indices.length; ++i) {
            this.indices.add(indices[i]);
        }
    }

    public void addIndices(ArrayList<Integer> indices) {
        this.indices.addAll(indices);
    }

    public void addVertices(ArrayList<Vector3f> vertices) {
        this.vertices.addAll(vertices);
    }

    public void addNormals(ArrayList<Vector3f> normals) {
        this.normals.addAll(normals);
    }

    public void addTangents(ArrayList<Vector4f> tangents) {
        this.tangents.addAll(tangents);
    }

    public void addUVs(int channel, ArrayList<Vector2f> uvs) {
        if (channel < 0 || channel >= 4) {
            throw new IndexOutOfBoundsException("Only 4 UV channels are supported!");
        }
        this.uvs[channel].addAll(uvs);
    }

    public void setIndices(ArrayList<Integer> indices) {
        this.indices = indices;
    }

    public void setVertices(ArrayList<Vector3f> vertices) {
        this.vertices = vertices;
    }

    public void setNormals(ArrayList<Vector3f> normals) {
        this.normals = normals;
    }

    public void setTangents(ArrayList<Vector4f> tangents) {
        this.tangents = tangents;
    }

    public void setUVs(int channel, ArrayList<Vector2f> uvs) {
        if (channel < 0 || channel >= 4) {
            throw new IndexOutOfBoundsException("Only 4 UV channels are supported!");
        }
        this.uvs[channel] = uvs;
    }

    public void setColors(ArrayList<ColorRGBA> colors) {
        this.colors = colors;
    }

    public void clear() {
        this.vertices.clear();
        this.normals.clear();
        this.tangents.clear();
        this.colors.clear();
        this.indices.clear();
        for (ArrayList<Vector2f> uv : this.uvs) {
            uv.clear();
        }
    }

    public void uploadMeshData(boolean cleanupData) {
        this.cleanupNextTime = cleanupData;
        PluginAssetManager.refreshAsset((int)this.handle);
    }

    @Override
    synchronized byte[] loadData(boolean saveInCache) {
        byte[] data = this.serialize();
        if (saveInCache) {
            this.cachedData = data;
        }
        if (this.cleanupNextTime) {
            this.clear();
            this.cleanupNextTime = false;
        }
        return data;
    }

    @Override
    void onInit() {
    }

    @Override
    boolean checkFileExtension(String name) {
        return true;
    }

    private byte[] serialize() {
        int i;
        if (this.vertices == null || this.vertices.size() <= 0 || this.indices == null || this.indices.size() <= 0) {
            return null;
        }
        int vertexCount = this.vertices.size();
        int normalCount = this.normals == null ? 0 : this.normals.size();
        int tangentCount = this.tangents == null ? 0 : this.tangents.size();
        int colorCount = this.colors == null ? 0 : this.colors.size();
        int indexCount = this.indices.size();
        int bytes = 8;
        bytes += vertexCount * 12 + 4;
        bytes += normalCount * 12 + 4;
        bytes += tangentCount * 16 + 4;
        bytes += colorCount * 4 + 4;
        bytes += indexCount * 4 + 4 + 1;
        int MAX_UVs = 4;
        bytes += 20;
        if (this.uvs != null) {
            for (int i2 = 0; i2 < 4; ++i2) {
                ArrayList<Vector2f> uv = this.uvs[i2];
                if (uv == null) continue;
                bytes += uv.size() * 2 * 4;
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(vertexCount);
        bb.putInt(1);
        bb.putInt(vertexCount);
        for (i = 0; i < vertexCount; ++i) {
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)bb, (Vector3f)this.vertices.get(i));
        }
        bb.putInt(normalCount);
        for (i = 0; i < normalCount; ++i) {
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)bb, (Vector3f)this.normals.get(i));
        }
        bb.putInt(tangentCount);
        for (i = 0; i < tangentCount; ++i) {
            InternalUtils.ByteBufferUtils.putVector4f((ByteBuffer)bb, (Vector4f)this.tangents.get(i));
        }
        for (i = 0; i < 4; ++i) {
            ArrayList<Vector2f> uv = this.uvs[i];
            if (uv != null) {
                bb.putInt(uv.size());
                bb.put((byte)2);
                for (int j = 0; j < uv.size(); ++j) {
                    InternalUtils.ByteBufferUtils.putVector2f((ByteBuffer)bb, (Vector2f)uv.get(j));
                }
                continue;
            }
            bb.putInt(0);
            bb.put((byte)0);
        }
        bb.putInt(colorCount);
        for (i = 0; i < colorCount; ++i) {
            InternalUtils.ByteBufferUtils.putColor32((ByteBuffer)bb, (ColorRGBA)this.colors.get(i));
        }
        bb.putInt(indexCount);
        bb.put((byte)4);
        for (i = 0; i < indexCount; ++i) {
            bb.putInt(this.indices.get(i));
        }
        byte[] data = new byte[bb.position()];
        bb.flip();
        bb.get(data);
        return data;
    }
}

