/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.jiw.unity.runtime.JavaPlugin;
import net.jiw.unity.runtime.PluginEventHandler;
import net.jiw.unity.runtime.PluginManager;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.Listener;

public abstract class Plugin {
    private int id = -1;

    protected Plugin() {
    }

    public void onLoad() {
    }

    public abstract void onEnable();

    public abstract void onDisable();

    public final int getID() {
        return this.id;
    }

    public String getName() {
        return this.getDescription("name");
    }

    public String getDescription(String name) {
        return PluginManager.getDefinition((int)this.id, (String)name);
    }

    public int getLoadOrder() {
        return PluginManager.getPlugin((int)this.id).loadorder;
    }

    public String getPath() {
        return PluginManager.getPluginPath((int)this.id);
    }

    public final String getGameVersion() {
        return PluginManager.getGameVersion();
    }

    public final Plugin getPluginByID(int pluginID) {
        JavaPlugin p = PluginManager.getPlugin((int)pluginID);
        if (p != null) {
            return p.plugin;
        }
        return null;
    }

    public final Plugin getPluginByName(String pluginName) {
        return PluginManager.getPluginByName((String)pluginName);
    }

    public final Collection<Plugin> getAllPlugins() {
        Collection plugins = PluginManager.getAllPlugins();
        ArrayList<Plugin> list = new ArrayList<Plugin>(plugins.size());
        for (JavaPlugin p : plugins) {
            if (p == null || p.plugin == null) continue;
            list.add(p.plugin);
        }
        return list;
    }

    public final WorldDatabase getWorldDatabase(WorldDatabase.Target db) {
        return PluginManager.getWorldDatabase((WorldDatabase.Target)db);
    }

    public final Database getSQLiteConnection(String database) {
        return PluginManager.getSQLiteConnection((int)this.id, (String)database);
    }

    public final Database getMySQLConnection(String database, String ip, int port, String username, String password) {
        return PluginManager.getMySQLConnection((int)this.id, (String)database, (String)ip, (int)port, (String)username, (String)password);
    }

    public final String sendHttpRequest(String url) {
        return PluginManager.sendHttpRequest((String)url);
    }

    public final String sendHttpRequest(String url, HashMap<String, String> postData) {
        return PluginManager.sendHttpRequest((String)url, postData);
    }

    public final void registerEventListener(Listener listener) {
        PluginEventHandler.registerEventListener((int)this.id, (Listener)listener);
    }

    public final void unregisterEventListener(Listener listener) {
        PluginEventHandler.unregisterEventListener((int)this.id, (Listener)listener);
    }

    public final void triggerEvent(Event event) {
        PluginEventHandler.triggerEvent((Event)event);
    }

    public final void enqueue(Runnable runnable) {
        PluginManager.enqueue((int)this.id, (Runnable)runnable);
    }

    public final void executeDelayed(float delay, Runnable runnable) {
        if (runnable != null) {
            if (delay <= 0.0f) {
                this.enqueue(runnable);
            } else {
                new Timer(0.0f, delay, 0, runnable).start();
            }
        }
    }

    public final boolean isMainThread() {
        return PluginManager.isMainThread();
    }

    public final float getRunningTime() {
        return PluginManager.getRunningTime();
    }
}

