/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Objects;
import java.util.Random;
import java.util.SplittableRandom;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public abstract class Utils {
    public static final int SEA_LEVEL = (Integer)InternalUtils.getCommon((String)"SEA_LEVEL");
    public static final int ORBIT_START = (Integer)InternalUtils.getCommon((String)"ORBIT_START");
    public static final int ORBIT_END = (Integer)InternalUtils.getCommon((String)"ORBIT_END");

    public static abstract class ImageUtils {
        public static byte[] bufferedImageToByteArray(BufferedImage image) {
            return InternalUtils.ImageUtils.bufferedImageToByteArray((BufferedImage)image, (String)"png");
        }

        public static BufferedImage byteArrayToBufferedImage(byte[] bytes) {
            return InternalUtils.ImageUtils.byteArrayToBufferedImage((byte[])bytes);
        }

        public static BufferedImage rawMapTileToBufferedImage(byte[] data) {
            BufferedImage img = new BufferedImage(256, 256, 6);
            ByteBuffer bb = ByteBuffer.wrap(data);
            InternalUtils.ImageUtils.convertRGBAToABGR((ByteBuffer)bb, (BufferedImage)img);
            return img;
        }
    }

    public static abstract class VectorUtils {
        public static Vector3f getXZInFrontOfPlayer(Player player, float distance) {
            return VectorUtils.getXZInFrontOfPlayer(player, distance, null);
        }

        public static Vector3f getXZInFrontOfPlayer(Player player, float distance, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f(0.0f, 0.0f, 1.0f);
            }
            player.getRotation().multLocal(storeTo);
            storeTo.setY(0.0f).normalizeLocal().multLocal(distance).addLocal(player.getPosition());
            return storeTo;
        }

        public static Vector3f getXYZInFrontOfPlayer(Player player, float distance) {
            return VectorUtils.getXYZInFrontOfPlayer(player, distance, null);
        }

        public static Vector3f getXYZInFrontOfPlayer(Player player, float distance, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f(0.0f, 0.0f, 1.0f);
            }
            player.getRotation().multLocal(storeTo);
            storeTo.multLocal(distance).addLocal(player.getPosition());
            return storeTo;
        }

        public static Vector3f getDirection(Vector3f from, Vector3f to) {
            return VectorUtils.getDirection(from, to, null);
        }

        public static Vector3f getDirection(Vector3f from, Vector3f to, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f();
            }
            return storeTo.set(to).subtractLocal(from).normalizeLocal();
        }

        public static Vector3f getAlignedDirection(Vector3f direction, Vector3f normal) {
            return VectorUtils.getAlignedDirection(direction, normal, null);
        }

        public static Vector3f getAlignedDirection(Vector3f direction, Vector3f normal, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f();
            }
            storeTo.set(normal);
            storeTo.crossLocal(direction);
            storeTo.crossLocal(normal);
            return storeTo;
        }
    }

    public static abstract class SystemUtils {
        public static String getOperatingSystem() {
            return System.getProperty("os.name");
        }

        public static int getProcessorCores() {
            return Runtime.getRuntime().availableProcessors();
        }

        public static int getMemory() {
            return (int)(Runtime.getRuntime().maxMemory() / 1000000L);
        }

        public static String getArchitecture() {
            return System.getProperty("os.arch");
        }

        public static String getJavaVersion() {
            return System.getProperty("java.version");
        }
    }

    public static abstract class StringUtils {
        public static int parseInteger(String string, int defaultValue) {
            try {
                if (StringUtils.isInteger(string)) {
                    return Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        public static float parseFloat(String string, float defaultValue) {
            try {
                if (StringUtils.isNumeric(string)) {
                    return Float.parseFloat(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        public static boolean parseBoolean(String string, boolean defaultValue) {
            try {
                if (string.equalsIgnoreCase("true") || string.equals("1")) {
                    return true;
                }
                if (string.equalsIgnoreCase("false") || string.equals("0")) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        public static boolean isInteger(String string) {
            return string != null && string.matches("[-]{0,1}[\\d]+");
        }

        public static boolean isNumeric(String string) {
            return string != null && string.matches("[-]?([\\d]+[.]?[\\d]*)[f]?");
        }

        public static boolean isHex(String string) {
            return string != null && string.matches("0x[0-9A-Fa-f]+");
        }

        public static boolean isBoolean(String string) {
            return string != null && string.matches("(true)|(false)");
        }

        public static String combineStringArray(String[] array, int start, int end, char delimiter) {
            if (array == null || array.length < start || start < 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(64);
            if (end > array.length) {
                end = array.length;
            }
            for (int i = start; i < end; ++i) {
                sb.append(array[i]).append(delimiter);
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }

        public static String firstCharToUpper(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }

        public static String firstCharToLower(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }

        public static String removeAllNonWordCharacters(String string) {
            return string.replaceAll("\\W*", "");
        }

        public static String removeAllWhitespaces(String string) {
            return string.replaceAll("\\s+", "");
        }

        public static String removeAllLeadingWhitespaces(String string) {
            return InternalUtils.StringUtils.removeLeadingWhitespaces((String)string);
        }

        public static String removeAllTrailingWhitespaces(String string) {
            return InternalUtils.StringUtils.removeTrailingWhitespaces((String)string);
        }

        public static String removeAllLeadingAndTrailingWhitespaces(String string) {
            return InternalUtils.StringUtils.removeLeadingAndTrailingWhitespaces((String)string);
        }

        public static String[] getLines(String string) {
            return string.split("\\r?\\n");
        }

        public static String getMd5(String string) {
            return InternalUtils.StringUtils.getMd5((String)string);
        }

        public static String vector3fToString(Vector3f vector3f) {
            return InternalUtils.StringUtils.vector3fToString((float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
        }
    }

    public static abstract class ChunkUtils {
        public static final int CHUNK_SIZE_X = (Integer)InternalUtils.getCommon((String)"CHUNK_SIZE_X");
        public static final int CHUNK_SIZE_Y = (Integer)InternalUtils.getCommon((String)"CHUNK_SIZE_Y");
        public static final int CHUNK_SIZE_Z = (Integer)InternalUtils.getCommon((String)"CHUNK_SIZE_Z");
        public static final float CHUNK_INV_SIZE_X = 1.0f / (float)CHUNK_SIZE_X;
        public static final float CHUNK_INV_SIZE_Y = 1.0f / (float)CHUNK_SIZE_Y;
        public static final float CHUNK_INV_SIZE_Z = 1.0f / (float)CHUNK_SIZE_Z;

        public static Vector3i getChunkPosition(Vector3f globalPosition) {
            return ChunkUtils.getChunkPosition(globalPosition.x, globalPosition.y, globalPosition.z, new Vector3i());
        }

        public static Vector3i getChunkPosition(Vector3f globalPosition, Vector3i storeTo) {
            return ChunkUtils.getChunkPosition(globalPosition.x, globalPosition.y, globalPosition.z, storeTo);
        }

        public static Vector3i getChunkPosition(float x, float y, float z) {
            return ChunkUtils.getChunkPosition(x, y, z, new Vector3i());
        }

        public static Vector3i getChunkPosition(float x, float y, float z, Vector3i storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3i();
            } else {
                storeTo.zero();
            }
            return storeTo.set(ChunkUtils.getChunkPositionX(x), ChunkUtils.getChunkPositionY(y), ChunkUtils.getChunkPositionZ(z));
        }

        public static int getChunkPositionX(float x) {
            float cx = x * CHUNK_INV_SIZE_X;
            if (cx < 0.0f) {
                return (int)cx - 1;
            }
            return (int)cx;
        }

        public static int getChunkPositionY(float y) {
            float cy = y * CHUNK_INV_SIZE_Y;
            if (cy < 0.0f) {
                return (int)cy - 1;
            }
            return (int)cy;
        }

        public static int getChunkPositionZ(float z) {
            float cz = z * CHUNK_INV_SIZE_Z;
            if (cz < 0.0f) {
                return (int)cz - 1;
            }
            return (int)cz;
        }

        public static float getRelativePositionX(float x, int cx) {
            return x - (float)(cx * CHUNK_SIZE_X);
        }

        public static float getRelativePositionY(float y, int cy) {
            return y - (float)(cy * CHUNK_SIZE_Y);
        }

        public static float getRelativePositionZ(float z, int cz) {
            return z - (float)(cz * CHUNK_SIZE_Z);
        }

        public static void getChunkAndBlockPosition(Vector3f globalPosition, Vector3i chunkPositionStore, Vector3i blockPositionStore) {
            ChunkUtils.getChunkAndBlockPosition(globalPosition.x, globalPosition.y, globalPosition.z, chunkPositionStore, blockPositionStore);
        }

        public static void getChunkAndBlockPosition(float x, float y, float z, Vector3i chunkPositionStore, Vector3i blockPositionStore) {
            ChunkUtils.getChunkPosition(x, y, z, chunkPositionStore);
            if (blockPositionStore != null) {
                blockPositionStore.set(ChunkUtils.getBlockPositionX(x, chunkPositionStore.x), ChunkUtils.getBlockPositionY(y, chunkPositionStore.y), ChunkUtils.getBlockPositionZ(z, chunkPositionStore.z));
            }
        }

        public static Vector3i getBlockPosition(Vector3f globalPosition, Vector3i chunkPosition) {
            Vector3i blockPos = new Vector3i();
            blockPos.x = ChunkUtils.getBlockPositionX(globalPosition.x, chunkPosition.x);
            blockPos.y = ChunkUtils.getBlockPositionY(globalPosition.y, chunkPosition.y);
            blockPos.z = ChunkUtils.getBlockPositionZ(globalPosition.z, chunkPosition.z);
            return blockPos;
        }

        public static int getBlockPositionX(float x, int chunkPositionX) {
            if (x >= 0.0f) {
                return (int)x - chunkPositionX * CHUNK_SIZE_X;
            }
            if (x - (float)((int)x) == 0.0f) {
                x += 0.5f;
            }
            return (int)x - chunkPositionX * CHUNK_SIZE_X - 1;
        }

        public static int getBlockPositionY(float y, int chunkPositionY) {
            if (y >= 0.0f) {
                return (int)y - chunkPositionY * CHUNK_SIZE_Y;
            }
            if (y - (float)((int)y) == 0.0f) {
                y += 0.5f;
            }
            return (int)y - chunkPositionY * CHUNK_SIZE_Y - 1;
        }

        public static int getBlockPositionZ(float z, int chunkPositionZ) {
            if (z >= 0.0f) {
                return (int)z - chunkPositionZ * CHUNK_SIZE_Z;
            }
            if (z - (float)((int)z) == 0.0f) {
                z += 0.5f;
            }
            return (int)z - chunkPositionZ * CHUNK_SIZE_Z - 1;
        }

        public static Vector3f getGlobalPosition(Vector3i chunkPosition, Vector3i blockPosition) {
            return ChunkUtils.getGlobalPosition(chunkPosition, blockPosition, new Vector3f());
        }

        public static Vector3f getGlobalPosition(Vector3i chunkPosition, Vector3i blockPosition, Vector3f storeTo) {
            if (storeTo == null) {
                storeTo = new Vector3f();
            }
            storeTo.setX(chunkPosition.x * CHUNK_SIZE_X + blockPosition.x);
            storeTo.setY(chunkPosition.y * CHUNK_SIZE_Y + blockPosition.y);
            storeTo.setZ(chunkPosition.z * CHUNK_SIZE_Z + blockPosition.z);
            return storeTo;
        }

        public static Vector3i getGlobalBlockPosition(Vector3i chunkPosition, Vector3i blockPosition) {
            return ChunkUtils.getGlobalBlockPosition(chunkPosition.x, chunkPosition.y, chunkPosition.z, blockPosition.x, blockPosition.y, blockPosition.z);
        }

        public static Vector3i getGlobalBlockPosition(int cx, int cy, int cz, int bx, int by, int bz) {
            Vector3i vector = new Vector3i();
            vector.setX(cx * CHUNK_SIZE_X + bx);
            vector.setY(cy * CHUNK_SIZE_Y + by);
            vector.setZ(cz * CHUNK_SIZE_Z + bz);
            return vector;
        }
    }

    public static abstract class GeneralUtils {
        public static int colorRGBAToInt(float r, float g, float b, float a) {
            return ((int)(r * 255.0f) & 0xFF) << 24 | ((int)(g * 255.0f) & 0xFF) << 16 | ((int)(b * 255.0f) & 0xFF) << 8 | (int)(a * 255.0f) & 0xFF;
        }

        public static float intToColorR(int color) {
            return (float)((byte)(color >> 24) & 0xFF) / 255.0f;
        }

        public static float intToColorG(int color) {
            return (float)((byte)(color >> 16) & 0xFF) / 255.0f;
        }

        public static float intToColorB(int color) {
            return (float)((byte)(color >> 8) & 0xFF) / 255.0f;
        }

        public static float intToColorA(int color) {
            return (float)((byte)color & 0xFF) / 255.0f;
        }

        public static int nextRandomColor(boolean alpha) {
            return GeneralUtils.colorRGBAToInt(MathUtils.nextRandomFloat(), MathUtils.nextRandomFloat(), MathUtils.nextRandomFloat(), alpha ? MathUtils.nextRandomFloat() : 1.0f);
        }

        public static String getFormattedTimeAndDate(long timeInMillis) {
            Calendar d = Calendar.getInstance();
            d.setTimeInMillis(timeInMillis);
            return String.format("%04d/%02d/%02d  %02d:%02d ", d.get(1), d.get(2) + 1, d.get(5), d.get(10) == 0 ? 12 : d.get(10), d.get(12)) + (d.get(9) == 0 ? "AM" : "PM");
        }

        public static long getUnixTimestamp() {
            return System.currentTimeMillis() / 1000L;
        }

        public static float celsiusToFahrenheit(float celsius) {
            return celsius * 1.8f + 32.0f;
        }

        public static float fahrenheitToCelsius(float fahrenheit) {
            return (fahrenheit - 32.0f) / 1.8f;
        }
    }

    public static abstract class ByteUtils {
        public static byte[] compress(byte[] input) {
            return InternalUtils.ByteUtils.compress((byte[])input);
        }

        public static byte[] decompress(byte[] input) {
            return InternalUtils.ByteUtils.decompress((byte[])input);
        }

        public static String getMd5(byte[] input) {
            return InternalUtils.ByteUtils.getMd5((byte[])input);
        }

        public int unsignedByteToInt(byte b) {
            return b & 0xFF;
        }
    }

    public static abstract class FileUtils {
        public static final String ROOT_DIR = InternalUtils.ROOT_DIR;

        public static boolean writeStringToFile(String text, File file) {
            return InternalUtils.FileUtils.writeToFile((String)text, (File)file);
        }

        public static String readStringFromFile(File file) {
            return InternalUtils.FileUtils.readFromFile((File)file);
        }

        public static boolean writeBytesToFile(byte[] bytes, File file) {
            return InternalUtils.FileUtils.writeBytesToFile((byte[])bytes, (File)file);
        }

        public static byte[] readBytesFromFile(File file) {
            return InternalUtils.FileUtils.readBytesFromFile((File)file);
        }

        public static String getMd5(File file) {
            return InternalUtils.FileUtils.getMd5((File)file);
        }
    }

    public static abstract class MathUtils {
        public static final float PI = (float)Math.PI;
        public static final float HALF_PI = 1.5707964f;
        public static final float QUARTER_PI = 0.7853982f;
        public static final float TWO_PI = (float)Math.PI * 2;
        public static final float DEG_TO_RAD = (float)Math.PI / 180;
        public static final float RAD_TO_DEG = 57.295776f;
        private static final SplittableRandom random = new SplittableRandom(System.currentTimeMillis());

        public static float abs(float value) {
            return value < 0.0f ? -value : value;
        }

        public static int absInt(int value) {
            return value < 0 ? -value : value;
        }

        public static int mod(int x, int y) {
            return (x % y + y) % y;
        }

        public static float mod(float x, float y) {
            return (x % y + y) % y;
        }

        public static float min(float x, float y) {
            return x < y ? x : y;
        }

        public static float min(float x, float y, float z) {
            return x < y ? (x < z ? x : (z < y ? z : y)) : (y < z ? y : z);
        }

        public static int min(int x, int y) {
            return x < y ? x : y;
        }

        public static int min(int x, int y, int z) {
            return x < y ? (x < z ? x : (z < y ? z : y)) : (y < z ? y : z);
        }

        public static float max(float x, float y) {
            return x > y ? x : y;
        }

        public static float max(float x, float y, float z) {
            return x > y ? (x > z ? x : z) : (y > z ? y : z);
        }

        public static int max(int x, int y) {
            return x > y ? x : y;
        }

        public static int max(int x, int y, int z) {
            return x > y ? (x > z ? x : z) : (y > z ? y : z);
        }

        public static float sqr(float value) {
            return value * value;
        }

        public static float sqrt(float value) {
            return (float)Math.sqrt(value);
        }

        public static float degreeToRadian(float degree) {
            return (float)Math.PI / 180 * degree;
        }

        public static float radianToDegree(float radian) {
            return 57.295776f * radian;
        }

        public static float clamp(float min, float max, float value) {
            return value < min ? min : (value > max ? max : value);
        }

        public static int clamp(int min, int max, int value) {
            return value < min ? min : (value > max ? max : value);
        }

        public static float saturate(float value) {
            return MathUtils.clamp(0.0f, 1.0f, value);
        }

        public static float step(float min, float x) {
            return x < min ? 0.0f : 1.0f;
        }

        public static float smoothstep(float min, float max, float x) {
            x = MathUtils.clamp(0.0f, 1.0f, (x - min) / (max - min));
            return x * x * (3.0f - 2.0f * x);
        }

        public static float distance(float x1, float x2) {
            return MathUtils.abs(x1 - x2);
        }

        public static float distance(float x1, float y1, float x2, float y2) {
            float dx = x1 - x2;
            float dy = y1 - y2;
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public static float distance(float x1, float y1, float z1, float x2, float y2, float z2) {
            return (float)Math.sqrt(MathUtils.distanceSqr(x1, y1, z1, x2, y2, z2));
        }

        public static float distanceSqr(float x1, float y1, float z1, float x2, float y2, float z2) {
            float dx = x1 - x2;
            float dy = y1 - y2;
            float dz = z1 - z2;
            return dx * dx + dy * dy + dz * dz;
        }

        public static float length(float x, float y) {
            return (float)Math.sqrt(x * x + y * y);
        }

        public static float length(float x, float y, float z) {
            return (float)Math.sqrt(x * x + y * y + z * z);
        }

        public static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
            return x1 * x2 + y1 * y2 + z1 * z2;
        }

        public static int getNextPowerOfTwo(int value) {
            --value;
            value |= value >> 1;
            value |= value >> 2;
            value |= value >> 4;
            value |= value >> 8;
            value |= value >> 16;
            return ++value;
        }

        public static int getGCD(int ... input) {
            int result = input[0];
            for (int i = 1; i < input.length; ++i) {
                result = MathUtils.getGCD(result, input[i]);
            }
            return result;
        }

        public static int getGCD(int a, int b) {
            while (b > 0) {
                int temp = b;
                b = a % b;
                a = temp;
            }
            return a;
        }

        public static float round(float value, int digit) {
            digit = digit == 0 ? 1 : (digit *= 10);
            int intval = (int)(value *= (float)digit);
            float fract = value - (float)intval;
            if ((double)fract >= 0.5) {
                return (intval + 1) / digit;
            }
            return (float)intval / (float)digit;
        }

        public static float nextRandomFloat() {
            return (float)(random.nextInt() >>> 8) * 5.9604645E-8f;
        }

        public static int nextRandomInt(int min, int max) {
            return random.nextInt(min, max + 1);
        }

        public static boolean nextRandomBoolean() {
            return random.nextBoolean();
        }
    }

    public static abstract class ArrayUtils {
        public static <T> boolean contains(T[] array, T value) {
            if (array == null) {
                return false;
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != value && (array[i] == null || !array[i].equals(value))) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(int[] array, int value) {
            if (array == null) {
                return false;
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(byte[] array, byte value) {
            if (array == null) {
                return false;
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        public static <T> int indexOf(T[] array, T value) {
            if (array == null) {
                return -1;
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != value && (array[i] == null || !array[i].equals(value))) continue;
                return i;
            }
            return -1;
        }

        public static <T> void shiftRight(T[] array, int start, int end) {
            if (array == null) {
                return;
            }
            for (int i = end - 1; i >= start; --i) {
                Object previous = i <= 0 ? null : array[i - 1];
                array[i] = previous;
            }
        }

        public static String[] append(String[] array, String value) {
            String[] newArray = array == null ? new String[1] : ArrayUtils.resize(array, array.length + 1);
            newArray[newArray.length - 1] = value;
            return newArray;
        }

        public static int[] append(int[] array, int value) {
            int[] newArray = array == null ? new int[1] : ArrayUtils.resize(array, array.length + 1);
            newArray[newArray.length - 1] = value;
            return newArray;
        }

        public static byte[] append(byte[] array, byte value) {
            byte[] newArray = array == null ? new byte[1] : ArrayUtils.resize(array, array.length + 1);
            newArray[newArray.length - 1] = value;
            return newArray;
        }

        public static String[] resize(String[] array, int newLength) {
            if (newLength == array.length) {
                return array;
            }
            String[] newArray = new String[newLength];
            System.arraycopy(array, 0, newArray, 0, Math.min(newLength, array.length));
            return newArray;
        }

        public static int[] resize(int[] array, int newLength) {
            if (newLength == array.length) {
                return array;
            }
            int[] newArray = new int[newLength];
            System.arraycopy(array, 0, newArray, 0, Math.min(newLength, array.length));
            return newArray;
        }

        public static byte[] resize(byte[] array, int newLength) {
            if (newLength == array.length) {
                return array;
            }
            byte[] newArray = new byte[newLength];
            System.arraycopy(array, 0, newArray, 0, Math.min(newLength, array.length));
            return newArray;
        }

        public static String[] removeEntries(String[] array, String value) {
            int foundEntries = 0;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (!Objects.equals(array[i], value)) continue;
                ++foundEntries;
            }
            if (foundEntries == 0) {
                return array;
            }
            if (foundEntries >= array.length) {
                return new String[0];
            }
            int pos = 0;
            String[] newArray = new String[array.length - foundEntries];
            int len2 = array.length;
            for (int i = 0; i < len2; ++i) {
                if (Objects.equals(array[i], value)) continue;
                newArray[pos++] = array[i];
            }
            return newArray;
        }

        public static int[] removeEntries(int[] array, int value) {
            int foundEntries = 0;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (array[i] != value) continue;
                ++foundEntries;
            }
            if (foundEntries == 0) {
                return array;
            }
            if (foundEntries >= array.length) {
                return new int[0];
            }
            int pos = 0;
            int[] newArray = new int[array.length - foundEntries];
            int len2 = array.length;
            for (int i = 0; i < len2; ++i) {
                if (array[i] == value) continue;
                newArray[pos++] = array[i];
            }
            return newArray;
        }

        public static void shuffle(int[] array, int from, int to) {
            if (array == null || array.length == 0) {
                return;
            }
            int n = to;
            Random random = new Random(System.currentTimeMillis());
            while (n-- > from + 1) {
                int k = from + random.nextInt(n + 1 - from);
                int value = array[k];
                array[k] = array[n];
                array[n] = value;
            }
        }
    }
}

