/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector4f;

public class ColorRGBA {
    public static final ColorRGBA White = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA Grey = new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f);
    public static final ColorRGBA Black = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA Clear = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    public static final ColorRGBA Red = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA Green = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ColorRGBA Blue = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public ColorRGBA() {
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
    }

    public ColorRGBA(int rgba) {
        this.r = Utils.GeneralUtils.intToColorR(rgba);
        this.g = Utils.GeneralUtils.intToColorG(rgba);
        this.b = Utils.GeneralUtils.intToColorB(rgba);
        this.a = Utils.GeneralUtils.intToColorA(rgba);
    }

    public ColorRGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public ColorRGBA(ColorRGBA copy) {
        this.r = copy.r;
        this.g = copy.g;
        this.b = copy.b;
        this.a = copy.a;
    }

    public ColorRGBA set(ColorRGBA color) {
        return this.set(color.r, color.g, color.b, color.a);
    }

    public ColorRGBA set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public ColorRGBA interpolateLocal(ColorRGBA color, float mu) {
        this.r = (1.0f - mu) * this.r + mu * color.r;
        this.g = (1.0f - mu) * this.g + mu * color.g;
        this.b = (1.0f - mu) * this.b + mu * color.b;
        this.a = (1.0f - mu) * this.a + mu * color.a;
        return this;
    }

    public Vector4f toVector4f() {
        return new Vector4f(this.r, this.g, this.b, this.a);
    }

    public int toIntRGBA() {
        int rgba = ((int)(this.r * 255.0f) & 0xFF) << 24 | ((int)(this.g * 255.0f) & 0xFF) << 16 | ((int)(this.b * 255.0f) & 0xFF) << 8 | (int)(this.a * 255.0f) & 0xFF;
        return rgba;
    }

    public ColorRGBA fromIntRGBA(int rgba) {
        this.r = (float)((byte)(rgba >> 24) & 0xFF) / 255.0f;
        this.g = (float)((byte)(rgba >> 16) & 0xFF) / 255.0f;
        this.b = (float)((byte)(rgba >> 8) & 0xFF) / 255.0f;
        this.a = (float)((byte)rgba & 0xFF) / 255.0f;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof ColorRGBA) {
            ColorRGBA color = (ColorRGBA)o;
            return this.equals(color.r, color.g, color.b, color.a);
        }
        return false;
    }

    public boolean equals(float r, float g, float b, float a) {
        return this.r == r && this.g == g && this.b == b && this.a == a;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Float.floatToIntBits(this.r);
        hash = 37 * hash + Float.floatToIntBits(this.g);
        hash = 37 * hash + Float.floatToIntBits(this.b);
        hash = 37 * hash + Float.floatToIntBits(this.a);
        return hash;
    }

    public String toString() {
        return "(" + this.r + ", " + this.g + ", " + this.b + ", " + this.a + ")";
    }
}

