/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import net.risingworld.api.definitions.Clothing;
import net.risingworld.api.definitions.Definitions;

public final class Clothes {
    private final long handle;
    private final boolean isNpc;

    protected Clothes(long handle, boolean isNpc) {
        this.handle = handle;
        this.isNpc = isNpc;
    }

    public boolean isNpc() {
        return this.isNpc;
    }

    public void add(short clothingID) {
        this.add(this.handle, this.isNpc, clothingID, 0, 0L, 0);
    }

    public void add(short clothingID, int color, long infoID) {
        this.add(this.handle, this.isNpc, clothingID, color, infoID, 0);
    }

    private native void add(long var1, boolean var3, short var4, int var5, long var6, int var8);

    public Garment get(Clothing.Type type) {
        return this.get(this.handle, this.isNpc, type.value);
    }

    private native Garment get(long var1, boolean var3, int var4);

    public Garment[] getAll() {
        return this.getAll(this.handle, this.isNpc);
    }

    private native Garment[] getAll(long var1, boolean var3);

    public boolean remove(short clothingID) {
        return this.remove(this.handle, this.isNpc, clothingID);
    }

    private native boolean remove(long var1, boolean var3, short var4);

    public boolean remove(Clothing.Type type) {
        return this.removeType(this.handle, this.isNpc, type.value);
    }

    private native boolean removeType(long var1, boolean var3, int var4);

    public void removeAll() {
        this.removeAll(this.handle, this.isNpc);
    }

    private native void removeAll(long var1, boolean var3);

    public boolean has(short clothingID) {
        return this.has(this.handle, this.isNpc, clothingID);
    }

    private native boolean has(long var1, boolean var3, short var4);

    public boolean hasType(Clothing.Type type) {
        return this.hasType(this.handle, this.isNpc, type.value);
    }

    private native boolean hasType(long var1, boolean var3, int var4);

    public boolean hasSpecialGear(Clothing.Function clothingFunction) {
        return this.hasSpecialGear(this.handle, this.isNpc, clothingFunction.value);
    }

    private native boolean hasSpecialGear(long var1, boolean var3, int var4);

    public byte[] serialize() {
        return this.serialize(this.handle, this.isNpc);
    }

    private native byte[] serialize(long var1, boolean var3);

    public boolean deserialize(byte[] bytes) {
        return this.deserialize(this.handle, this.isNpc, bytes);
    }

    private native boolean deserialize(long var1, boolean var3, byte[] var4);

    public static class Garment {
        private final short id;
        private final int color;
        private final long infoID;
        private final int flags;

        private Garment(short id, int color, long infoID, int flags) {
            this.id = id;
            this.color = color;
            this.infoID = infoID;
            this.flags = flags;
        }

        public short getID() {
            return this.id;
        }

        public Clothing.ClothingDefinition getDefinition() {
            return Definitions.getClothingDefinition(this.id);
        }

        public int getColor() {
            return this.color;
        }

        public long getInfoID() {
            return this.infoID;
        }

        public String toString() {
            return "Garment (id: " + this.id + ", color: " + this.color + ", info: " + this.infoID + ", flags: " + this.flags + ")";
        }
    }
}

