/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.utils.Vector3f;

public final class Constructions {
    private Constructions() {
    }

    public static enum BlockType {
        None(0),
        Natural(1),
        Wood(100),
        Stone(200),
        Bricks(300),
        Marble(400),
        Tiles(500),
        Plaster(550),
        Loam(590),
        Concrete(600),
        Asphalt(670),
        Metal(700),
        Emissive(800),
        Glass(850),
        Roofing(900),
        Fabric(930),
        Misc(970),
        Custom(1000);

        public final int value;
        private static BlockType[] values;

        private BlockType(int i) {
            this.value = i;
        }

        public static BlockType get(int value) {
            if (values == null) {
                values = BlockType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (BlockType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Axis {
        None(0),
        X(4),
        Y(2),
        Z(1),
        XY(6),
        XZ(5),
        YZ(3),
        XYZ(7);

        public final int value;
        private static Axis[] values;

        private Axis(int i) {
            this.value = i;
        }

        public static Axis get(int value) {
            if (values == null) {
                values = Axis.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Axis.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Size {
        None(0),
        Tiny(1),
        SmallLight(2),
        Small(3),
        Medium(4),
        MediumLarge(5),
        Large(6),
        Huge(7);

        public final int value;
        private static Size[] values;

        private Size(int i) {
            this.value = i;
        }

        public static Size get(int value) {
            if (values == null) {
                values = Size.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Size.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public final class ConstructionDefinition {
        public byte id;
        public String name;
        public Type type;
        public ShapeType shapetype;
        public TilingMode tilingmode;
        public String meshpath;
        public short basestrength;
        public String relateditem;
        public boolean isseparategeometry;
        public Axis scaleaxisx;
        public Axis scaleaxisy;
        public Axis scaleaxisz;
        public boolean resizekeepproportions;
        public boolean supportssurfaceedit;
        public boolean supportsthickness;
        public boolean resetrotationafterplace;
        public Axis rowplacement;
        public BlockType[] supportedblocktypes;
        public int[] supportedtextures;
        public Vector3f startsize;
        public Axis pivotaxisflip;
        public boolean pivotincluderotation;
        public String pivotasset;
        public String debris;

        private ConstructionDefinition(Constructions this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (byte)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.shapetype = ShapeType.get(buffer.getInt());
            this.tilingmode = TilingMode.get(buffer.getInt());
            this.meshpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.basestrength = buffer.getShort();
            this.relateditem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.isseparategeometry = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.scaleaxisx = Axis.get(buffer.getInt());
            this.scaleaxisy = Axis.get(buffer.getInt());
            this.scaleaxisz = Axis.get(buffer.getInt());
            this.resizekeepproportions = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.supportssurfaceedit = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.supportsthickness = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.resetrotationafterplace = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.rowplacement = Axis.get(buffer.getInt());
            int isupportedblocktypes = buffer.getInt();
            if (isupportedblocktypes == -1) {
                this.supportedblocktypes = null;
            } else if (isupportedblocktypes >= 0) {
                this.supportedblocktypes = new BlockType[isupportedblocktypes];
                for (int i = 0; i < isupportedblocktypes; ++i) {
                    this.supportedblocktypes[i] = BlockType.get(buffer.getInt());
                }
            }
            int isupportedtextures = buffer.getInt();
            if (isupportedtextures == -1) {
                this.supportedtextures = null;
            } else if (isupportedtextures >= 0) {
                this.supportedtextures = new int[isupportedtextures];
                for (int i = 0; i < isupportedtextures; ++i) {
                    this.supportedtextures[i] = buffer.getInt();
                }
            }
            this.startsize = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.pivotaxisflip = Axis.get(buffer.getInt());
            this.pivotincluderotation = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.pivotasset = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.debris = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            int i;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.shapetype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.shapetype.value);
            if (this.tilingmode == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.tilingmode.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.meshpath);
            buffer.putShort(this.basestrength);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.relateditem);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isseparategeometry);
            if (this.scaleaxisx == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisx.value);
            if (this.scaleaxisy == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisy.value);
            if (this.scaleaxisz == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisz.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.resizekeepproportions);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.supportssurfaceedit);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.supportsthickness);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.resetrotationafterplace);
            if (this.rowplacement == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.rowplacement.value);
            if (this.supportedblocktypes == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.supportedblocktypes.length);
                for (i = 0; i < this.supportedblocktypes.length; ++i) {
                    if (this.supportedblocktypes[i] == null) {
                        throw new IllegalArgumentException("Enumeration must not be null!");
                    }
                    buffer.putInt(this.supportedblocktypes[i].value);
                }
            }
            if (this.supportedtextures == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.supportedtextures.length);
                for (i = 0; i < this.supportedtextures.length; ++i) {
                    buffer.putInt(this.supportedtextures[i]);
                }
            }
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.startsize);
            if (this.pivotaxisflip == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.pivotaxisflip.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.pivotincluderotation);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.pivotasset);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.debris);
        }

        private int getSize() {
            int size = 56;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.meshpath != null) {
                size += this.meshpath.length() * 2;
            }
            size += 2;
            if (this.relateditem != null) {
                size += this.relateditem.length() * 2;
            }
            size += 4;
            if (this.supportedblocktypes != null) {
                size += this.supportedblocktypes.length * 4;
            }
            size += 4;
            if (this.supportedtextures != null) {
                size += this.supportedtextures.length * 4;
            }
            size += 2;
            if (this.pivotasset != null) {
                size += this.pivotasset.length() * 2;
            }
            size += 2;
            if (this.debris != null) {
                size += this.debris.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeConstructionDefinition(this.serialize());
        }
    }

    public static enum Face {
        Undefined(0),
        Front(1),
        Right(2),
        Back(4),
        Left(8),
        Top(16),
        Bottom(32);

        public final int value;
        private static Face[] values;

        private Face(int i) {
            this.value = i;
        }

        public static Face get(int value) {
            if (values == null) {
                values = Face.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Face.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum TilingMode {
        World(0),
        WorldOriented(1),
        Fixed(2),
        Slope(3),
        Cylinder(4);

        public final int value;
        private static TilingMode[] values;

        private TilingMode(int i) {
            this.value = i;
        }

        public static TilingMode get(int value) {
            if (values == null) {
                values = TilingMode.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (TilingMode.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum ShapeType {
        Default(0),
        Slope(1),
        Corner(2),
        Special(3),
        Pane(4),
        Window(5);

        public final int value;
        private static ShapeType[] values;

        private ShapeType(int i) {
            this.value = i;
        }

        public static ShapeType get(int value) {
            if (values == null) {
                values = ShapeType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (ShapeType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        Default(0),
        Block(1),
        Window(2);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

