/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.collider;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.risingworld.api.assets.Asset;
import net.risingworld.api.assets.MeshAsset;
import net.risingworld.api.assets.ModelAsset;
import net.risingworld.api.collider.Collider;

public class MeshCollider
extends Collider {
    private Asset mesh = null;
    private boolean convex = false;
    private boolean isTrigger;

    public MeshCollider() {
        super(Collider.Type.Mesh);
    }

    public MeshCollider(MeshAsset mesh) {
        super(Collider.Type.Mesh);
        this.mesh = mesh;
    }

    public MeshCollider(ModelAsset mesh) {
        super(Collider.Type.Mesh);
        this.mesh = mesh;
    }

    @Override
    final byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(7);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)this.getType().ordinal());
        buffer.put((byte)(this.convex ? 1 : 0));
        buffer.put((byte)(this.isTrigger ? 1 : 0));
        buffer.putInt(this.mesh == null ? -1 : this.mesh.getHandle());
        return buffer.array();
    }
}

