/*
 * Decompiled with CFR 0.152.
 */
package worldprotection;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.definitions.Clothing;
import net.risingworld.api.definitions.Npcs;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.definitions.Plants;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.npc.NpcAddClothesEvent;
import net.risingworld.api.events.npc.NpcRemoveClothesEvent;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCreateBlueprintEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerEnterChunkEvent;
import net.risingworld.api.events.player.PlayerEnterWorldPartEvent;
import net.risingworld.api.events.player.PlayerGameObjectHitEvent;
import net.risingworld.api.events.player.PlayerHitItemEvent;
import net.risingworld.api.events.player.PlayerHitNpcEvent;
import net.risingworld.api.events.player.PlayerHitPlayerEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerMountNpcEvent;
import net.risingworld.api.events.player.PlayerMouseButtonEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.events.player.world.PlayerChangeConstructionColorEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectColorEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectInfoEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.events.player.world.PlayerCreativePlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerCreativeRemoveVegetationEvent;
import net.risingworld.api.events.player.world.PlayerCreativeTerrainEditEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerDestroyVegetationEvent;
import net.risingworld.api.events.player.world.PlayerEditConstructionEvent;
import net.risingworld.api.events.player.world.PlayerHitConstructionEvent;
import net.risingworld.api.events.player.world.PlayerHitObjectEvent;
import net.risingworld.api.events.player.world.PlayerHitTerrainEvent;
import net.risingworld.api.events.player.world.PlayerHitVegetationEvent;
import net.risingworld.api.events.player.world.PlayerHitWaterEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlueprintEvent;
import net.risingworld.api.events.player.world.PlayerPlaceConstructionEvent;
import net.risingworld.api.events.player.world.PlayerPlaceGrassEvent;
import net.risingworld.api.events.player.world.PlayerPlaceObjectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceTerrainEvent;
import net.risingworld.api.events.player.world.PlayerPlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceWaterEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveGrassEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveWaterEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.objects.world.Chunk;
import net.risingworld.api.objects.world.ConstructionElement;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITextField;
import net.risingworld.api.ui.style.ScaleMode;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Key;
import net.risingworld.api.utils.MouseButton;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.GameObject;
import worldprotection.AdminPage1Buttons;
import worldprotection.AdminPage2Buttons;
import worldprotection.AdminPage3Buttons;
import worldprotection.AreaBack;
import worldprotection.AreaConfirmationPanel;
import worldprotection.AreaNext;
import worldprotection.AreaPanelUI;
import worldprotection.BluePrintPlace;
import worldprotection.BlueprintBack;
import worldprotection.BlueprintNext;
import worldprotection.BlueprintPanelUI;
import worldprotection.CreateDatabase;
import worldprotection.DataUpdate;
import worldprotection.FoxButtons;
import worldprotection.FoxPanel;
import worldprotection.HorsePanel;
import worldprotection.OpenAreaPanel;
import worldprotection.OpenBluePrintPanel;
import worldprotection.OpenNPCPanels;
import worldprotection.OpenWPCommand;
import worldprotection.PlayerPage1Buttons;
import worldprotection.PlayerPage2Buttons;
import worldprotection.PlayerPage3Buttons;
import worldprotection.ResetAllAreasProectionToOff;
import worldprotection.TameAnimals;
import worldprotection.UpDateAdminSettings;
import worldprotection.UpDatePlayerSettings;

public class WorldProtection
extends Plugin
implements Listener {
    public Database database;
    public ArrayList<Area3D> UserAreas = new ArrayList();
    public ArrayList<Area3D> OtherAreas = new ArrayList();
    public ArrayList<Area3D> AllPreviewAreas = new ArrayList();
    public ArrayList<Object> NPCIDs = new ArrayList();
    public ArrayList<Timer> MYFollowTimer = new ArrayList();
    public ArrayList<Object> CalledNPCIDs = new ArrayList();
    public ArrayList<Timer> CalledNPCHorseTimer = new ArrayList();
    public ArrayList<Object> CalledFoxNPCIDs = new ArrayList();
    public ArrayList<Timer> CalledNPCFoxTimer = new ArrayList();
    public ArrayList<Object> FoxNPCIDs = new ArrayList();
    public ArrayList<Timer> FoxMYFollowTimer = new ArrayList();

    @Override
    public void onEnable() {
        String WorldName = World.getName();
        System.out.println("-- WorldProtection PLUGIN ENABLED --");
        this.database = this.getSQLiteConnection(this.getPath() + "/" + WorldName + "/database.db");
        CreateDatabase CreateDatabase2 = new CreateDatabase(this);
        CreateDatabase2.InstallDatabase();
        this.registerEventListener(this);
    }

    @Override
    public void onDisable() {
        System.out.println("-- PLUGIN DISABLED --");
        if (this.database != null) {
            this.database.close();
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        Timer PointsTimer = (Timer)player.getAttribute("PointsTimer");
        if (PointsTimer != null) {
            PointsTimer.kill();
        }
    }

    @EventMethod
    public void onPlayerSpawnEvent(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        Vector3i ChunkPosition = player.getChunkPosition();
        UpDateAdminSettings updateAdminSettings = new UpDateAdminSettings(this);
        updateAdminSettings.UpdateAdminSettings(player);
        UpDatePlayerSettings updatePlayerSettings = new UpDatePlayerSettings(this);
        updatePlayerSettings.UpdatePlayerSettings(player);
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        if (player != null) {
            Runnable HideTask;
            Timer HideTimer;
            Area3D SetArea;
            Area area;
            Vector3f endPos;
            Vector3f startPos;
            Vector3i EndChunk;
            Vector3i StartChunk;
            Vector3i EndBlock;
            Vector3i StartBlock;
            int AreaZ;
            ResultSet Result;
            ResultSet Result2;
            String PlayerUID = player.getUID();
            String UserName = player.getName();
            LocalDate Date2 = LocalDate.now();
            player.setAttribute("KeyFPressed", false);
            player.setAttribute("MenuOpen", false);
            player.setAttribute("FoxFeed", 0);
            player.setAttribute("foxcalled", false);
            player.setAttribute("PigFeed", 0);
            player.setAttribute("pigcalled", false);
            player.setAttribute("ChickenFeed", 0);
            player.setAttribute("chickencalled", false);
            player.setAttribute("CowFeed", 0);
            player.setAttribute("cowcalled", false);
            player.setAttribute("GoatFeed", 0);
            player.setAttribute("goatcalled", false);
            player.setAttribute("SheepFeed", 0);
            player.setAttribute("sheepcalled", false);
            player.setAttribute("LionFeed", 0);
            player.setAttribute("lioncalled", false);
            player.setAttribute("DummyFeed", 0);
            player.setAttribute("dummycalled", false);
            player.setAttribute("BearFeed", 0);
            player.setAttribute("bearcalled", false);
            player.setAttribute("ConstructionElementInfo", false);
            player.setAttribute("BPPageNumber", 0);
            player.setAttribute("AreaPageNumber", 0);
            HorsePanel HorsePanel2 = new HorsePanel(this);
            HorsePanel2.HorsePanel(player);
            FoxPanel FoxPanel2 = new FoxPanel(this);
            FoxPanel2.FoxPanel(player);
            BlueprintPanelUI BlueprintPanelUI2 = new BlueprintPanelUI(this);
            BlueprintPanelUI2.BlueprintPanelUI(player);
            AreaPanelUI AreaPanelUI2 = new AreaPanelUI(this);
            AreaPanelUI2.AreaPanelUI(player);
            String PlotOwner = "UnKnown";
            player.setAttribute("PlotOwner", PlotOwner);
            int Points = 0;
            player.setAttribute("Points", Points);
            String AreaNameText = "UnKnown";
            player.setAttribute("AreaNameText", AreaNameText);
            int NeededPoints = 10;
            player.setAttribute("NeededPoints", NeededPoints);
            player.setAttribute("TroggleViewAreas", false);
            player.setAttribute("AdminRights", true);
            player.setAttribute("NamePass", false);
            player.setAttribute("FriendName", "");
            player.setAttribute("list", 0);
            player.setAttribute("AreaFriendUID", "Guest");
            player.registerKeys(Key.B, Key.N, Key.F);
            player.setListenForKeyInput(true);
            player.setListenForMouseInput(true);
            try {
                Result2 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` = '" + player.getUID() + "'");
                try {
                    while (Result2.next()) {
                        int AreaX = (Integer)Result2.getObject("AreaX");
                        int AreaY = (Integer)Result2.getObject("AreaY");
                        int AreaZ2 = (Integer)Result2.getObject("AreaZ");
                        Vector3i vector3i = new Vector3i(AreaX, AreaY, AreaZ2);
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result2 = this.database.executeQuery("SELECT * FROM `PlayerLastOnline` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result2.next()) {
                        this.database.executeUpdate("UPDATE PlayerLastOnline SET LastOnLine = '" + String.valueOf(Date2) + "' WHERE PlayerUID = '" + PlayerUID + "'");
                    } else {
                        this.database.executeUpdate("INSERT INTO `PlayerLastOnline` (PlayerUID, LastOnLine) VALUES ('" + PlayerUID + "','" + String.valueOf(Date2) + "');");
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result2 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result2.next()) {
                        player.setAttribute("PointsEarnedAdjust", Result2.getInt("PointsEarnedAdjust"));
                        player.setAttribute("AreaCostAdjust", Result2.getInt("AreaCostAdjust"));
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result2 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result2.next()) {
                        int CountPlots = Result2.getInt(1);
                        player.setAttribute("CountPlots", CountPlots);
                        int PlusPoints = (Integer)player.getAttribute("AreaCostAdjust");
                        NeededPoints = PlusPoints * CountPlots;
                        if (NeededPoints == 0) {
                            NeededPoints = 10;
                        }
                        player.setAttribute("NeededPoints", NeededPoints);
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result2 = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result2.next()) {
                        Points = Result2.getInt("Points");
                        player.setAttribute("Points", Points);
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            AreaConfirmationPanel AreaConfirmationPanel2 = new AreaConfirmationPanel(this);
            AreaConfirmationPanel2.AreaConfirmationPanel(player);
            UILabel PointsInfo = new UILabel();
            PointsInfo.setClickable(false);
            PointsInfo.setText("Points=" + String.valueOf(player.getAttribute("Points")));
            PointsInfo.setPosition(5.0f, 850.0f, false);
            PointsInfo.setVisible(true);
            player.setAttribute("PointsInfo", PointsInfo);
            player.setAttribute("PointsInfoID", PointsInfo.getID());
            player.addUIElement(PointsInfo);
            UILabel AreaAmount = new UILabel();
            AreaAmount.setClickable(false);
            AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + String.valueOf(player.getAttribute("NeededPoints")));
            AreaAmount.setPosition(5.0f, 830.0f, false);
            AreaAmount.setVisible(true);
            player.setAttribute("AreaAmount", AreaAmount);
            player.setAttribute("AreaAmountID", AreaAmount.getID());
            player.addUIElement(AreaAmount);
            TextureAsset BackGround = TextureAsset.loadFromFile(this.getPath() + "/Assets/BackGround.png");
            TextureAsset Exit = TextureAsset.loadFromFile(this.getPath() + "/Assets/Exit.png");
            TextureAsset ExitOver = TextureAsset.loadFromFile(this.getPath() + "/Assets/ExitOver.png");
            UIElement SettingsWPPanel = new UIElement();
            SettingsWPPanel.setSize(800.0f, 600.0f, false);
            SettingsWPPanel.setPosition(25.0f, 25.0f, true);
            SettingsWPPanel.setVisible(false);
            SettingsWPPanel.style.backgroundImage.set(BackGround);
            SettingsWPPanel.style.backgroundImageScaleMode.set(ScaleMode.StretchToFill);
            player.setAttribute("SettingsWPPanel", SettingsWPPanel);
            player.setAttribute("SettingsWPPanelID", SettingsWPPanel.getID());
            UIElement SettingsWPPlayerPanel = new UIElement();
            SettingsWPPlayerPanel.setSize(800.0f, 600.0f, false);
            SettingsWPPlayerPanel.setPosition(25.0f, 25.0f, true);
            SettingsWPPlayerPanel.setVisible(false);
            SettingsWPPlayerPanel.style.backgroundImage.set(BackGround);
            SettingsWPPlayerPanel.style.backgroundImageScaleMode.set(ScaleMode.StretchToFill);
            player.setAttribute("SettingsWPlayerPPanel", SettingsWPPlayerPanel);
            player.setAttribute("SettingsWPPlayerPanelID", SettingsWPPlayerPanel.getID());
            UILabel exitSettingsWPPanel = new UILabel();
            exitSettingsWPPanel.setClickable(true);
            exitSettingsWPPanel.isClickable();
            exitSettingsWPPanel.setSize(5.0f, 4.0f, true);
            exitSettingsWPPanel.setPosition(733.0f, 8.0f, false);
            exitSettingsWPPanel.style.backgroundImage.set(Exit);
            exitSettingsWPPanel.hoverStyle.backgroundImage.set(ExitOver);
            exitSettingsWPPanel.style.backgroundImageScaleMode.set(ScaleMode.StretchToFill);
            SettingsWPPanel.addChild(exitSettingsWPPanel);
            player.setAttribute("exitSettingsWPPanel", exitSettingsWPPanel);
            player.setAttribute("exitSettingsWPPanelID", exitSettingsWPPanel.getID());
            UILabel exitSettingsWPPlayerPanel = new UILabel();
            exitSettingsWPPlayerPanel.setClickable(true);
            exitSettingsWPPlayerPanel.isClickable();
            exitSettingsWPPlayerPanel.setSize(5.0f, 4.0f, true);
            exitSettingsWPPlayerPanel.setPosition(733.0f, 8.0f, false);
            exitSettingsWPPlayerPanel.style.backgroundImage.set(Exit);
            exitSettingsWPPlayerPanel.hoverStyle.backgroundImage.set(ExitOver);
            exitSettingsWPPlayerPanel.style.backgroundImageScaleMode.set(ScaleMode.StretchToFill);
            SettingsWPPlayerPanel.addChild(exitSettingsWPPlayerPanel);
            player.setAttribute("exitSettingsWPPlayerPanel", exitSettingsWPPlayerPanel);
            player.setAttribute("exitSettingsWPPlayerPanelID", exitSettingsWPPlayerPanel.getID());
            UILabel CreationDateSettingsWPPanel = new UILabel();
            CreationDateSettingsWPPanel.setText("Creation Date=");
            CreationDateSettingsWPPanel.setPosition(90.0f, 10.0f, false);
            SettingsWPPanel.addChild(CreationDateSettingsWPPanel);
            player.setAttribute("CreationDateSettingsWPPanel", CreationDateSettingsWPPanel);
            player.setAttribute("CreationDateSettingsWPPanelID", CreationDateSettingsWPPanel.getID());
            UILabel LastOnlineSettingsWPPanel = new UILabel();
            LastOnlineSettingsWPPanel.setText("Last OnLine=");
            LastOnlineSettingsWPPanel.setPosition(340.0f, 10.0f, false);
            SettingsWPPanel.addChild(LastOnlineSettingsWPPanel);
            player.setAttribute("LastOnlineSettingsWPPanel", LastOnlineSettingsWPPanel);
            player.setAttribute("LastOnlineSettingsWPPanelID", LastOnlineSettingsWPPanel.getID());
            UILabel SinceLastOnlineSettingsWPPanel = new UILabel();
            SinceLastOnlineSettingsWPPanel.setText("Days Offline=");
            SinceLastOnlineSettingsWPPanel.setPosition(600.0f, 10.0f, false);
            SettingsWPPanel.addChild(SinceLastOnlineSettingsWPPanel);
            player.setAttribute("SinceLastOnlineSettingsWPPanel", SinceLastOnlineSettingsWPPanel);
            player.setAttribute("SinceLastOnlineSettingsWPPanelID", SinceLastOnlineSettingsWPPanel.getID());
            UILabel OpenAdminTools = new UILabel();
            OpenAdminTools.setClickable(true);
            OpenAdminTools.setText("<b> Admin Tools </b>");
            OpenAdminTools.style.textAlign.set(TextAnchor.MiddleCenter);
            OpenAdminTools.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            OpenAdminTools.setFontSize(12.0f);
            OpenAdminTools.setBorder(2.0f);
            OpenAdminTools.setBorderColor(999);
            OpenAdminTools.style.borderBottomColor.set(ColorRGBA.Green);
            OpenAdminTools.setBorderEdgeRadius(5.0f, false);
            OpenAdminTools.setSize(100.0f, 25.0f, false);
            OpenAdminTools.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            OpenAdminTools.setPosition(70.0f, 557.0f, false);
            OpenAdminTools.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            OpenAdminTools.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(OpenAdminTools);
            player.setAttribute("OpenAdminTools", OpenAdminTools);
            player.setAttribute("OpenAdminToolsID", OpenAdminTools.getID());
            UILabel OpenPlayerTools = new UILabel();
            OpenPlayerTools.setClickable(true);
            OpenPlayerTools.setText("<b> Player Tools </b>");
            OpenPlayerTools.style.textAlign.set(TextAnchor.MiddleCenter);
            OpenPlayerTools.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            OpenPlayerTools.setFontSize(12.0f);
            OpenPlayerTools.setBorder(2.0f);
            OpenPlayerTools.setBorderColor(999);
            OpenPlayerTools.style.borderBottomColor.set(ColorRGBA.Green);
            OpenPlayerTools.setBorderEdgeRadius(5.0f, false);
            OpenPlayerTools.setSize(100.0f, 25.0f, false);
            OpenPlayerTools.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            OpenPlayerTools.setPosition(170.0f, 557.0f, false);
            OpenPlayerTools.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            OpenPlayerTools.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(OpenPlayerTools);
            player.setAttribute("OpenPlayerTools", OpenPlayerTools);
            player.setAttribute("OpenPlayerToolsID", OpenPlayerTools.getID());
            AdminPage1Buttons AdminPage1buttons = new AdminPage1Buttons(this);
            AdminPage1buttons.page1(player);
            AdminPage2Buttons AdminPage2buttons = new AdminPage2Buttons(this);
            AdminPage2buttons.page2(player);
            AdminPage3Buttons AdminPage3buttons = new AdminPage3Buttons(this);
            AdminPage3buttons.page3(player);
            PlayerPage1Buttons PlayerPage1buttons = new PlayerPage1Buttons(this);
            PlayerPage1buttons.page1(player);
            PlayerPage2Buttons PlayerPage2buttons = new PlayerPage2Buttons(this);
            PlayerPage2buttons.page2(player);
            PlayerPage3Buttons PlayerPage3buttons = new PlayerPage3Buttons(this);
            PlayerPage3buttons.page3(player);
            UILabel WPNextPlayerButton = new UILabel();
            WPNextPlayerButton.setClickable(true);
            WPNextPlayerButton.setText("<b> Next </b>");
            WPNextPlayerButton.style.textAlign.set(TextAnchor.MiddleCenter);
            WPNextPlayerButton.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            WPNextPlayerButton.setFontSize(12.0f);
            WPNextPlayerButton.setBorder(2.0f);
            WPNextPlayerButton.setSize(100.0f, 25.0f, false);
            WPNextPlayerButton.setBorderColor(999);
            WPNextPlayerButton.style.borderBottomColor.set(ColorRGBA.Green);
            WPNextPlayerButton.setBorderEdgeRadius(5.0f, false);
            WPNextPlayerButton.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            WPNextPlayerButton.setPosition(670.0f, 160.0f, false);
            WPNextPlayerButton.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            WPNextPlayerButton.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(WPNextPlayerButton);
            player.setAttribute("WPNextPlayerButton", WPNextPlayerButton);
            player.setAttribute("WPNextPlayerButtonID", WPNextPlayerButton.getID());
            UILabel DeleteWPArea = new UILabel();
            DeleteWPArea.setClickable(true);
            DeleteWPArea.setText("<b> Delete Area </b>");
            DeleteWPArea.style.textAlign.set(TextAnchor.MiddleCenter);
            DeleteWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            DeleteWPArea.setFontSize(12.0f);
            DeleteWPArea.setBorder(2.0f);
            DeleteWPArea.setBorderColor(999);
            DeleteWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            DeleteWPArea.setBorderEdgeRadius(5.0f, false);
            DeleteWPArea.setSize(100.0f, 25.0f, false);
            DeleteWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 1.0f);
            DeleteWPArea.setPosition(378.0f, 557.0f, false);
            DeleteWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            DeleteWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(DeleteWPArea);
            player.setAttribute("DeleteWPArea", DeleteWPArea);
            player.setAttribute("DeleteWPAreaID", DeleteWPArea.getID());
            UILabel RemoveFriendFromWPArea = new UILabel();
            RemoveFriendFromWPArea.setClickable(true);
            RemoveFriendFromWPArea.setText("<b> Delete Friend </b>");
            RemoveFriendFromWPArea.style.textAlign.set(TextAnchor.MiddleCenter);
            RemoveFriendFromWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            RemoveFriendFromWPArea.setFontSize(12.0f);
            RemoveFriendFromWPArea.setBorder(2.0f);
            RemoveFriendFromWPArea.setSize(100.0f, 25.0f, false);
            RemoveFriendFromWPArea.setBorderColor(999);
            RemoveFriendFromWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            RemoveFriendFromWPArea.setBorderEdgeRadius(5.0f, false);
            RemoveFriendFromWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 1.0f);
            RemoveFriendFromWPArea.setPosition(277.0f, 557.0f, false);
            RemoveFriendFromWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            RemoveFriendFromWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(RemoveFriendFromWPArea);
            player.setAttribute("RemoveFriendFromWPArea", RemoveFriendFromWPArea);
            player.setAttribute("RemoveFriendFromWPAreaID", RemoveFriendFromWPArea.getID());
            UILabel ReNameWPArea = new UILabel();
            ReNameWPArea.setClickable(true);
            ReNameWPArea.setText("<b> Name Area </b>");
            ReNameWPArea.style.textAlign.set(TextAnchor.MiddleCenter);
            ReNameWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            ReNameWPArea.setFontSize(12.0f);
            ReNameWPArea.setBorder(2.0f);
            ReNameWPArea.setBorderColor(999);
            ReNameWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            ReNameWPArea.setBorderEdgeRadius(5.0f, false);
            ReNameWPArea.setSize(100.0f, 25.0f, false);
            ReNameWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            ReNameWPArea.setPosition(30.0f, 45.0f, false);
            ReNameWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            ReNameWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(ReNameWPArea);
            player.setAttribute("ReNameWPArea", ReNameWPArea);
            player.setAttribute("ReNameWPAreaID", ReNameWPArea.getID());
            UILabel AddFriendToWPArea = new UILabel();
            AddFriendToWPArea.setClickable(true);
            AddFriendToWPArea.setText("<b> Add Friend </b>");
            AddFriendToWPArea.style.textAlign.set(TextAnchor.MiddleCenter);
            AddFriendToWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            AddFriendToWPArea.setFontSize(12.0f);
            AddFriendToWPArea.setBorder(2.0f);
            AddFriendToWPArea.setSize(100.0f, 25.0f, false);
            AddFriendToWPArea.setBorderColor(999);
            AddFriendToWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            AddFriendToWPArea.setBorderEdgeRadius(5.0f, false);
            AddFriendToWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            AddFriendToWPArea.setPosition(235.0f, 160.0f, false);
            AddFriendToWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            AddFriendToWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(AddFriendToWPArea);
            player.setAttribute("AddFriendToWPArea", AddFriendToWPArea);
            player.setAttribute("AddFriendToWPAreaID", AddFriendToWPArea.getID());
            UITextField WPNameTextField = new UITextField();
            WPNameTextField.setClickable(true);
            WPNameTextField.setMaxCharacters(55);
            WPNameTextField.setText("");
            WPNameTextField.setBorderColor(143);
            WPNameTextField.setSize(630.0f, 25.0f, false);
            WPNameTextField.setPosition(133.0f, 45.0f, false);
            WPNameTextField.getCurrentText(player, SettingsWPNameTextField -> {
                player.setAttribute("SettingsExitPortalNameText", SettingsWPNameTextField);
                player.sendTextMessage("Settings Text: " + SettingsWPNameTextField);
            });
            player.setAttribute("WPNameTextField", WPNameTextField);
            SettingsWPPanel.addChild(WPNameTextField);
            player.addUIElement(WPNameTextField);
            player.setAttribute("WPNameTextField", WPNameTextField);
            player.setAttribute("SWPNameTextFieldID", WPNameTextField.getID());
            UITextField AddFriendToWPAreaTextField = new UITextField();
            AddFriendToWPAreaTextField.setClickable(true);
            AddFriendToWPAreaTextField.setMaxCharacters(33);
            AddFriendToWPAreaTextField.setText("Enter User Name");
            AddFriendToWPAreaTextField.setBorderColor(143);
            AddFriendToWPAreaTextField.setSize(330.0f, 25.0f, false);
            AddFriendToWPAreaTextField.setPosition(338.0f, 160.0f, false);
            AddFriendToWPAreaTextField.getCurrentText(player, SettingsAddFriendToWPAreaTextField -> {
                player.setAttribute("SettingsExitPortalNameText", SettingsAddFriendToWPAreaTextField);
                player.sendTextMessage("Settings Text: " + SettingsAddFriendToWPAreaTextField);
            });
            player.setAttribute("AddFriendToWPAreaTextField", AddFriendToWPAreaTextField);
            SettingsWPPanel.addChild(AddFriendToWPAreaTextField);
            player.addUIElement(AddFriendToWPAreaTextField);
            player.setAttribute("AddFriendToWPAreaTextField", AddFriendToWPAreaTextField);
            player.setAttribute("AddFriendToWPAreaTextFieldID", AddFriendToWPAreaTextField.getID());
            UILabel GivePoints = new UILabel();
            GivePoints.setClickable(true);
            GivePoints.setText("<b> Give Points </b>");
            GivePoints.style.textAlign.set(TextAnchor.MiddleCenter);
            GivePoints.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            GivePoints.setFontSize(12.0f);
            GivePoints.setBorder(2.0f);
            GivePoints.setSize(100.0f, 25.0f, false);
            GivePoints.setBorderColor(999);
            GivePoints.style.borderBottomColor.set(ColorRGBA.Green);
            GivePoints.setBorderEdgeRadius(5.0f, false);
            GivePoints.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            GivePoints.setPosition(30.0f, 160.0f, false);
            GivePoints.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            GivePoints.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(GivePoints);
            player.setAttribute("GivePoints", GivePoints);
            player.setAttribute("GivePointsID", GivePoints.getID());
            UITextField SendPointsAmount = new UITextField();
            SendPointsAmount.setClickable(true);
            SendPointsAmount.setMaxCharacters(10);
            SendPointsAmount.setText("10");
            SendPointsAmount.setBorderColor(143);
            SendPointsAmount.setSize(100.0f, 25.0f, false);
            SendPointsAmount.setPosition(133.0f, 160.0f, false);
            SendPointsAmount.getCurrentText(player, SettingsSendPointsAmount -> {
                player.setAttribute("SettingsExitPortalNameText", SettingsSendPointsAmount);
                player.sendTextMessage("Settings Text: " + SettingsSendPointsAmount);
            });
            player.setAttribute("SendPointsAmount", SendPointsAmount);
            SettingsWPPanel.addChild(SendPointsAmount);
            player.addUIElement(SendPointsAmount);
            player.setAttribute("SendPointsAmount", SendPointsAmount);
            player.setAttribute("SendPointsAmountID", SendPointsAmount.getID());
            UILabel LockArea = new UILabel();
            LockArea.setClickable(true);
            LockArea.setText("<b> Lock Area </b>");
            LockArea.style.textAlign.set(TextAnchor.MiddleCenter);
            LockArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            LockArea.setFontSize(12.0f);
            LockArea.setBorder(2.0f);
            LockArea.setSize(100.0f, 25.0f, false);
            LockArea.setBorderColor(999);
            LockArea.style.borderBottomColor.set(ColorRGBA.Green);
            LockArea.setBorderEdgeRadius(5.0f, false);
            LockArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            LockArea.setPosition(38.0f, 345.0f, false);
            LockArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            LockArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(LockArea);
            player.setAttribute("LockArea", LockArea);
            player.setAttribute("LockAreaID", LockArea.getID());
            UILabel UnlockArea = new UILabel();
            UnlockArea.setClickable(true);
            UnlockArea.setText("<b> Unlock Area </b>");
            UnlockArea.style.textAlign.set(TextAnchor.MiddleCenter);
            UnlockArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            UnlockArea.setFontSize(12.0f);
            UnlockArea.setBorder(2.0f);
            UnlockArea.setSize(100.0f, 25.0f, false);
            UnlockArea.setBorderColor(999);
            UnlockArea.style.borderBottomColor.set(ColorRGBA.Green);
            UnlockArea.setBorderEdgeRadius(5.0f, false);
            UnlockArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            UnlockArea.setPosition(140.0f, 345.0f, false);
            UnlockArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            UnlockArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(UnlockArea);
            player.setAttribute("UnlockArea", UnlockArea);
            player.setAttribute("UnlockAreaID", UnlockArea.getID());
            UILabel Areastatus = new UILabel();
            Areastatus.setText("<b>Status=Area Locked </b>");
            Areastatus.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
            Areastatus.setFontSize(12.0f);
            Areastatus.setSize(500.0f, 25.0f, false);
            Areastatus.setPosition(240.0f, 345.0f, false);
            SettingsWPPanel.addChild(Areastatus);
            player.setAttribute("Areastatus", Areastatus);
            player.setAttribute("AreastatusID", Areastatus.getID());
            UILabel PlayerPVPOff = new UILabel();
            PlayerPVPOff.setClickable(true);
            PlayerPVPOff.setText("<b> PVP Off </b>");
            PlayerPVPOff.style.textAlign.set(TextAnchor.MiddleCenter);
            PlayerPVPOff.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            PlayerPVPOff.setFontSize(12.0f);
            PlayerPVPOff.setBorder(2.0f);
            PlayerPVPOff.setSize(100.0f, 25.0f, false);
            PlayerPVPOff.setBorderColor(999);
            PlayerPVPOff.style.borderBottomColor.set(ColorRGBA.Green);
            PlayerPVPOff.setBorderEdgeRadius(5.0f, false);
            PlayerPVPOff.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            PlayerPVPOff.setPosition(38.0f, 420.0f, false);
            PlayerPVPOff.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            PlayerPVPOff.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(PlayerPVPOff);
            player.setAttribute("PlayerPVPOff", PlayerPVPOff);
            player.setAttribute("PlayerPVPOffID", PlayerPVPOff.getID());
            UILabel PlayerPVPOn = new UILabel();
            PlayerPVPOn.setClickable(true);
            PlayerPVPOn.setText("<b> PVP ON </b>");
            PlayerPVPOn.style.textAlign.set(TextAnchor.MiddleCenter);
            PlayerPVPOn.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            PlayerPVPOn.setFontSize(12.0f);
            PlayerPVPOn.setBorder(2.0f);
            PlayerPVPOn.setSize(100.0f, 25.0f, false);
            PlayerPVPOn.setBorderColor(999);
            PlayerPVPOn.style.borderBottomColor.set(ColorRGBA.Green);
            PlayerPVPOn.setBorderEdgeRadius(5.0f, false);
            PlayerPVPOn.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
            PlayerPVPOn.setPosition(140.0f, 420.0f, false);
            PlayerPVPOn.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            PlayerPVPOn.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(PlayerPVPOn);
            player.setAttribute("PlayerPVPOn", PlayerPVPOn);
            player.setAttribute("PlayerPVPOnID", PlayerPVPOn.getID());
            UILabel PlayerPVPStatus = new UILabel();
            PlayerPVPStatus.setText("<b>Status=PVP OFF </b>");
            PlayerPVPStatus.setFontColor(9.0f, 9.0f, 9.0f, 1.0f);
            PlayerPVPStatus.setFontSize(12.0f);
            PlayerPVPStatus.setSize(500.0f, 25.0f, false);
            PlayerPVPStatus.setPosition(240.0f, 420.0f, false);
            SettingsWPPanel.addChild(PlayerPVPStatus);
            player.setAttribute("PlayerPVPStatus", PlayerPVPStatus);
            player.setAttribute("PlayerPVPStatusID", PlayerPVPStatus.getID());
            UILabel HideWPArea = new UILabel();
            HideWPArea.setClickable(true);
            HideWPArea.setText("<b> Hide Areas </b>");
            HideWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            HideWPArea.setFontSize(12.0f);
            HideWPArea.setBorder(2.0f);
            HideWPArea.setSize(100.0f, 25.0f, false);
            HideWPArea.setBorderColor(999);
            HideWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            HideWPArea.setBorderEdgeRadius(5.0f, false);
            HideWPArea.setPosition(38.0f, 524.0f, false);
            HideWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            HideWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(HideWPArea);
            player.setAttribute("HideWPArea", HideWPArea);
            player.setAttribute("HideWPAreaID", HideWPArea.getID());
            UILabel ViewWPArea = new UILabel();
            ViewWPArea.setClickable(true);
            ViewWPArea.setText("<b> Show Areas </b>");
            ViewWPArea.setFontColor(0.0f, 0.0f, 0.0f, 1.0f);
            ViewWPArea.setFontSize(12.0f);
            ViewWPArea.setBorder(2.0f);
            ViewWPArea.setSize(100.0f, 25.0f, false);
            ViewWPArea.setBorderColor(999);
            ViewWPArea.style.borderBottomColor.set(ColorRGBA.Green);
            ViewWPArea.setBorderEdgeRadius(5.0f, false);
            ViewWPArea.setPosition(140.0f, 524.0f, false);
            ViewWPArea.hoverStyle.color.set(9.0f, 9.0f, 9.0f, 9.0f);
            ViewWPArea.hoverStyle.backgroundColor.set(0.0f, 0.0f, 9.0f, 9.0f);
            SettingsWPPanel.addChild(ViewWPArea);
            player.setAttribute("ViewWPArea", ViewWPArea);
            player.setAttribute("ViewWPAreaID", ViewWPArea.getID());
            if (Boolean.FALSE.equals(player.getAttribute("TroggleViewAreas"))) {
                HideWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 0.5f);
                ViewWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
            } else if (Boolean.TRUE.equals(player.getAttribute("TroggleViewAreas"))) {
                HideWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
                ViewWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 0.5f);
            }
            player.addUIElement(SettingsWPPanel);
            try {
                Result = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result.next()) {
                        Points = Result.getInt("Points");
                        player.setAttribute("Points", Points);
                        PointsTimer = new Timer(60.0f, 0.0f, -1, null);
                        PointsTask = () -> {
                            int BonusPoints = (Integer)player.getAttribute("Points");
                            int PlusPoints = (Integer)player.getAttribute("PointsEarnedAdjust");
                            this.database.executeUpdate("UPDATE Points SET Points = '" + (BonusPoints += PlusPoints) + "' WHERE PlayerUID = '" + PlayerUID + "'");
                            player.setAttribute("Points", BonusPoints);
                            PointsInfo.setText("Points=" + String.valueOf(player.getAttribute("Points")));
                        };
                        PointsTimer.setTask(PointsTask);
                        PointsTimer.start();
                        player.setAttribute("PointsTimer", PointsTimer);
                    } else {
                        this.database.executeUpdate("INSERT INTO `Points` (UserName, Points, PlayerUID) VALUES ('" + UserName + "','1','" + PlayerUID + "');");
                        PointsTimer = new Timer(60.0f, 0.0f, -1, null);
                        PointsTask = () -> {
                            int BonusPoints = (Integer)player.getAttribute("Points");
                            int PlusPoints = (Integer)player.getAttribute("PointsEarnedAdjust");
                            this.database.executeUpdate("UPDATE Points SET Points = '" + (BonusPoints += PlusPoints) + "' WHERE PlayerUID = '" + PlayerUID + "'");
                            player.setAttribute("Points", BonusPoints);
                            PointsInfo.setText("Points=" + String.valueOf(player.getAttribute("Points")));
                        };
                        PointsTimer.setTask(PointsTask);
                        PointsTimer.start();
                        player.setAttribute("PointsTimer", PointsTimer);
                    }
                }
                finally {
                    if (Result != null) {
                        Result.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    while (Result.next()) {
                        int AreaX = (Integer)Result.getObject("AreaX");
                        int AreaY = (Integer)Result.getObject("AreaY");
                        AreaZ = (Integer)Result.getObject("AreaZ");
                        StartBlock = new Vector3i(0, 0, 0);
                        EndBlock = new Vector3i(32, 64, 32);
                        StartChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        EndChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        area = new Area(startPos, endPos);
                        SetArea = new Area3D(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.3f);
                        SetArea.setFrameColor(0.0f, 0.5f, 0.0f, 0.6f);
                        player.addGameObject(SetArea);
                        HideTimer = new Timer(60.0f, 0.0f, 0, null);
                        HideTask = () -> {
                            player.removeGameObject(SetArea);
                            try {
                                Result.close();
                            }
                            catch (SQLException ex) {
                                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        };
                        HideTimer.setTask(HideTask);
                        HideTimer.start();
                    }
                }
                finally {
                    if (Result != null) {
                        Result.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` != '" + PlayerUID + "'");
                try {
                    while (Result.next()) {
                        int AreaX = (Integer)Result.getObject("AreaX");
                        int AreaY = (Integer)Result.getObject("AreaY");
                        AreaZ = (Integer)Result.getObject("AreaZ");
                        StartBlock = new Vector3i(0, 0, 0);
                        EndBlock = new Vector3i(32, 64, 32);
                        StartChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        EndChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        area = new Area(startPos, endPos);
                        SetArea = new Area3D(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.5f, 0.0f, 0.0f, 0.3f);
                        SetArea.setFrameColor(0.5f, 0.0f, 0.0f, 0.6f);
                        player.addGameObject(SetArea);
                        HideTimer = new Timer(60.0f, 0.0f, 0, null);
                        HideTask = () -> {
                            player.removeGameObject(SetArea);
                            try {
                                Result.close();
                            }
                            catch (SQLException ex) {
                                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        };
                        HideTimer.setTask(HideTask);
                        HideTimer.start();
                    }
                }
                finally {
                    if (Result != null) {
                        Result.close();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @EventMethod
    public void onPlayerChangePositionEvent(PlayerChangePositionEvent event) throws SQLException {
        Area[] areas;
        Player player = event.getPlayer();
        UILabel PlotInfo = (UILabel)player.getAttribute("PlotInfo");
        UILabel AreaName = (UILabel)player.getAttribute("AreaName");
        Vector3f playerPosition = player.getPosition();
        for (Area area : areas = Server.getAllAreas()) {
            if (area.isPointInArea(playerPosition)) {
                player.setAttribute("InsideAdminArea", true);
                AreaName.setText("Area Name=" + area.getName());
                PlotInfo.setText("Plot Owner=Admin Area");
                continue;
            }
            player.setAttribute("InsideAdminArea", false);
        }
    }

    @EventMethod
    public void onPlayerEnterWorldPartEvent(PlayerEnterWorldPartEvent event) throws SQLException {
        Player player = event.getPlayer();
    }

    @EventMethod
    public void onPlayerEnterChunk(PlayerEnterChunkEvent event) throws SQLException {
        ResultSet Result;
        Player player = event.getPlayer();
        String AreaOwnerName = "UnClaimed";
        String AreaNameText = "UnNamed";
        Vector3i ChunkPosition = event.getNewChunkCoordinates();
        player.setAttribute("PlayersChunkPositionX", ChunkPosition.x);
        player.setAttribute("PlayersChunkPositionY", ChunkPosition.y);
        player.setAttribute("PlayersChunkPositionZ", ChunkPosition.z);
        if (Boolean.TRUE.equals(player.getAttribute("preview"))) {
            Vector3i StartBlock = new Vector3i(0, 0, 0);
            Vector3i EndBlock = new Vector3i(32, 64, 32);
            Vector3i StartChunk = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
            Vector3i EndChunk = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
            Vector3f startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
            Vector3f endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
            Area area = new Area(startPos, endPos);
            Area3D SetArea = new Area3D(area);
            SetArea.setAlwaysVisible(false);
            SetArea.setFrameVisible(true);
            SetArea.setColor(0.5f, 0.5f, 0.0f, 0.1f);
            SetArea.setFrameColor(9.0f, 9.0f, 9.0f, 9.0f);
            player.addGameObject(SetArea);
            player.setAttribute("previewoff", SetArea);
            this.AllPreviewAreas.add(SetArea);
        }
        UpDateAdminSettings updateAdminSettings = new UpDateAdminSettings(this);
        updateAdminSettings.UpdateAdminSettings(player);
        UpDatePlayerSettings updatePlayerSettings = new UpDatePlayerSettings(this);
        updatePlayerSettings.UpdatePlayerSettings(player);
        try {
            Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `AreaGuest` = '" + player.getUID() + "'");
            try {
                if (Result.next()) {
                    player.setAttribute("AreaFriendUID", Result.getString("AreaGuest"));
                } else {
                    player.setAttribute("AreaFriendUID", "Guest");
                }
                Result.close();
            }
            finally {
                if (Result != null) {
                    Result.close();
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + player.getUID() + "'");
            try {
                if (Result.next()) {
                    player.setAttribute("AreaOwnerUID", Result.getString("PlayerUID"));
                } else {
                    player.setAttribute("AreaOwnerUID", "Guest");
                }
                Result.close();
            }
            finally {
                if (Result != null) {
                    Result.close();
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @EventMethod
    public void onPlayerEnterAreaEvent(PlayerEnterAreaEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        UILabel AreaName = (UILabel)player.getAttribute("AreaName");
        UILabel PlotInfo = (UILabel)player.getAttribute("PlotInfo");
        player.sendTextMessage("area=" + event.getArea().getName());
        player.sendTextMessage("area=" + event.getArea().getID());
        PlotInfo.setText("Plot Owner=Admin Area");
        AreaName.setText("Area Name=" + event.getArea().getName());
        player.setAttribute("InsideAdminArea", true);
    }

    @EventMethod
    public void onPlayerLeaveAreaEvent(PlayerLeaveAreaEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        UILabel AreaName = (UILabel)player.getAttribute("AreaName");
        UILabel PlotInfo = (UILabel)player.getAttribute("PlotInfo");
        PlotInfo.setText("Plot Owner=" + String.valueOf(player.getAttribute("PlotOwner")));
        AreaName.setText("Area Name=UnNamed");
        player.setAttribute("InsideAdminArea", false);
    }

    @EventMethod
    public void onPlayerKeyInputEvent(PlayerKeyEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        Object KeyFPressed = null;
        UILabel PlotInfo = (UILabel)player.getAttribute("PlotInfo");
        UILabel PointsInfo = (UILabel)player.getAttribute("PointsInfo");
        UILabel AreaAmount = (UILabel)player.getAttribute("AreaAmount");
        UILabel AreaName = (UILabel)player.getAttribute("AreaName");
        UIElement AreaConfirmationPanel2 = (UIElement)player.getAttribute("AreaConfirmationPanel");
        Vector3i ChunkPosition = player.getChunkPosition();
        player.setAttribute("PlayersChunkPositionX", ChunkPosition.x);
        player.setAttribute("PlayersChunkPositionY", ChunkPosition.y);
        player.setAttribute("PlayersChunkPositionZ", ChunkPosition.z);
        if (player.isAdmin() && event.isPressed() && event.getKey().equals((Object)Key.N)) {
            try (ResultSet Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");){
                if (Result != null) {
                    if (Result.next()) {
                        String AreaOwnerName = Result.getString("AreaOwnerName");
                        player.sendTextMessage("This area is already claimed by " + AreaOwnerName);
                    } else {
                        LocalDate Date2 = LocalDate.now();
                        this.database.executeUpdate("INSERT INTO `Areas` (AreaOwnerName, AreaName, AreaGuest, AreaX, AreaY, AreaZ, PlayerUID, CreationDate, AreaLocked, ChestLocked, DoorsLocked, PVPStatus) VALUES ('Admin','TownArea','AreaGuest','" + ChunkPosition.x + "','" + ChunkPosition.y + "','" + ChunkPosition.z + "','Town','" + String.valueOf(Date2) + "','1','1','1','1');");
                        String PlotOwner = "Admin";
                        player.setAttribute("PlotOwner", PlotOwner);
                        PlotInfo.setText("Plot Owner=Admin");
                        AreaName.setText("Area Name=TownArea");
                        AreaName.setFontColor(0.0f, 9.0f, 0.0f, 9.0f);
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(32, 64, 32);
                        Vector3i StartChunk = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
                        Vector3i EndChunk = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
                        Vector3f startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        Vector3f endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        Area area = new Area(startPos, endPos);
                        Area3D SetArea = new Area3D(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.5f, 0.5f, 0.5f, 0.3f);
                        SetArea.setFrameColor(0.0f, 0.0f, 9.0f, 1.0f);
                        player.addGameObject(SetArea);
                        Timer HideTimer = new Timer(60.0f, 0.0f, 0, null);
                        Runnable HideTask = () -> player.removeGameObject(SetArea);
                        HideTimer.setTask(HideTask);
                        HideTimer.start();
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (event.isPressed() && event.getKey() == Key.B) {
            player.setMouseCursorVisible(true);
            AreaConfirmationPanel2.setVisible(true);
        }
        if (event.isPressed() && event.getKey() == Key.F) {
            player.setAttribute("KeyFPressed", true);
        } else if (!event.isPressed() && event.getKey() == Key.F) {
            player.setAttribute("KeyFPressed", false);
        }
    }

    @EventMethod
    public void onPlayerMountNpcEvent(PlayerMountNpcEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Npc npc = event.getNpc();
        Npcs.NpcDefinition def = npc.getDefinition();
        player.setAttribute("NPC", npc);
        try (ResultSet Result = this.database.executeQuery("SELECT * FROM `HorseOwnerShip` WHERE HorseID = '" + npc.getGlobalID() + "'");){
            if (Result.next()) {
                String HorseOwner = Result.getString("PlayerUID");
                String OwnerName = Result.getString("UserName");
                if (!PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    event.setCancelled(true);
                    player.sendTextMessage("Only " + OwnerName + " Can ride this horse!!");
                    return;
                }
                if (PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    event.setCancelled(false);
                    return;
                }
            }
            Result.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea")) && def.type == Npcs.Type.Mount) {
            if (Boolean.FALSE.equals(player.getAttribute("RideMountNPC"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot Ride NPC Mounts here");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("RideMountNPC"))) {
                event.setCancelled(false);
                return;
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Npcs.Type.Mount) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerRideMountNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Ride NPC Mounts here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerRideMountNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 7");
            }
        }
    }

    @EventMethod
    public void onNpcAddClothesEvent(NpcAddClothesEvent event) throws SQLException {
        Player player = event.getRelatedPlayer();
        String PlayerUID = player.getUID();
        String PlayerName = player.getName();
        Npc NPCHorse = event.getNpc();
        Clothing.ClothingDefinition Clothdef = event.getClothingDefinition();
        if (Clothdef.function == Clothing.Function.Saddle && NPCHorse.getDefinition().name.equals("horse")) {
            try (ResultSet Result = this.database.executeQuery("SELECT * FROM `HorseOwnerShip` WHERE HorseID = '" + NPCHorse.getGlobalID() + "'");){
                if (Result.next()) {
                    String OwnerName = Result.getString("UserName");
                    player.sendTextMessage(OwnerName + " Already Owns This Horse");
                } else {
                    this.database.executeUpdate("INSERT INTO `HorseOwnerShip` (PlayerUID, UserName, HorseID, HorseName, SetRoaming) VALUES ('" + PlayerUID + "','" + PlayerName + "','" + NPCHorse.getGlobalID() + "','Mr Ed','0');");
                    NPCHorse.setName("Mr Ed");
                    NPCHorse.setLocked(true);
                    player.sendTextMessage("You Now Own This Horse");
                }
                Result.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (Clothdef.function == Clothing.Function.Saddle) {
                if (Boolean.TRUE.equals(player.getAttribute("NpcAddSaddle"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("NpcAddSaddle"))) {
                    player.sendTextMessage("You Are Not allowed To Add Saddles Here 1");
                    event.setCancelled(true);
                }
            }
            if (Clothdef.function == Clothing.Function.Saddlebag) {
                if (Boolean.TRUE.equals(player.getAttribute("NpcAddSaddleBag"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("NpcAddSaddleBag"))) {
                    player.sendTextMessage("You Are Not allowed To Add Saddles Bags Here");
                    event.setCancelled(true);
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Clothdef.function == Clothing.Function.Saddle) {
                if (Boolean.TRUE.equals(player.getAttribute("PlayerNpcAddSaddle"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("PlayerNpcAddSaddle"))) {
                    player.sendTextMessage("You Are Not allowed To Add Saddles Here 2");
                    event.setCancelled(true);
                }
            }
            if (Clothdef.function == Clothing.Function.Saddlebag) {
                if (Boolean.TRUE.equals(player.getAttribute("PlayerNpcAddSaddleBag"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("PlayerNpcAddSaddleBag"))) {
                    player.sendTextMessage("You Are Not allowed To Add Saddles Bags Here");
                    event.setCancelled(true);
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onNpcRemoveClothesEvent(NpcRemoveClothesEvent event) throws SQLException {
        Player player = event.getRelatedPlayer();
        String PlayerUID = player.getUID();
        Npc NPCHorse = event.getNpc();
        Clothing.ClothingDefinition Clothdef = event.getClothingDefinition();
        try (ResultSet Result = this.database.executeQuery("SELECT * FROM `HorseOwnerShip` WHERE HorseID = '" + NPCHorse.getGlobalID() + "'");){
            if (Result.next()) {
                String HorseOwner = Result.getString("PlayerUID");
                String OwnerName = Result.getString("UserName");
                if (!PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    event.setCancelled(true);
                    player.sendTextMessage("Only " + OwnerName + " Can Remove Its Saddle!!");
                    return;
                }
                if (PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    Timer RunTimer = new Timer(1.0f, 1.0f, 0, null);
                    Runnable RunTask = () -> {
                        NPCHorse.setLocked(true);
                        RunTimer.kill();
                    };
                    RunTimer.setTask(RunTask);
                    RunTimer.start();
                    event.setCancelled(false);
                    return;
                }
            }
            Result.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (Clothdef.function == Clothing.Function.Saddle) {
                if (Boolean.TRUE.equals(player.getAttribute("NpcRemoveSaddle"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("NpcRemoveSaddle"))) {
                    player.sendTextMessage("You Are Not allowed To Remove Saddles Here");
                    event.setCancelled(true);
                }
            }
            if (Clothdef.function == Clothing.Function.Saddlebag) {
                if (Boolean.TRUE.equals(player.getAttribute("NpcRemoveSaddleBag"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("NpcRemoveSaddleBag"))) {
                    player.sendTextMessage("You Are Not allowed To Remove Saddles Bags Here");
                    event.setCancelled(true);
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Clothdef.function == Clothing.Function.Saddle) {
                if (Boolean.TRUE.equals(player.getAttribute("PlayerNpcRemoveSaddle"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("PlayerNpcRemoveSaddle"))) {
                    player.sendTextMessage("You Are Not allowed To Remove Saddles Here");
                    event.setCancelled(true);
                }
            }
            if (Clothdef.function == Clothing.Function.Saddlebag) {
                if (Boolean.TRUE.equals(player.getAttribute("PlayerNpcRemoveSaddleBag"))) {
                    event.setCancelled(false);
                } else if (Boolean.FALSE.equals(player.getAttribute("PlayerNpcRemoveSaddleBag"))) {
                    player.sendTextMessage("You Are Not allowed To Remove Saddles Bags Here");
                    event.setCancelled(true);
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerHitNpcEvent(PlayerHitNpcEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Npc npc = event.getNpc();
        Npcs.NpcDefinition def = npc.getDefinition();
        try (ResultSet Result = this.database.executeQuery("SELECT * FROM `HorseOwnerShip` WHERE HorseID = '" + npc.getGlobalID() + "'");){
            if (Result.next()) {
                String HorseOwner = Result.getString("PlayerUID");
                String OwnerName = Result.getString("UserName");
                if (!PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    event.setCancelled(true);
                    player.sendTextMessage("you cannot hit " + OwnerName + "s Horse!!");
                    return;
                }
                if (PlayerUID.equalsIgnoreCase(HorseOwner)) {
                    player.sendTextMessage("Stop hitting your own horse you asshole");
                    npc.setLocked(false);
                    npc.setAlerted(true, 15);
                    Timer RunTimer = new Timer(1.0f, 15.0f, 0, null);
                    Runnable RunTask = () -> {
                        npc.setLocked(true);
                        RunTimer.kill();
                    };
                    RunTimer.setTask(RunTask);
                    RunTimer.start();
                    event.setCancelled(true);
                    return;
                }
            }
            Result.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Npcs.Type.Animal) {
                if (Boolean.FALSE.equals(player.getAttribute("HitAnimalNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Animals here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("HitAnimalNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Npcs.Type.Human) {
                if (Boolean.FALSE.equals(player.getAttribute("HitHumanNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Humans here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("HitHumanNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Npcs.Type.Mount) {
                if (Boolean.FALSE.equals(player.getAttribute("HitMountNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Mount here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("HitMountNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Npcs.Type.Animal) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerHitAnimalNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Animals here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerHitAnimalNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Npcs.Type.Mount) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerHitMountNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Mount here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerHitMountNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Npcs.Type.Human) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerHitHumanNPC"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot hit NPC Humans here");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerHitHumanNPC"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here 1");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 37");
            }
        }
    }

    @EventMethod
    public void onPlayerChangeConstructionColorEvent(PlayerChangeConstructionColorEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 1");
            }
        }
    }

    @EventMethod
    public void onPlayerChangeObjectColorEvent(PlayerChangeObjectColorEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 2");
            }
        }
    }

    @EventMethod
    public void onPlayerChangeObjectInfoEvent(PlayerChangeObjectInfoEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 3");
            }
        }
    }

    @EventMethod
    public void onPlayerCreativePlaceVegetationEvent(PlayerCreativePlaceVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 6");
            }
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveConstructionEvent(PlayerCreativeRemoveConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 7.5");
            }
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveObjectEvent(PlayerCreativeRemoveObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 8");
            }
        }
    }

    @EventMethod
    public void onPlayerCreativeRemoveVegetationEvent(PlayerCreativeRemoveVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 9");
            }
        }
    }

    @EventMethod
    public void onPlayerCreativeTerrainEditEvent(PlayerCreativeTerrainEditEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 10");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyConstructionEvent(PlayerDestroyConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 11");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyObjectEvent(PlayerDestroyObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 12");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyTerrainEvent(PlayerDestroyTerrainEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        int TerrainID = event.getTerrainID();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (Boolean.FALSE.equals(player.getAttribute("DestroyTerrain"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot Destroy Terrain in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("DestroyTerrain"))) {
                event.setCancelled(false);
                return;
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("PlayerDestroyTerrain"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot Destroy Terrain in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("PlayerDestroyTerrain"))) {
                event.setCancelled(false);
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 13");
            }
        }
    }

    @EventMethod
    public void onPlayerDestroyVegetationEvent(PlayerDestroyVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Plants.PlantDefinition def = event.getPlantDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("TreeDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TreeDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("TrunkDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TrunkDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("RockDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("RockDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTreeDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTreeDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTrunkDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTrunkDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerRockDestroyVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Destroy Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerRockDestroyVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 14");
            }
        }
    }

    @EventMethod
    public void onPlayerChangeObjectStatusEvent(PlayerChangeObjectStatusEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Objects.Type.Bed) {
                if (Boolean.FALSE.equals(player.getAttribute("BedUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Beds in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("BedUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Campfire) {
                if (Boolean.FALSE.equals(player.getAttribute("CampfireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Campfires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("CampfireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Clock) {
                if (Boolean.FALSE.equals(player.getAttribute("ClockUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Clocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ClockUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Door) {
                if (Boolean.FALSE.equals(player.getAttribute("DoorUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Doors in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("DoorUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.DryingRack) {
                if (Boolean.FALSE.equals(player.getAttribute("DryingRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use DryingRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("DryingRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Fire) {
                if (Boolean.FALSE.equals(player.getAttribute("FireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Fires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("FireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Furnace) {
                if (Boolean.FALSE.equals(player.getAttribute("FurnaceUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Furnaces in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("FurnaceUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grill) {
                if (Boolean.FALSE.equals(player.getAttribute("GrillUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grills in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrillUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grinder) {
                if (Boolean.FALSE.equals(player.getAttribute("GrinderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grinders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrinderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grindstone) {
                if (Boolean.FALSE.equals(player.getAttribute("GrindstoneUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grindstones in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrindstoneUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Ladder) {
                if (Boolean.FALSE.equals(player.getAttribute("LadderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ladders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("LadderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Lamp) {
                if (Boolean.FALSE.equals(player.getAttribute("LampUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Lamps in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("LampUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.MusicPlayer) {
                if (Boolean.FALSE.equals(player.getAttribute("MusicPlayerUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use MusicPlayers in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("MusicPlayerUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Oven) {
                if (Boolean.FALSE.equals(player.getAttribute("OvenUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ovens in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("OvenUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.PaperPress) {
                if (Boolean.FALSE.equals(player.getAttribute("PaperPressUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use PaperPress's in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PaperPressUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Piano) {
                if (Boolean.FALSE.equals(player.getAttribute("PianoUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Pianos in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PianoUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Poster) {
                if (Boolean.FALSE.equals(player.getAttribute("PosterUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Posters in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PosterUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Scaffolding) {
                if (Boolean.FALSE.equals(player.getAttribute("ScaffoldingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Scaffoldings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ScaffoldingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Seating) {
                if (Boolean.FALSE.equals(player.getAttribute("SeatingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Seatings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SeatingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.ShootingTarget) {
                if (Boolean.FALSE.equals(player.getAttribute("ShootingTargetUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use ShootingTargets in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ShootingTargetUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Sign) {
                if (Boolean.FALSE.equals(player.getAttribute("SignUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Signs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SignUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.SpinningWheel) {
                if (Boolean.FALSE.equals(player.getAttribute("SpinningWheelUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use SpinningWheels in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SpinningWheelUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Storage) {
                if (Boolean.FALSE.equals(player.getAttribute("StorageUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Storages in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("StorageUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.TanningRack) {
                if (Boolean.FALSE.equals(player.getAttribute("TanningRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use TanningRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TanningRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Technical) {
                if (Boolean.FALSE.equals(player.getAttribute("TechnicalUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Technicals in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TechnicalUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Torch) {
                if (Boolean.FALSE.equals(player.getAttribute("TorchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Torchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TorchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Trashcan) {
                if (Boolean.FALSE.equals(player.getAttribute("TrashcanUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Trashcans in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TrashcanUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Workbench) {
                if (Boolean.FALSE.equals(player.getAttribute("WorkbenchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Workbenchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("WorkbenchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Objects.Type.Bed) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerBedUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Beds in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerBedUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Campfire) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerCampfireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Campfires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerCampfireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Clock) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerClockUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Clocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerClockUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Door) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerDoorUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Doors in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerDoorUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.DryingRack) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerDryingRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use DryingRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerDryingRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Fire) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerFireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Fires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerFireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Furnace) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerFurnaceUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Furnaces in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerFurnaceUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grill) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrillUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grills in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrillUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grinder) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrinderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grinders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrinderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grindstone) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrindstoneUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grindstones in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrindstoneUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Ladder) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerLadderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ladders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerLadderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Lamp) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerLampUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Lamps in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerLampUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.MusicPlayer) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerMusicPlayerUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use MusicPlayers in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerMusicPlayerUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Oven) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerOvenUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ovens in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerOvenUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.PaperPress) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPaperPressUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use PaperPress's in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPaperPressUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Piano) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPianoUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Pianos in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPianoUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Poster) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPosterUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Posters in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPosterUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Scaffolding) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerScaffoldingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Scaffoldings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerScaffoldingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Seating) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSeatingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Seatings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSeatingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.ShootingTarget) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerShootingTargetUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use ShootingTargets in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerShootingTargetUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Sign) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSignUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Signs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSignUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.SpinningWheel) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSpinningWheelUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use SpinningWheels in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSpinningWheelUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Storage) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerStorageUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Storages in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerStorageUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.TanningRack) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTanningRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use TanningRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTanningRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Technical) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTechnicalUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Technicals in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTechnicalUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Torch) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTorchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Torchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTorchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Trashcan) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTrashcanUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Trashcans in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTrashcanUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Workbench) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerWorkbenchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Workbenchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerWorkbenchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 4");
            }
        }
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Objects.Type.Bed) {
                if (Boolean.FALSE.equals(player.getAttribute("BedUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Beds in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("BedUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Campfire) {
                if (Boolean.FALSE.equals(player.getAttribute("CampfireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Campfires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("CampfireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Clock) {
                if (Boolean.FALSE.equals(player.getAttribute("ClockUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Clocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ClockUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Door) {
                if (Boolean.FALSE.equals(player.getAttribute("DoorUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Doors in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("DoorUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.DryingRack) {
                if (Boolean.FALSE.equals(player.getAttribute("DryingRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use DryingRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("DryingRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Fire) {
                if (Boolean.FALSE.equals(player.getAttribute("FireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Fires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("FireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Furnace) {
                if (Boolean.FALSE.equals(player.getAttribute("FurnaceUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Furnaces in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("FurnaceUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grill) {
                if (Boolean.FALSE.equals(player.getAttribute("GrillUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grills in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrillUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grinder) {
                if (Boolean.FALSE.equals(player.getAttribute("GrinderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grinders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrinderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grindstone) {
                if (Boolean.FALSE.equals(player.getAttribute("GrindstoneUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grindstones in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("GrindstoneUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Ladder) {
                if (Boolean.FALSE.equals(player.getAttribute("LadderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ladders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("LadderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Lamp) {
                if (Boolean.FALSE.equals(player.getAttribute("LampUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Lamps in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("LampUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.MusicPlayer) {
                if (Boolean.FALSE.equals(player.getAttribute("MusicPlayerUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use MusicPlayers in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("MusicPlayerUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Oven) {
                if (Boolean.FALSE.equals(player.getAttribute("OvenUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ovens in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("OvenUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.PaperPress) {
                if (Boolean.FALSE.equals(player.getAttribute("PaperPressUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use PaperPress's in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PaperPressUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Piano) {
                if (Boolean.FALSE.equals(player.getAttribute("PianoUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Pianos in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PianoUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Poster) {
                if (Boolean.FALSE.equals(player.getAttribute("PosterUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Posters in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PosterUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Scaffolding) {
                if (Boolean.FALSE.equals(player.getAttribute("ScaffoldingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Scaffoldings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ScaffoldingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Seating) {
                if (Boolean.FALSE.equals(player.getAttribute("SeatingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Seatings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SeatingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.ShootingTarget) {
                if (Boolean.FALSE.equals(player.getAttribute("ShootingTargetUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use ShootingTargets in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("ShootingTargetUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Sign) {
                if (Boolean.FALSE.equals(player.getAttribute("SignUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Signs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SignUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.SpinningWheel) {
                if (Boolean.FALSE.equals(player.getAttribute("SpinningWheelUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use SpinningWheels in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("SpinningWheelUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Storage) {
                if (Boolean.FALSE.equals(player.getAttribute("StorageUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Storages in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("StorageUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.TanningRack) {
                if (Boolean.FALSE.equals(player.getAttribute("TanningRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use TanningRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TanningRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Technical) {
                if (Boolean.FALSE.equals(player.getAttribute("TechnicalUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Technicals in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TechnicalUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Torch) {
                if (Boolean.FALSE.equals(player.getAttribute("TorchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Torchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TorchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Trashcan) {
                if (Boolean.FALSE.equals(player.getAttribute("TrashcanUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Trashcans in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TrashcanUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Workbench) {
                if (Boolean.FALSE.equals(player.getAttribute("WorkbenchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Workbenchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("WorkbenchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Objects.Type.Bed) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerBedUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Beds in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerBedUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Campfire) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerCampfireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Campfires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerCampfireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Clock) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerClockUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Clocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerClockUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Door) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerDoorUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Doors in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerDoorUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.DryingRack) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerDryingRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use DryingRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerDryingRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Fire) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerFireUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Fires in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerFireUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Furnace) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerFurnaceUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Furnaces in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerFurnaceUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grill) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrillUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grills in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrillUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grinder) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrinderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grinders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrinderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Grindstone) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerGrindstoneUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Grindstones in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerGrindstoneUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Ladder) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerLadderUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ladders in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerLadderUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Lamp) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerLampUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Lamps in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerLampUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.MusicPlayer) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerMusicPlayerUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use MusicPlayers in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerMusicPlayerUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Oven) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerOvenUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Ovens in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerOvenUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.PaperPress) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPaperPressUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use PaperPress's in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPaperPressUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Piano) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPianoUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Pianos in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPianoUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Poster) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPosterUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Posters in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPosterUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Scaffolding) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerScaffoldingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Scaffoldings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerScaffoldingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Seating) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSeatingUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Seatings in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSeatingUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.ShootingTarget) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerShootingTargetUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use ShootingTargets in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerShootingTargetUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Sign) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSignUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Signs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSignUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.SpinningWheel) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerSpinningWheelUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use SpinningWheels in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerSpinningWheelUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Storage) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerStorageUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Storages in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerStorageUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.TanningRack) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTanningRackUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use TanningRacks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTanningRackUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Technical) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTechnicalUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Technicals in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTechnicalUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Torch) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTorchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Torchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTorchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Trashcan) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTrashcanUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Trashcans in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTrashcanUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Objects.Type.Workbench) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerWorkbenchUseObject"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot use Workbenchs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerWorkbenchUseObject"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 14");
            }
        }
    }

    @EventMethod
    public void onPlayerEditConstructionEvent(PlayerEditConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 15");
            }
        }
    }

    @EventMethod
    public void onPlayerHitConstructionEvent(PlayerHitConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (Boolean.TRUE.equals(player.getAttribute("ConstructionElementInfo"))) {
            long GlobalID = event.getGlobalID();
            int PositionX = event.getChunkPositionX();
            int PositionY = event.getChunkPositionY();
            int PositionZ = event.getChunkPositionZ();
            ConstructionElement ConstructionE = World.getConstructionElement(GlobalID, PositionX, PositionY, PositionZ);
            int PlayerDbID = ConstructionE.getPlayerDbID();
            TimeZone zone = TimeZone.getDefault();
            zone.toZoneId();
            long CreationDate = ConstructionE.getCreationDate();
            Instant instant = Instant.ofEpochSecond(CreationDate);
            ZonedDateTime DateTimeInfo = instant.atZone(zone.toZoneId());
            WorldDatabase db = this.getWorldDatabase(WorldDatabase.Target.Players);
            try (ResultSet result = db.executeQuery("SELECT * FROM `player` WHERE `id` = '" + PlayerDbID + "'");){
                if (result.next()) {
                    String uid = result.getString("uid");
                    int health = result.getInt("health");
                    int hunger = result.getInt("hunger");
                    String name = result.getString("name");
                    String playtime = result.getString("playtime");
                    Vector3f position = new Vector3f();
                    position.x = result.getFloat("posx");
                    position.y = result.getFloat("posy");
                    position.z = result.getFloat("posz");
                    player.sendTextMessage("Creation Date=" + String.valueOf(DateTimeInfo) + " Player DBID+" + PlayerDbID + " Name=" + name + " Uid=" + uid + " Playtime=" + playtime);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 16");
            }
        }
    }

    @EventMethod
    public void onPlayerHitObjectEvent(PlayerHitObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 17");
            }
        }
    }

    @EventMethod
    public void onPlayerHitTerrainEvent(PlayerHitTerrainEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (Boolean.FALSE.equals(player.getAttribute("HitTerrain"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot Hit Terrain in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("HitTerrain"))) {
                event.setCancelled(false);
                return;
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("PlayerHitTerrain"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot Hit Terrain in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("PlayerHitTerrain"))) {
                event.setCancelled(false);
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 18");
            }
        }
    }

    @EventMethod
    public void onPlayerHitVegetationEvent(PlayerHitVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Plants.PlantDefinition def = event.getPlantDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("TreeHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TreeHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("TrunkHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TrunkHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("RockHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("RockHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTreeHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTreeHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTrunkHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTrunkHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerRockHitVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Hit Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerRockHitVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 19");
            }
        }
    }

    @EventMethod
    public void onPlayerHitWaterEvent(PlayerHitWaterEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 20");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceConstructionEvent(PlayerPlaceConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 23");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceGrassEvent(PlayerPlaceGrassEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 24");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceObjectEvent(PlayerPlaceObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 25");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceTerrainEvent(PlayerPlaceTerrainEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 26");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceVegetationEvent(PlayerPlaceVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 27");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceWaterEvent(PlayerPlaceWaterEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 28");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveConstructionEvent(PlayerRemoveConstructionEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 29");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveGrassEvent(PlayerRemoveGrassEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 30");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveObjectEvent(PlayerRemoveObjectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Objects.ObjectDefinition def = event.getObjectDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea")) && def.type == Objects.Type.Bed) {
            event.setCancelled(false);
            return;
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 31");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveVegetationEvent(PlayerRemoveVegetationEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        Plants.PlantDefinition def = event.getPlantDefinition();
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (def.type == Plants.Type.Crop) {
                if (Boolean.FALSE.equals(player.getAttribute("CropRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Crops in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("CropRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.FruitTree) {
                if (Boolean.FALSE.equals(player.getAttribute("FruitTreeRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Fruit Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("FruitTreeRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Plant) {
                if (Boolean.FALSE.equals(player.getAttribute("PlantRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Plants in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlantRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("TreeRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TreeRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("TrunkRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("TrunkRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("RockRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("RockRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (def.type == Plants.Type.Crop) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerCropRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Crops in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerCropRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.FruitTree) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerFruitTreeRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Fruit Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerFruitTreeRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Plant) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerPlantRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Plants in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerPlantRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Tree) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTreeRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Trees in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTreeRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Trunk) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerTrunkRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Old Logs in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerTrunkRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (def.type == Plants.Type.Rock) {
                if (Boolean.FALSE.equals(player.getAttribute("PlayerRockRemoveVegetation"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("You Cannot Remove Rocks in this Area");
                    return;
                }
                if (Boolean.TRUE.equals(player.getAttribute("PlayerRockRemoveVegetation"))) {
                    event.setCancelled(false);
                    return;
                }
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 32");
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveWaterEvent(PlayerRemoveWaterEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 33");
            }
        }
    }

    @EventMethod
    public void onPlayerHitItemEvent(PlayerHitItemEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        WorldItem getItem = event.getItem();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 36");
            }
        }
    }

    @EventMethod
    public void onPlayerHitPlayerEvent(PlayerHitPlayerEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
                if (Boolean.FALSE.equals(player.getAttribute("PVPStatus"))) {
                    event.setCancelled(false);
                } else if (Boolean.TRUE.equals(player.getAttribute("PVPStatus"))) {
                    event.setCancelled(true);
                    player.sendTextMessage("PVP is turned off");
                }
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 38");
            }
        }
    }

    @EventMethod
    public void onPlayerCreateBlueprintEvent(PlayerCreateBlueprintEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 39");
            }
        }
    }

    @EventMethod
    public void onPlayerPlaceBlueprintEvent(PlayerPlaceBlueprintEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        if (player.isAdmin()) {
            this.database.executeUpdate("INSERT INTO `BluePrintCreater` (PlayerUID, UserName, BlueprintID, PlacedID, PlacedPosition, PlacedBounds) VALUES ('" + PlayerUID + "','" + player.getName() + "','" + event.getBlueprintID() + "','" + event.getPlaceID() + "','" + String.valueOf(event.getPosition()) + "','" + String.valueOf(event.getBounds()) + "');");
            player.sendTextMessage("Blueprint Data Has been logged UID=" + PlayerUID + " Name=" + player.getName() + " BlueprintID=" + event.getBlueprintID() + " Location=" + String.valueOf(event.getPosition()));
            event.setCancelled(false);
            return;
        }
        if (Boolean.TRUE.equals(player.getAttribute("OutSideArea"))) {
            if (Boolean.FALSE.equals(player.getAttribute("PlaceBluePrints"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot place Blue Prints in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("PlaceBluePrints"))) {
                event.setCancelled(false);
                return;
            }
        }
        if (!Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
            if (Boolean.TRUE.equals(player.getAttribute("AdminRights")) && player.isAdmin()) {
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaFriendUID"))) {
                BluePrintPlace BluePrintPlace2 = new BluePrintPlace(this);
                BluePrintPlace2.BluePrintPlace(event);
                return;
            }
            if (PlayerUID.equals(player.getAttribute("AreaOwnerUID"))) {
                BluePrintPlace BluePrintPlace3 = new BluePrintPlace(this);
                BluePrintPlace3.BluePrintPlace(event);
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("PlayerPlaceBluePrints"))) {
                event.setCancelled(true);
                player.sendTextMessage("You Cannot place Blue Prints in this Area");
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("PlayerPlaceBluePrints"))) {
                BluePrintPlace BluePrintPlace4 = new BluePrintPlace(this);
                BluePrintPlace4.BluePrintPlace(event);
                return;
            }
            if (Boolean.FALSE.equals(player.getAttribute("isAreaLocked"))) {
                return;
            }
            if (Boolean.TRUE.equals(player.getAttribute("isAreaLocked"))) {
                player.sendTextMessage("You Cannot Do That Here");
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                player.sendTextMessage("you need to own a plot to do that!!!, use the b key to claim a area 22");
            }
        }
    }

    @EventMethod
    public void onPlayerGameObjectHitEvent(PlayerGameObjectHitEvent event) {
        Player player = event.getPlayer();
    }

    /*
     * Opcode count of 20102 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - void declaration
     */
    @EventMethod
    public void onPlayerUIEClick(PlayerUIElementClickEvent event) throws SQLException {
        void AreaBackButtonID;
        void AreaNextButtonID;
        void AreaTpButtonID;
        void AreaTextField;
        void AreaExitButtonID;
        void BluePrintBackButtonID;
        void BluePrintNextButtonID;
        void BluePrintTpButtonID;
        void BluePrintTextField;
        void BluePrintExitButtonID;
        void FoxButtons2;
        void UnlockAreaID;
        void LockAreaID;
        void DeleteAllAreasID;
        void PlayerRockRemoveVegetationOFFID;
        void PlayerRockRemoveVegetationONID;
        void PlayerRockHitVegetationOFFID;
        void PlayerRockHitVegetationONID;
        void PlayerRockDestroyVegetationOFFID;
        void PlayerRockDestroyVegetationONID;
        void PlayerPlantRemoveVegetationOFFID;
        void PlayerPlantRemoveVegetationONID;
        void PlayerFruitTreeRemoveVegetationOFFID;
        void PlayerFruitTreeRemoveVegetationONID;
        void PlayerCropRemoveVegetationOFFID;
        void PlayerCropRemoveVegetationONID;
        void PlayerTrunkRemoveVegetationOFFID;
        void PlayerTrunkRemoveVegetationONID;
        void PlayerTreeRemoveVegetationOFFID;
        void PlayerTreeRemoveVegetationONID;
        void PlayerTrunkHitVegetationOFFID;
        void PlayerTrunkHitVegetationONID;
        void PlayerTreeHitVegetationOFFID;
        void PlayerTreeHitVegetationONID;
        void PlayerTrunkDestroyVegetationOFFID;
        void PlayerTrunkDestroyVegetationONID;
        void PlayerTreeDestroyVegetationOFFID;
        void PlayerTreeDestroyVegetationONID;
        void PlayerNpcRemoveClothesOFFID;
        void PlayerNpcRemoveClothesONID;
        void PlayerNpcAddClothesOFFID;
        void PlayerNpcAddClothesONID;
        void PlayerNpcRemoveSaddleBagOFFID;
        void PlayerNpcRemoveSaddleBagONID;
        void PlayerNpcAddSaddleBagOFFID;
        void PlayerNpcAddSaddleBagONID;
        void PlayerNpcRemoveSaddleOFFID;
        void PlayerNpcRemoveSaddleONID;
        void PlayerNpcAddSaddleOFFID;
        void PlayerNpcAddSaddleONID;
        void PlayerPlaceBluePrintsOFFID;
        void PlayerPlaceBluePrintsONID;
        void PlayerRideMountNPCOFFID;
        void PlayerRideMountNPCONID;
        void PlayerHitMountNPCOFFID;
        void PlayerHitMountNPCONID;
        void PlayerHitHumanNPCOFFID;
        void PlayerHitHumanNPCONID;
        void PlayerHitAnimalNPCOFFID;
        void PlayerHitAnimalNPCONID;
        void PlayerWorkbenchUseObjectOFFID;
        void PlayerWorkbenchUseObjectONID;
        void PlayerTrashcanUseObjectOFFID;
        void PlayerTrashcanUseObjectONID;
        void PlayerTorchUseObjectOFFID;
        void PlayerTorchUseObjectONID;
        void PlayerTechnicalUseObjectOFFID;
        void PlayerTechnicalUseObjectONID;
        void PlayerTanningRackUseObjectOFFID;
        void PlayerTanningRackUseObjectONID;
        void PlayerStorageUseObjectOFFID;
        void PlayerStorageUseObjectONID;
        void PlayerSpinningWheelUseObjectOFFID;
        void PlayerSpinningWheelUseObjectONID;
        void PlayerSignUseObjectOFFID;
        void PlayerSignUseObjectONID;
        void PlayerShootingTargetUseObjectOFFID;
        void PlayerShootingTargetUseObjectONID;
        void PlayerSeatingUseObjectOFFID;
        void PlayerSeatingUseObjectONID;
        void PlayerScaffoldingUseObjectOFFID;
        void PlayerScaffoldingUseObjectONID;
        void PlayerPosterUseObjectOFFID;
        void PlayerPosterUseObjectONID;
        void PlayerPianoUseObjectOFFID;
        void PlayerPianoUseObjectONID;
        void PlayerPaperPressUseObjectOFFID;
        void PlayerPaperPressUseObjectONID;
        void PlayerOvenUseObjectOFFID;
        void PlayerOvenUseObjectONID;
        void PlayerMusicPlayerUseObjectOFFID;
        void PlayerMusicPlayerUseObjectONID;
        void PlayerLampUseObjectOFFID;
        void PlayerLampUseObjectONID;
        void PlayerLadderUseObjectOFFID;
        void PlayerLadderUseObjectONID;
        void PlayerGrindstoneUseObjectOFFID;
        void PlayerGrindstoneUseObjectONID;
        void PlayerGrinderUseObjectOFFID;
        void PlayerGrinderUseObjectONID;
        void PlayerGrillUseObjectOFFID;
        void PlayerGrillUseObjectONID;
        void PlayerFurnaceUseObjectOFFID;
        void PlayerFurnaceUseObjectONID;
        void PlayerFireUseObjectOFFID;
        void PlayerFireUseObjectONID;
        void PlayerDryingRackUseObjectOFFID;
        void PlayerDryingRackUseObjectONID;
        void PlayerDoorUseObjectOFFID;
        void PlayerDoorUseObjectONID;
        void PlayerClockUseObjectOFFID;
        void PlayerClockUseObjectONID;
        void PlayerCampfireUseObjectOFFID;
        void PlayerCampfireUseObjectONID;
        void PlayerBedUseObjectOFFID;
        void PlayerBedUseObjectONID;
        void PlayerHitTerrainOFFID;
        void PlayerHitTerrainONID;
        void PlayerDestroyTerrainOFFID;
        void PlayerDestroyTerrainONID;
        void NpcRemoveClothesOFFID;
        void NpcRemoveClothesONID;
        void NpcAddClothesOFFID;
        void NpcAddClothesONID;
        void NpcRemoveSaddleBagOFFID;
        void NpcRemoveSaddleBagONID;
        void NpcAddSaddleBagOFFID;
        void NpcAddSaddleBagONID;
        void NpcRemoveSaddleOFFID;
        void NpcRemoveSaddleONID;
        void NpcAddSaddleOFFID;
        void NpcAddSaddleONID;
        void PlaceBluePrintsOFFID;
        void PlaceBluePrintsONID;
        void RideMountNPCOFFID;
        void RideMountNPCONID;
        void HitMountNPCOFFID;
        void HitMountNPCONID;
        void HitHumanNPCOFFID;
        void HitHumanNPCONID;
        void HitAnimalNPCOFFID;
        void HitAnimalNPCONID;
        void WorkbenchUseObjectOFFID;
        void WorkbenchUseObjectONID;
        void TrashcanUseObjectOFFID;
        void TrashcanUseObjectONID;
        void TorchUseObjectOFFID;
        void TorchUseObjectONID;
        void TechnicalUseObjectOFFID;
        void TechnicalUseObjectONID;
        void TanningRackUseObjectOFFID;
        void TanningRackUseObjectONID;
        void StorageUseObjectOFFID;
        void StorageUseObjectONID;
        void SpinningWheelUseObjectOFFID;
        void SpinningWheelUseObjectONID;
        void SignUseObjectOFFID;
        void SignUseObjectONID;
        void ShootingTargetUseObjectOFFID;
        void ShootingTargetUseObjectONID;
        void SeatingUseObjectOFFID;
        void SeatingUseObjectONID;
        void ScaffoldingUseObjectOFFID;
        void ScaffoldingUseObjectONID;
        void PosterUseObjectOFFID;
        void PosterUseObjectONID;
        void PianoUseObjectOFFID;
        void PianoUseObjectONID;
        void PaperPressUseObjectOFFID;
        void PaperPressUseObjectONID;
        void OvenUseObjectOFFID;
        void OvenUseObjectONID;
        void MusicPlayerUseObjectOFFID;
        void MusicPlayerUseObjectONID;
        void LampUseObjectOFFID;
        void LampUseObjectONID;
        void LadderUseObjectOFFID;
        void LadderUseObjectONID;
        void GrindstoneUseObjectOFFID;
        void AreaCostAdjustDownID;
        void AreaCostAdjustUPID;
        void PointsEarnedAdjustDownID;
        void PointsEarnedAdjustUPID;
        void Areastatus;
        Object ex6;
        String DataUpdate2;
        String Date2;
        int Points;
        int CountPlots;
        int CountPlots2;
        Object ex22;
        void Result2;
        if (event.getUIElement() == null) {
            return;
        }
        Player player = event.getPlayer();
        WorldDatabase db = this.getWorldDatabase(WorldDatabase.Target.Players);
        String PlayerName = player.getName();
        String PlayerUID = player.getUID();
        Vector3i ChunkPosition = player.getChunkPosition();
        player.setAttribute("PlayersChunkPositionX", ChunkPosition.x);
        player.setAttribute("PlayersChunkPositionY", ChunkPosition.y);
        player.setAttribute("PlayersChunkPositionZ", ChunkPosition.z);
        UILabel AreaName = (UILabel)player.getAttribute("AreaName");
        UILabel PlotInfo = (UILabel)player.getAttribute("PlotInfo");
        UILabel ViewWPArea = (UILabel)player.getAttribute("ViewWPArea");
        UILabel HideWPArea = (UILabel)player.getAttribute("HideWPArea");
        UILabel PointsInfo = (UILabel)player.getAttribute("PointsInfo");
        UILabel PlayerPVPStatus = (UILabel)player.getAttribute("PlayerPVPStatus");
        UIElement AdminToolsWPPanel = (UIElement)player.getAttribute("AdminToolsWPPanel");
        UIElement AdminToolsWPPanelPage2 = (UIElement)player.getAttribute("AdminToolsWPPanelPage2");
        UIElement AdminToolsWPPanelPage3 = (UIElement)player.getAttribute("AdminToolsWPPanelPage3");
        UIElement PlayerToolsWPPanel = (UIElement)player.getAttribute("PlayerToolsWPPanel");
        UIElement PlayerToolsWPPanelPage2 = (UIElement)player.getAttribute("PlayerToolsWPPanelPage2");
        UIElement PlayerToolsWPPanelPage3 = (UIElement)player.getAttribute("PlayerToolsWPPanelPage3");
        UIElement SettingsWPPanel = (UIElement)player.getAttribute("SettingsWPPanel");
        UILabel AreaAmount = (UILabel)player.getAttribute("AreaAmount");
        UILabel PointsEarnedAdjustInfo = (UILabel)player.getAttribute("PointsEarnedAdjustInfo");
        UILabel AreaCostAdjustInfo = (UILabel)player.getAttribute("AreaCostAdjustInfo");
        UIElement AreaConfirmationPanel2 = (UIElement)player.getAttribute("AreaConfirmationPanel");
        UIElement HorsePanel2 = (UIElement)player.getAttribute("HorsePanel");
        UIElement cfr_ignored_0 = (UIElement)player.getAttribute("OpenFoxPanel");
        UILabel DestroyTerrainINFO = (UILabel)player.getAttribute("DestroyTerrainINFO");
        UILabel HitTerrainINFO = (UILabel)player.getAttribute("HitTerrainINFO");
        UILabel BedUseObjectINFO = (UILabel)player.getAttribute("BedUseObjectINFO");
        UILabel CampfireUseObjectINFO = (UILabel)player.getAttribute("CampfireUseObjectINFO");
        UILabel TreeDestroyVegetationINFO = (UILabel)player.getAttribute("TreeDestroyVegetationINFO");
        UILabel TrunkDestroyVegetationINFO = (UILabel)player.getAttribute("TrunkDestroyVegetationINFO");
        UILabel TreeHitVegetationINFO = (UILabel)player.getAttribute("TreeHitVegetationINFO");
        UILabel TrunkHitVegetationINFO = (UILabel)player.getAttribute("TrunkHitVegetationINFO");
        UILabel TreeRemoveVegetationINFO = (UILabel)player.getAttribute("TreeRemoveVegetationINFO");
        UILabel TrunkRemoveVegetationINFO = (UILabel)player.getAttribute("TrunkRemoveVegetationINFO");
        UILabel CropRemoveVegetationINFO = (UILabel)player.getAttribute("CropRemoveVegetationINFO");
        UILabel FruitTreeRemoveVegetationINFO = (UILabel)player.getAttribute("FruitTreeRemoveVegetationINFO");
        UILabel PlantRemoveVegetationINFO = (UILabel)player.getAttribute("PlantRemoveVegetationINFO");
        UILabel RockDestroyVegetationINFO = (UILabel)player.getAttribute("RockDestroyVegetationINFO");
        UILabel RockHitVegetationINFO = (UILabel)player.getAttribute("RockHitVegetationINFO");
        UILabel RockRemoveVegetationINFO = (UILabel)player.getAttribute("RockRemoveVegetationINFO");
        UILabel AdminRightsINFO = (UILabel)player.getAttribute("AdminRightsINFO");
        UILabel ClockUseObjectINFO = (UILabel)player.getAttribute("ClockUseObjectINFO");
        UILabel DoorUseObjectINFO = (UILabel)player.getAttribute("DoorUseObjectINFO");
        UILabel DryingRackUseObjectINFO = (UILabel)player.getAttribute("DryingRackUseObjectINFO");
        UILabel FireUseObjectINFO = (UILabel)player.getAttribute("FireUseObjectINFO");
        UILabel FurnaceUseObjectINFO = (UILabel)player.getAttribute("FurnaceUseObjectINFO");
        UILabel GrillUseObjectINFO = (UILabel)player.getAttribute("GrillUseObjectINFO");
        UILabel GrinderUseObjectINFO = (UILabel)player.getAttribute("GrinderUseObjectINFO");
        UILabel GrindstoneUseObjectINFO = (UILabel)player.getAttribute("GrindstoneUseObjectINFO");
        UILabel LadderUseObjectINFO = (UILabel)player.getAttribute("LadderUseObjectINFO");
        UILabel LampUseObjectINFO = (UILabel)player.getAttribute("LampUseObjectINFO");
        UILabel MusicPlayerUseObjectINFO = (UILabel)player.getAttribute("MusicPlayerUseObjectINFO");
        UILabel OvenUseObjectINFO = (UILabel)player.getAttribute("OvenUseObjectINFO");
        UILabel PaperPressUseObjectINFO = (UILabel)player.getAttribute("PaperPressUseObjectINFO");
        UILabel PianoUseObjectINFO = (UILabel)player.getAttribute("PianoUseObjectINFO");
        UILabel PosterUseObjectINFO = (UILabel)player.getAttribute("PosterUseObjectINFO");
        UILabel ScaffoldingUseObjectINFO = (UILabel)player.getAttribute("ScaffoldingUseObjectINFO");
        UILabel SeatingUseObjectINFO = (UILabel)player.getAttribute("SeatingUseObjectINFO");
        UILabel ShootingTargetUseObjectINFO = (UILabel)player.getAttribute("ShootingTargetUseObjectINFO");
        UILabel SignUseObjectINFO = (UILabel)player.getAttribute("SignUseObjectINFO");
        UILabel SpinningWheelUseObjectINFO = (UILabel)player.getAttribute("SpinningWheelUseObjectINFO");
        UILabel StorageUseObjectINFO = (UILabel)player.getAttribute("StorageUseObjectINFO");
        UILabel TanningRackUseObjectINFO = (UILabel)player.getAttribute("TanningRackUseObjectINFO");
        UILabel TechnicalUseObjectINFO = (UILabel)player.getAttribute("TechnicalUseObjectINFO");
        UILabel TorchUseObjectINFO = (UILabel)player.getAttribute("TorchUseObjectINFO");
        UILabel TrashcanUseObjectINFO = (UILabel)player.getAttribute("TrashcanUseObjectINFO");
        UILabel WorkbenchUseObjectINFO = (UILabel)player.getAttribute("WorkbenchUseObjectINFO");
        UILabel HitAnimalNPCINFO = (UILabel)player.getAttribute("HitAnimalNPCINFO");
        UILabel HitHumanNPCINFO = (UILabel)player.getAttribute("HitHumanNPCINFO");
        UILabel HitMountNPCINFO = (UILabel)player.getAttribute("HitMountNPCINFO");
        UILabel RideMountNPCINFO = (UILabel)player.getAttribute("RideMountNPCINFO");
        UILabel PlaceBluePrintsINFO = (UILabel)player.getAttribute("PlaceBluePrintsINFO");
        UILabel NpcAddSaddleINFO = (UILabel)player.getAttribute("NpcAddSaddleINFO");
        UILabel NpcRemoveSaddleINFO = (UILabel)player.getAttribute("NpcRemoveSaddleINFO");
        UILabel NpcAddSaddleBagINFO = (UILabel)player.getAttribute("NpcAddSaddleBagINFO");
        UILabel NpcRemoveSaddleBagINFO = (UILabel)player.getAttribute("NpcRemoveSaddleBagINFO");
        UILabel NpcAddClothesINFO = (UILabel)player.getAttribute("NpcAddClothesINFO");
        UILabel NpcRemoveClothesINFO = (UILabel)player.getAttribute("NpcRemoveClothesINFO");
        UILabel cfr_ignored_1 = (UILabel)player.getAttribute("PlayerDoorObjectStatusINFO");
        UILabel PlayerDestroyTerrainINFO = (UILabel)player.getAttribute("PlayerDestroyTerrainINFO");
        UILabel PlayerHitTerrainINFO = (UILabel)player.getAttribute("PlayerHitTerrainINFO");
        UILabel PlayerBedUseObjectINFO = (UILabel)player.getAttribute("PlayerBedUseObjectINFO");
        UILabel PlayerCampfireUseObjectINFO = (UILabel)player.getAttribute("PlayerCampfireUseObjectINFO");
        UILabel cfr_ignored_2 = (UILabel)player.getAttribute("PlayerStorageObjectStatusINFO");
        UILabel PlayerTreeDestroyVegetationINFO = (UILabel)player.getAttribute("PlayerTreeDestroyVegetationINFO");
        UILabel PlayerTrunkDestroyVegetationINFO = (UILabel)player.getAttribute("PlayerTrunkDestroyVegetationINFO");
        UILabel PlayerTreeHitVegetationINFO = (UILabel)player.getAttribute("PlayerTreeHitVegetationINFO");
        UILabel PlayerTrunkHitVegetationINFO = (UILabel)player.getAttribute("PlayerTrunkHitVegetationINFO");
        UILabel PlayerTreeRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerTreeRemoveVegetationINFO");
        UILabel PlayerTrunkRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerTrunkRemoveVegetationINFO");
        UILabel PlayerCropRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerCropRemoveVegetationINFO");
        UILabel PlayerFruitTreeRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerFruitTreeRemoveVegetationINFO");
        UILabel PlayerPlantRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerPlantRemoveVegetationINFO");
        UILabel PlayerRockDestroyVegetationINFO = (UILabel)player.getAttribute("PlayerRockDestroyVegetationINFO");
        UILabel PlayerRockHitVegetationINFO = (UILabel)player.getAttribute("PlayerRockHitVegetationINFO");
        UILabel PlayerRockRemoveVegetationINFO = (UILabel)player.getAttribute("PlayerRockRemoveVegetationINFO");
        UILabel cfr_ignored_3 = (UILabel)player.getAttribute("PlayerAdminRightsINFO");
        UILabel PlayerClockUseObjectINFO = (UILabel)player.getAttribute("PlayerClockUseObjectINFO");
        UILabel PlayerDoorUseObjectINFO = (UILabel)player.getAttribute("PlayerDoorUseObjectINFO");
        UILabel PlayerDryingRackUseObjectINFO = (UILabel)player.getAttribute("PlayerDryingRackUseObjectINFO");
        UILabel PlayerFireUseObjectINFO = (UILabel)player.getAttribute("PlayerFireUseObjectINFO");
        UILabel PlayerFurnaceUseObjectINFO = (UILabel)player.getAttribute("PlayerFurnaceUseObjectINFO");
        UILabel PlayerGrillUseObjectINFO = (UILabel)player.getAttribute("PlayerGrillUseObjectINFO");
        UILabel PlayerGrinderUseObjectINFO = (UILabel)player.getAttribute("PlayerGrinderUseObjectINFO");
        UILabel PlayerGrindstoneUseObjectINFO = (UILabel)player.getAttribute("PlayerGrindstoneUseObjectINFO");
        UILabel PlayerLadderUseObjectINFO = (UILabel)player.getAttribute("PlayerLadderUseObjectINFO");
        UILabel PlayerLampUseObjectINFO = (UILabel)player.getAttribute("PlayerLampUseObjectINFO");
        UILabel PlayerMusicPlayerUseObjectINFO = (UILabel)player.getAttribute("PlayerMusicPlayerUseObjectINFO");
        UILabel PlayerOvenUseObjectINFO = (UILabel)player.getAttribute("PlayerOvenUseObjectINFO");
        UILabel PlayerPaperPressUseObjectINFO = (UILabel)player.getAttribute("PlayerPaperPressUseObjectINFO");
        UILabel PlayerPianoUseObjectINFO = (UILabel)player.getAttribute("PlayerPianoUseObjectINFO");
        UILabel PlayerPosterUseObjectINFO = (UILabel)player.getAttribute("PlayerPosterUseObjectINFO");
        UILabel PlayerScaffoldingUseObjectINFO = (UILabel)player.getAttribute("PlayerScaffoldingUseObjectINFO");
        UILabel PlayerSeatingUseObjectINFO = (UILabel)player.getAttribute("PlayerSeatingUseObjectINFO");
        UILabel PlayerShootingTargetUseObjectINFO = (UILabel)player.getAttribute("PlayerShootingTargetUseObjectINFO");
        UILabel PlayerSignUseObjectINFO = (UILabel)player.getAttribute("PlayerSignUseObjectINFO");
        UILabel PlayerSpinningWheelUseObjectINFO = (UILabel)player.getAttribute("PlayerSpinningWheelUseObjectINFO");
        UILabel PlayerStorageUseObjectINFO = (UILabel)player.getAttribute("PlayerStorageUseObjectINFO");
        UILabel PlayerTanningRackUseObjectINFO = (UILabel)player.getAttribute("PlayerTanningRackUseObjectINFO");
        UILabel PlayerTechnicalUseObjectINFO = (UILabel)player.getAttribute("PlayerTechnicalUseObjectINFO");
        UILabel PlayerTorchUseObjectINFO = (UILabel)player.getAttribute("PlayerTorchUseObjectINFO");
        UILabel PlayerTrashcanUseObjectINFO = (UILabel)player.getAttribute("PlayerTrashcanUseObjectINFO");
        UILabel PlayerWorkbenchUseObjectINFO = (UILabel)player.getAttribute("PlayerWorkbenchUseObjectINFO");
        UILabel PlayerHitAnimalNPCINFO = (UILabel)player.getAttribute("PlayerHitAnimalNPCINFO");
        UILabel PlayerHitHumanNPCINFO = (UILabel)player.getAttribute("PlayerHitHumanNPCINFO");
        UILabel PlayerHitMountNPCINFO = (UILabel)player.getAttribute("PlayerHitMountNPCINFO");
        UILabel PlayerRideMountNPCINFO = (UILabel)player.getAttribute("PlayerRideMountNPCINFO");
        UILabel PlayerPlaceBluePrintsINFO = (UILabel)player.getAttribute("PlayerPlaceBluePrintsINFO");
        UILabel PlayerNpcAddSaddleINFO = (UILabel)player.getAttribute("PlayerNpcAddSaddleINFO");
        UILabel PlayerNpcRemoveSaddleINFO = (UILabel)player.getAttribute("PlayerNpcRemoveSaddleINFO");
        UILabel PlayerNpcAddSaddleBagINFO = (UILabel)player.getAttribute("PlayerNpcAddSaddleBagINFO");
        UILabel PlayerNpcRemoveSaddleBagINFO = (UILabel)player.getAttribute("PlayerNpcRemoveSaddleBagINFO");
        UILabel PlayerNpcAddClothesINFO = (UILabel)player.getAttribute("PlayerNpcAddClothesINFO");
        UILabel PlayerNpcRemoveClothesINFO = (UILabel)player.getAttribute("PlayerNpcRemoveClothesINFO");
        UITextField FoxTextField = (UITextField)player.getAttribute("FoxTextField");
        FoxTextField.getID();
        UITextField HorseTextField = (UITextField)player.getAttribute("HorseTextField");
        HorseTextField.getID();
        UITextField WPNameTextField = (UITextField)player.getAttribute("WPNameTextField");
        WPNameTextField.getID();
        UITextField AddFriendToWPAreaTextField = (UITextField)player.getAttribute("AddFriendToWPAreaTextField");
        AddFriendToWPAreaTextField.getID();
        UITextField SendPointsAmount = (UITextField)player.getAttribute("SendPointsAmount");
        SendPointsAmount.getID();
        UITextField ATNameTextField = (UITextField)player.getAttribute("ATNameTextField");
        ATNameTextField.getID();
        int eventID = event.getUIElement().getID();
        player.setAttribute("eventID", eventID);
        int exitSettingsWPPanelID = (Integer)player.getAttribute("exitSettingsWPPanelID");
        int exitSettingsWPPanel1ID = (Integer)player.getAttribute("exitSettingsWPPanel1ID");
        int exitSettingsWPPanel2ID = (Integer)player.getAttribute("exitSettingsWPPanel2ID");
        int exitSettingsWPPanel3ID = (Integer)player.getAttribute("exitSettingsWPPanel3ID");
        ((Integer)player.getAttribute("exitSettingsWPPlayerPanelID")).intValue();
        int exitSettingsWPPlayerPanel1ID = (Integer)player.getAttribute("exitSettingsWPPlayerPanel1ID");
        int exitSettingsWPPlayerPanel2ID = (Integer)player.getAttribute("exitSettingsWPPlayerPanel2ID");
        int exitSettingsWPPlayerPanel3ID = (Integer)player.getAttribute("exitSettingsWPPlayerPanel3ID");
        ((Integer)player.getAttribute("AreaConfirmationPanelID")).intValue();
        int exitAreaConfirmationPanelbuttonID = (Integer)player.getAttribute("exitAreaConfirmationPanelbuttonID");
        int AddAreaConfirmationPanelbuttonID = (Integer)player.getAttribute("AddAreaConfirmationPanelbuttonID");
        int RemoveAreaConfirmationPanelbuttonID = (Integer)player.getAttribute("RemoveAreaConfirmationPanelbuttonID");
        int OpenPanelbuttonID = (Integer)player.getAttribute("OpenPanelbuttonID");
        int exitHorsePanelID = (Integer)player.getAttribute("exitHorsePanelID");
        int RemoveHorsebuttonID = (Integer)player.getAttribute("RemoveHorsebuttonID");
        int ReNamebuttonID = (Integer)player.getAttribute("ReNamebuttonID");
        int RoambuttonID = (Integer)player.getAttribute("RoambuttonID");
        int CallbuttonID = (Integer)player.getAttribute("CallbuttonID");
        int FollowMebuttonID = (Integer)player.getAttribute("FollowMebuttonID");
        int StopFollowingMebuttonID = (Integer)player.getAttribute("StopFollowingMebuttonID");
        ((Integer)player.getAttribute("exitFoxPanelID")).intValue();
        ((Integer)player.getAttribute("RemoveFoxbuttonID")).intValue();
        ((Integer)player.getAttribute("ReNameFoxbuttonID")).intValue();
        ((Integer)player.getAttribute("FoxRoambuttonID")).intValue();
        ((Integer)player.getAttribute("CallFoxbuttonID")).intValue();
        ((Integer)player.getAttribute("FoxFollowMebuttonID")).intValue();
        ((Integer)player.getAttribute("StopFoxFollowingMebuttonID")).intValue();
        int DeleteWPAreaID = (Integer)player.getAttribute("DeleteWPAreaID");
        int ReNameWPAreaID = (Integer)player.getAttribute("ReNameWPAreaID");
        int AddFriendToWPAreaID = (Integer)player.getAttribute("AddFriendToWPAreaID");
        int RemoveFriendFromWPAreaID = (Integer)player.getAttribute("RemoveFriendFromWPAreaID");
        int ViewWPAreaID = (Integer)player.getAttribute("ViewWPAreaID");
        int HideWPAreaID = (Integer)player.getAttribute("HideWPAreaID");
        int GivePointsID = (Integer)player.getAttribute("GivePointsID");
        int PlayerPVPOffID = (Integer)player.getAttribute("PlayerPVPOffID");
        int PlayerPVPOnID = (Integer)player.getAttribute("PlayerPVPOnID");
        int OpenAdminToolsID = (Integer)player.getAttribute("OpenAdminToolsID");
        int OpenPlayerToolsID = (Integer)player.getAttribute("OpenPlayerToolsID");
        int WPBackButtonID = (Integer)player.getAttribute("WPBackButtonID");
        int WPNextButtonID = (Integer)player.getAttribute("WPNextButtonID");
        int WPBackButtonPage2ID = (Integer)player.getAttribute("WPBackButtonPage2ID");
        int WPNextButtonPage2ID = (Integer)player.getAttribute("WPNextButtonPage2ID");
        int WPBackButtonPage3ID = (Integer)player.getAttribute("WPBackButtonPage3ID");
        ((Integer)player.getAttribute("WPNextButtonPage3ID")).intValue();
        int WPPlayerBackButtonID = (Integer)player.getAttribute("WPPlayerBackButtonID");
        int WPPlayerNextButtonID = (Integer)player.getAttribute("WPPlayerNextButtonID");
        int WPPlayerBackButtonPage2ID = (Integer)player.getAttribute("WPPlayerBackButtonPage2ID");
        int WPPlayerNextButtonPage2ID = (Integer)player.getAttribute("WPPlayerNextButtonPage2ID");
        int WPPlayerBackButtonPage3ID = (Integer)player.getAttribute("WPPlayerBackButtonPage3ID");
        ((Integer)player.getAttribute("WPPlayerNextButtonPage3ID")).intValue();
        int NextPlayerButtonID = (Integer)player.getAttribute("NextPlayerButtonID");
        int WPNextPlayerButtonID = (Integer)player.getAttribute("WPNextPlayerButtonID");
        ((Integer)player.getAttribute("DoorObjectStatusONID")).intValue();
        ((Integer)player.getAttribute("DoorObjectStatusOFFID")).intValue();
        int DestroyTerrainONID = (Integer)player.getAttribute("DestroyTerrainONID");
        int DestroyTerrainOFFID = (Integer)player.getAttribute("DestroyTerrainOFFID");
        int HitTerrainONID = (Integer)player.getAttribute("HitTerrainONID");
        int HitTerrainOFFID = (Integer)player.getAttribute("HitTerrainOFFID");
        int BedUseObjectONID = (Integer)player.getAttribute("BedUseObjectONID");
        int BedUseObjectOFFID = (Integer)player.getAttribute("BedUseObjectOFFID");
        int CampfireUseObjectONID = (Integer)player.getAttribute("CampfireUseObjectONID");
        int CampfireUseObjectOFFID = (Integer)player.getAttribute("CampfireUseObjectOFFID");
        ((Integer)player.getAttribute("StorageObjectStatusONID")).intValue();
        ((Integer)player.getAttribute("StorageObjectStatusOFFID")).intValue();
        int TreeDestroyVegetationONID = (Integer)player.getAttribute("TreeDestroyVegetationONID");
        int TreeDestroyVegetationOFFID = (Integer)player.getAttribute("TreeDestroyVegetationOFFID");
        int TrunkDestroyVegetationONID = (Integer)player.getAttribute("TrunkDestroyVegetationONID");
        int TrunkDestroyVegetationOFFID = (Integer)player.getAttribute("TrunkDestroyVegetationOFFID");
        int TreeHitVegetationONID = (Integer)player.getAttribute("TreeHitVegetationONID");
        int TreeHitVegetationOFFID = (Integer)player.getAttribute("TreeHitVegetationOFFID");
        int TrunkHitVegetationONID = (Integer)player.getAttribute("TrunkHitVegetationONID");
        int TrunkHitVegetationOFFID = (Integer)player.getAttribute("TrunkHitVegetationOFFID");
        int TreeRemoveVegetationONID = (Integer)player.getAttribute("TreeRemoveVegetationONID");
        int TreeRemoveVegetationOFFID = (Integer)player.getAttribute("TreeRemoveVegetationOFFID");
        int TrunkRemoveVegetationONID = (Integer)player.getAttribute("TrunkRemoveVegetationONID");
        int TrunkRemoveVegetationOFFID = (Integer)player.getAttribute("TrunkRemoveVegetationOFFID");
        int CropRemoveVegetationONID = (Integer)player.getAttribute("CropRemoveVegetationONID");
        int CropRemoveVegetationOFFID = (Integer)player.getAttribute("CropRemoveVegetationOFFID");
        int FruitTreeRemoveVegetationONID = (Integer)player.getAttribute("FruitTreeRemoveVegetationONID");
        int FruitTreeRemoveVegetationOFFID = (Integer)player.getAttribute("FruitTreeRemoveVegetationOFFID");
        int PlantRemoveVegetationONID = (Integer)player.getAttribute("PlantRemoveVegetationONID");
        int PlantRemoveVegetationOFFID = (Integer)player.getAttribute("PlantRemoveVegetationOFFID");
        int RockDestroyVegetationONID = (Integer)player.getAttribute("RockDestroyVegetationONID");
        int RockDestroyVegetationOFFID = (Integer)player.getAttribute("RockDestroyVegetationOFFID");
        int RockHitVegetationONID = (Integer)player.getAttribute("RockHitVegetationONID");
        int RockHitVegetationOFFID = (Integer)player.getAttribute("RockHitVegetationOFFID");
        int RockRemoveVegetationONID = (Integer)player.getAttribute("RockRemoveVegetationONID");
        int RockRemoveVegetationOFFID = (Integer)player.getAttribute("RockRemoveVegetationOFFID");
        int AdminRightsONID = (Integer)player.getAttribute("AdminRightsONID");
        int AdminRightsOFFID = (Integer)player.getAttribute("AdminRightsOFFID");
        int ClockUseObjectONID = (Integer)player.getAttribute("ClockUseObjectONID");
        int ClockUseObjectOFFID = (Integer)player.getAttribute("ClockUseObjectOFFID");
        int DoorUseObjectONID = (Integer)player.getAttribute("DoorUseObjectONID");
        int DoorUseObjectOFFID = (Integer)player.getAttribute("DoorUseObjectOFFID");
        int DryingRackUseObjectONID = (Integer)player.getAttribute("DryingRackUseObjectONID");
        int DryingRackUseObjectOFFID = (Integer)player.getAttribute("DryingRackUseObjectOFFID");
        int FireUseObjectONID = (Integer)player.getAttribute("FireUseObjectONID");
        int FireUseObjectOFFID = (Integer)player.getAttribute("FireUseObjectOFFID");
        int FurnaceUseObjectONID = (Integer)player.getAttribute("FurnaceUseObjectONID");
        int FurnaceUseObjectOFFID = (Integer)player.getAttribute("FurnaceUseObjectOFFID");
        int GrillUseObjectONID = (Integer)player.getAttribute("GrillUseObjectONID");
        int GrillUseObjectOFFID = (Integer)player.getAttribute("GrillUseObjectOFFID");
        int GrinderUseObjectONID = (Integer)player.getAttribute("GrinderUseObjectONID");
        int GrinderUseObjectOFFID = (Integer)player.getAttribute("GrinderUseObjectOFFID");
        int GrindstoneUseObjectONID = (Integer)player.getAttribute("GrindstoneUseObjectONID");
        int n = (Integer)player.getAttribute("GrindstoneUseObjectOFFID");
        int n2 = (Integer)player.getAttribute("LadderUseObjectONID");
        int n3 = (Integer)player.getAttribute("LadderUseObjectOFFID");
        int n4 = (Integer)player.getAttribute("LampUseObjectONID");
        int n5 = (Integer)player.getAttribute("LampUseObjectOFFID");
        int n6 = (Integer)player.getAttribute("MusicPlayerUseObjectONID");
        int n7 = (Integer)player.getAttribute("MusicPlayerUseObjectOFFID");
        int n8 = (Integer)player.getAttribute("OvenUseObjectONID");
        int n9 = (Integer)player.getAttribute("OvenUseObjectOFFID");
        int n10 = (Integer)player.getAttribute("PaperPressUseObjectONID");
        int n11 = (Integer)player.getAttribute("PaperPressUseObjectOFFID");
        int n12 = (Integer)player.getAttribute("PianoUseObjectONID");
        int n13 = (Integer)player.getAttribute("PianoUseObjectOFFID");
        int n14 = (Integer)player.getAttribute("PosterUseObjectONID");
        int n15 = (Integer)player.getAttribute("PosterUseObjectOFFID");
        int n16 = (Integer)player.getAttribute("ScaffoldingUseObjectONID");
        int n17 = (Integer)player.getAttribute("ScaffoldingUseObjectOFFID");
        int n18 = (Integer)player.getAttribute("SeatingUseObjectONID");
        int n19 = (Integer)player.getAttribute("SeatingUseObjectOFFID");
        int n20 = (Integer)player.getAttribute("ShootingTargetUseObjectONID");
        int n21 = (Integer)player.getAttribute("ShootingTargetUseObjectOFFID");
        int n22 = (Integer)player.getAttribute("SignUseObjectONID");
        int n23 = (Integer)player.getAttribute("SignUseObjectOFFID");
        int n24 = (Integer)player.getAttribute("SpinningWheelUseObjectONID");
        int n25 = (Integer)player.getAttribute("SpinningWheelUseObjectOFFID");
        int n26 = (Integer)player.getAttribute("StorageUseObjectONID");
        int n27 = (Integer)player.getAttribute("StorageUseObjectOFFID");
        int n28 = (Integer)player.getAttribute("TanningRackUseObjectONID");
        int n29 = (Integer)player.getAttribute("TanningRackUseObjectOFFID");
        int n30 = (Integer)player.getAttribute("TechnicalUseObjectONID");
        int n31 = (Integer)player.getAttribute("TechnicalUseObjectOFFID");
        int n32 = (Integer)player.getAttribute("TorchUseObjectONID");
        int n33 = (Integer)player.getAttribute("TorchUseObjectOFFID");
        int n34 = (Integer)player.getAttribute("TrashcanUseObjectONID");
        int n35 = (Integer)player.getAttribute("TrashcanUseObjectOFFID");
        int n36 = (Integer)player.getAttribute("WorkbenchUseObjectONID");
        int n37 = (Integer)player.getAttribute("WorkbenchUseObjectOFFID");
        int n38 = (Integer)player.getAttribute("HitAnimalNPCONID");
        int n39 = (Integer)player.getAttribute("HitAnimalNPCOFFID");
        int n40 = (Integer)player.getAttribute("HitHumanNPCONID");
        int n41 = (Integer)player.getAttribute("HitHumanNPCOFFID");
        int n42 = (Integer)player.getAttribute("HitMountNPCONID");
        int n43 = (Integer)player.getAttribute("HitMountNPCOFFID");
        int n44 = (Integer)player.getAttribute("RideMountNPCONID");
        int n45 = (Integer)player.getAttribute("RideMountNPCOFFID");
        int n46 = (Integer)player.getAttribute("PlaceBluePrintsONID");
        int n47 = (Integer)player.getAttribute("PlaceBluePrintsOFFID");
        int n48 = (Integer)player.getAttribute("NpcAddSaddleONID");
        int n49 = (Integer)player.getAttribute("NpcAddSaddleOFFID");
        int n50 = (Integer)player.getAttribute("NpcRemoveSaddleONID");
        int n51 = (Integer)player.getAttribute("NpcRemoveSaddleOFFID");
        int n52 = (Integer)player.getAttribute("NpcAddSaddleBagONID");
        int n53 = (Integer)player.getAttribute("NpcAddSaddleBagOFFID");
        int n54 = (Integer)player.getAttribute("NpcRemoveSaddleBagONID");
        int n55 = (Integer)player.getAttribute("NpcRemoveSaddleBagOFFID");
        int n56 = (Integer)player.getAttribute("NpcAddClothesONID");
        int n57 = (Integer)player.getAttribute("NpcAddClothesOFFID");
        int n58 = (Integer)player.getAttribute("NpcRemoveClothesONID");
        int n59 = (Integer)player.getAttribute("NpcRemoveClothesOFFID");
        int n60 = (Integer)player.getAttribute("PlayerDestroyTerrainONID");
        int n61 = (Integer)player.getAttribute("PlayerDestroyTerrainOFFID");
        int n62 = (Integer)player.getAttribute("PlayerHitTerrainONID");
        int n63 = (Integer)player.getAttribute("PlayerHitTerrainOFFID");
        int n64 = (Integer)player.getAttribute("PlayerBedUseObjectONID");
        int n65 = (Integer)player.getAttribute("PlayerBedUseObjectOFFID");
        int n66 = (Integer)player.getAttribute("PlayerCampfireUseObjectONID");
        int n67 = (Integer)player.getAttribute("PlayerCampfireUseObjectOFFID");
        int n68 = (Integer)player.getAttribute("PlayerTreeDestroyVegetationONID");
        int n69 = (Integer)player.getAttribute("PlayerTreeDestroyVegetationOFFID");
        int n70 = (Integer)player.getAttribute("PlayerTrunkDestroyVegetationONID");
        int n71 = (Integer)player.getAttribute("PlayerTrunkDestroyVegetationOFFID");
        int n72 = (Integer)player.getAttribute("PlayerTreeHitVegetationONID");
        int n73 = (Integer)player.getAttribute("PlayerTreeHitVegetationOFFID");
        int n74 = (Integer)player.getAttribute("PlayerTrunkHitVegetationONID");
        int n75 = (Integer)player.getAttribute("PlayerTrunkHitVegetationOFFID");
        int n76 = (Integer)player.getAttribute("PlayerTreeRemoveVegetationONID");
        int n77 = (Integer)player.getAttribute("PlayerTreeRemoveVegetationOFFID");
        int n78 = (Integer)player.getAttribute("PlayerTrunkRemoveVegetationONID");
        int n79 = (Integer)player.getAttribute("PlayerTrunkRemoveVegetationOFFID");
        int n80 = (Integer)player.getAttribute("PlayerCropRemoveVegetationONID");
        int n81 = (Integer)player.getAttribute("PlayerCropRemoveVegetationOFFID");
        int n82 = (Integer)player.getAttribute("PlayerFruitTreeRemoveVegetationONID");
        int n83 = (Integer)player.getAttribute("PlayerFruitTreeRemoveVegetationOFFID");
        int n84 = (Integer)player.getAttribute("PlayerPlantRemoveVegetationONID");
        int n85 = (Integer)player.getAttribute("PlayerPlantRemoveVegetationOFFID");
        int n86 = (Integer)player.getAttribute("PlayerRockDestroyVegetationONID");
        int n87 = (Integer)player.getAttribute("PlayerRockDestroyVegetationOFFID");
        int n88 = (Integer)player.getAttribute("PlayerRockHitVegetationONID");
        int n89 = (Integer)player.getAttribute("PlayerRockHitVegetationOFFID");
        int n90 = (Integer)player.getAttribute("PlayerRockRemoveVegetationONID");
        int n91 = (Integer)player.getAttribute("PlayerRockRemoveVegetationOFFID");
        int n92 = (Integer)player.getAttribute("PlayerClockUseObjectONID");
        int n93 = (Integer)player.getAttribute("PlayerClockUseObjectOFFID");
        int n94 = (Integer)player.getAttribute("PlayerDoorUseObjectONID");
        int n95 = (Integer)player.getAttribute("PlayerDoorUseObjectOFFID");
        int n96 = (Integer)player.getAttribute("PlayerDryingRackUseObjectONID");
        int n97 = (Integer)player.getAttribute("PlayerDryingRackUseObjectOFFID");
        int n98 = (Integer)player.getAttribute("PlayerFireUseObjectONID");
        int n99 = (Integer)player.getAttribute("PlayerFireUseObjectOFFID");
        int n100 = (Integer)player.getAttribute("PlayerFurnaceUseObjectONID");
        int n101 = (Integer)player.getAttribute("PlayerFurnaceUseObjectOFFID");
        int n102 = (Integer)player.getAttribute("PlayerGrillUseObjectONID");
        int n103 = (Integer)player.getAttribute("PlayerGrillUseObjectOFFID");
        int n104 = (Integer)player.getAttribute("PlayerGrinderUseObjectONID");
        int n105 = (Integer)player.getAttribute("PlayerGrinderUseObjectOFFID");
        int n106 = (Integer)player.getAttribute("PlayerGrindstoneUseObjectONID");
        int n107 = (Integer)player.getAttribute("PlayerGrindstoneUseObjectOFFID");
        int n108 = (Integer)player.getAttribute("PlayerLadderUseObjectONID");
        int n109 = (Integer)player.getAttribute("PlayerLadderUseObjectOFFID");
        int n110 = (Integer)player.getAttribute("PlayerLampUseObjectONID");
        int n111 = (Integer)player.getAttribute("PlayerLampUseObjectOFFID");
        int n112 = (Integer)player.getAttribute("PlayerMusicPlayerUseObjectONID");
        int n113 = (Integer)player.getAttribute("PlayerMusicPlayerUseObjectOFFID");
        int n114 = (Integer)player.getAttribute("PlayerOvenUseObjectONID");
        int n115 = (Integer)player.getAttribute("PlayerOvenUseObjectOFFID");
        int n116 = (Integer)player.getAttribute("PlayerPaperPressUseObjectONID");
        int n117 = (Integer)player.getAttribute("PlayerPaperPressUseObjectOFFID");
        int n118 = (Integer)player.getAttribute("PlayerPianoUseObjectONID");
        int n119 = (Integer)player.getAttribute("PlayerPianoUseObjectOFFID");
        int n120 = (Integer)player.getAttribute("PlayerPosterUseObjectONID");
        int n121 = (Integer)player.getAttribute("PlayerPosterUseObjectOFFID");
        int n122 = (Integer)player.getAttribute("PlayerScaffoldingUseObjectONID");
        int n123 = (Integer)player.getAttribute("PlayerScaffoldingUseObjectOFFID");
        int n124 = (Integer)player.getAttribute("PlayerSeatingUseObjectONID");
        int n125 = (Integer)player.getAttribute("PlayerSeatingUseObjectOFFID");
        int n126 = (Integer)player.getAttribute("PlayerShootingTargetUseObjectONID");
        int n127 = (Integer)player.getAttribute("PlayerShootingTargetUseObjectOFFID");
        int n128 = (Integer)player.getAttribute("PlayerSignUseObjectONID");
        int n129 = (Integer)player.getAttribute("PlayerSignUseObjectOFFID");
        int n130 = (Integer)player.getAttribute("PlayerSpinningWheelUseObjectONID");
        int n131 = (Integer)player.getAttribute("PlayerSpinningWheelUseObjectOFFID");
        int n132 = (Integer)player.getAttribute("PlayerStorageUseObjectONID");
        int n133 = (Integer)player.getAttribute("PlayerStorageUseObjectOFFID");
        int n134 = (Integer)player.getAttribute("PlayerTanningRackUseObjectONID");
        int n135 = (Integer)player.getAttribute("PlayerTanningRackUseObjectOFFID");
        int n136 = (Integer)player.getAttribute("PlayerTechnicalUseObjectONID");
        int n137 = (Integer)player.getAttribute("PlayerTechnicalUseObjectOFFID");
        int n138 = (Integer)player.getAttribute("PlayerTorchUseObjectONID");
        int n139 = (Integer)player.getAttribute("PlayerTorchUseObjectOFFID");
        int n140 = (Integer)player.getAttribute("PlayerTrashcanUseObjectONID");
        int n141 = (Integer)player.getAttribute("PlayerTrashcanUseObjectOFFID");
        int n142 = (Integer)player.getAttribute("PlayerWorkbenchUseObjectONID");
        int n143 = (Integer)player.getAttribute("PlayerWorkbenchUseObjectOFFID");
        int n144 = (Integer)player.getAttribute("PlayerHitAnimalNPCONID");
        int n145 = (Integer)player.getAttribute("PlayerHitAnimalNPCOFFID");
        int n146 = (Integer)player.getAttribute("PlayerHitHumanNPCONID");
        int n147 = (Integer)player.getAttribute("PlayerHitHumanNPCOFFID");
        int n148 = (Integer)player.getAttribute("PlayerHitMountNPCONID");
        int n149 = (Integer)player.getAttribute("PlayerHitMountNPCOFFID");
        int n150 = (Integer)player.getAttribute("PlayerRideMountNPCONID");
        int n151 = (Integer)player.getAttribute("PlayerRideMountNPCOFFID");
        int n152 = (Integer)player.getAttribute("PlayerPlaceBluePrintsONID");
        int n153 = (Integer)player.getAttribute("PlayerPlaceBluePrintsOFFID");
        int n154 = (Integer)player.getAttribute("PlayerNpcAddSaddleONID");
        int n155 = (Integer)player.getAttribute("PlayerNpcAddSaddleOFFID");
        int n156 = (Integer)player.getAttribute("PlayerNpcRemoveSaddleONID");
        int n157 = (Integer)player.getAttribute("PlayerNpcRemoveSaddleOFFID");
        int n158 = (Integer)player.getAttribute("PlayerNpcAddSaddleBagONID");
        int n159 = (Integer)player.getAttribute("PlayerNpcAddSaddleBagOFFID");
        int n160 = (Integer)player.getAttribute("PlayerNpcRemoveSaddleBagONID");
        int n161 = (Integer)player.getAttribute("PlayerNpcRemoveSaddleBagOFFID");
        int n162 = (Integer)player.getAttribute("PlayerNpcAddClothesONID");
        int n163 = (Integer)player.getAttribute("PlayerNpcAddClothesOFFID");
        int n164 = (Integer)player.getAttribute("PlayerNpcRemoveClothesONID");
        int n165 = (Integer)player.getAttribute("PlayerNpcRemoveClothesOFFID");
        int n166 = (Integer)player.getAttribute("PointsEarnedAdjustUPID");
        int n167 = (Integer)player.getAttribute("PointsEarnedAdjustDownID");
        int n168 = (Integer)player.getAttribute("AreaCostAdjustUPID");
        int n169 = (Integer)player.getAttribute("AreaCostAdjustDownID");
        int n170 = (Integer)player.getAttribute("DeleteAllAreasID");
        int n171 = (Integer)player.getAttribute("LockAreaID");
        int n172 = (Integer)player.getAttribute("UnlockAreaID");
        UILabel uILabel = (UILabel)player.getAttribute("Areastatus");
        if (eventID == exitAreaConfirmationPanelbuttonID) {
            player.setMouseCursorVisible(false);
            AreaConfirmationPanel2.setVisible(false);
        }
        if (eventID == AddAreaConfirmationPanelbuttonID) {
            int NeededPoints;
            int PlusPoints;
            player.setMouseCursorVisible(false);
            AreaConfirmationPanel2.setVisible(false);
            try {
                ResultSet resultSet = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result2.next()) {
                        player.setAttribute("PointsEarnedAdjust", Result2.getInt("PointsEarnedAdjust"));
                        player.setAttribute("AreaCostAdjust", Result2.getInt("AreaCostAdjust"));
                        player.setAttribute("BPConstructionCost", Result2.getInt("BPConstructionCost"));
                        player.setAttribute("BPObjectCost", Result2.getInt("BPObjectCost"));
                        player.setAttribute("BPPlantCost", Result2.getInt("BPPlantCost"));
                        player.setAttribute("BPMaxPlaceDistance", Result2.getInt("BPMaxPlaceDistance"));
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException Result2) {
                void ex3;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex3);
            }
            try {
                ex22 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result2.next()) {
                        int n173 = Result2.getInt(1);
                        player.setAttribute("CountPlots", CountPlots2);
                        int n174 = (Integer)player.getAttribute("AreaCostAdjust");
                        void var432_1163 = PlusPoints * CountPlots2;
                        if (NeededPoints == 0) {
                            NeededPoints = 10;
                        }
                        AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + NeededPoints);
                    }
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException Result3) {
                void ex4;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex4);
            }
            if (Boolean.TRUE.equals(player.getAttribute("InsideAdminArea"))) {
                player.sendTextMessage("you cannot claim areas inside Admin Areas");
                return;
            }
            try {
                void PointsResult;
                ex22 = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (PointsResult.next()) {
                        int NeededPoints2;
                        int PlusPoints2;
                        CountPlots2 = PointsResult.getInt("Points");
                        PlusPoints = (Integer)player.getAttribute("CountPlots");
                        NeededPoints = (Integer)player.getAttribute("AreaCostAdjust");
                        void var433_1415 = PlusPoints2 * CountPlots;
                        if (NeededPoints2 == 0) {
                            NeededPoints2 = 10;
                        }
                        if (Points >= NeededPoints2) {
                            try {
                                void Result4;
                                ResultSet resultSet = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                                try {
                                    if (Result4.next()) {
                                        String string = Result4.getString("AreaOwnerName");
                                        player.sendTextMessage("This area is already claimed by " + (String)((Object)getAreaOwnerName));
                                    } else {
                                        void HideTask;
                                        void HideTimer;
                                        void SetArea;
                                        void area;
                                        void endPos;
                                        void startPos;
                                        void EndBlock;
                                        void EndChunk;
                                        void StartBlock;
                                        void StartChunk;
                                        getAreaOwnerName = LocalDate.now();
                                        this.database.executeUpdate("INSERT INTO `Areas` (AreaOwnerName, AreaName, AreaGuest, AreaX, AreaY, AreaZ, PlayerUID, CreationDate, AreaLocked, ChestLocked, DoorsLocked, PVPStatus) VALUES ('" + PlayerName + "','AreaName','AreaGuest','" + ChunkPosition.x + "','" + ChunkPosition.y + "','" + ChunkPosition.z + "','" + PlayerUID + "','" + String.valueOf(Date2) + "','1','1','1','1');");
                                        DataUpdate dataUpdate = new DataUpdate(this);
                                        ((DataUpdate)((Object)DataUpdate2)).RunDataUpdate(player);
                                        player.setAttribute("AreaOwnerUID", PlayerUID);
                                        Vector3i vector3i = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
                                        this.database.executeUpdate("UPDATE Points SET Points = '" + (Points -= NeededPoints2) + "' WHERE PlayerUID = '" + PlayerUID + "'");
                                        player.sendTextMessage("This area is now claimed by " + PlayerName);
                                        player.setAttribute("PlotOwner", PlayerName);
                                        PlotInfo.setText("Plot Owner=" + String.valueOf(player.getAttribute("PlotOwner")));
                                        AreaName.setText("Area Name=AreaName");
                                        Vector3i vector3i2 = new Vector3i(0, 0, 0);
                                        Vector3i vector3i3 = new Vector3i(32, 64, 32);
                                        Vector3i vector3i4 = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
                                        Vector3i vector3i5 = new Vector3i(ChunkPosition.x, ChunkPosition.y, ChunkPosition.z);
                                        Vector3f vector3f = Utils.ChunkUtils.getGlobalPosition((Vector3i)StartChunk, (Vector3i)StartBlock);
                                        Vector3f vector3f2 = Utils.ChunkUtils.getGlobalPosition((Vector3i)EndChunk, (Vector3i)EndBlock);
                                        Area area2 = new Area((Vector3f)startPos, (Vector3f)endPos);
                                        Area3D area3D = new Area3D((Area)area);
                                        SetArea.setAlwaysVisible(false);
                                        SetArea.setFrameVisible(true);
                                        SetArea.setColor(0.0f, 0.0f, 0.5f, 0.3f);
                                        SetArea.setFrameColor(0.0f, 0.0f, 0.5f, 0.6f);
                                        player.addGameObject((GameObject)SetArea);
                                        Timer timer = new Timer(60.0f, 0.0f, 0, null);
                                        Runnable runnable = () -> WorldProtection.lambda$onPlayerUIEClick$10(player, (Area3D)SetArea);
                                        HideTimer.setTask((Runnable)HideTask);
                                        HideTimer.start();
                                    }
                                    Result4.close();
                                }
                                finally {
                                    if (Result4 != null) {
                                        Result4.close();
                                    }
                                }
                            }
                            catch (SQLException Result4) {
                                void ex5;
                                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex5);
                            }
                            try {
                                ex6 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                                try {
                                    if (Result4.next()) {
                                        CountPlots = Result4.getInt(1);
                                        player.setAttribute("CountPlots", CountPlots);
                                        PlusPoints2 = (Integer)player.getAttribute("AreaCostAdjust");
                                        NeededPoints2 = PlusPoints2 * CountPlots;
                                        if (NeededPoints2 == 0) {
                                            NeededPoints2 = 10;
                                        }
                                        AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + NeededPoints2);
                                    }
                                }
                                finally {
                                    if (Result4 != null) {
                                        Result4.close();
                                    }
                                }
                            }
                            catch (SQLException Result5) {
                                void ex6;
                                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex6);
                            }
                            player.setAttribute("Points", Points);
                            PointsInfo.setText("Points=" + String.valueOf(player.getAttribute("Points")));
                        } else {
                            player.sendTextMessage("you do not have enough points to claim a area!!! you need " + NeededPoints2 + " Points for you next plot!!!");
                        }
                    }
                    PointsResult.close();
                }
                finally {
                    if (PointsResult != null) {
                        PointsResult.close();
                    }
                }
            }
            catch (SQLException PointsResult) {
                void ex7;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex7);
            }
        }
        if (eventID == RemoveAreaConfirmationPanelbuttonID) {
            player.setMouseCursorVisible(false);
            AreaConfirmationPanel2.setVisible(false);
            if (player.isAdmin()) {
                this.database.executeUpdate("DELETE FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                PlotInfo.setText("Plot Owner=UnClaimed");
                AreaName.setText("Area Name=UnNamed");
                player.sendTextMessage("Area deleted");
                try {
                    ex22 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                    try {
                        if (Result2.next()) {
                            Points = Result2.getInt(1);
                            player.setAttribute("CountPlots", CountPlots2);
                            AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + String.valueOf(player.getAttribute("NeededPoints")));
                        }
                        Result2.close();
                    }
                    finally {
                        if (Result2 != null) {
                            Result2.close();
                        }
                    }
                }
                catch (SQLException Result6) {
                    void ex8;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex8);
                }
                return;
            }
            try {
                ex22 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result2.next()) {
                        this.database.executeUpdate("DELETE FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        PlotInfo.setText("Plot Owner=UnClaimed");
                        AreaName.setText("Area Name=UnNamed");
                        player.sendTextMessage("Area deleted");
                        try {
                            void CountResult;
                            ResultSet CountPlots3 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                            try {
                                if (CountResult.next()) {
                                    CountPlots = CountResult.getInt(1);
                                    player.setAttribute("CountPlots", CountPlots);
                                    AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + String.valueOf(player.getAttribute("NeededPoints")));
                                }
                                CountResult.close();
                            }
                            finally {
                                if (CountResult != null) {
                                    CountResult.close();
                                }
                            }
                        }
                        catch (SQLException CountResult) {
                            void ex9;
                            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex9);
                        }
                    } else {
                        player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
                    }
                    Result2.close();
                }
                finally {
                    if (Result2 != null) {
                        Result2.close();
                    }
                }
            }
            catch (SQLException Result7) {
                void ex22;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex22);
            }
        }
        ex22 = LocalDate.now();
        if (eventID == OpenPanelbuttonID) {
            DateTimeFormatter CreationDate;
            String getAreaName;
            LocalDate OwnerUID;
            AreaConfirmationPanel2.setVisible(false);
            UILabel ex9 = (UILabel)player.getAttribute("CreationDateSettingsWPPanel");
            UILabel CountPlots4 = (UILabel)player.getAttribute("LastOnlineSettingsWPPanel");
            UILabel PlusPoints2 = (UILabel)player.getAttribute("SinceLastOnlineSettingsWPPanel");
            SettingsWPPanel.setVisible(true);
            AddFriendToWPAreaTextField.setText(String.valueOf(player.getAttribute("PlotOwner")));
            try {
                void Result8;
                ResultSet NeededPoints2 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                try {
                    if (Result8.next()) {
                        void CreationDateSettingsWPPanel;
                        void isAreaLocked;
                        ex6 = Result8.getString("AreaName");
                        Date2 = Result8.getString("CreationDate");
                        DataUpdate2 = Result8.getString("PlayerUID");
                        boolean PlayersChunks = Result8.getBoolean("AreaLocked");
                        if (isAreaLocked == true) {
                            Areastatus.setText("<b>Status=Area Locked </b>");
                        } else {
                            Areastatus.setText("<b>Status=Area Unlocked </b>");
                        }
                        player.setAttribute("OwnerUID", OwnerUID);
                        WPNameTextField.setText(getAreaName);
                        CreationDateSettingsWPPanel.setText("Creation Date=" + (String)((Object)CreationDate));
                    } else {
                        WPNameTextField.setText("");
                    }
                    Result8.close();
                }
                finally {
                    if (Result8 != null) {
                        Result8.close();
                    }
                }
            }
            catch (SQLException Result8) {
                void ex10;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex10);
            }
            try {
                ResultSet ex10 = this.database.executeQuery("SELECT * FROM `PlayerLastOnline` WHERE `PlayerUID` = '" + String.valueOf(player.getAttribute("OwnerUID")) + "'");
                try {
                    if (Result8.next()) {
                        void SinceLastOnlineSettingsWPPanel;
                        void DaysAway;
                        void date;
                        void Date3;
                        void formatter;
                        void str;
                        void LastOnlineSettingsWPPanel;
                        LastOnlineSettingsWPPanel.setText("Last OnLine=" + Result8.getString("LastOnLine"));
                        getAreaName = Result8.getString("LastOnLine");
                        CreationDate = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                        OwnerUID = LocalDate.parse((CharSequence)str, (DateTimeFormatter)formatter);
                        int isAreaLocked = Date3.compareTo((ChronoLocalDate)date);
                        if (DaysAway <= 30) {
                            SinceLastOnlineSettingsWPPanel.setFontColor(0.0f, 1.0f, 0.0f, 1.0f);
                        }
                        if (DaysAway >= 30 && DaysAway <= 60) {
                            SinceLastOnlineSettingsWPPanel.setFontColor(0.0f, 0.0f, 1.0f, 1.0f);
                        }
                        if (DaysAway >= 60) {
                            SinceLastOnlineSettingsWPPanel.setFontColor(1.0f, 0.0f, 0.0f, 1.0f);
                        }
                        SinceLastOnlineSettingsWPPanel.setText("Days Offline=" + (int)DaysAway);
                    }
                    Result8.close();
                }
                finally {
                    if (Result8 != null) {
                        Result8.close();
                    }
                }
            }
            catch (SQLException Result9) {
                void ex11;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex11);
            }
        }
        if (eventID == OpenAdminToolsID) {
            if (player.isAdmin()) {
                void updateAdminSettings;
                SettingsWPPanel.setVisible(false);
                AdminToolsWPPanel.setVisible(true);
                ATNameTextField.setText(String.valueOf(player.getAttribute("PlotOwner")));
                UpDateAdminSettings CreationDateSettingsWPPanel = new UpDateAdminSettings(this);
                updateAdminSettings.UpdateAdminSettings(player);
            } else if (!player.isAdmin()) {
                player.sendTextMessage("Only Admins Can Use Admin Tools");
            }
        }
        if (eventID == OpenPlayerToolsID) {
            SettingsWPPanel.setVisible(false);
            PlayerToolsWPPanel.setVisible(true);
            try {
                void Result10;
                ResultSet updateAdminSettings = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result10.next()) {
                        void PlayerNpcRemoveClothes;
                        void PlayerNpcAddClothes;
                        void PlayerNpcRemoveSaddleBag;
                        void PlayerNpcAddSaddleBag;
                        void PlayerNpcRemoveSaddle;
                        void PlayerNpcAddSaddle;
                        void PlayerPlaceBluePrints;
                        void PlayerRideMountNPC;
                        void PlayerHitMountNPC;
                        void PlayerHitHumanNPC;
                        void PlayerHitAnimalNPC;
                        void PlayerWorkbenchUseObject;
                        void PlayerTrashcanUseObject;
                        void PlayerTorchUseObject;
                        void PlayerTechnicalUseObject;
                        void PlayerTanningRackUseObject;
                        void PlayerStorageUseObject;
                        void PlayerSpinningWheelUseObject;
                        void PlayerSignUseObject;
                        void PlayerShootingTargetUseObject;
                        void PlayerSeatingUseObject;
                        void PlayerScaffoldingUseObject;
                        void PlayerPosterUseObject;
                        void PlayerPianoUseObject;
                        void PlayerPaperPressUseObject;
                        void PlayerOvenUseObject;
                        void PlayerMusicPlayerUseObject;
                        void PlayerLampUseObject;
                        void PlayerLadderUseObject;
                        void PlayerGrindstoneUseObject;
                        void PlayerGrinderUseObject;
                        void PlayerGrillUseObject;
                        void PlayerFurnaceUseObject;
                        void PlayerFireUseObject;
                        void PlayerCampfireUseObject;
                        void PlayerBedUseObject;
                        void PlayerHitTerrain;
                        void PlayerDestroyTerrain;
                        void PlayerDryingRackUseObject;
                        void PlayerDoorUseObject;
                        void PlayerClockUseObject;
                        void PlayerRockRemoveVegetation;
                        void PlayerRockHitVegetation;
                        void PlayerRockDestroyVegetation;
                        void PlayerPlantRemoveVegetation;
                        void PlayerFruitTreeRemoveVegetation;
                        void PlayerCropRemoveVegetation;
                        void PlayerTrunkRemoveVegetation;
                        void PlayerTreeRemoveVegetation;
                        void PlayerTrunkHitVegetation;
                        void PlayerTreeHitVegetation;
                        void PlayerTrunkDestroyVegetation;
                        void PlayerTreeDestroyVegetation;
                        int LastOnlineSettingsWPPanel = Result10.getInt("TreeDestroyVegetation");
                        if (PlayerTreeDestroyVegetation == true) {
                            player.setAttribute("PlayerTreeDestroyVegetation", true);
                            PlayerTreeDestroyVegetationINFO.setText("<b>Tree Destroy = ON</b>");
                        } else if (PlayerTreeDestroyVegetation == false) {
                            player.setAttribute("PlayerTreeDestroyVegetation", false);
                            PlayerTreeDestroyVegetationINFO.setText("<b>Tree Destroy = OFF</b>");
                        }
                        int SinceLastOnlineSettingsWPPanel = Result10.getInt("TrunkDestroyVegetation");
                        if (PlayerTrunkDestroyVegetation == true) {
                            player.setAttribute("PlayerTrunkDestroyVegetation", true);
                            PlayerTrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = ON</b>");
                        } else if (PlayerTrunkDestroyVegetation == false) {
                            player.setAttribute("PlayerTrunkDestroyVegetation", false);
                            PlayerTrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = OFF</b>");
                        }
                        int ex11 = Result10.getInt("TreeHitVegetation");
                        if (PlayerTreeHitVegetation == true) {
                            player.setAttribute("PlayerTreeHitVegetation", true);
                            PlayerTreeHitVegetationINFO.setText("<b>Tree Hit = ON</b>");
                        } else if (PlayerTreeHitVegetation == false) {
                            player.setAttribute("PlayerTreeHitVegetation", false);
                            PlayerTreeHitVegetationINFO.setText("<b>Tree Hit = OFF</b>");
                        }
                        int str = Result10.getInt("TrunkHitVegetation");
                        if (PlayerTrunkHitVegetation == true) {
                            player.setAttribute("PlayerTrunkHitVegetation", true);
                            PlayerTrunkHitVegetationINFO.setText("<b>OldLog Hit = ON</b>");
                        } else if (PlayerTrunkHitVegetation == false) {
                            player.setAttribute("PlayerTrunkHitVegetation", false);
                            PlayerTrunkHitVegetationINFO.setText("<b>OldLog Hit = OFF</b>");
                        }
                        int formatter = Result10.getInt("TreeRemoveVegetation");
                        if (PlayerTreeRemoveVegetation == true) {
                            player.setAttribute("PlayerTreeRemoveVegetation", true);
                            PlayerTreeRemoveVegetationINFO.setText("<b>Tree Remove = ON</b>");
                        } else if (PlayerTreeRemoveVegetation == false) {
                            player.setAttribute("PlayerTreeRemoveVegetation", false);
                            PlayerTreeRemoveVegetationINFO.setText("<b>Tree Remove = OFF</b>");
                        }
                        int date = Result10.getInt("TrunkRemoveVegetation");
                        if (PlayerTrunkRemoveVegetation == true) {
                            player.setAttribute("PlayerTrunkRemoveVegetation", true);
                            PlayerTrunkRemoveVegetationINFO.setText("<b>OldLog Remove = ON</b>");
                        } else if (PlayerTrunkRemoveVegetation == false) {
                            player.setAttribute("PlayerTrunkRemoveVegetation", false);
                            PlayerTrunkRemoveVegetationINFO.setText("<b>OldLog Remove = OFF</b>");
                        }
                        int DaysAway = Result10.getInt("CropRemoveVegetation");
                        if (PlayerCropRemoveVegetation == true) {
                            player.setAttribute("PlayerCropRemoveVegetation", true);
                            PlayerCropRemoveVegetationINFO.setText("<b>Crop Remove = ON</b>");
                        } else if (PlayerCropRemoveVegetation == false) {
                            player.setAttribute("PlayerCropRemoveVegetation", false);
                            PlayerCropRemoveVegetationINFO.setText("<b>Crop Remove = OFF</b>");
                        }
                        int StartBlock = Result10.getInt("FruitTreeRemoveVegetation");
                        if (PlayerFruitTreeRemoveVegetation == true) {
                            player.setAttribute("PlayerFruitTreeRemoveVegetation", true);
                            PlayerFruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = ON</b>");
                        } else if (PlayerFruitTreeRemoveVegetation == false) {
                            player.setAttribute("PlayerFruitTreeRemoveVegetation", false);
                            PlayerFruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = OFF</b>");
                        }
                        int EndBlock = Result10.getInt("PlantRemoveVegetation");
                        if (PlayerPlantRemoveVegetation == true) {
                            player.setAttribute("PlayerPlantRemoveVegetation", true);
                            PlayerPlantRemoveVegetationINFO.setText("<b>Plant Remove = ON</b>");
                        } else if (PlayerPlantRemoveVegetation == false) {
                            player.setAttribute("PlayerPlantRemoveVegetation", false);
                            PlayerPlantRemoveVegetationINFO.setText("<b>Plant Remove = OFF</b>");
                        }
                        int StartChunk = Result10.getInt("RockDestroyVegetation");
                        if (PlayerRockDestroyVegetation == true) {
                            player.setAttribute("PlayerRockDestroyVegetation", true);
                            PlayerRockDestroyVegetationINFO.setText("<b>Rock Destroy = ON</b>");
                        } else if (PlayerRockDestroyVegetation == false) {
                            player.setAttribute("PlayerRockDestroyVegetation", false);
                            PlayerRockDestroyVegetationINFO.setText("<b>Rock Destroy = OFF</b>");
                        }
                        int EndChunk = Result10.getInt("RockHitVegetation");
                        if (PlayerRockHitVegetation == true) {
                            player.setAttribute("PlayerRockHitVegetation", true);
                            PlayerRockHitVegetationINFO.setText("<b>Rock Hit = ON</b>");
                        } else if (PlayerRockHitVegetation == false) {
                            player.setAttribute("PlayerRockHitVegetation", false);
                            PlayerRockHitVegetationINFO.setText("<b>Rock Hit = OFF</b>");
                        }
                        int startPos = Result10.getInt("RockRemoveVegetation");
                        if (PlayerRockRemoveVegetation == true) {
                            player.setAttribute("PlayerRockRemoveVegetation", true);
                            PlayerRockRemoveVegetationINFO.setText("<b>Rock Remove = ON</b>");
                        } else if (PlayerRockRemoveVegetation == false) {
                            player.setAttribute("PlayerRockRemoveVegetation", false);
                            PlayerRockRemoveVegetationINFO.setText("<b>Rock Remove = OFF</b>");
                        }
                        int endPos = Result10.getInt("ClockUseObject");
                        if (PlayerClockUseObject == true) {
                            player.setAttribute("PlayerClockUseObject", true);
                            PlayerClockUseObjectINFO.setText("<b>Use Clocks = ON</b>");
                        } else if (PlayerClockUseObject == false) {
                            player.setAttribute("PlayerClockUseObject", false);
                            PlayerClockUseObjectINFO.setText("<b>Use Clocks = OFF</b>");
                        }
                        int area = Result10.getInt("DoorUseObject");
                        if (PlayerDoorUseObject == true) {
                            player.setAttribute("PlayerDoorUseObject", true);
                            PlayerDoorUseObjectINFO.setText("<b>Use Doors = ON</b>");
                        } else if (PlayerDoorUseObject == false) {
                            player.setAttribute("PlayerDoorUseObject", false);
                            PlayerDoorUseObjectINFO.setText("<b>Use Doors = OFF</b>");
                        }
                        int SetArea = Result10.getInt("DryingRackUseObject");
                        if (PlayerDryingRackUseObject == true) {
                            player.setAttribute("PlayerDryingRackUseObject", true);
                            PlayerDryingRackUseObjectINFO.setText("<b>Use DryingRacks = ON</b>");
                        } else if (PlayerDryingRackUseObject == false) {
                            player.setAttribute("PlayerDryingRackUseObject", false);
                            PlayerDryingRackUseObjectINFO.setText("<b>Use DryingRacks = OFF</b>");
                        }
                        int HideTimer = Result10.getInt("DestroyTerrain");
                        if (PlayerDestroyTerrain == true) {
                            player.setAttribute("PlayerDestroyTerrain", true);
                            PlayerDestroyTerrainINFO.setText("<b>Destroy Terrain = ON</b>");
                        } else if (PlayerDestroyTerrain == false) {
                            player.setAttribute("PlayerDestroyTerrain", false);
                            PlayerDestroyTerrainINFO.setText("<b>Destroy Terrain = OFF</b>");
                        }
                        int HideTask = Result10.getInt("HitTerrain");
                        if (PlayerHitTerrain == true) {
                            player.setAttribute("PlayerHitTerrain", true);
                            PlayerHitTerrainINFO.setText("<b>Hit Terrain = ON</b>");
                        } else if (PlayerHitTerrain == false) {
                            player.setAttribute("PlayerHitTerrain", false);
                            PlayerHitTerrainINFO.setText("<b>Hit Terrain = OFF</b>");
                        }
                        int n175 = Result10.getInt("BedUseObject");
                        if (PlayerBedUseObject == true) {
                            player.setAttribute("PlayerBedUseObject", true);
                            PlayerBedUseObjectINFO.setText("<b>Use Beds = ON</b>");
                        } else if (PlayerBedUseObject == false) {
                            player.setAttribute("PlayerBedUseObject", false);
                            PlayerBedUseObjectINFO.setText("<b>Use Beds = OFF</b>");
                        }
                        int n176 = Result10.getInt("CampfireUseObject");
                        if (PlayerCampfireUseObject == true) {
                            player.setAttribute("PlayerCampfireUseObject", true);
                            PlayerCampfireUseObjectINFO.setText("<b>Use Campfires = ON</b>");
                        } else if (PlayerCampfireUseObject == false) {
                            player.setAttribute("PlayerCampfireUseObject", false);
                            PlayerCampfireUseObjectINFO.setText("<b>Use Campfires = OFF</b>");
                        }
                        int n177 = Result10.getInt("FireUseObject");
                        if (PlayerFireUseObject == true) {
                            player.setAttribute("PlayerFireUseObject", true);
                            PlayerFireUseObjectINFO.setText("<b>Use Fires = ON</b>");
                        } else if (PlayerFireUseObject == false) {
                            player.setAttribute("PlayerFireUseObject", false);
                            PlayerFireUseObjectINFO.setText("<b>Use Fires = OFF</b>");
                        }
                        int n178 = Result10.getInt("FurnaceUseObject");
                        if (PlayerFurnaceUseObject == true) {
                            player.setAttribute("PlayerFurnaceUseObject", true);
                            PlayerFurnaceUseObjectINFO.setText("<b>Use Furnaces = ON</b>");
                        } else if (PlayerFurnaceUseObject == false) {
                            player.setAttribute("PlayerFurnaceUseObject", false);
                            PlayerFurnaceUseObjectINFO.setText("<b>Use Furnaces = OFF</b>");
                        }
                        int n179 = Result10.getInt("GrillUseObject");
                        if (PlayerGrillUseObject == true) {
                            player.setAttribute("PlayerGrillUseObject", true);
                            PlayerGrillUseObjectINFO.setText("<b>Use Grills = ON</b>");
                        } else if (PlayerGrillUseObject == false) {
                            player.setAttribute("PlayerGrillUseObject", false);
                            PlayerGrillUseObjectINFO.setText("<b>Use Grills = OFF</b>");
                        }
                        int n180 = Result10.getInt("GrinderUseObject");
                        if (PlayerGrinderUseObject == true) {
                            player.setAttribute("PlayerGrinderUseObject", true);
                            PlayerGrinderUseObjectINFO.setText("<b>Use Grinders = ON</b>");
                        } else if (PlayerGrinderUseObject == false) {
                            player.setAttribute("PlayerGrinderUseObject", false);
                            PlayerGrinderUseObjectINFO.setText("<b>Use Grinderst = OFF</b>");
                        }
                        int n181 = Result10.getInt("GrindstoneUseObject");
                        if (PlayerGrindstoneUseObject == true) {
                            player.setAttribute("PlayerGrindstoneUseObject", true);
                            PlayerGrindstoneUseObjectINFO.setText("<b>Use Grindstones = ON</b>");
                        } else if (PlayerGrindstoneUseObject == false) {
                            player.setAttribute("PlayerGrindstoneUseObject", false);
                            PlayerGrindstoneUseObjectINFO.setText("<b>Use Grindstones = OFF</b>");
                        }
                        int n182 = Result10.getInt("LadderUseObject");
                        if (PlayerLadderUseObject == true) {
                            player.setAttribute("PlayerLadderUseObject", true);
                            PlayerLadderUseObjectINFO.setText("<b>Use Ladders = ON</b>");
                        } else if (PlayerLadderUseObject == false) {
                            player.setAttribute("PlayerLadderUseObject", false);
                            PlayerLadderUseObjectINFO.setText("<b>Use Ladders = OFF</b>");
                        }
                        int n183 = Result10.getInt("LampUseObject");
                        if (PlayerLampUseObject == true) {
                            player.setAttribute("PlayerLampUseObject", true);
                            PlayerLampUseObjectINFO.setText("<b>Use Lamps = ON</b>");
                        } else if (PlayerLampUseObject == false) {
                            player.setAttribute("PlayerLampUseObject", false);
                            PlayerLampUseObjectINFO.setText("<b>Use Lamps = OFF</b>");
                        }
                        int n184 = Result10.getInt("MusicPlayerUseObject");
                        if (PlayerMusicPlayerUseObject == true) {
                            player.setAttribute("PlayerMusicPlayerUseObject", true);
                            PlayerMusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = ON</b>");
                        } else if (PlayerMusicPlayerUseObject == false) {
                            player.setAttribute("PlayerMusicPlayerUseObject", false);
                            PlayerMusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = OFF</b>");
                        }
                        int n185 = Result10.getInt("OvenUseObject");
                        if (PlayerOvenUseObject == true) {
                            player.setAttribute("PlayerOvenUseObject", true);
                            PlayerOvenUseObjectINFO.setText("<b>Use Ovens = ON</b>");
                        } else if (PlayerOvenUseObject == false) {
                            player.setAttribute("PlayerOvenUseObject", false);
                            PlayerOvenUseObjectINFO.setText("<b>Use Ovens = OFF</b>");
                        }
                        int n186 = Result10.getInt("PaperPressUseObject");
                        if (PlayerPaperPressUseObject == true) {
                            player.setAttribute("PlayerPaperPressUseObject", true);
                            PlayerPaperPressUseObjectINFO.setText("<b>Use PaperPress = ON</b>");
                        } else if (PlayerPaperPressUseObject == false) {
                            player.setAttribute("PlayerPaperPressUseObject", false);
                            PlayerPaperPressUseObjectINFO.setText("<b>Use PaperPress = OFF</b>");
                        }
                        int n187 = Result10.getInt("PianoUseObject");
                        if (PlayerPianoUseObject == true) {
                            player.setAttribute("PlayerPianoUseObject", true);
                            PlayerPianoUseObjectINFO.setText("<b>Use Pianos = ON</b>");
                        } else if (PlayerPianoUseObject == false) {
                            player.setAttribute("PlayerPianoUseObject", false);
                            PlayerPianoUseObjectINFO.setText("<b>Use Pianos = OFF</b>");
                        }
                        int n188 = Result10.getInt("PosterUseObject");
                        if (PlayerPosterUseObject == true) {
                            player.setAttribute("PlayerPosterUseObject", true);
                            PlayerPosterUseObjectINFO.setText("<b>Use Posters = ON</b>");
                        } else if (PlayerPosterUseObject == false) {
                            player.setAttribute("PlayerPosterUseObject", false);
                            PlayerPosterUseObjectINFO.setText("<b>Use Posters = OFF</b>");
                        }
                        int n189 = Result10.getInt("ScaffoldingUseObject");
                        if (PlayerScaffoldingUseObject == true) {
                            player.setAttribute("PlayerScaffoldingUseObject", true);
                            PlayerScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = ON</b>");
                        } else if (PlayerScaffoldingUseObject == false) {
                            player.setAttribute("PlayerScaffoldingUseObject", false);
                            PlayerScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = OFF</b>");
                        }
                        int n190 = Result10.getInt("SeatingUseObject");
                        if (PlayerSeatingUseObject == true) {
                            player.setAttribute("PlayerSeatingUseObject", true);
                            PlayerSeatingUseObjectINFO.setText("<b>Use Seating = ON</b>");
                        } else if (PlayerSeatingUseObject == false) {
                            player.setAttribute("PlayerSeatingUseObject", false);
                            PlayerSeatingUseObjectINFO.setText("<b>Use Seating = OFF</b>");
                        }
                        int n191 = Result10.getInt("ShootingTargetUseObject");
                        if (PlayerShootingTargetUseObject == true) {
                            player.setAttribute("PlayerShootingTargetUseObject", true);
                            PlayerShootingTargetUseObjectINFO.setText("<b>Use Targets = ON</b>");
                        } else if (PlayerShootingTargetUseObject == false) {
                            player.setAttribute("PlayerShootingTargetUseObject", false);
                            PlayerShootingTargetUseObjectINFO.setText("<b>Use Targets = OFF</b>");
                        }
                        int n192 = Result10.getInt("SignUseObject");
                        if (PlayerSignUseObject == true) {
                            player.setAttribute("PlayerSignUseObject", true);
                            PlayerSignUseObjectINFO.setText("<b>Use Signs = ON</b>");
                        } else if (PlayerSignUseObject == false) {
                            player.setAttribute("PlayerSignUseObject", false);
                            PlayerSignUseObjectINFO.setText("<b>Use Signs = OFF</b>");
                        }
                        int n193 = Result10.getInt("SpinningWheelUseObject");
                        if (PlayerSpinningWheelUseObject == true) {
                            player.setAttribute("PlayerSpinningWheelUseObject", true);
                            PlayerSpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = ON</b>");
                        } else if (PlayerSpinningWheelUseObject == false) {
                            player.setAttribute("PlayerSpinningWheelUseObject", false);
                            PlayerSpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = OFF</b>");
                        }
                        int n194 = Result10.getInt("StorageUseObject");
                        if (PlayerStorageUseObject == true) {
                            player.setAttribute("PlayerStorageUseObject", true);
                            PlayerStorageUseObjectINFO.setText("<b>Use Storage = ON</b>");
                        } else if (PlayerStorageUseObject == false) {
                            player.setAttribute("PlayerStorageUseObject", false);
                            PlayerStorageUseObjectINFO.setText("<b>Use Storage = OFF</b>");
                        }
                        int n195 = Result10.getInt("TanningRackUseObject");
                        if (PlayerTanningRackUseObject == true) {
                            player.setAttribute("PlayerTanningRackUseObject", true);
                            PlayerTanningRackUseObjectINFO.setText("<b>Use TanningRacks = ON</b>");
                        } else if (PlayerTanningRackUseObject == false) {
                            player.setAttribute("PlayerTanningRackUseObject", false);
                            PlayerTanningRackUseObjectINFO.setText("<b>Use TanningRacks = OFF</b>");
                        }
                        int n196 = Result10.getInt("TechnicalUseObject");
                        if (PlayerTechnicalUseObject == true) {
                            player.setAttribute("PlayerTechnicalUseObject", true);
                            PlayerTechnicalUseObjectINFO.setText("<b>Use Technicals = ON</b>");
                        } else if (PlayerTechnicalUseObject == false) {
                            player.setAttribute("PlayerTechnicalUseObject", false);
                            PlayerTechnicalUseObjectINFO.setText("<b>Use Technicals = OFF</b>");
                        }
                        int n197 = Result10.getInt("TorchUseObject");
                        if (PlayerTorchUseObject == true) {
                            player.setAttribute("PlayerTorchUseObject", true);
                            PlayerTorchUseObjectINFO.setText("<b>Use Torchs = ON</b>");
                        } else if (PlayerTorchUseObject == false) {
                            player.setAttribute("PlayerTorchUseObject", false);
                            PlayerTorchUseObjectINFO.setText("<b>Use Torchs = OFF</b>");
                        }
                        int n198 = Result10.getInt("TrashcanUseObject");
                        if (PlayerTrashcanUseObject == true) {
                            player.setAttribute("PlayerTrashcanUseObject", true);
                            PlayerTrashcanUseObjectINFO.setText("<b>Use Trashcans = ON</b>");
                        } else if (PlayerTrashcanUseObject == false) {
                            player.setAttribute("PlayerTrashcanUseObject", false);
                            PlayerTrashcanUseObjectINFO.setText("<b>Use Trashcans = OFF</b>");
                        }
                        int n199 = Result10.getInt("WorkbenchUseObject");
                        if (PlayerWorkbenchUseObject == true) {
                            player.setAttribute("PlayerWorkbenchUseObject", true);
                            PlayerWorkbenchUseObjectINFO.setText("<b>Use Workbenchs = ON</b>");
                        } else if (PlayerWorkbenchUseObject == false) {
                            player.setAttribute("PlayerWorkbenchUseObject", false);
                            PlayerWorkbenchUseObjectINFO.setText("<b>Use Workbenchs = OFF</b>");
                        }
                        int n200 = Result10.getInt("HitAnimalNPC");
                        if (PlayerHitAnimalNPC == true) {
                            player.setAttribute("PlayerHitAnimalNPC", true);
                            PlayerHitAnimalNPCINFO.setText("<b>Hit Animal NPCs = ON</b>");
                        } else if (PlayerHitAnimalNPC == false) {
                            player.setAttribute("PlayerHitAnimalNPC", false);
                            PlayerHitAnimalNPCINFO.setText("<b>Hit Animal NPCs = OFF</b>");
                        }
                        int n201 = Result10.getInt("HitHumanNPC");
                        if (PlayerHitHumanNPC == true) {
                            player.setAttribute("PlayerHitHumanNPC", true);
                            PlayerHitHumanNPCINFO.setText("<b>Hit Human NPCs = ON</b>");
                        } else if (PlayerHitHumanNPC == false) {
                            player.setAttribute("PlayerHitHumanNPC", false);
                            PlayerHitHumanNPCINFO.setText("<b>Hit Human NPCs = OFF</b>");
                        }
                        int n202 = Result10.getInt("HitMountNPC");
                        if (PlayerHitMountNPC == true) {
                            player.setAttribute("PlayerHitMountNPC", true);
                            PlayerHitMountNPCINFO.setText("<b>Hit Mount NPCs = ON</b>");
                        } else if (PlayerHitMountNPC == false) {
                            player.setAttribute("PlayerHitMountNPC", false);
                            PlayerHitMountNPCINFO.setText("<b>Hit Mount NPCs = OFF</b>");
                        }
                        int n203 = Result10.getInt("RideMountNPC");
                        if (PlayerRideMountNPC == true) {
                            player.setAttribute("PlayerRideMountNPC", true);
                            PlayerRideMountNPCINFO.setText("<b>Ride Mount NPCs = ON</b>");
                        } else if (PlayerRideMountNPC == false) {
                            player.setAttribute("PlayerRideMountNPC", false);
                            PlayerRideMountNPCINFO.setText("<b>Ride Mount NPCs = OFF</b>");
                        }
                        int n204 = Result10.getInt("PlaceBluePrints");
                        if (PlayerPlaceBluePrints == true) {
                            player.setAttribute("PlayerPlaceBluePrints", true);
                            PlayerPlaceBluePrintsINFO.setText("<b>Place Blue Prints = ON</b>");
                        } else if (PlayerPlaceBluePrints == false) {
                            player.setAttribute("PlayerPlaceBluePrints", false);
                            PlayerPlaceBluePrintsINFO.setText("<b>Place Blue Prints = OFF</b>");
                        }
                        int n205 = Result10.getInt("NpcAddSaddle");
                        if (PlayerNpcAddSaddle == true) {
                            player.setAttribute("PlayerNpcAddSaddle", true);
                            PlayerNpcAddSaddleINFO.setText("<b>Add Saddle = ON</b>");
                        } else if (PlayerNpcAddSaddle == false) {
                            player.setAttribute("PlayerNpcAddSaddle", false);
                            PlayerNpcAddSaddleINFO.setText("<b>Add Saddle = OFF</b>");
                        }
                        int n206 = Result10.getInt("NpcRemoveSaddle");
                        if (PlayerNpcRemoveSaddle == true) {
                            player.setAttribute("PlayerNpcRemoveSaddle", true);
                            PlayerNpcRemoveSaddleINFO.setText("<b>Remove Saddle = ON</b>");
                        } else if (PlayerNpcRemoveSaddle == false) {
                            player.setAttribute("PlayerNpcRemoveSaddle", false);
                            PlayerNpcRemoveSaddleINFO.setText("<b>Remove Saddle = OFF</b>");
                        }
                        int n207 = Result10.getInt("NpcAddSaddleBag");
                        if (PlayerNpcAddSaddleBag == true) {
                            player.setAttribute("PlayerNpcAddSaddleBag", true);
                            PlayerNpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = ON</b>");
                        } else if (PlayerNpcAddSaddleBag == false) {
                            player.setAttribute("PlayerNpcAddSaddleBag", false);
                            PlayerNpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = OFF</b>");
                        }
                        int n208 = Result10.getInt("NpcRemoveSaddleBag");
                        if (PlayerNpcRemoveSaddleBag == true) {
                            player.setAttribute("PlayerNpcRemoveSaddleBag", true);
                            PlayerNpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = ON</b>");
                        } else if (PlayerNpcRemoveSaddleBag == false) {
                            player.setAttribute("PlayerNpcRemoveSaddleBag", false);
                            PlayerNpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = OFF</b>");
                        }
                        int n209 = Result10.getInt("NpcAddClothes");
                        if (PlayerNpcAddClothes == true) {
                            player.setAttribute("PlayerNpcAddClothes", true);
                            PlayerNpcAddClothesINFO.setText("<b>Npc Add Clothes = ON</b>");
                        } else if (PlayerNpcAddClothes == false) {
                            player.setAttribute("PlayerNpcAddClothes", false);
                            PlayerNpcAddClothesINFO.setText("<b>Npc Add Clothes = OFF</b>");
                        }
                        int n210 = Result10.getInt("NpcRemoveClothes");
                        if (PlayerNpcRemoveClothes == true) {
                            player.setAttribute("PlayerNpcRemoveClothes", true);
                            PlayerNpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = ON</b>");
                        } else if (PlayerNpcRemoveClothes == false) {
                            player.setAttribute("PlayerNpcRemoveClothes", false);
                            PlayerNpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = OFF</b>");
                        }
                    } else {
                        SettingsWPPanel.setVisible(true);
                        PlayerToolsWPPanel.setVisible(false);
                        player.sendTextMessage("Error!! you need to own the area to use player setting here");
                    }
                    Result10.close();
                }
                finally {
                    if (Result10 != null) {
                        Result10.close();
                    }
                }
            }
            catch (SQLException Result10) {
                void ex12;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex12);
            }
        }
        if (eventID == WPNextButtonID) {
            AdminToolsWPPanel.setVisible(false);
            AdminToolsWPPanelPage2.setVisible(true);
        }
        if (eventID == WPNextButtonPage2ID) {
            AdminToolsWPPanelPage2.setVisible(false);
            AdminToolsWPPanelPage3.setVisible(true);
        }
        if (eventID == WPBackButtonPage3ID) {
            AdminToolsWPPanelPage2.setVisible(true);
            AdminToolsWPPanelPage3.setVisible(false);
        }
        if (eventID == WPBackButtonPage2ID) {
            AdminToolsWPPanelPage2.setVisible(false);
            AdminToolsWPPanel.setVisible(true);
        }
        if (eventID == WPBackButtonID) {
            SettingsWPPanel.setVisible(true);
            AdminToolsWPPanel.setVisible(false);
        }
        if (eventID == WPPlayerNextButtonID) {
            PlayerToolsWPPanel.setVisible(false);
            PlayerToolsWPPanelPage2.setVisible(true);
            player.sendTextMessage("page 2");
        }
        if (eventID == WPPlayerNextButtonPage2ID) {
            PlayerToolsWPPanelPage2.setVisible(false);
            PlayerToolsWPPanelPage3.setVisible(true);
            player.sendTextMessage("page 3");
        }
        if (eventID == WPPlayerBackButtonPage3ID) {
            PlayerToolsWPPanelPage2.setVisible(true);
            PlayerToolsWPPanelPage3.setVisible(false);
            player.sendTextMessage("page 2");
        }
        if (eventID == WPPlayerBackButtonPage2ID) {
            PlayerToolsWPPanelPage2.setVisible(false);
            PlayerToolsWPPanel.setVisible(true);
            player.sendTextMessage("page 1");
        }
        if (eventID == WPPlayerBackButtonID) {
            SettingsWPPanel.setVisible(true);
            PlayerToolsWPPanel.setVisible(false);
        }
        if (eventID == PointsEarnedAdjustUPID) {
            void NewPoints;
            void Points2;
            int ex12 = (Integer)player.getAttribute("PointsEarnedAdjust");
            void PlayerTreeDestroyVegetation = Points2 + true;
            player.setAttribute("PointsEarnedAdjust", (int)NewPoints);
            PointsEarnedAdjustInfo.setText("<b>Points per minute = " + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "</b>");
            this.database.executeUpdate("UPDATE AdminSettings SET PointsEarnedAdjust = '" + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "' WHERE ID = '1'");
        }
        if (eventID == PointsEarnedAdjustDownID) {
            int Points2 = (Integer)player.getAttribute("PointsEarnedAdjust");
            int NewPoints = Points2 - 1;
            if (NewPoints == 0) {
                NewPoints = 1;
                player.setAttribute("PointsEarnedAdjust", NewPoints);
                PointsEarnedAdjustInfo.setText("<b>Points per minute = " + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET PointsEarnedAdjust = '" + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "' WHERE ID = '1'");
            } else {
                player.setAttribute("PointsEarnedAdjust", NewPoints);
                PointsEarnedAdjustInfo.setText("<b>Points per minute = " + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET PointsEarnedAdjust = '" + String.valueOf(player.getAttribute("PointsEarnedAdjust")) + "' WHERE ID = '1'");
            }
        }
        if (eventID == AreaCostAdjustUPID) {
            int Points3 = (Integer)player.getAttribute("AreaCostAdjust");
            int NewPoints = Points3 + 1;
            player.setAttribute("AreaCostAdjust", NewPoints);
            AreaCostAdjustInfo.setText("<b>Cost Increase = " + String.valueOf(player.getAttribute("AreaCostAdjust")) + "</b>");
            this.database.executeUpdate("UPDATE AdminSettings SET AreaCostAdjust = '" + String.valueOf(player.getAttribute("AreaCostAdjust")) + "' WHERE ID = '1'");
        }
        if (eventID == AreaCostAdjustDownID) {
            int Points4 = (Integer)player.getAttribute("AreaCostAdjust");
            int NewPoints = Points4 - 1;
            if (NewPoints == 0) {
                NewPoints = 1;
                player.setAttribute("AreaCostAdjust", NewPoints);
                AreaCostAdjustInfo.setText("<b>Cost Increase = " + String.valueOf(player.getAttribute("AreaCostAdjust")) + "</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET AreaCostAdjust = '" + String.valueOf(player.getAttribute("AreaCostAdjust")) + "' WHERE ID = '1'");
            } else {
                player.setAttribute("AreaCostAdjust", NewPoints);
                AreaCostAdjustInfo.setText("<b>Cost Increase = " + String.valueOf(player.getAttribute("AreaCostAdjust")) + "</b>");
                this.database.executeUpdate("UPDATE AdminSettings SET AreaCostAdjust = '" + String.valueOf(player.getAttribute("AreaCostAdjust")) + "' WHERE ID = '1'");
            }
        }
        if (eventID == DestroyTerrainONID) {
            try {
                void Result11;
                ResultSet Points5 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result11.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DestroyTerrain = '1' WHERE ID = '1'");
                        DestroyTerrainINFO.setText("<b>Destroy Terrain = ON</b>");
                        player.setAttribute("DestroyTerrain", true);
                    }
                    Result11.close();
                }
                finally {
                    if (Result11 != null) {
                        Result11.close();
                    }
                }
            }
            catch (SQLException Result11) {
                void ex13;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex13);
            }
        }
        if (eventID == DestroyTerrainOFFID) {
            try {
                void Result12;
                ResultSet ex13 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result12.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DestroyTerrain = '0' WHERE ID = '1'");
                        DestroyTerrainINFO.setText("<b>Destroy Terrain = OFF</b>");
                        player.setAttribute("DestroyTerrain", false);
                    }
                    Result12.close();
                }
                finally {
                    if (Result12 != null) {
                        Result12.close();
                    }
                }
            }
            catch (SQLException Result12) {
                void ex14;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex14);
            }
        }
        if (eventID == HitTerrainONID) {
            try {
                void Result13;
                ResultSet ex14 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result13.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitTerrain = '1' WHERE ID = '1'");
                        HitTerrainINFO.setText("<b>Hit Terrain = ON</b>");
                        player.setAttribute("HitTerrain", true);
                    }
                    Result13.close();
                }
                finally {
                    if (Result13 != null) {
                        Result13.close();
                    }
                }
            }
            catch (SQLException Result13) {
                void ex15;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex15);
            }
        }
        if (eventID == HitTerrainOFFID) {
            try {
                void Result14;
                ResultSet ex15 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result14.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitTerrain = '0' WHERE ID = '1'");
                        HitTerrainINFO.setText("<b>Hit Terrain = OFF</b>");
                        player.setAttribute("HitTerrain", false);
                    }
                    Result14.close();
                }
                finally {
                    if (Result14 != null) {
                        Result14.close();
                    }
                }
            }
            catch (SQLException Result14) {
                void ex16;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex16);
            }
        }
        if (eventID == BedUseObjectONID) {
            try {
                void Result15;
                ResultSet ex16 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result15.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET BedUseObject = '1' WHERE ID = '1'");
                        BedUseObjectINFO.setText("<b>Use Beds = ON</b>");
                        player.setAttribute("BedUseObject", true);
                    }
                    Result15.close();
                }
                finally {
                    if (Result15 != null) {
                        Result15.close();
                    }
                }
            }
            catch (SQLException Result15) {
                void ex17;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex17);
            }
        }
        if (eventID == BedUseObjectOFFID) {
            try {
                void Result16;
                ResultSet ex17 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result16.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET BedUseObject = '0' WHERE ID = '1'");
                        BedUseObjectINFO.setText("<b>Use Beds = OFF</b>");
                        player.setAttribute("BedUseObject", false);
                    }
                    Result16.close();
                }
                finally {
                    if (Result16 != null) {
                        Result16.close();
                    }
                }
            }
            catch (SQLException Result16) {
                void ex18;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex18);
            }
        }
        if (eventID == CampfireUseObjectONID) {
            try {
                void Result17;
                ResultSet ex18 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result17.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET CampfireUseObject = '1' WHERE ID = '1'");
                        CampfireUseObjectINFO.setText("<b>Use Campfires = ON</b>");
                        player.setAttribute("CampfireUseObject", true);
                    }
                    Result17.close();
                }
                finally {
                    if (Result17 != null) {
                        Result17.close();
                    }
                }
            }
            catch (SQLException Result17) {
                void ex19;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex19);
            }
        }
        if (eventID == CampfireUseObjectOFFID) {
            try {
                void Result18;
                ResultSet ex19 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result18.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET CampfireUseObject = '0' WHERE ID = '1'");
                        CampfireUseObjectINFO.setText("<b>Use Campfires = OFF</b>");
                        player.setAttribute("CampfireUseObject", false);
                    }
                    Result18.close();
                }
                finally {
                    if (Result18 != null) {
                        Result18.close();
                    }
                }
            }
            catch (SQLException Result18) {
                void ex20;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex20);
            }
        }
        if (eventID == ClockUseObjectONID) {
            try {
                void Result19;
                ResultSet ex20 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result19.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ClockUseObject = '1' WHERE ID = '1'");
                        ClockUseObjectINFO.setText("<b>Use Clocks = ON</b>");
                        player.setAttribute("ClockUseObject", true);
                    }
                    Result19.close();
                }
                finally {
                    if (Result19 != null) {
                        Result19.close();
                    }
                }
            }
            catch (SQLException Result19) {
                void ex21;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex21);
            }
        }
        if (eventID == ClockUseObjectOFFID) {
            try {
                void Result20;
                ResultSet ex21 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result20.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ClockUseObject = '0' WHERE ID = '1'");
                        ClockUseObjectINFO.setText("<b>Use Clocks = OFF</b>");
                        player.setAttribute("ClockUseObject", false);
                    }
                    Result20.close();
                }
                finally {
                    if (Result20 != null) {
                        Result20.close();
                    }
                }
            }
            catch (SQLException Result20) {
                void ex22;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex22);
            }
        }
        if (eventID == DoorUseObjectONID) {
            try {
                void Result21;
                ResultSet ex22 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result21.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DoorUseObject = '1' WHERE ID = '1'");
                        DoorUseObjectINFO.setText("<b>Use Doors = ON</b>");
                        player.setAttribute("DoorUseObject", true);
                    }
                    Result21.close();
                }
                finally {
                    if (Result21 != null) {
                        Result21.close();
                    }
                }
            }
            catch (SQLException Result21) {
                void ex23;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex23);
            }
        }
        if (eventID == DoorUseObjectOFFID) {
            try {
                void Result22;
                ResultSet ex23 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result22.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DoorUseObject = '0' WHERE ID = '1'");
                        DoorUseObjectINFO.setText("<b>Use Doors = OFF</b>");
                        player.setAttribute("DoorUseObject", false);
                    }
                    Result22.close();
                }
                finally {
                    if (Result22 != null) {
                        Result22.close();
                    }
                }
            }
            catch (SQLException Result22) {
                void ex24;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex24);
            }
        }
        if (eventID == DryingRackUseObjectONID) {
            try {
                void Result23;
                ResultSet ex24 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result23.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DryingRackUseObject = '1' WHERE ID = '1'");
                        DryingRackUseObjectINFO.setText("<b>Use DryingRacks = ON</b>");
                        player.setAttribute("DryingRackUseObject", true);
                    }
                    Result23.close();
                }
                finally {
                    if (Result23 != null) {
                        Result23.close();
                    }
                }
            }
            catch (SQLException Result23) {
                void ex25;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex25);
            }
        }
        if (eventID == DryingRackUseObjectOFFID) {
            try {
                void Result24;
                ResultSet ex25 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result24.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET DryingRackUseObject = '0' WHERE ID = '1'");
                        DryingRackUseObjectINFO.setText("<b>Use DryingRacks = OFF</b>");
                        player.setAttribute("DryingRackUseObject", false);
                    }
                    Result24.close();
                }
                finally {
                    if (Result24 != null) {
                        Result24.close();
                    }
                }
            }
            catch (SQLException Result24) {
                void ex26;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex26);
            }
        }
        if (eventID == FireUseObjectONID) {
            try {
                void Result25;
                ResultSet ex26 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result25.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FireUseObject = '1' WHERE ID = '1'");
                        FireUseObjectINFO.setText("<b>Use Fires = ON</b>");
                        player.setAttribute("FireUseObject", true);
                    }
                    Result25.close();
                }
                finally {
                    if (Result25 != null) {
                        Result25.close();
                    }
                }
            }
            catch (SQLException Result25) {
                void ex27;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex27);
            }
        }
        if (eventID == FireUseObjectOFFID) {
            try {
                void Result26;
                ResultSet ex27 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result26.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FireUseObject = '0' WHERE ID = '1'");
                        FireUseObjectINFO.setText("<b>Use Fires = OFF</b>");
                        player.setAttribute("FireUseObject", false);
                    }
                    Result26.close();
                }
                finally {
                    if (Result26 != null) {
                        Result26.close();
                    }
                }
            }
            catch (SQLException Result26) {
                void ex28;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex28);
            }
        }
        if (eventID == FurnaceUseObjectONID) {
            try {
                void Result27;
                ResultSet ex28 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result27.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FurnaceUseObject = '1' WHERE ID = '1'");
                        FurnaceUseObjectINFO.setText("<b>Use Furnaces = ON</b>");
                        player.setAttribute("FurnaceUseObject", true);
                    }
                    Result27.close();
                }
                finally {
                    if (Result27 != null) {
                        Result27.close();
                    }
                }
            }
            catch (SQLException Result27) {
                void ex29;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex29);
            }
        }
        if (eventID == FurnaceUseObjectOFFID) {
            try {
                void Result28;
                ResultSet ex29 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result28.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FurnaceUseObject = '0' WHERE ID = '1'");
                        FurnaceUseObjectINFO.setText("<b>Use Furnaces = OFF</b>");
                        player.setAttribute("FurnaceUseObject", false);
                    }
                    Result28.close();
                }
                finally {
                    if (Result28 != null) {
                        Result28.close();
                    }
                }
            }
            catch (SQLException Result28) {
                void ex30;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex30);
            }
        }
        if (eventID == GrillUseObjectONID) {
            try {
                void Result29;
                ResultSet ex30 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result29.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrillUseObject = '1' WHERE ID = '1'");
                        GrillUseObjectINFO.setText("<b>Use Grills = ON</b>");
                        player.setAttribute("GrillUseObject", true);
                    }
                    Result29.close();
                }
                finally {
                    if (Result29 != null) {
                        Result29.close();
                    }
                }
            }
            catch (SQLException Result29) {
                void ex31;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex31);
            }
        }
        if (eventID == GrillUseObjectOFFID) {
            try {
                void Result30;
                ResultSet ex31 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result30.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrillUseObject = '0' WHERE ID = '1'");
                        GrillUseObjectINFO.setText("<b>Use Grills = OFF</b>");
                        player.setAttribute("GrillUseObject", false);
                    }
                    Result30.close();
                }
                finally {
                    if (Result30 != null) {
                        Result30.close();
                    }
                }
            }
            catch (SQLException Result30) {
                void ex32;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex32);
            }
        }
        if (eventID == GrinderUseObjectONID) {
            try {
                void Result31;
                ResultSet ex32 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result31.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrinderUseObject = '1' WHERE ID = '1'");
                        GrinderUseObjectINFO.setText("<b>Use Grinders = ON</b>");
                        player.setAttribute("GrinderUseObject", true);
                    }
                    Result31.close();
                }
                finally {
                    if (Result31 != null) {
                        Result31.close();
                    }
                }
            }
            catch (SQLException Result31) {
                void ex33;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex33);
            }
        }
        if (eventID == GrinderUseObjectOFFID) {
            try {
                void Result32;
                ResultSet ex33 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result32.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrinderUseObject = '0' WHERE ID = '1'");
                        GrinderUseObjectINFO.setText("<b>Use Grinders = OFF</b>");
                        player.setAttribute("GrinderUseObject", false);
                    }
                    Result32.close();
                }
                finally {
                    if (Result32 != null) {
                        Result32.close();
                    }
                }
            }
            catch (SQLException Result32) {
                void ex34;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex34);
            }
        }
        if (eventID == GrindstoneUseObjectONID) {
            try {
                void Result33;
                ResultSet ex34 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result33.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrindstoneUseObject = '1' WHERE ID = '1'");
                        GrindstoneUseObjectINFO.setText("<b>Use Grindstones = ON</b>");
                        player.setAttribute("GrindstoneUseObject", true);
                    }
                    Result33.close();
                }
                finally {
                    if (Result33 != null) {
                        Result33.close();
                    }
                }
            }
            catch (SQLException Result33) {
                void ex35;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex35);
            }
        }
        if (eventID == GrindstoneUseObjectOFFID) {
            try {
                void Result34;
                ResultSet ex35 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result34.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET GrindstoneUseObject = '0' WHERE ID = '1'");
                        GrindstoneUseObjectINFO.setText("<b>Use Grindstones = OFF</b>");
                        player.setAttribute("GrindstoneUseObject", false);
                    }
                    Result34.close();
                }
                finally {
                    if (Result34 != null) {
                        Result34.close();
                    }
                }
            }
            catch (SQLException Result34) {
                void ex36;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex36);
            }
        }
        if (eventID == LadderUseObjectONID) {
            try {
                void Result35;
                ResultSet ex36 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result35.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET LadderUseObject = '1' WHERE ID = '1'");
                        LadderUseObjectINFO.setText("<b>Use Ladders = ON</b>");
                        player.setAttribute("LadderUseObject", true);
                    }
                    Result35.close();
                }
                finally {
                    if (Result35 != null) {
                        Result35.close();
                    }
                }
            }
            catch (SQLException Result35) {
                void ex37;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex37);
            }
        }
        if (eventID == LadderUseObjectOFFID) {
            try {
                void Result36;
                ResultSet ex37 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result36.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET LadderUseObject = '0' WHERE ID = '1'");
                        LadderUseObjectINFO.setText("<b>Use Ladders = OFF</b>");
                        player.setAttribute("LadderUseObject", false);
                    }
                    Result36.close();
                }
                finally {
                    if (Result36 != null) {
                        Result36.close();
                    }
                }
            }
            catch (SQLException Result36) {
                void ex38;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex38);
            }
        }
        if (eventID == LampUseObjectONID) {
            try {
                void Result37;
                ResultSet ex38 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result37.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET LampUseObject = '1' WHERE ID = '1'");
                        LampUseObjectINFO.setText("<b>Use Lamps = ON</b>");
                        player.setAttribute("LampUseObject", true);
                    }
                    Result37.close();
                }
                finally {
                    if (Result37 != null) {
                        Result37.close();
                    }
                }
            }
            catch (SQLException Result37) {
                void ex39;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex39);
            }
        }
        if (eventID == LampUseObjectOFFID) {
            try {
                void Result38;
                ResultSet ex39 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result38.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET LampUseObject = '0' WHERE ID = '1'");
                        LampUseObjectINFO.setText("<b>Use Lamps = OFF</b>");
                        player.setAttribute("LampUseObject", false);
                    }
                    Result38.close();
                }
                finally {
                    if (Result38 != null) {
                        Result38.close();
                    }
                }
            }
            catch (SQLException Result38) {
                void ex40;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex40);
            }
        }
        if (eventID == MusicPlayerUseObjectONID) {
            try {
                void Result39;
                ResultSet ex40 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result39.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET MusicPlayerUseObject = '1' WHERE ID = '1'");
                        MusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = ON</b>");
                        player.setAttribute("MusicPlayerUseObject", true);
                    }
                    Result39.close();
                }
                finally {
                    if (Result39 != null) {
                        Result39.close();
                    }
                }
            }
            catch (SQLException Result39) {
                void ex41;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex41);
            }
        }
        if (eventID == MusicPlayerUseObjectOFFID) {
            try {
                void Result40;
                ResultSet ex41 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result40.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET MusicPlayerUseObject = '0' WHERE ID = '1'");
                        MusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = OFF</b>");
                        player.setAttribute("MusicPlayerUseObject", false);
                    }
                    Result40.close();
                }
                finally {
                    if (Result40 != null) {
                        Result40.close();
                    }
                }
            }
            catch (SQLException Result40) {
                void ex42;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex42);
            }
        }
        if (eventID == OvenUseObjectONID) {
            try {
                void Result41;
                ResultSet ex42 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result41.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET OvenUseObject = '1' WHERE ID = '1'");
                        OvenUseObjectINFO.setText("<b>Use Ovens = ON</b>");
                        player.setAttribute("OvenUseObject", true);
                    }
                    Result41.close();
                }
                finally {
                    if (Result41 != null) {
                        Result41.close();
                    }
                }
            }
            catch (SQLException Result41) {
                void ex43;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex43);
            }
        }
        if (eventID == OvenUseObjectOFFID) {
            try {
                void Result42;
                ResultSet ex43 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result42.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET OvenUseObject = '0' WHERE ID = '1'");
                        OvenUseObjectINFO.setText("<b>Use Ovens = OFF</b>");
                        player.setAttribute("OvenUseObject", false);
                    }
                    Result42.close();
                }
                finally {
                    if (Result42 != null) {
                        Result42.close();
                    }
                }
            }
            catch (SQLException Result42) {
                void ex44;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex44);
            }
        }
        if (eventID == PaperPressUseObjectONID) {
            try {
                void Result43;
                ResultSet ex44 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result43.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PaperPressUseObject = '1' WHERE ID = '1'");
                        PaperPressUseObjectINFO.setText("<b>Use PaperPress = ON</b>");
                        player.setAttribute("PaperPressUseObject", true);
                    }
                    Result43.close();
                }
                finally {
                    if (Result43 != null) {
                        Result43.close();
                    }
                }
            }
            catch (SQLException Result43) {
                void ex45;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex45);
            }
        }
        if (eventID == PaperPressUseObjectOFFID) {
            try {
                void Result44;
                ResultSet ex45 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result44.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PaperPressUseObject = '0' WHERE ID = '1'");
                        PaperPressUseObjectINFO.setText("<b>Use PaperPress = OFF</b>");
                        player.setAttribute("PaperPressUseObject", false);
                    }
                    Result44.close();
                }
                finally {
                    if (Result44 != null) {
                        Result44.close();
                    }
                }
            }
            catch (SQLException Result44) {
                void ex46;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex46);
            }
        }
        if (eventID == PianoUseObjectONID) {
            try {
                void Result45;
                ResultSet ex46 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result45.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PianoUseObject = '1' WHERE ID = '1'");
                        PianoUseObjectINFO.setText("<b>Use Pianos = ON</b>");
                        player.setAttribute("PianoUseObject", true);
                    }
                    Result45.close();
                }
                finally {
                    if (Result45 != null) {
                        Result45.close();
                    }
                }
            }
            catch (SQLException Result45) {
                void ex47;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex47);
            }
        }
        if (eventID == PianoUseObjectOFFID) {
            try {
                void Result46;
                ResultSet ex47 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result46.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PianoUseObject = '0' WHERE ID = '1'");
                        PianoUseObjectINFO.setText("<b>Use Pianos = OFF</b>");
                        player.setAttribute("PianoUseObject", false);
                    }
                    Result46.close();
                }
                finally {
                    if (Result46 != null) {
                        Result46.close();
                    }
                }
            }
            catch (SQLException Result46) {
                void ex48;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex48);
            }
        }
        if (eventID == PosterUseObjectONID) {
            try {
                void Result47;
                ResultSet ex48 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result47.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PosterUseObject = '1' WHERE ID = '1'");
                        PosterUseObjectINFO.setText("<b>Use Posters = ON</b>");
                        player.setAttribute("PosterUseObject", true);
                    }
                    Result47.close();
                }
                finally {
                    if (Result47 != null) {
                        Result47.close();
                    }
                }
            }
            catch (SQLException Result47) {
                void ex49;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex49);
            }
        }
        if (eventID == PosterUseObjectOFFID) {
            try {
                void Result48;
                ResultSet ex49 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result48.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PosterUseObject = '0' WHERE ID = '1'");
                        PosterUseObjectINFO.setText("<b>Use Posters = OFF</b>");
                        player.setAttribute("PosterUseObject", false);
                    }
                    Result48.close();
                }
                finally {
                    if (Result48 != null) {
                        Result48.close();
                    }
                }
            }
            catch (SQLException Result48) {
                void ex50;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex50);
            }
        }
        if (eventID == ScaffoldingUseObjectONID) {
            try {
                void Result49;
                ResultSet ex50 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result49.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ScaffoldingUseObject = '1' WHERE ID = '1'");
                        ScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = ON</b>");
                        player.setAttribute("ScaffoldingUseObject", true);
                    }
                    Result49.close();
                }
                finally {
                    if (Result49 != null) {
                        Result49.close();
                    }
                }
            }
            catch (SQLException Result49) {
                void ex51;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex51);
            }
        }
        if (eventID == ScaffoldingUseObjectOFFID) {
            try {
                void Result50;
                ResultSet ex51 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result50.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ScaffoldingUseObject = '0' WHERE ID = '1'");
                        ScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = OFF</b>");
                        player.setAttribute("ScaffoldingUseObject", false);
                    }
                    Result50.close();
                }
                finally {
                    if (Result50 != null) {
                        Result50.close();
                    }
                }
            }
            catch (SQLException Result50) {
                void ex52;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex52);
            }
        }
        if (eventID == SeatingUseObjectONID) {
            try {
                void Result51;
                ResultSet ex52 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result51.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SeatingUseObject = '1' WHERE ID = '1'");
                        SeatingUseObjectINFO.setText("<b>Use Seating = ON</b>");
                        player.setAttribute("SeatingUseObject", true);
                    }
                    Result51.close();
                }
                finally {
                    if (Result51 != null) {
                        Result51.close();
                    }
                }
            }
            catch (SQLException Result51) {
                void ex53;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex53);
            }
        }
        if (eventID == SeatingUseObjectOFFID) {
            try {
                void Result52;
                ResultSet ex53 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result52.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SeatingUseObject = '0' WHERE ID = '1'");
                        SeatingUseObjectINFO.setText("<b>Use Seating = OFF</b>");
                        player.setAttribute("SeatingUseObject", false);
                    }
                    Result52.close();
                }
                finally {
                    if (Result52 != null) {
                        Result52.close();
                    }
                }
            }
            catch (SQLException Result52) {
                void ex54;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex54);
            }
        }
        if (eventID == ShootingTargetUseObjectONID) {
            try {
                void Result53;
                ResultSet ex54 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result53.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ShootingTargetUseObject = '1' WHERE ID = '1'");
                        ShootingTargetUseObjectINFO.setText("<b>Use Targets = ON</b>");
                        player.setAttribute("ShootingTargetUseObject", true);
                    }
                    Result53.close();
                }
                finally {
                    if (Result53 != null) {
                        Result53.close();
                    }
                }
            }
            catch (SQLException Result53) {
                void ex55;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex55);
            }
        }
        if (eventID == ShootingTargetUseObjectOFFID) {
            try {
                void Result54;
                ResultSet ex55 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result54.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET ShootingTargetUseObject = '0' WHERE ID = '1'");
                        ShootingTargetUseObjectINFO.setText("<b>Use Targets = OFF</b>");
                        player.setAttribute("ShootingTargetUseObject", false);
                    }
                    Result54.close();
                }
                finally {
                    if (Result54 != null) {
                        Result54.close();
                    }
                }
            }
            catch (SQLException Result54) {
                void ex56;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex56);
            }
        }
        if (eventID == SignUseObjectONID) {
            try {
                void Result55;
                ResultSet ex56 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result55.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SignUseObject = '1' WHERE ID = '1'");
                        SignUseObjectINFO.setText("<b>Use Signs = ON</b>");
                        player.setAttribute("SignUseObject", true);
                    }
                    Result55.close();
                }
                finally {
                    if (Result55 != null) {
                        Result55.close();
                    }
                }
            }
            catch (SQLException Result55) {
                void ex57;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex57);
            }
        }
        if (eventID == SignUseObjectOFFID) {
            try {
                void Result56;
                ResultSet ex57 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result56.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SignUseObject = '0' WHERE ID = '1'");
                        SignUseObjectINFO.setText("<b>Use Signs = OFF</b>");
                        player.setAttribute("SignUseObject", false);
                    }
                    Result56.close();
                }
                finally {
                    if (Result56 != null) {
                        Result56.close();
                    }
                }
            }
            catch (SQLException Result56) {
                void ex58;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex58);
            }
        }
        if (eventID == SpinningWheelUseObjectONID) {
            try {
                void Result57;
                ResultSet ex58 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result57.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SpinningWheelUseObject = '1' WHERE ID = '1'");
                        SpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = ON</b>");
                        player.setAttribute("SpinningWheelUseObject", true);
                    }
                    Result57.close();
                }
                finally {
                    if (Result57 != null) {
                        Result57.close();
                    }
                }
            }
            catch (SQLException Result57) {
                void ex59;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex59);
            }
        }
        if (eventID == SpinningWheelUseObjectOFFID) {
            try {
                void Result58;
                ResultSet ex59 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result58.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET SpinningWheelUseObject = '0' WHERE ID = '1'");
                        SpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = OFF</b>");
                        player.setAttribute("SpinningWheelUseObject", false);
                    }
                    Result58.close();
                }
                finally {
                    if (Result58 != null) {
                        Result58.close();
                    }
                }
            }
            catch (SQLException Result58) {
                void ex60;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex60);
            }
        }
        if (eventID == StorageUseObjectONID) {
            try {
                void Result59;
                ResultSet ex60 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result59.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET StorageUseObject = '1' WHERE ID = '1'");
                        StorageUseObjectINFO.setText("<b>Use Storages = ON</b>");
                        player.setAttribute("StorageUseObject", true);
                    }
                    Result59.close();
                }
                finally {
                    if (Result59 != null) {
                        Result59.close();
                    }
                }
            }
            catch (SQLException Result59) {
                void ex61;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex61);
            }
        }
        if (eventID == StorageUseObjectOFFID) {
            try {
                void Result60;
                ResultSet ex61 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result60.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET StorageUseObject = '0' WHERE ID = '1'");
                        StorageUseObjectINFO.setText("<b>Use Storages = OFF</b>");
                        player.setAttribute("StorageUseObject", false);
                    }
                    Result60.close();
                }
                finally {
                    if (Result60 != null) {
                        Result60.close();
                    }
                }
            }
            catch (SQLException Result60) {
                void ex62;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex62);
            }
        }
        if (eventID == TanningRackUseObjectONID) {
            try {
                void Result61;
                ResultSet ex62 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result61.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TanningRackUseObject = '1' WHERE ID = '1'");
                        TanningRackUseObjectINFO.setText("<b>Use TanningRacks = ON</b>");
                        player.setAttribute("TanningRackUseObject", true);
                    }
                    Result61.close();
                }
                finally {
                    if (Result61 != null) {
                        Result61.close();
                    }
                }
            }
            catch (SQLException Result61) {
                void ex63;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex63);
            }
        }
        if (eventID == TanningRackUseObjectOFFID) {
            try {
                void Result62;
                ResultSet ex63 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result62.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TanningRackUseObject = '0' WHERE ID = '1'");
                        TanningRackUseObjectINFO.setText("<b>Use TanningRacks = OFF</b>");
                        player.setAttribute("TanningRackUseObject", false);
                    }
                    Result62.close();
                }
                finally {
                    if (Result62 != null) {
                        Result62.close();
                    }
                }
            }
            catch (SQLException Result62) {
                void ex64;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex64);
            }
        }
        if (eventID == TechnicalUseObjectONID) {
            try {
                void Result63;
                ResultSet ex64 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result63.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TechnicalUseObject = '1' WHERE ID = '1'");
                        TechnicalUseObjectINFO.setText("<b>Use Technicals = ON</b>");
                        player.setAttribute("TechnicalUseObject", true);
                    }
                    Result63.close();
                }
                finally {
                    if (Result63 != null) {
                        Result63.close();
                    }
                }
            }
            catch (SQLException Result63) {
                void ex65;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex65);
            }
        }
        if (eventID == TechnicalUseObjectOFFID) {
            try {
                void Result64;
                ResultSet ex65 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result64.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TechnicalUseObject = '0' WHERE ID = '1'");
                        TechnicalUseObjectINFO.setText("<b>Use Technicals = OFF</b>");
                        player.setAttribute("TechnicalUseObject", false);
                    }
                    Result64.close();
                }
                finally {
                    if (Result64 != null) {
                        Result64.close();
                    }
                }
            }
            catch (SQLException Result64) {
                void ex66;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex66);
            }
        }
        if (eventID == TorchUseObjectONID) {
            try {
                void Result65;
                ResultSet ex66 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result65.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TorchUseObject = '1' WHERE ID = '1'");
                        TorchUseObjectINFO.setText("<b>Use Torchs = ON</b>");
                        player.setAttribute("TorchUseObject", true);
                    }
                    Result65.close();
                }
                finally {
                    if (Result65 != null) {
                        Result65.close();
                    }
                }
            }
            catch (SQLException Result65) {
                void ex67;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex67);
            }
        }
        if (eventID == TorchUseObjectOFFID) {
            try {
                void Result66;
                ResultSet ex67 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result66.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TorchUseObject = '0' WHERE ID = '1'");
                        TorchUseObjectINFO.setText("<b>Use Torchs = OFF</b>");
                        player.setAttribute("TorchUseObject", false);
                    }
                    Result66.close();
                }
                finally {
                    if (Result66 != null) {
                        Result66.close();
                    }
                }
            }
            catch (SQLException Result66) {
                void ex68;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex68);
            }
        }
        if (eventID == TrashcanUseObjectONID) {
            try {
                void Result67;
                ResultSet ex68 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result67.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrashcanUseObject = '1' WHERE ID = '1'");
                        TrashcanUseObjectINFO.setText("<b>Use Trashcans = ON</b>");
                        player.setAttribute("TrashcanUseObject", true);
                    }
                    Result67.close();
                }
                finally {
                    if (Result67 != null) {
                        Result67.close();
                    }
                }
            }
            catch (SQLException Result67) {
                void ex69;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex69);
            }
        }
        if (eventID == TrashcanUseObjectOFFID) {
            try {
                void Result68;
                ResultSet ex69 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result68.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET Trashcans = '0' WHERE ID = '1'");
                        TrashcanUseObjectINFO.setText("<b>Use Trashcans = OFF</b>");
                        player.setAttribute("TrashcanUseObject", false);
                    }
                    Result68.close();
                }
                finally {
                    if (Result68 != null) {
                        Result68.close();
                    }
                }
            }
            catch (SQLException Result68) {
                void ex70;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex70);
            }
        }
        if (eventID == WorkbenchUseObjectONID) {
            try {
                void Result69;
                ResultSet ex70 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result69.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET WorkbenchUseObject = '1' WHERE ID = '1'");
                        WorkbenchUseObjectINFO.setText("<b>Use Workbenchs = ON</b>");
                        player.setAttribute("WorkbenchUseObject", true);
                    }
                    Result69.close();
                }
                finally {
                    if (Result69 != null) {
                        Result69.close();
                    }
                }
            }
            catch (SQLException Result69) {
                void ex71;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex71);
            }
        }
        if (eventID == WorkbenchUseObjectOFFID) {
            try {
                void Result70;
                ResultSet ex71 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result70.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET WorkbenchUseObject = '0' WHERE ID = '1'");
                        WorkbenchUseObjectINFO.setText("<b>Use Workbenchs = OFF</b>");
                        player.setAttribute("WorkbenchUseObject", false);
                    }
                    Result70.close();
                }
                finally {
                    if (Result70 != null) {
                        Result70.close();
                    }
                }
            }
            catch (SQLException Result70) {
                void ex72;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex72);
            }
        }
        if (eventID == HitAnimalNPCONID) {
            try {
                void Result71;
                ResultSet ex72 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result71.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitAnimalNPC = '1' WHERE ID = '1'");
                        HitAnimalNPCINFO.setText("<b>Hit Animal NPCs = ON</b>");
                        player.setAttribute("HitAnimalNPC", true);
                    }
                    Result71.close();
                }
                finally {
                    if (Result71 != null) {
                        Result71.close();
                    }
                }
            }
            catch (SQLException Result71) {
                void ex73;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex73);
            }
        }
        if (eventID == HitAnimalNPCOFFID) {
            try {
                void Result72;
                ResultSet ex73 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result72.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitAnimalNPC = '0' WHERE ID = '1'");
                        HitAnimalNPCINFO.setText("<b>Hit Animal NPCs = OFF</b>");
                        player.setAttribute("HitAnimalNPC", false);
                    }
                    Result72.close();
                }
                finally {
                    if (Result72 != null) {
                        Result72.close();
                    }
                }
            }
            catch (SQLException Result72) {
                void ex74;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex74);
            }
        }
        if (eventID == HitHumanNPCONID) {
            try {
                void Result73;
                ResultSet ex74 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result73.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitHumanNPC = '1' WHERE ID = '1'");
                        HitHumanNPCINFO.setText("<b>Hit Human NPCs = ON</b>");
                        player.setAttribute("HitHumanNPC", true);
                    }
                    Result73.close();
                }
                finally {
                    if (Result73 != null) {
                        Result73.close();
                    }
                }
            }
            catch (SQLException Result73) {
                void ex75;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex75);
            }
        }
        if (eventID == HitHumanNPCOFFID) {
            try {
                void Result74;
                ResultSet ex75 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result74.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitHumanNPC = '0' WHERE ID = '1'");
                        HitHumanNPCINFO.setText("<b>Hit Human NPCs = OFF</b>");
                        player.setAttribute("HitHumanNPC", false);
                    }
                    Result74.close();
                }
                finally {
                    if (Result74 != null) {
                        Result74.close();
                    }
                }
            }
            catch (SQLException Result74) {
                void ex76;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex76);
            }
        }
        if (eventID == HitMountNPCONID) {
            try {
                void Result75;
                ResultSet ex76 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result75.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitMountNPC = '1' WHERE ID = '1'");
                        HitMountNPCINFO.setText("<b>Hit Mount NPCs = ON</b>");
                        player.setAttribute("HitMountNPC", true);
                    }
                    Result75.close();
                }
                finally {
                    if (Result75 != null) {
                        Result75.close();
                    }
                }
            }
            catch (SQLException Result75) {
                void ex77;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex77);
            }
        }
        if (eventID == HitMountNPCOFFID) {
            try {
                void Result76;
                ResultSet ex77 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result76.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET HitMountNPC = '0' WHERE ID = '1'");
                        HitMountNPCINFO.setText("<b>Hit Mount NPCs = OFF</b>");
                        player.setAttribute("HitMountNPC", false);
                    }
                    Result76.close();
                }
                finally {
                    if (Result76 != null) {
                        Result76.close();
                    }
                }
            }
            catch (SQLException Result76) {
                void ex78;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex78);
            }
        }
        if (eventID == RideMountNPCONID) {
            try {
                void Result77;
                ResultSet ex78 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result77.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RideMountNPC = '1' WHERE ID = '1'");
                        RideMountNPCINFO.setText("<b>Ride Mount NPCs = ON</b>");
                        player.setAttribute("RideMountNPC", true);
                    }
                    Result77.close();
                }
                finally {
                    if (Result77 != null) {
                        Result77.close();
                    }
                }
            }
            catch (SQLException Result77) {
                void ex79;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex79);
            }
        }
        if (eventID == RideMountNPCOFFID) {
            try {
                void Result78;
                ResultSet ex79 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result78.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RideMountNPC = '0' WHERE ID = '1'");
                        RideMountNPCINFO.setText("<b>Ride Mount NPCs = OFF</b>");
                        player.setAttribute("RideMountNPC", false);
                    }
                    Result78.close();
                }
                finally {
                    if (Result78 != null) {
                        Result78.close();
                    }
                }
            }
            catch (SQLException Result78) {
                void ex80;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex80);
            }
        }
        if (eventID == PlaceBluePrintsONID) {
            try {
                void Result79;
                ResultSet ex80 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result79.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PlaceBluePrints = '1' WHERE ID = '1'");
                        PlaceBluePrintsINFO.setText("<b>Place Blue Prints = ON</b>");
                        player.setAttribute("PlaceBluePrints", true);
                    }
                    Result79.close();
                }
                finally {
                    if (Result79 != null) {
                        Result79.close();
                    }
                }
            }
            catch (SQLException Result79) {
                void ex81;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex81);
            }
        }
        if (eventID == PlaceBluePrintsOFFID) {
            try {
                void Result80;
                ResultSet ex81 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result80.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PlaceBluePrints = '0' WHERE ID = '1'");
                        PlaceBluePrintsINFO.setText("<b>Place Blue Prints = OFF</b>");
                        player.setAttribute("PlaceBluePrints", false);
                    }
                    Result80.close();
                }
                finally {
                    if (Result80 != null) {
                        Result80.close();
                    }
                }
            }
            catch (SQLException Result80) {
                void ex82;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex82);
            }
        }
        if (eventID == NpcAddSaddleONID) {
            try {
                void Result81;
                ResultSet ex82 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result81.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddSaddle = '1' WHERE ID = '1'");
                        NpcAddSaddleINFO.setText("<b>Add Saddle = ON</b>");
                        player.setAttribute("NpcAddSaddle", true);
                    }
                    Result81.close();
                }
                finally {
                    if (Result81 != null) {
                        Result81.close();
                    }
                }
            }
            catch (SQLException Result81) {
                void ex83;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex83);
            }
        }
        if (eventID == NpcAddSaddleOFFID) {
            try {
                void Result82;
                ResultSet ex83 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result82.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddSaddle = '0' WHERE ID = '1'");
                        NpcAddSaddleINFO.setText("<b>Add Saddle = OFF</b>");
                        player.setAttribute("NpcAddSaddle", false);
                    }
                    Result82.close();
                }
                finally {
                    if (Result82 != null) {
                        Result82.close();
                    }
                }
            }
            catch (SQLException Result82) {
                void ex84;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex84);
            }
        }
        if (eventID == NpcRemoveSaddleONID) {
            try {
                void Result83;
                ResultSet ex84 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result83.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveSaddle = '1' WHERE ID = '1'");
                        NpcRemoveSaddleINFO.setText("<b>Remove Saddle = ON</b>");
                        player.setAttribute("NpcRemoveSaddle", true);
                    }
                    Result83.close();
                }
                finally {
                    if (Result83 != null) {
                        Result83.close();
                    }
                }
            }
            catch (SQLException Result83) {
                void ex85;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex85);
            }
        }
        if (eventID == NpcRemoveSaddleOFFID) {
            try {
                void Result84;
                ResultSet ex85 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result84.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveSaddle = '0' WHERE ID = '1'");
                        NpcRemoveSaddleINFO.setText("<b>Remove Saddle = OFF</b>");
                        player.setAttribute("NpcRemoveSaddle", false);
                    }
                    Result84.close();
                }
                finally {
                    if (Result84 != null) {
                        Result84.close();
                    }
                }
            }
            catch (SQLException Result84) {
                void ex86;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex86);
            }
        }
        if (eventID == NpcAddSaddleBagONID) {
            try {
                void Result85;
                ResultSet ex86 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result85.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddSaddleBag = '1' WHERE ID = '1'");
                        NpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = ON</b>");
                        player.setAttribute("NpcAddSaddleBag", true);
                    }
                    Result85.close();
                }
                finally {
                    if (Result85 != null) {
                        Result85.close();
                    }
                }
            }
            catch (SQLException Result85) {
                void ex87;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex87);
            }
        }
        if (eventID == NpcAddSaddleBagOFFID) {
            try {
                void Result86;
                ResultSet ex87 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result86.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddSaddleBag = '0' WHERE ID = '1'");
                        NpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = OFF</b>");
                        player.setAttribute("NpcAddSaddleBag", false);
                    }
                    Result86.close();
                }
                finally {
                    if (Result86 != null) {
                        Result86.close();
                    }
                }
            }
            catch (SQLException Result86) {
                void ex88;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex88);
            }
        }
        if (eventID == NpcRemoveSaddleBagONID) {
            try {
                void Result87;
                ResultSet ex88 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result87.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveSaddleBag = '1' WHERE ID = '1'");
                        NpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = ON</b>");
                        player.setAttribute("NpcRemoveSaddleBag", true);
                    }
                    Result87.close();
                }
                finally {
                    if (Result87 != null) {
                        Result87.close();
                    }
                }
            }
            catch (SQLException Result87) {
                void ex89;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex89);
            }
        }
        if (eventID == NpcRemoveSaddleBagOFFID) {
            try {
                void Result88;
                ResultSet ex89 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result88.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveSaddleBag = '0' WHERE ID = '1'");
                        NpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = OFF</b>");
                        player.setAttribute("NpcRemoveSaddleBag", false);
                    }
                    Result88.close();
                }
                finally {
                    if (Result88 != null) {
                        Result88.close();
                    }
                }
            }
            catch (SQLException Result88) {
                void ex90;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex90);
            }
        }
        if (eventID == NpcAddClothesONID) {
            try {
                void Result89;
                ResultSet ex90 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result89.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddClothes = '1' WHERE ID = '1'");
                        NpcAddClothesINFO.setText("<b>Npc Add Clothes = ON</b>");
                        player.setAttribute("NpcAddClothes", true);
                    }
                    Result89.close();
                }
                finally {
                    if (Result89 != null) {
                        Result89.close();
                    }
                }
            }
            catch (SQLException Result89) {
                void ex91;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex91);
            }
        }
        if (eventID == NpcAddClothesOFFID) {
            try {
                void Result90;
                ResultSet ex91 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result90.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcAddClothes = '0' WHERE ID = '1'");
                        NpcAddClothesINFO.setText("<b>Npc Add Clothes = OFF</b>");
                        player.setAttribute("NpcAddClothes", false);
                    }
                    Result90.close();
                }
                finally {
                    if (Result90 != null) {
                        Result90.close();
                    }
                }
            }
            catch (SQLException Result90) {
                void ex92;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex92);
            }
        }
        if (eventID == NpcRemoveClothesONID) {
            try {
                void Result91;
                ResultSet ex92 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result91.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveClothes = '1' WHERE ID = '1'");
                        NpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = ON</b>");
                        player.setAttribute("NpcRemoveClothes", true);
                    }
                    Result91.close();
                }
                finally {
                    if (Result91 != null) {
                        Result91.close();
                    }
                }
            }
            catch (SQLException Result91) {
                void ex93;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex93);
            }
        }
        if (eventID == NpcRemoveClothesOFFID) {
            try {
                void Result92;
                ResultSet ex93 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result92.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET NpcRemoveClothes = '0' WHERE ID = '1'");
                        NpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = OFF</b>");
                        player.setAttribute("NpcRemoveClothes", false);
                    }
                    Result92.close();
                }
                finally {
                    if (Result92 != null) {
                        Result92.close();
                    }
                }
            }
            catch (SQLException Result92) {
                void ex94;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex94);
            }
        }
        if (eventID == TreeDestroyVegetationONID) {
            try {
                void Result93;
                ResultSet ex94 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result93.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeDestroyVegetation = '1' WHERE ID = '1'");
                        TreeDestroyVegetationINFO.setText("<b>Tree Destroy = ON</b>");
                        player.setAttribute("TreeDestroyVegetation", true);
                    }
                    Result93.close();
                }
                finally {
                    if (Result93 != null) {
                        Result93.close();
                    }
                }
            }
            catch (SQLException Result93) {
                void ex95;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex95);
            }
        }
        if (eventID == TreeDestroyVegetationOFFID) {
            try {
                void Result94;
                ResultSet ex95 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result94.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeDestroyVegetation = '0' WHERE ID = '1'");
                        TreeDestroyVegetationINFO.setText("<b>Tree Destroy = OFF</b>");
                        player.setAttribute("TreeDestroyVegetation", false);
                    }
                    Result94.close();
                }
                finally {
                    if (Result94 != null) {
                        Result94.close();
                    }
                }
            }
            catch (SQLException Result94) {
                void ex96;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex96);
            }
        }
        if (eventID == TrunkDestroyVegetationONID) {
            try {
                void Result95;
                ResultSet ex96 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result95.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkDestroyVegetation = '1' WHERE ID = '1'");
                        TrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = ON</b>");
                        player.setAttribute("TrunkDestroyVegetation", true);
                    }
                    Result95.close();
                }
                finally {
                    if (Result95 != null) {
                        Result95.close();
                    }
                }
            }
            catch (SQLException Result95) {
                void ex97;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex97);
            }
        }
        if (eventID == TrunkDestroyVegetationOFFID) {
            try {
                void Result96;
                ResultSet ex97 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result96.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkDestroyVegetation = '0' WHERE ID = '1'");
                        TrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = OFF</b>");
                        player.setAttribute("TrunkDestroyVegetation", false);
                    }
                    Result96.close();
                }
                finally {
                    if (Result96 != null) {
                        Result96.close();
                    }
                }
            }
            catch (SQLException Result96) {
                void ex98;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex98);
            }
        }
        if (eventID == TreeHitVegetationONID) {
            try {
                void Result97;
                ResultSet ex98 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result97.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeHitVegetation = '1' WHERE ID = '1'");
                        TreeHitVegetationINFO.setText("<b>Tree Hit = ON</b>");
                        player.setAttribute("TreeHitVegetation", true);
                    }
                    Result97.close();
                }
                finally {
                    if (Result97 != null) {
                        Result97.close();
                    }
                }
            }
            catch (SQLException Result97) {
                void ex99;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex99);
            }
        }
        if (eventID == TreeHitVegetationOFFID) {
            try {
                void Result98;
                ResultSet ex99 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result98.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeHitVegetation = '0' WHERE ID = '1'");
                        TreeHitVegetationINFO.setText("<b>Tree Hit = OFF</b>");
                        player.setAttribute("TreeHitVegetation", false);
                    }
                    Result98.close();
                }
                finally {
                    if (Result98 != null) {
                        Result98.close();
                    }
                }
            }
            catch (SQLException Result98) {
                void ex100;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex100);
            }
        }
        if (eventID == TrunkHitVegetationONID) {
            try {
                void Result99;
                ResultSet ex100 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result99.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkHitVegetation = '1' WHERE ID = '1'");
                        TrunkHitVegetationINFO.setText("<b>OldLog Hit = ON</b>");
                        player.setAttribute("TrunkHitVegetation", true);
                    }
                    Result99.close();
                }
                finally {
                    if (Result99 != null) {
                        Result99.close();
                    }
                }
            }
            catch (SQLException Result99) {
                void ex101;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex101);
            }
        }
        if (eventID == TrunkHitVegetationOFFID) {
            try {
                void Result100;
                ResultSet ex101 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result100.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkHitVegetation = '0' WHERE ID = '1'");
                        TrunkHitVegetationINFO.setText("<b>OldLog Hit = OFF</b>");
                        player.setAttribute("TrunkHitVegetation", false);
                    }
                    Result100.close();
                }
                finally {
                    if (Result100 != null) {
                        Result100.close();
                    }
                }
            }
            catch (SQLException Result100) {
                void ex102;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex102);
            }
        }
        if (eventID == TreeRemoveVegetationONID) {
            try {
                void Result101;
                ResultSet ex102 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result101.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeRemoveVegetation = '1' WHERE ID = '1'");
                        TreeRemoveVegetationINFO.setText("<b>Tree Remove = ON</b>");
                        player.setAttribute("TreeRemoveVegetation", true);
                    }
                    Result101.close();
                }
                finally {
                    if (Result101 != null) {
                        Result101.close();
                    }
                }
            }
            catch (SQLException Result101) {
                void ex103;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex103);
            }
        }
        if (eventID == TreeRemoveVegetationOFFID) {
            try {
                void Result102;
                ResultSet ex103 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result102.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TreeRemoveVegetation = '0' WHERE ID = '1'");
                        TreeRemoveVegetationINFO.setText("<b>Tree Remove = OFF</b>");
                        player.setAttribute("TreeRemoveVegetation", false);
                    }
                    Result102.close();
                }
                finally {
                    if (Result102 != null) {
                        Result102.close();
                    }
                }
            }
            catch (SQLException Result102) {
                void ex104;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex104);
            }
        }
        if (eventID == TrunkRemoveVegetationONID) {
            try {
                void Result103;
                ResultSet ex104 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result103.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkRemoveVegetation = '1' WHERE ID = '1'");
                        TrunkRemoveVegetationINFO.setText("<b>OldLog Remove = ON</b>");
                        player.setAttribute("TrunkRemoveVegetation", true);
                    }
                    Result103.close();
                }
                finally {
                    if (Result103 != null) {
                        Result103.close();
                    }
                }
            }
            catch (SQLException Result103) {
                void ex105;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex105);
            }
        }
        if (eventID == TrunkRemoveVegetationOFFID) {
            try {
                void Result104;
                ResultSet ex105 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result104.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET TrunkRemoveVegetation = '0' WHERE ID = '1'");
                        TrunkRemoveVegetationINFO.setText("<b>OldLog Remove = OFF</b>");
                        player.setAttribute("TrunkRemoveVegetation", false);
                    }
                    Result104.close();
                }
                finally {
                    if (Result104 != null) {
                        Result104.close();
                    }
                }
            }
            catch (SQLException Result104) {
                void ex106;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex106);
            }
        }
        if (eventID == CropRemoveVegetationONID) {
            try {
                void Result105;
                ResultSet ex106 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result105.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET CropRemoveVegetation = '1' WHERE ID = '1'");
                        CropRemoveVegetationINFO.setText("<b>Crop Remove = ON</b>");
                        player.setAttribute("CropRemoveVegetation", true);
                    }
                    Result105.close();
                }
                finally {
                    if (Result105 != null) {
                        Result105.close();
                    }
                }
            }
            catch (SQLException Result105) {
                void ex107;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex107);
            }
        }
        if (eventID == CropRemoveVegetationOFFID) {
            try {
                void Result106;
                ResultSet ex107 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result106.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET CropRemoveVegetation = '0' WHERE ID = '1'");
                        CropRemoveVegetationINFO.setText("<b>Crop Remove = OFF</b>");
                        player.setAttribute("CropRemoveVegetation", false);
                    }
                    Result106.close();
                }
                finally {
                    if (Result106 != null) {
                        Result106.close();
                    }
                }
            }
            catch (SQLException Result106) {
                void ex108;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex108);
            }
        }
        if (eventID == FruitTreeRemoveVegetationONID) {
            try {
                void Result107;
                ResultSet ex108 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result107.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FruitTreeRemoveVegetation = '1' WHERE ID = '1'");
                        FruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = ON</b>");
                        player.setAttribute("FruitTreeRemoveVegetation", true);
                    }
                    Result107.close();
                }
                finally {
                    if (Result107 != null) {
                        Result107.close();
                    }
                }
            }
            catch (SQLException Result107) {
                void ex109;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex109);
            }
        }
        if (eventID == FruitTreeRemoveVegetationOFFID) {
            try {
                void Result108;
                ResultSet ex109 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result108.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET FruitTreeRemoveVegetation = '0' WHERE ID = '1'");
                        FruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = OFF</b>");
                        player.setAttribute("FruitTreeRemoveVegetation", false);
                    }
                    Result108.close();
                }
                finally {
                    if (Result108 != null) {
                        Result108.close();
                    }
                }
            }
            catch (SQLException Result108) {
                void ex110;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex110);
            }
        }
        if (eventID == PlantRemoveVegetationONID) {
            try {
                void Result109;
                ResultSet ex110 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result109.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PlantRemoveVegetation = '1' WHERE ID = '1'");
                        PlantRemoveVegetationINFO.setText("<b>Plant Remove = ON</b>");
                        player.setAttribute("PlantRemoveVegetation", true);
                    }
                    Result109.close();
                }
                finally {
                    if (Result109 != null) {
                        Result109.close();
                    }
                }
            }
            catch (SQLException Result109) {
                void ex111;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex111);
            }
        }
        if (eventID == PlantRemoveVegetationOFFID) {
            try {
                void Result110;
                ResultSet ex111 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result110.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET PlantRemoveVegetation = '0' WHERE ID = '1'");
                        PlantRemoveVegetationINFO.setText("<b>Plant Remove = OFF</b>");
                        player.setAttribute("PlantRemoveVegetation", false);
                    }
                    Result110.close();
                }
                finally {
                    if (Result110 != null) {
                        Result110.close();
                    }
                }
            }
            catch (SQLException Result110) {
                void ex112;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex112);
            }
        }
        if (eventID == RockDestroyVegetationONID) {
            try {
                void Result111;
                ResultSet ex112 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result111.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockDestroyVegetation = '1' WHERE ID = '1'");
                        RockDestroyVegetationINFO.setText("<b>Rock Destroy = ON</b>");
                        player.setAttribute("RockDestroyVegetation", true);
                    }
                    Result111.close();
                }
                finally {
                    if (Result111 != null) {
                        Result111.close();
                    }
                }
            }
            catch (SQLException Result111) {
                void ex113;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex113);
            }
        }
        if (eventID == RockDestroyVegetationOFFID) {
            try {
                void Result112;
                ResultSet ex113 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result112.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockDestroyVegetation = '0' WHERE ID = '1'");
                        RockDestroyVegetationINFO.setText("<b>Rock Destroy = OFF</b>");
                        player.setAttribute("RockDestroyVegetation", false);
                    }
                    Result112.close();
                }
                finally {
                    if (Result112 != null) {
                        Result112.close();
                    }
                }
            }
            catch (SQLException Result112) {
                void ex114;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex114);
            }
        }
        if (eventID == RockHitVegetationONID) {
            try {
                void Result113;
                ResultSet ex114 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result113.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockHitVegetation = '1' WHERE ID = '1'");
                        RockHitVegetationINFO.setText("<b>Rock Hit = ON</b>");
                        player.setAttribute("RockHitVegetation", true);
                    }
                    Result113.close();
                }
                finally {
                    if (Result113 != null) {
                        Result113.close();
                    }
                }
            }
            catch (SQLException Result113) {
                void ex115;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex115);
            }
        }
        if (eventID == RockHitVegetationOFFID) {
            try {
                void Result114;
                ResultSet ex115 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result114.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockHitVegetation = '0' WHERE ID = '1'");
                        RockHitVegetationINFO.setText("<b>Rock Hit = OFF</b>");
                        player.setAttribute("RockHitVegetation", false);
                    }
                    Result114.close();
                }
                finally {
                    if (Result114 != null) {
                        Result114.close();
                    }
                }
            }
            catch (SQLException Result114) {
                void ex116;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex116);
            }
        }
        if (eventID == RockRemoveVegetationONID) {
            try {
                void Result115;
                ResultSet ex116 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result115.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockRemoveVegetation = '1' WHERE ID = '1'");
                        RockRemoveVegetationINFO.setText("<b>Rock Remove = ON</b>");
                        player.setAttribute("RockRemoveVegetation", true);
                    }
                    Result115.close();
                }
                finally {
                    if (Result115 != null) {
                        Result115.close();
                    }
                }
            }
            catch (SQLException Result115) {
                void ex117;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex117);
            }
        }
        if (eventID == RockRemoveVegetationOFFID) {
            try {
                void Result116;
                ResultSet ex117 = this.database.executeQuery("SELECT * FROM `AdminSettings` WHERE ID = '1'");
                try {
                    if (Result116.next()) {
                        this.database.executeUpdate("UPDATE AdminSettings SET RockRemoveVegetation = '0' WHERE ID = '1'");
                        RockRemoveVegetationINFO.setText("<b>Rock Remove = OFF</b>");
                        player.setAttribute("RockRemoveVegetation", false);
                    }
                    Result116.close();
                }
                finally {
                    if (Result116 != null) {
                        Result116.close();
                    }
                }
            }
            catch (SQLException Result116) {
                void ex118;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex118);
            }
        }
        if (eventID == PlayerDestroyTerrainONID) {
            try {
                void Result117;
                ResultSet ex118 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result117.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DestroyTerrain = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDestroyTerrainINFO.setText("<b>Destroy Terrain = ON</b>");
                        player.setAttribute("PlayerDestroyTerrain", true);
                    }
                    Result117.close();
                }
                finally {
                    if (Result117 != null) {
                        Result117.close();
                    }
                }
            }
            catch (SQLException Result117) {
                void ex119;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex119);
            }
        }
        if (eventID == PlayerDestroyTerrainOFFID) {
            try {
                void Result118;
                ResultSet ex119 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result118.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DestroyTerrain = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDestroyTerrainINFO.setText("<b>Destroy Terrain = OFF</b>");
                        player.setAttribute("PlayerDestroyTerrain", false);
                    }
                    Result118.close();
                }
                finally {
                    if (Result118 != null) {
                        Result118.close();
                    }
                }
            }
            catch (SQLException Result118) {
                void ex120;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex120);
            }
        }
        if (eventID == PlayerHitTerrainONID) {
            try {
                void Result119;
                ResultSet ex120 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result119.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitTerrain = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitTerrainINFO.setText("<b>Hit Terrain = ON</b>");
                        player.setAttribute("PlayerHitTerrain", true);
                    }
                    Result119.close();
                }
                finally {
                    if (Result119 != null) {
                        Result119.close();
                    }
                }
            }
            catch (SQLException Result119) {
                void ex121;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex121);
            }
        }
        if (eventID == PlayerHitTerrainOFFID) {
            try {
                void Result120;
                ResultSet ex121 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result120.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitTerrain = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitTerrainINFO.setText("<b>Hit Terrain = OFF</b>");
                        player.setAttribute("PlayerHitTerrain", false);
                    }
                    Result120.close();
                }
                finally {
                    if (Result120 != null) {
                        Result120.close();
                    }
                }
            }
            catch (SQLException Result120) {
                void ex122;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex122);
            }
        }
        if (eventID == PlayerBedUseObjectONID) {
            try {
                void Result121;
                ResultSet ex122 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result121.next()) {
                        this.database.executeUpdate("UPDATE Areas SET BedUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerBedUseObjectINFO.setText("<b>Use Beds = ON</b>");
                        player.setAttribute("PlayerBedUseObject", true);
                    }
                    Result121.close();
                }
                finally {
                    if (Result121 != null) {
                        Result121.close();
                    }
                }
            }
            catch (SQLException Result121) {
                void ex123;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex123);
            }
        }
        if (eventID == PlayerBedUseObjectOFFID) {
            try {
                void Result122;
                ResultSet ex123 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result122.next()) {
                        this.database.executeUpdate("UPDATE Areas SET BedUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerBedUseObjectINFO.setText("<b>Use Beds = OFF</b>");
                        player.setAttribute("PlayerBedUseObject", false);
                    }
                    Result122.close();
                }
                finally {
                    if (Result122 != null) {
                        Result122.close();
                    }
                }
            }
            catch (SQLException Result122) {
                void ex124;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex124);
            }
        }
        if (eventID == PlayerCampfireUseObjectONID) {
            try {
                void Result123;
                ResultSet ex124 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result123.next()) {
                        this.database.executeUpdate("UPDATE Areas SET CampfireUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerCampfireUseObjectINFO.setText("<b>Use Campfires = ON</b>");
                        player.setAttribute("PlayerCampfireUseObject", true);
                    }
                    Result123.close();
                }
                finally {
                    if (Result123 != null) {
                        Result123.close();
                    }
                }
            }
            catch (SQLException Result123) {
                void ex125;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex125);
            }
        }
        if (eventID == PlayerCampfireUseObjectOFFID) {
            try {
                void Result124;
                ResultSet ex125 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result124.next()) {
                        this.database.executeUpdate("UPDATE Areas SET CampfireUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerCampfireUseObjectINFO.setText("<b>Use Campfires = OFF</b>");
                        player.setAttribute("PlayerCampfireUseObject", false);
                    }
                    Result124.close();
                }
                finally {
                    if (Result124 != null) {
                        Result124.close();
                    }
                }
            }
            catch (SQLException Result124) {
                void ex126;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex126);
            }
        }
        if (eventID == PlayerClockUseObjectONID) {
            try {
                void Result125;
                ResultSet ex126 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result125.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ClockUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerClockUseObjectINFO.setText("<b>Use Clocks = ON</b>");
                        player.setAttribute("PlayerClockUseObject", true);
                    }
                    Result125.close();
                }
                finally {
                    if (Result125 != null) {
                        Result125.close();
                    }
                }
            }
            catch (SQLException Result125) {
                void ex127;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex127);
            }
        }
        if (eventID == PlayerClockUseObjectOFFID) {
            try {
                void Result126;
                ResultSet ex127 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result126.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ClockUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerClockUseObjectINFO.setText("<b>Use Clocks = OFF</b>");
                        player.setAttribute("PlayerClockUseObject", false);
                    }
                    Result126.close();
                }
                finally {
                    if (Result126 != null) {
                        Result126.close();
                    }
                }
            }
            catch (SQLException Result126) {
                void ex128;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex128);
            }
        }
        if (eventID == PlayerDoorUseObjectONID) {
            try {
                void Result127;
                ResultSet ex128 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result127.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DoorUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDoorUseObjectINFO.setText("<b>Use Doors = ON</b>");
                        player.setAttribute("PlayerDoorUseObject", true);
                    }
                    Result127.close();
                }
                finally {
                    if (Result127 != null) {
                        Result127.close();
                    }
                }
            }
            catch (SQLException Result127) {
                void ex129;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex129);
            }
        }
        if (eventID == PlayerDoorUseObjectOFFID) {
            try {
                void Result128;
                ResultSet ex129 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result128.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DoorUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDoorUseObjectINFO.setText("<b>Use Doors = OFF</b>");
                        player.setAttribute("PlayerDoorUseObject", false);
                    }
                    Result128.close();
                }
                finally {
                    if (Result128 != null) {
                        Result128.close();
                    }
                }
            }
            catch (SQLException Result128) {
                void ex130;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex130);
            }
        }
        if (eventID == PlayerDryingRackUseObjectONID) {
            try {
                void Result129;
                ResultSet ex130 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result129.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DryingRackUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDryingRackUseObjectINFO.setText("<b>Use DryingRacks = ON</b>");
                        player.setAttribute("PlayerDryingRackUseObject", true);
                    }
                    Result129.close();
                }
                finally {
                    if (Result129 != null) {
                        Result129.close();
                    }
                }
            }
            catch (SQLException Result129) {
                void ex131;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex131);
            }
        }
        if (eventID == PlayerDryingRackUseObjectOFFID) {
            try {
                void Result130;
                ResultSet ex131 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result130.next()) {
                        this.database.executeUpdate("UPDATE Areas SET DryingRackUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerDryingRackUseObjectINFO.setText("<b>Use DryingRacks = OFF</b>");
                        player.setAttribute("PlayerDryingRackUseObject", false);
                    }
                    Result130.close();
                }
                finally {
                    if (Result130 != null) {
                        Result130.close();
                    }
                }
            }
            catch (SQLException Result130) {
                void ex132;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex132);
            }
        }
        if (eventID == PlayerFireUseObjectONID) {
            try {
                void Result131;
                ResultSet ex132 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result131.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FireUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFireUseObjectINFO.setText("<b>Use Fires = ON</b>");
                        player.setAttribute("PlayerFireUseObject", true);
                    }
                    Result131.close();
                }
                finally {
                    if (Result131 != null) {
                        Result131.close();
                    }
                }
            }
            catch (SQLException Result131) {
                void ex133;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex133);
            }
        }
        if (eventID == PlayerFireUseObjectOFFID) {
            try {
                void Result132;
                ResultSet ex133 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result132.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FireUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFireUseObjectINFO.setText("<b>Use Fires = OFF</b>");
                        player.setAttribute("PlayerFireUseObject", false);
                    }
                    Result132.close();
                }
                finally {
                    if (Result132 != null) {
                        Result132.close();
                    }
                }
            }
            catch (SQLException Result132) {
                void ex134;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex134);
            }
        }
        if (eventID == PlayerFurnaceUseObjectONID) {
            try {
                void Result133;
                ResultSet ex134 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result133.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FurnaceUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFurnaceUseObjectINFO.setText("<b>Use Furnaces = ON</b>");
                        player.setAttribute("PlayerFurnaceUseObject", true);
                    }
                    Result133.close();
                }
                finally {
                    if (Result133 != null) {
                        Result133.close();
                    }
                }
            }
            catch (SQLException Result133) {
                void ex135;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex135);
            }
        }
        if (eventID == PlayerFurnaceUseObjectOFFID) {
            try {
                void Result134;
                ResultSet ex135 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result134.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FurnaceUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFurnaceUseObjectINFO.setText("<b>Use Furnaces = OFF</b>");
                        player.setAttribute("PlayerFurnaceUseObject", false);
                    }
                    Result134.close();
                }
                finally {
                    if (Result134 != null) {
                        Result134.close();
                    }
                }
            }
            catch (SQLException Result134) {
                void ex136;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex136);
            }
        }
        if (eventID == PlayerGrillUseObjectONID) {
            try {
                void Result135;
                ResultSet ex136 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result135.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrillUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrillUseObjectINFO.setText("<b>Use Grills = ON</b>");
                        player.setAttribute("PlayerGrillUseObject", true);
                    }
                    Result135.close();
                }
                finally {
                    if (Result135 != null) {
                        Result135.close();
                    }
                }
            }
            catch (SQLException Result135) {
                void ex137;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex137);
            }
        }
        if (eventID == PlayerGrillUseObjectOFFID) {
            try {
                void Result136;
                ResultSet ex137 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result136.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrillUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrillUseObjectINFO.setText("<b>Use Grills = OFF</b>");
                        player.setAttribute("PlayerGrillUseObject", false);
                    }
                    Result136.close();
                }
                finally {
                    if (Result136 != null) {
                        Result136.close();
                    }
                }
            }
            catch (SQLException Result136) {
                void ex138;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex138);
            }
        }
        if (eventID == PlayerGrinderUseObjectONID) {
            try {
                void Result137;
                ResultSet ex138 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result137.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrinderUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrinderUseObjectINFO.setText("<b>Use Grinders = ON</b>");
                        player.setAttribute("PlayerGrinderUseObject", true);
                    }
                    Result137.close();
                }
                finally {
                    if (Result137 != null) {
                        Result137.close();
                    }
                }
            }
            catch (SQLException Result137) {
                void ex139;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex139);
            }
        }
        if (eventID == PlayerGrinderUseObjectOFFID) {
            try {
                void Result138;
                ResultSet ex139 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result138.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrinderUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrinderUseObjectINFO.setText("<b>Use Grinders = OFF</b>");
                        player.setAttribute("PlayerGrinderUseObject", false);
                    }
                    Result138.close();
                }
                finally {
                    if (Result138 != null) {
                        Result138.close();
                    }
                }
            }
            catch (SQLException Result138) {
                void ex140;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex140);
            }
        }
        if (eventID == PlayerGrindstoneUseObjectONID) {
            try {
                void Result139;
                ResultSet ex140 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result139.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrindstoneUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrindstoneUseObjectINFO.setText("<b>Use Grindstones = ON</b>");
                        player.setAttribute("PlayerGrindstoneUseObject", true);
                    }
                    Result139.close();
                }
                finally {
                    if (Result139 != null) {
                        Result139.close();
                    }
                }
            }
            catch (SQLException Result139) {
                void ex141;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex141);
            }
        }
        if (eventID == PlayerGrindstoneUseObjectOFFID) {
            try {
                void Result140;
                ResultSet ex141 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result140.next()) {
                        this.database.executeUpdate("UPDATE Areas SET GrindstoneUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerGrindstoneUseObjectINFO.setText("<b>Use Grindstones = OFF</b>");
                        player.setAttribute("PlayerGrindstoneUseObject", false);
                    }
                    Result140.close();
                }
                finally {
                    if (Result140 != null) {
                        Result140.close();
                    }
                }
            }
            catch (SQLException Result140) {
                void ex142;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex142);
            }
        }
        if (eventID == PlayerLadderUseObjectONID) {
            try {
                void Result141;
                ResultSet ex142 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result141.next()) {
                        this.database.executeUpdate("UPDATE Areas SET LadderUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerLadderUseObjectINFO.setText("<b>Use Ladders = ON</b>");
                        player.setAttribute("PlayerLadderUseObject", true);
                    }
                    Result141.close();
                }
                finally {
                    if (Result141 != null) {
                        Result141.close();
                    }
                }
            }
            catch (SQLException Result141) {
                void ex143;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex143);
            }
        }
        if (eventID == PlayerLadderUseObjectOFFID) {
            try {
                void Result142;
                ResultSet ex143 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result142.next()) {
                        this.database.executeUpdate("UPDATE Areas SET LadderUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerLadderUseObjectINFO.setText("<b>Use Ladders = OFF</b>");
                        player.setAttribute("PlayerLadderUseObject", false);
                    }
                    Result142.close();
                }
                finally {
                    if (Result142 != null) {
                        Result142.close();
                    }
                }
            }
            catch (SQLException Result142) {
                void ex144;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex144);
            }
        }
        if (eventID == PlayerLampUseObjectONID) {
            try {
                void Result143;
                ResultSet ex144 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result143.next()) {
                        this.database.executeUpdate("UPDATE Areas SET LampUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerLampUseObjectINFO.setText("<b>Use Lamps = ON</b>");
                        player.setAttribute("PlayerLampUseObject", true);
                    }
                    Result143.close();
                }
                finally {
                    if (Result143 != null) {
                        Result143.close();
                    }
                }
            }
            catch (SQLException Result143) {
                void ex145;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex145);
            }
        }
        if (eventID == PlayerLampUseObjectOFFID) {
            try {
                void Result144;
                ResultSet ex145 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result144.next()) {
                        this.database.executeUpdate("UPDATE Areas SET LampUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerLampUseObjectINFO.setText("<b>Use Lamps = OFF</b>");
                        player.setAttribute("PlayerLampUseObject", false);
                    }
                    Result144.close();
                }
                finally {
                    if (Result144 != null) {
                        Result144.close();
                    }
                }
            }
            catch (SQLException Result144) {
                void ex146;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex146);
            }
        }
        if (eventID == PlayerMusicPlayerUseObjectONID) {
            try {
                void Result145;
                ResultSet ex146 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result145.next()) {
                        this.database.executeUpdate("UPDATE Areas SET MusicPlayerUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerMusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = ON</b>");
                        player.setAttribute("PlayerMusicPlayerUseObject", true);
                    }
                    Result145.close();
                }
                finally {
                    if (Result145 != null) {
                        Result145.close();
                    }
                }
            }
            catch (SQLException Result145) {
                void ex147;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex147);
            }
        }
        if (eventID == PlayerMusicPlayerUseObjectOFFID) {
            try {
                void Result146;
                ResultSet ex147 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result146.next()) {
                        this.database.executeUpdate("UPDATE Areas SET MusicPlayerUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerMusicPlayerUseObjectINFO.setText("<b>Use MusicPlayers = OFF</b>");
                        player.setAttribute("PlayerMusicPlayerUseObject", false);
                    }
                    Result146.close();
                }
                finally {
                    if (Result146 != null) {
                        Result146.close();
                    }
                }
            }
            catch (SQLException Result146) {
                void ex148;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex148);
            }
        }
        if (eventID == PlayerOvenUseObjectONID) {
            try {
                void Result147;
                ResultSet ex148 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result147.next()) {
                        this.database.executeUpdate("UPDATE Areas SET OvenUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerOvenUseObjectINFO.setText("<b>Use Ovens = ON</b>");
                        player.setAttribute("PlayerOvenUseObject", true);
                    }
                    Result147.close();
                }
                finally {
                    if (Result147 != null) {
                        Result147.close();
                    }
                }
            }
            catch (SQLException Result147) {
                void ex149;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex149);
            }
        }
        if (eventID == PlayerOvenUseObjectOFFID) {
            try {
                void Result148;
                ResultSet ex149 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result148.next()) {
                        this.database.executeUpdate("UPDATE Areas SET OvenUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerOvenUseObjectINFO.setText("<b>Use Ovens = OFF</b>");
                        player.setAttribute("PlayerOvenUseObject", false);
                    }
                    Result148.close();
                }
                finally {
                    if (Result148 != null) {
                        Result148.close();
                    }
                }
            }
            catch (SQLException Result148) {
                void ex150;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex150);
            }
        }
        if (eventID == PlayerPaperPressUseObjectONID) {
            try {
                void Result149;
                ResultSet ex150 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result149.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PaperPressUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPaperPressUseObjectINFO.setText("<b>Use PaperPress = ON</b>");
                        player.setAttribute("PlayerPaperPressUseObject", true);
                    }
                    Result149.close();
                }
                finally {
                    if (Result149 != null) {
                        Result149.close();
                    }
                }
            }
            catch (SQLException Result149) {
                void ex151;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex151);
            }
        }
        if (eventID == PlayerPaperPressUseObjectOFFID) {
            try {
                void Result150;
                ResultSet ex151 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result150.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PaperPressUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPaperPressUseObjectINFO.setText("<b>Use PaperPress = OFF</b>");
                        player.setAttribute("PlayerPaperPressUseObject", false);
                    }
                    Result150.close();
                }
                finally {
                    if (Result150 != null) {
                        Result150.close();
                    }
                }
            }
            catch (SQLException Result150) {
                void ex152;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex152);
            }
        }
        if (eventID == PlayerPianoUseObjectONID) {
            try {
                void Result151;
                ResultSet ex152 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result151.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PianoUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPianoUseObjectINFO.setText("<b>Use Pianos = ON</b>");
                        player.setAttribute("PlayerPianoUseObject", true);
                    }
                    Result151.close();
                }
                finally {
                    if (Result151 != null) {
                        Result151.close();
                    }
                }
            }
            catch (SQLException Result151) {
                void ex153;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex153);
            }
        }
        if (eventID == PlayerPianoUseObjectOFFID) {
            try {
                void Result152;
                ResultSet ex153 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result152.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PianoUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPianoUseObjectINFO.setText("<b>Use Pianos = OFF</b>");
                        player.setAttribute("PlayerPianoUseObject", false);
                    }
                    Result152.close();
                }
                finally {
                    if (Result152 != null) {
                        Result152.close();
                    }
                }
            }
            catch (SQLException Result152) {
                void ex154;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex154);
            }
        }
        if (eventID == PlayerPosterUseObjectONID) {
            try {
                void Result153;
                ResultSet ex154 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result153.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PosterUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPosterUseObjectINFO.setText("<b>Use Posters = ON</b>");
                        player.setAttribute("PlayerPosterUseObject", true);
                    }
                    Result153.close();
                }
                finally {
                    if (Result153 != null) {
                        Result153.close();
                    }
                }
            }
            catch (SQLException Result153) {
                void ex155;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex155);
            }
        }
        if (eventID == PlayerPosterUseObjectOFFID) {
            try {
                void Result154;
                ResultSet ex155 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result154.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PosterUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPosterUseObjectINFO.setText("<b>Use Posters = OFF</b>");
                        player.setAttribute("PlayerPosterUseObject", false);
                    }
                    Result154.close();
                }
                finally {
                    if (Result154 != null) {
                        Result154.close();
                    }
                }
            }
            catch (SQLException Result154) {
                void ex156;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex156);
            }
        }
        if (eventID == PlayerScaffoldingUseObjectONID) {
            try {
                void Result155;
                ResultSet ex156 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result155.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ScaffoldingUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = ON</b>");
                        player.setAttribute("PlayerScaffoldingUseObject", true);
                    }
                    Result155.close();
                }
                finally {
                    if (Result155 != null) {
                        Result155.close();
                    }
                }
            }
            catch (SQLException Result155) {
                void ex157;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex157);
            }
        }
        if (eventID == PlayerScaffoldingUseObjectOFFID) {
            try {
                void Result156;
                ResultSet ex157 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result156.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ScaffoldingUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerScaffoldingUseObjectINFO.setText("<b>Use Scaffolding = OFF</b>");
                        player.setAttribute("PlayerScaffoldingUseObject", false);
                    }
                    Result156.close();
                }
                finally {
                    if (Result156 != null) {
                        Result156.close();
                    }
                }
            }
            catch (SQLException Result156) {
                void ex158;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex158);
            }
        }
        if (eventID == PlayerSeatingUseObjectONID) {
            try {
                void Result157;
                ResultSet ex158 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result157.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SeatingUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSeatingUseObjectINFO.setText("<b>Use Seating = ON</b>");
                        player.setAttribute("PlayerSeatingUseObject", true);
                    }
                    Result157.close();
                }
                finally {
                    if (Result157 != null) {
                        Result157.close();
                    }
                }
            }
            catch (SQLException Result157) {
                void ex159;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex159);
            }
        }
        if (eventID == PlayerSeatingUseObjectOFFID) {
            try {
                void Result158;
                ResultSet ex159 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result158.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SeatingUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSeatingUseObjectINFO.setText("<b>Use Seating = OFF</b>");
                        player.setAttribute("PlayerSeatingUseObject", false);
                    }
                    Result158.close();
                }
                finally {
                    if (Result158 != null) {
                        Result158.close();
                    }
                }
            }
            catch (SQLException Result158) {
                void ex160;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex160);
            }
        }
        if (eventID == PlayerShootingTargetUseObjectONID) {
            try {
                void Result159;
                ResultSet ex160 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result159.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ShootingTargetUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerShootingTargetUseObjectINFO.setText("<b>Use Targets = ON</b>");
                        player.setAttribute("PlayerShootingTargetUseObject", true);
                    }
                    Result159.close();
                }
                finally {
                    if (Result159 != null) {
                        Result159.close();
                    }
                }
            }
            catch (SQLException Result159) {
                void ex161;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex161);
            }
        }
        if (eventID == PlayerShootingTargetUseObjectOFFID) {
            try {
                void Result160;
                ResultSet ex161 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result160.next()) {
                        this.database.executeUpdate("UPDATE Areas SET ShootingTargetUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerShootingTargetUseObjectINFO.setText("<b>Use Targets = OFF</b>");
                        player.setAttribute("PlayerShootingTargetUseObject", false);
                    }
                    Result160.close();
                }
                finally {
                    if (Result160 != null) {
                        Result160.close();
                    }
                }
            }
            catch (SQLException Result160) {
                void ex162;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex162);
            }
        }
        if (eventID == PlayerSignUseObjectONID) {
            try {
                void Result161;
                ResultSet ex162 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result161.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SignUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSignUseObjectINFO.setText("<b>Use Signs = ON</b>");
                        player.setAttribute("PlayerSignUseObject", true);
                    }
                    Result161.close();
                }
                finally {
                    if (Result161 != null) {
                        Result161.close();
                    }
                }
            }
            catch (SQLException Result161) {
                void ex163;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex163);
            }
        }
        if (eventID == PlayerSignUseObjectOFFID) {
            try {
                void Result162;
                ResultSet ex163 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result162.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SignUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSignUseObjectINFO.setText("<b>Use Signs = OFF</b>");
                        player.setAttribute("PlayerSignUseObject", false);
                    }
                    Result162.close();
                }
                finally {
                    if (Result162 != null) {
                        Result162.close();
                    }
                }
            }
            catch (SQLException Result162) {
                void ex164;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex164);
            }
        }
        if (eventID == PlayerSpinningWheelUseObjectONID) {
            try {
                void Result163;
                ResultSet ex164 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result163.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SpinningWheelUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = ON</b>");
                        player.setAttribute("PlayerSpinningWheelUseObject", true);
                    }
                    Result163.close();
                }
                finally {
                    if (Result163 != null) {
                        Result163.close();
                    }
                }
            }
            catch (SQLException Result163) {
                void ex165;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex165);
            }
        }
        if (eventID == PlayerSpinningWheelUseObjectOFFID) {
            try {
                void Result164;
                ResultSet ex165 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result164.next()) {
                        this.database.executeUpdate("UPDATE Areas SET SpinningWheelUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerSpinningWheelUseObjectINFO.setText("<b>Use Spin Wheels = OFF</b>");
                        player.setAttribute("PlayerSpinningWheelUseObject", false);
                    }
                    Result164.close();
                }
                finally {
                    if (Result164 != null) {
                        Result164.close();
                    }
                }
            }
            catch (SQLException Result164) {
                void ex166;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex166);
            }
        }
        if (eventID == PlayerStorageUseObjectONID) {
            try {
                void Result165;
                ResultSet ex166 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result165.next()) {
                        this.database.executeUpdate("UPDATE Areas SET StorageUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerStorageUseObjectINFO.setText("<b>Use Storages = ON</b>");
                        player.setAttribute("PlayerStorageUseObject", true);
                    }
                    Result165.close();
                }
                finally {
                    if (Result165 != null) {
                        Result165.close();
                    }
                }
            }
            catch (SQLException Result165) {
                void ex167;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex167);
            }
        }
        if (eventID == PlayerStorageUseObjectOFFID) {
            try {
                void Result166;
                ResultSet ex167 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result166.next()) {
                        this.database.executeUpdate("UPDATE Areas SET StorageUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerStorageUseObjectINFO.setText("<b>Use Storages = OFF</b>");
                        player.setAttribute("PlayerStorageUseObject", false);
                    }
                    Result166.close();
                }
                finally {
                    if (Result166 != null) {
                        Result166.close();
                    }
                }
            }
            catch (SQLException Result166) {
                void ex168;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex168);
            }
        }
        if (eventID == PlayerTanningRackUseObjectONID) {
            try {
                void Result167;
                ResultSet ex168 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result167.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TanningRackUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTanningRackUseObjectINFO.setText("<b>Use TanningRacks = ON</b>");
                        player.setAttribute("PlayerTanningRackUseObject", true);
                    }
                    Result167.close();
                }
                finally {
                    if (Result167 != null) {
                        Result167.close();
                    }
                }
            }
            catch (SQLException Result167) {
                void ex169;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex169);
            }
        }
        if (eventID == PlayerTanningRackUseObjectOFFID) {
            try {
                void Result168;
                ResultSet ex169 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result168.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TanningRackUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTanningRackUseObjectINFO.setText("<b>Use TanningRacks = OFF</b>");
                        player.setAttribute("PlayerTanningRackUseObject", false);
                    }
                    Result168.close();
                }
                finally {
                    if (Result168 != null) {
                        Result168.close();
                    }
                }
            }
            catch (SQLException Result168) {
                void ex170;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex170);
            }
        }
        if (eventID == PlayerTechnicalUseObjectONID) {
            try {
                void Result169;
                ResultSet ex170 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result169.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TechnicalUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTechnicalUseObjectINFO.setText("<b>Use Technicals = ON</b>");
                        player.setAttribute("PlayerTechnicalUseObject", true);
                    }
                    Result169.close();
                }
                finally {
                    if (Result169 != null) {
                        Result169.close();
                    }
                }
            }
            catch (SQLException Result169) {
                void ex171;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex171);
            }
        }
        if (eventID == PlayerTechnicalUseObjectOFFID) {
            try {
                void Result170;
                ResultSet ex171 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result170.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TechnicalUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTechnicalUseObjectINFO.setText("<b>Use Technicals = OFF</b>");
                        player.setAttribute("PlayerTechnicalUseObject", false);
                    }
                    Result170.close();
                }
                finally {
                    if (Result170 != null) {
                        Result170.close();
                    }
                }
            }
            catch (SQLException Result170) {
                void ex172;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex172);
            }
        }
        if (eventID == PlayerTorchUseObjectONID) {
            try {
                void Result171;
                ResultSet ex172 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result171.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TorchUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTorchUseObjectINFO.setText("<b>Use Torchs = ON</b>");
                        player.setAttribute("PlayerTorchUseObject", true);
                    }
                    Result171.close();
                }
                finally {
                    if (Result171 != null) {
                        Result171.close();
                    }
                }
            }
            catch (SQLException Result171) {
                void ex173;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex173);
            }
        }
        if (eventID == PlayerTorchUseObjectOFFID) {
            try {
                void Result172;
                ResultSet ex173 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result172.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TorchUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTorchUseObjectINFO.setText("<b>Use Torchs = OFF</b>");
                        player.setAttribute("PlayerTorchUseObject", false);
                    }
                    Result172.close();
                }
                finally {
                    if (Result172 != null) {
                        Result172.close();
                    }
                }
            }
            catch (SQLException Result172) {
                void ex174;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex174);
            }
        }
        if (eventID == PlayerTrashcanUseObjectONID) {
            try {
                void Result173;
                ResultSet ex174 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result173.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrashcanUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrashcanUseObjectINFO.setText("<b>Use Trashcans = ON</b>");
                        player.setAttribute("PlayerTrashcanUseObject", true);
                    }
                    Result173.close();
                }
                finally {
                    if (Result173 != null) {
                        Result173.close();
                    }
                }
            }
            catch (SQLException Result173) {
                void ex175;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex175);
            }
        }
        if (eventID == PlayerTrashcanUseObjectOFFID) {
            try {
                void Result174;
                ResultSet ex175 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result174.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrashcanUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrashcanUseObjectINFO.setText("<b>Use Trashcans = OFF</b>");
                        player.setAttribute("PlayerTrashcanUseObject", false);
                    }
                    Result174.close();
                }
                finally {
                    if (Result174 != null) {
                        Result174.close();
                    }
                }
            }
            catch (SQLException Result174) {
                void ex176;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex176);
            }
        }
        if (eventID == PlayerWorkbenchUseObjectONID) {
            try {
                void Result175;
                ResultSet ex176 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result175.next()) {
                        this.database.executeUpdate("UPDATE Areas SET WorkbenchUseObject = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerWorkbenchUseObjectINFO.setText("<b>Use Workbenchs = ON</b>");
                        player.setAttribute("PlayerWorkbenchUseObject", true);
                    }
                    Result175.close();
                }
                finally {
                    if (Result175 != null) {
                        Result175.close();
                    }
                }
            }
            catch (SQLException Result175) {
                void ex177;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex177);
            }
        }
        if (eventID == PlayerWorkbenchUseObjectOFFID) {
            try {
                void Result176;
                ResultSet ex177 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result176.next()) {
                        this.database.executeUpdate("UPDATE Areas SET WorkbenchUseObject = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerWorkbenchUseObjectINFO.setText("<b>Use Workbenchs = OFF</b>");
                        player.setAttribute("PlayerWorkbenchUseObject", false);
                    }
                    Result176.close();
                }
                finally {
                    if (Result176 != null) {
                        Result176.close();
                    }
                }
            }
            catch (SQLException Result176) {
                void ex178;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex178);
            }
        }
        if (eventID == PlayerHitAnimalNPCONID) {
            try {
                void Result177;
                ResultSet ex178 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result177.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitAnimalNPC = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitAnimalNPCINFO.setText("<b>Hit Animal NPCs = ON</b>");
                        player.setAttribute("PlayerHitAnimalNPC", true);
                    }
                    Result177.close();
                }
                finally {
                    if (Result177 != null) {
                        Result177.close();
                    }
                }
            }
            catch (SQLException Result177) {
                void ex179;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex179);
            }
        }
        if (eventID == PlayerHitAnimalNPCOFFID) {
            try {
                void Result178;
                ResultSet ex179 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result178.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitAnimalNPC = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitAnimalNPCINFO.setText("<b>Hit Animal NPCs = OFF</b>");
                        player.setAttribute("PlayerHitAnimalNPC", false);
                    }
                    Result178.close();
                }
                finally {
                    if (Result178 != null) {
                        Result178.close();
                    }
                }
            }
            catch (SQLException Result178) {
                void ex180;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex180);
            }
        }
        if (eventID == PlayerHitHumanNPCONID) {
            try {
                void Result179;
                ResultSet ex180 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result179.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitHumanNPC = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitHumanNPCINFO.setText("<b>Hit Human NPCs = ON</b>");
                        player.setAttribute("PlayerHitHumanNPC", true);
                    }
                    Result179.close();
                }
                finally {
                    if (Result179 != null) {
                        Result179.close();
                    }
                }
            }
            catch (SQLException Result179) {
                void ex181;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex181);
            }
        }
        if (eventID == PlayerHitHumanNPCOFFID) {
            try {
                void Result180;
                ResultSet ex181 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result180.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitHumanNPC = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitHumanNPCINFO.setText("<b>Hit Human NPCs = OFF</b>");
                        player.setAttribute("PlayerHitHumanNPC", false);
                    }
                    Result180.close();
                }
                finally {
                    if (Result180 != null) {
                        Result180.close();
                    }
                }
            }
            catch (SQLException Result180) {
                void ex182;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex182);
            }
        }
        if (eventID == PlayerHitMountNPCONID) {
            try {
                void Result181;
                ResultSet ex182 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result181.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitMountNPC = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitMountNPCINFO.setText("<b>Hit Mount NPCs = ON</b>");
                        player.setAttribute("PlayerHitMountNPC", true);
                    }
                    Result181.close();
                }
                finally {
                    if (Result181 != null) {
                        Result181.close();
                    }
                }
            }
            catch (SQLException Result181) {
                void ex183;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex183);
            }
        }
        if (eventID == PlayerHitMountNPCOFFID) {
            try {
                void Result182;
                ResultSet ex183 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result182.next()) {
                        this.database.executeUpdate("UPDATE Areas SET HitMountNPC = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerHitMountNPCINFO.setText("<b>Hit Mount NPCs = OFF</b>");
                        player.setAttribute("PlayerHitMountNPC", false);
                    }
                    Result182.close();
                }
                finally {
                    if (Result182 != null) {
                        Result182.close();
                    }
                }
            }
            catch (SQLException Result182) {
                void ex184;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex184);
            }
        }
        if (eventID == PlayerRideMountNPCONID) {
            try {
                void Result183;
                ResultSet ex184 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result183.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RideMountNPC = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRideMountNPCINFO.setText("<b>Ride Mount NPCs = ON</b>");
                        player.setAttribute("PlayerRideMountNPC", true);
                    }
                    Result183.close();
                }
                finally {
                    if (Result183 != null) {
                        Result183.close();
                    }
                }
            }
            catch (SQLException Result183) {
                void ex185;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex185);
            }
        }
        if (eventID == PlayerRideMountNPCOFFID) {
            try {
                void Result184;
                ResultSet ex185 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result184.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RideMountNPC = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRideMountNPCINFO.setText("<b>Ride Mount NPCs = OFF</b>");
                        player.setAttribute("PlayerRideMountNPC", false);
                    }
                    Result184.close();
                }
                finally {
                    if (Result184 != null) {
                        Result184.close();
                    }
                }
            }
            catch (SQLException Result184) {
                void ex186;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex186);
            }
        }
        if (eventID == PlayerPlaceBluePrintsONID) {
            try {
                void Result185;
                ResultSet ex186 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result185.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PlaceBluePrints = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPlaceBluePrintsINFO.setText("<b>Place Blue Prints = ON</b>");
                        player.setAttribute("PlayerPlaceBluePrints", true);
                    }
                    Result185.close();
                }
                finally {
                    if (Result185 != null) {
                        Result185.close();
                    }
                }
            }
            catch (SQLException Result185) {
                void ex187;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex187);
            }
        }
        if (eventID == PlayerPlaceBluePrintsOFFID) {
            try {
                void Result186;
                ResultSet ex187 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result186.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PlaceBluePrints = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPlaceBluePrintsINFO.setText("<b>Place Blue Prints = OFF</b>");
                        player.setAttribute("PlayerPlaceBluePrints", false);
                    }
                    Result186.close();
                }
                finally {
                    if (Result186 != null) {
                        Result186.close();
                    }
                }
            }
            catch (SQLException Result186) {
                void ex188;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex188);
            }
        }
        if (eventID == PlayerNpcAddSaddleONID) {
            try {
                void Result187;
                ResultSet ex188 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result187.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddSaddle = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddSaddleINFO.setText("<b>Add Saddle = ON</b>");
                        player.setAttribute("PlayerNpcAddSaddle", true);
                    }
                    Result187.close();
                }
                finally {
                    if (Result187 != null) {
                        Result187.close();
                    }
                }
            }
            catch (SQLException Result187) {
                void ex189;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex189);
            }
        }
        if (eventID == PlayerNpcAddSaddleOFFID) {
            try {
                void Result188;
                ResultSet ex189 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result188.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddSaddle = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddSaddleINFO.setText("<b>Add Saddle = OFF</b>");
                        player.setAttribute("PlayerNpcAddSaddle", false);
                    }
                    Result188.close();
                }
                finally {
                    if (Result188 != null) {
                        Result188.close();
                    }
                }
            }
            catch (SQLException Result188) {
                void ex190;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex190);
            }
        }
        if (eventID == PlayerNpcRemoveSaddleONID) {
            try {
                void Result189;
                ResultSet ex190 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result189.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveSaddle = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveSaddleINFO.setText("<b>Remove Saddle = ON</b>");
                        player.setAttribute("PlayerNpcRemoveSaddle", true);
                    }
                    Result189.close();
                }
                finally {
                    if (Result189 != null) {
                        Result189.close();
                    }
                }
            }
            catch (SQLException Result189) {
                void ex191;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex191);
            }
        }
        if (eventID == PlayerNpcRemoveSaddleOFFID) {
            try {
                void Result190;
                ResultSet ex191 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result190.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveSaddle = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveSaddleINFO.setText("<b>Remove Saddle = OFF</b>");
                        player.setAttribute("PlayerNpcRemoveSaddle", false);
                    }
                    Result190.close();
                }
                finally {
                    if (Result190 != null) {
                        Result190.close();
                    }
                }
            }
            catch (SQLException Result190) {
                void ex192;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex192);
            }
        }
        if (eventID == PlayerNpcAddSaddleBagONID) {
            try {
                void Result191;
                ResultSet ex192 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result191.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddSaddleBag = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = ON</b>");
                        player.setAttribute("PlayerNpcAddSaddleBag", true);
                    }
                    Result191.close();
                }
                finally {
                    if (Result191 != null) {
                        Result191.close();
                    }
                }
            }
            catch (SQLException Result191) {
                void ex193;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex193);
            }
        }
        if (eventID == PlayerNpcAddSaddleBagOFFID) {
            try {
                void Result192;
                ResultSet ex193 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result192.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddSaddleBag = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddSaddleBagINFO.setText("<b>Add Saddle Bag = OFF</b>");
                        player.setAttribute("PlayerNpcAddSaddleBag", false);
                    }
                    Result192.close();
                }
                finally {
                    if (Result192 != null) {
                        Result192.close();
                    }
                }
            }
            catch (SQLException Result192) {
                void ex194;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex194);
            }
        }
        if (eventID == PlayerNpcRemoveSaddleBagONID) {
            try {
                void Result193;
                ResultSet ex194 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result193.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveSaddleBag = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = ON</b>");
                        player.setAttribute("PlayerNpcRemoveSaddleBag", true);
                    }
                    Result193.close();
                }
                finally {
                    if (Result193 != null) {
                        Result193.close();
                    }
                }
            }
            catch (SQLException Result193) {
                void ex195;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex195);
            }
        }
        if (eventID == PlayerNpcRemoveSaddleBagOFFID) {
            try {
                void Result194;
                ResultSet ex195 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result194.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveSaddleBag = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveSaddleBagINFO.setText("<b>Remove Saddle Bag = OFF</b>");
                        player.setAttribute("PlayerNpcRemoveSaddleBag", false);
                    }
                    Result194.close();
                }
                finally {
                    if (Result194 != null) {
                        Result194.close();
                    }
                }
            }
            catch (SQLException Result194) {
                void ex196;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex196);
            }
        }
        if (eventID == PlayerNpcAddClothesONID) {
            try {
                void Result195;
                ResultSet ex196 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result195.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddClothes = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddClothesINFO.setText("<b>Npc Add Clothes = ON</b>");
                        player.setAttribute("PlayerNpcAddClothes", true);
                    }
                    Result195.close();
                }
                finally {
                    if (Result195 != null) {
                        Result195.close();
                    }
                }
            }
            catch (SQLException Result195) {
                void ex197;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex197);
            }
        }
        if (eventID == PlayerNpcAddClothesOFFID) {
            try {
                void Result196;
                ResultSet ex197 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result196.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcAddClothes = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcAddClothesINFO.setText("<b>Npc Add Clothes = OFF</b>");
                        player.setAttribute("PlayerNpcAddClothes", false);
                    }
                    Result196.close();
                }
                finally {
                    if (Result196 != null) {
                        Result196.close();
                    }
                }
            }
            catch (SQLException Result196) {
                void ex198;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex198);
            }
        }
        if (eventID == PlayerNpcRemoveClothesONID) {
            try {
                void Result197;
                ResultSet ex198 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result197.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveClothes = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = ON</b>");
                        player.setAttribute("PlayerNpcRemoveClothes", true);
                    }
                    Result197.close();
                }
                finally {
                    if (Result197 != null) {
                        Result197.close();
                    }
                }
            }
            catch (SQLException Result197) {
                void ex199;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex199);
            }
        }
        if (eventID == PlayerNpcRemoveClothesOFFID) {
            try {
                void Result198;
                ResultSet ex199 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result198.next()) {
                        this.database.executeUpdate("UPDATE Areas SET NpcRemoveClothes = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerNpcRemoveClothesINFO.setText("<b>Npc Remove Clothes = OFF</b>");
                        player.setAttribute("PlayerNpcRemoveClothes", false);
                    }
                    Result198.close();
                }
                finally {
                    if (Result198 != null) {
                        Result198.close();
                    }
                }
            }
            catch (SQLException Result198) {
                void ex200;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex200);
            }
        }
        if (eventID == PlayerTreeDestroyVegetationONID) {
            try {
                void Result199;
                ResultSet ex200 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result199.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeDestroyVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeDestroyVegetationINFO.setText("<b>Tree Destroy = ON</b>");
                        player.setAttribute("PlayerTreeDestroyVegetation", true);
                    }
                    Result199.close();
                }
                finally {
                    if (Result199 != null) {
                        Result199.close();
                    }
                }
            }
            catch (SQLException Result199) {
                void ex201;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex201);
            }
        }
        if (eventID == PlayerTreeDestroyVegetationOFFID) {
            try {
                void Result200;
                ResultSet ex201 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result200.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeDestroyVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeDestroyVegetationINFO.setText("<b>Tree Destroy = OFF</b>");
                        player.setAttribute("PlayerTreeDestroyVegetation", false);
                    }
                    Result200.close();
                }
                finally {
                    if (Result200 != null) {
                        Result200.close();
                    }
                }
            }
            catch (SQLException Result200) {
                void ex202;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex202);
            }
        }
        if (eventID == PlayerTrunkDestroyVegetationONID) {
            try {
                void Result201;
                ResultSet ex202 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result201.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkDestroyVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = ON</b>");
                        player.setAttribute("PlayerTrunkDestroyVegetation", true);
                    }
                    Result201.close();
                }
                finally {
                    if (Result201 != null) {
                        Result201.close();
                    }
                }
            }
            catch (SQLException Result201) {
                void ex203;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex203);
            }
        }
        if (eventID == PlayerTrunkDestroyVegetationOFFID) {
            try {
                void Result202;
                ResultSet ex203 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result202.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkDestroyVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkDestroyVegetationINFO.setText("<b>OldLog Destroy = OFF</b>");
                        player.setAttribute("PlayerTrunkDestroyVegetation", false);
                    }
                    Result202.close();
                }
                finally {
                    if (Result202 != null) {
                        Result202.close();
                    }
                }
            }
            catch (SQLException Result202) {
                void ex204;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex204);
            }
        }
        if (eventID == PlayerTreeHitVegetationONID) {
            try {
                void Result203;
                ResultSet ex204 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result203.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeHitVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeHitVegetationINFO.setText("<b>Tree Hit = ON</b>");
                        player.setAttribute("PlayerTreeHitVegetation", true);
                    }
                    Result203.close();
                }
                finally {
                    if (Result203 != null) {
                        Result203.close();
                    }
                }
            }
            catch (SQLException Result203) {
                void ex205;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex205);
            }
        }
        if (eventID == PlayerTreeHitVegetationOFFID) {
            try {
                void Result204;
                ResultSet ex205 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result204.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeHitVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeHitVegetationINFO.setText("<b>Tree Hit = OFF</b>");
                        player.setAttribute("PlayerTreeHitVegetation", false);
                    }
                    Result204.close();
                }
                finally {
                    if (Result204 != null) {
                        Result204.close();
                    }
                }
            }
            catch (SQLException Result204) {
                void ex206;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex206);
            }
        }
        if (eventID == PlayerTrunkHitVegetationONID) {
            try {
                void Result205;
                ResultSet ex206 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result205.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkHitVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkHitVegetationINFO.setText("<b>OldLog Hit = ON</b>");
                        player.setAttribute("PlayerTrunkHitVegetation", true);
                    }
                    Result205.close();
                }
                finally {
                    if (Result205 != null) {
                        Result205.close();
                    }
                }
            }
            catch (SQLException Result205) {
                void ex207;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex207);
            }
        }
        if (eventID == PlayerTrunkHitVegetationOFFID) {
            try {
                void Result206;
                ResultSet ex207 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result206.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkHitVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkHitVegetationINFO.setText("<b>OldLog Hit = OFF</b>");
                        player.setAttribute("PlayerTrunkHitVegetation", false);
                    }
                    Result206.close();
                }
                finally {
                    if (Result206 != null) {
                        Result206.close();
                    }
                }
            }
            catch (SQLException Result206) {
                void ex208;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex208);
            }
        }
        if (eventID == PlayerTreeRemoveVegetationONID) {
            try {
                void Result207;
                ResultSet ex208 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result207.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeRemoveVegetationINFO.setText("<b>Tree Remove = ON</b>");
                        player.setAttribute("PlayerTreeRemoveVegetation", true);
                    }
                    Result207.close();
                }
                finally {
                    if (Result207 != null) {
                        Result207.close();
                    }
                }
            }
            catch (SQLException Result207) {
                void ex209;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex209);
            }
        }
        if (eventID == PlayerTreeRemoveVegetationOFFID) {
            try {
                void Result208;
                ResultSet ex209 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result208.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TreeRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTreeRemoveVegetationINFO.setText("<b>Tree Remove = OFF</b>");
                        player.setAttribute("PlayerTreeRemoveVegetation", false);
                    }
                    Result208.close();
                }
                finally {
                    if (Result208 != null) {
                        Result208.close();
                    }
                }
            }
            catch (SQLException Result208) {
                void ex210;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex210);
            }
        }
        if (eventID == PlayerTrunkRemoveVegetationONID) {
            try {
                void Result209;
                ResultSet ex210 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result209.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkRemoveVegetationINFO.setText("<b>OldLog Remove = ON</b>");
                        player.setAttribute("PlayerTrunkRemoveVegetation", true);
                    }
                    Result209.close();
                }
                finally {
                    if (Result209 != null) {
                        Result209.close();
                    }
                }
            }
            catch (SQLException Result209) {
                void ex211;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex211);
            }
        }
        if (eventID == PlayerTrunkRemoveVegetationOFFID) {
            try {
                void Result210;
                ResultSet ex211 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result210.next()) {
                        this.database.executeUpdate("UPDATE Areas SET TrunkRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerTrunkRemoveVegetationINFO.setText("<b>OldLog Remove = OFF</b>");
                        player.setAttribute("PlayerTrunkRemoveVegetation", false);
                    }
                    Result210.close();
                }
                finally {
                    if (Result210 != null) {
                        Result210.close();
                    }
                }
            }
            catch (SQLException Result210) {
                void ex212;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex212);
            }
        }
        if (eventID == PlayerCropRemoveVegetationONID) {
            try {
                void Result211;
                ResultSet ex212 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result211.next()) {
                        this.database.executeUpdate("UPDATE Areas SET CropRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerCropRemoveVegetationINFO.setText("<b>Crop Remove = ON</b>");
                        player.setAttribute("PlayerCropRemoveVegetation", true);
                    }
                    Result211.close();
                }
                finally {
                    if (Result211 != null) {
                        Result211.close();
                    }
                }
            }
            catch (SQLException Result211) {
                void ex213;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex213);
            }
        }
        if (eventID == PlayerCropRemoveVegetationOFFID) {
            try {
                void Result212;
                ResultSet ex213 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result212.next()) {
                        this.database.executeUpdate("UPDATE Areas SET CropRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerCropRemoveVegetationINFO.setText("<b>Crop Remove = OFF</b>");
                        player.setAttribute("PlayerCropRemoveVegetation", false);
                    }
                    Result212.close();
                }
                finally {
                    if (Result212 != null) {
                        Result212.close();
                    }
                }
            }
            catch (SQLException Result212) {
                void ex214;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex214);
            }
        }
        if (eventID == PlayerFruitTreeRemoveVegetationONID) {
            try {
                void Result213;
                ResultSet ex214 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result213.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FruitTreeRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = ON</b>");
                        player.setAttribute("PlayerFruitTreeRemoveVegetation", true);
                    }
                    Result213.close();
                }
                finally {
                    if (Result213 != null) {
                        Result213.close();
                    }
                }
            }
            catch (SQLException Result213) {
                void ex215;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex215);
            }
        }
        if (eventID == PlayerFruitTreeRemoveVegetationOFFID) {
            try {
                void Result214;
                ResultSet ex215 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result214.next()) {
                        this.database.executeUpdate("UPDATE Areas SET FruitTreeRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerFruitTreeRemoveVegetationINFO.setText("<b>Fruit Tree Remove = OFF</b>");
                        player.setAttribute("PlayerFruitTreeRemoveVegetation", false);
                    }
                    Result214.close();
                }
                finally {
                    if (Result214 != null) {
                        Result214.close();
                    }
                }
            }
            catch (SQLException Result214) {
                void ex216;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex216);
            }
        }
        if (eventID == PlayerPlantRemoveVegetationONID) {
            try {
                void Result215;
                ResultSet ex216 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result215.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PlantRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPlantRemoveVegetationINFO.setText("<b>Plant Remove = ON</b>");
                        player.setAttribute("PlayerPlantRemoveVegetation", true);
                    }
                    Result215.close();
                }
                finally {
                    if (Result215 != null) {
                        Result215.close();
                    }
                }
            }
            catch (SQLException Result215) {
                void ex217;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex217);
            }
        }
        if (eventID == PlayerPlantRemoveVegetationOFFID) {
            try {
                void Result216;
                ResultSet ex217 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result216.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PlantRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerPlantRemoveVegetationINFO.setText("<b>Plant Remove = OFF</b>");
                        player.setAttribute("PlayerPlantRemoveVegetation", false);
                    }
                    Result216.close();
                }
                finally {
                    if (Result216 != null) {
                        Result216.close();
                    }
                }
            }
            catch (SQLException Result216) {
                void ex218;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex218);
            }
        }
        if (eventID == PlayerRockDestroyVegetationONID) {
            try {
                void Result217;
                ResultSet ex218 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result217.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockDestroyVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockDestroyVegetationINFO.setText("<b>Rock Destroy = ON</b>");
                        player.setAttribute("PlayerRockDestroyVegetation", true);
                    }
                    Result217.close();
                }
                finally {
                    if (Result217 != null) {
                        Result217.close();
                    }
                }
            }
            catch (SQLException Result217) {
                void ex219;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex219);
            }
        }
        if (eventID == PlayerRockDestroyVegetationOFFID) {
            try {
                void Result218;
                ResultSet ex219 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result218.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockDestroyVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockDestroyVegetationINFO.setText("<b>Rock Destroy = OFF</b>");
                        player.setAttribute("PlayerRockDestroyVegetation", false);
                    }
                    Result218.close();
                }
                finally {
                    if (Result218 != null) {
                        Result218.close();
                    }
                }
            }
            catch (SQLException Result218) {
                void ex220;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex220);
            }
        }
        if (eventID == PlayerRockHitVegetationONID) {
            try {
                void Result219;
                ResultSet ex220 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result219.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockHitVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockHitVegetationINFO.setText("<b>Rock Hit = ON</b>");
                        player.setAttribute("PlayerRockHitVegetation", true);
                    }
                    Result219.close();
                }
                finally {
                    if (Result219 != null) {
                        Result219.close();
                    }
                }
            }
            catch (SQLException Result219) {
                void ex221;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex221);
            }
        }
        if (eventID == PlayerRockHitVegetationOFFID) {
            try {
                void Result220;
                ResultSet ex221 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result220.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockHitVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockHitVegetationINFO.setText("<b>Rock Hit = OFF</b>");
                        player.setAttribute("PlayerRockHitVegetation", false);
                    }
                    Result220.close();
                }
                finally {
                    if (Result220 != null) {
                        Result220.close();
                    }
                }
            }
            catch (SQLException Result220) {
                void ex222;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex222);
            }
        }
        if (eventID == PlayerRockRemoveVegetationONID) {
            try {
                void Result221;
                ResultSet ex222 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result221.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockRemoveVegetation = '1' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockRemoveVegetationINFO.setText("<b>Rock Remove = ON</b>");
                        player.setAttribute("PlayerRockRemoveVegetation", true);
                    }
                    Result221.close();
                }
                finally {
                    if (Result221 != null) {
                        Result221.close();
                    }
                }
            }
            catch (SQLException Result221) {
                void ex223;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex223);
            }
        }
        if (eventID == PlayerRockRemoveVegetationOFFID) {
            try {
                void Result222;
                ResultSet ex223 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result222.next()) {
                        this.database.executeUpdate("UPDATE Areas SET RockRemoveVegetation = '0' WHERE AreaX = '" + ChunkPosition.x + "' AND AreaY = '" + ChunkPosition.y + "' AND AreaZ = '" + ChunkPosition.z + "' AND PlayerUID = '" + PlayerUID + "'");
                        PlayerRockRemoveVegetationINFO.setText("<b>Rock Remove = OFF</b>");
                        player.setAttribute("PlayerRockRemoveVegetation", false);
                    }
                    Result222.close();
                }
                finally {
                    if (Result222 != null) {
                        Result222.close();
                    }
                }
            }
            catch (SQLException Result222) {
                void ex224;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex224);
            }
        }
        if (eventID == AdminRightsONID) {
            AdminRightsINFO.setText("<b>Admin Rights = On</b>");
            player.setAttribute("AdminRights", true);
        }
        if (eventID == AdminRightsOFFID) {
            AdminRightsINFO.setText("<b>Admin Rights = Off</b>");
            player.setAttribute("AdminRights", false);
        }
        if (eventID == DeleteAllAreasID) {
            ATNameTextField.getCurrentText(player, PlayerNameToRemoveAllAreasFrom -> player.setAttribute("PlayerNameToRemoveAllAreasFrom", PlayerNameToRemoveAllAreasFrom));
            try {
                void Result223;
                ResultSet ex224 = this.database.executeQuery("SELECT * FROM `Points` WHERE `UserName` = '" + String.valueOf(player.getAttribute("PlayerNameToRemoveAllAreasFrom")) + "'");
                try {
                    if (Result223.next()) {
                        void getPlayerUID;
                        int NewPoints = Result223.getInt("PlayerUID");
                        player.setAttribute("PlayerUIDToRemoveAllAreasFrom", (int)getPlayerUID);
                        this.database.executeUpdate("DELETE FROM `Areas` WHERE `PlayerUID` = '" + (int)getPlayerUID + "'");
                        player.sendTextMessage("all areas removed frpm Player ID " + (int)getPlayerUID + " Name " + String.valueOf(player.getAttribute("PlayerNameToRemoveAllAreasFrom")));
                    } else {
                        player.sendTextMessage("Error Something went wrong!!! Try again");
                    }
                    Result223.close();
                }
                finally {
                    if (Result223 != null) {
                        Result223.close();
                    }
                }
            }
            catch (SQLException Result223) {
                void ex225;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex225);
            }
        }
        if (eventID == NextPlayerButtonID) {
            int list2;
            void Backclicked2;
            try {
                void Result224;
                ResultSet ex225 = this.database.executeQuery("SELECT count(*) FROM `Points`");
                try {
                    if (Result224.next()) {
                        void CountPointsRows;
                        int getPlayerUID = Result224.getInt(1);
                        player.setAttribute("CountPointsRows", (int)CountPointsRows);
                    }
                    Result224.close();
                }
                finally {
                    if (Result224 != null) {
                        Result224.close();
                    }
                }
            }
            catch (SQLException Result224) {
                void ex226;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex226);
            }
            int ex226 = (Integer)player.getAttribute("list");
            String CountPointsRows = (String)player.getAttribute("BackClicked");
            if (Backclicked2 == "Clicked") {
                ++list2;
            }
            if (list2 <= -1) {
                list2 = 0;
            }
            try {
                void Result225;
                ResultSet PlayerTrunkDestroyVegetation = this.database.executeQuery("SELECT * FROM `Points` LIMIT '" + list2 + "', 1 ");
                try {
                    if (Result225.next()) {
                        void Nextclick;
                        void Backclick;
                        void CountRows;
                        void RowNumver;
                        void Rows;
                        void UserName;
                        String PlayerTreeHitVegetation = Result225.getString("UserName");
                        int PlayerTrunkHitVegetation = list2 + 1;
                        ATNameTextField.setText((String)UserName);
                        ++list2;
                        Object PlayerTreeRemoveVegetation = player.getAttribute("CountPointsRows");
                        int PlayerTrunkRemoveVegetation = (Integer)Rows;
                        if (RowNumver == CountRows) {
                            list2 = 0;
                        }
                        player.setAttribute("list", list2);
                        String PlayerCropRemoveVegetation = "NotClicked";
                        player.setAttribute("BackClicked", Backclick);
                        String PlayerFruitTreeRemoveVegetation = "Clicked";
                        player.setAttribute("NextClicked", Nextclick);
                        return;
                    }
                    Result225.close();
                }
                finally {
                    if (Result225 != null) {
                        Result225.close();
                    }
                }
            }
            catch (SQLException Result225) {
                void ex227;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex227);
            }
        }
        if (eventID == WPNextPlayerButtonID) {
            int list;
            void Backclicked;
            try {
                void Result226;
                ResultSet list2 = this.database.executeQuery("SELECT count(*) FROM `Points`");
                try {
                    if (Result226.next()) {
                        void CountPointsRows;
                        int Backclicked2 = Result226.getInt(1);
                        player.setAttribute("CountPointsRows", (int)CountPointsRows);
                    }
                    Result226.close();
                }
                finally {
                    if (Result226 != null) {
                        Result226.close();
                    }
                }
            }
            catch (SQLException Result226) {
                void ex228;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex228);
            }
            int ex228 = (Integer)player.getAttribute("list");
            String CountPointsRows = (String)player.getAttribute("BackClicked");
            if (Backclicked == "Clicked") {
                ++list;
            }
            if (list <= -1) {
                list = 0;
            }
            try {
                void Result227;
                ResultSet ex227 = this.database.executeQuery("SELECT * FROM `Points` LIMIT '" + list + "', 1 ");
                try {
                    if (Result227.next()) {
                        String UserName = Result227.getString("UserName");
                        int RowNumver = list + 1;
                        AddFriendToWPAreaTextField.setText(UserName);
                        ++list;
                        Object Rows = player.getAttribute("CountPointsRows");
                        int CountRows = (Integer)Rows;
                        if (RowNumver == CountRows) {
                            list = 0;
                        }
                        player.setAttribute("list", list);
                        String Backclick = "NotClicked";
                        player.setAttribute("BackClicked", Backclick);
                        String Nextclick = "Clicked";
                        player.setAttribute("NextClicked", Nextclick);
                        return;
                    }
                    Result227.close();
                }
                finally {
                    if (Result227 != null) {
                        Result227.close();
                    }
                }
            }
            catch (SQLException Result227) {
                void ex229;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex229);
            }
        }
        if (eventID == PlayerPVPOffID) {
            try {
                void Result228;
                ResultSet list = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result228.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PVPStatus = '1' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        PlayerPVPStatus.setText("<b>Status=PVP OFF </b>");
                        AreaName.setFontColor(0.0f, 9.0f, 0.0f, 9.0f);
                        player.setAttribute("PVPStatus", true);
                    }
                    Result228.close();
                }
                finally {
                    if (Result228 != null) {
                        Result228.close();
                    }
                }
            }
            catch (SQLException Result228) {
                void ex230;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex230);
            }
            if (player.isAdmin()) {
                try {
                    ResultSet ex230 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                    try {
                        if (Result228.next()) {
                            this.database.executeUpdate("UPDATE Areas SET PVPStatus = '1' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                            PlayerPVPStatus.setText("<b>Status=PVP OFF </b>");
                            AreaName.setFontColor(0.0f, 9.0f, 0.0f, 9.0f);
                            player.setAttribute("PVPStatus", true);
                        }
                        Result228.close();
                    }
                    finally {
                        if (Result228 != null) {
                            Result228.close();
                        }
                    }
                }
                catch (SQLException Result229) {
                    void ex231;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex231);
                }
            } else {
                player.setAttribute("PVPStatus", true);
                player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
            }
        }
        if (eventID == PlayerPVPOnID) {
            ResultSet ex231;
            try {
                void Result230;
                ex231 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result230.next()) {
                        this.database.executeUpdate("UPDATE Areas SET PVPStatus = '0' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        PlayerPVPStatus.setText("<b>Status=PVP ON </b>");
                        AreaName.setFontColor(9.0f, 0.0f, 0.0f, 9.0f);
                        player.setAttribute("PVPStatus", false);
                    }
                    Result230.close();
                }
                finally {
                    if (Result230 != null) {
                        Result230.close();
                    }
                }
            }
            catch (SQLException Result230) {
                void ex232;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex232);
            }
            if (player.isAdmin()) {
                try {
                    ex231 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                    try {
                        if (Result230.next()) {
                            this.database.executeUpdate("UPDATE Areas SET PVPStatus = '0' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                            PlayerPVPStatus.setText("<b>Status=PVP ON </b>");
                            AreaName.setFontColor(9.0f, 0.0f, 0.0f, 9.0f);
                            player.setAttribute("PVPStatus", false);
                        }
                        Result230.close();
                    }
                    finally {
                        if (Result230 != null) {
                            Result230.close();
                        }
                    }
                }
                catch (SQLException Result231) {
                    void ex233;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex233);
                }
            } else {
                player.setAttribute("PVPStatus", true);
                player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
            }
        }
        if (eventID == GivePointsID) {
            try {
                void Result232;
                ResultSet ex233 = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result232.next()) {
                        void Points6;
                        int Backclicked = Result232.getInt("Points");
                        player.setAttribute("Points", (int)Points6);
                    }
                    Result232.close();
                }
                finally {
                    if (Result232 != null) {
                        Result232.close();
                    }
                }
            }
            catch (SQLException Result232) {
                void ex234;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex234);
            }
            AddFriendToWPAreaTextField.getCurrentText(player, SettingsAddFriendToWPAreaTextField -> SendPointsAmount.getCurrentText(player, SettingsSendPointsAmount -> {
                String GetAmount = SettingsSendPointsAmount;
                boolean Amount = GetAmount.matches("[0-9]+");
                if (Boolean.FALSE.equals(Amount)) {
                    player.sendTextMessage("Error!!! you must enter numbers only");
                    return;
                }
                if (Boolean.TRUE.equals(Amount)) {
                    int GiveAmount = Integer.parseInt(GetAmount);
                    player.setAttribute("GiveAmount", GiveAmount);
                }
                if (SettingsAddFriendToWPAreaTextField.equals("")) {
                    player.sendTextMessage("Error!! you need to enter a name");
                    return;
                }
                Player getname = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField);
                if (getname == null) {
                    player.sendTextMessage("Error!! the user must be online and the correct name used");
                    return;
                }
                if (!Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).equals(null)) {
                    String FriendUID = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getUID();
                    String FriendName = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getName();
                    int GivePoints = (Integer)player.getAttribute("Points");
                    int GiveAmount = (Integer)player.getAttribute("GiveAmount");
                    if (player.isAdmin()) {
                        try (ResultSet Result = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + FriendUID + "'");){
                            if (Result.next()) {
                                int FriendsCarrentPoints = Result.getInt("Points");
                                int FriendsNewPointsTotal = FriendsCarrentPoints + GiveAmount;
                                Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).setAttribute("Points", FriendsNewPointsTotal);
                                player.sendTextMessage("friends points" + String.valueOf(Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getAttribute("Points")));
                                this.database.executeUpdate("UPDATE Points SET Points = '" + FriendsNewPointsTotal + "' WHERE PlayerUID = '" + FriendUID + "'");
                                return;
                            }
                            Result.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (GivePoints >= GiveAmount) {
                        try (ResultSet Result = this.database.executeQuery("SELECT * FROM `Points` WHERE `PlayerUID` = '" + FriendUID + "'");){
                            if (Result.next()) {
                                int FriendsCarrentPoints = Result.getInt("Points");
                                int FriendsNewPointsTotal = FriendsCarrentPoints + GiveAmount;
                                Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).setAttribute("Points", FriendsNewPointsTotal);
                                player.sendTextMessage("friends points" + String.valueOf(Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getAttribute("Points")));
                                this.database.executeUpdate("UPDATE Points SET Points = '" + FriendsNewPointsTotal + "' WHERE PlayerUID = '" + FriendUID + "'");
                                int GiverNewPointsTotal = GivePoints - GiveAmount;
                                this.database.executeUpdate("UPDATE Points SET Points = '" + GiverNewPointsTotal + "' WHERE PlayerUID = '" + PlayerUID + "'");
                                player.setAttribute("Points", GiverNewPointsTotal);
                                PointsInfo.setText("Points=" + String.valueOf(player.getAttribute("Points")));
                                player.sendTextMessage("Friend Name " + FriendName + " FriendUID " + FriendUID + " points = " + String.valueOf(player.getAttribute("Points")));
                                return;
                            }
                            Result.close();
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    player.sendTextMessage("Error you do not have the points to give to a friend");
                }
                player.sendTextMessage("Error!!!");
            }));
        }
        if (eventID == LockAreaID) {
            ResultSet ex234;
            try {
                void Result233;
                ex234 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result233.next()) {
                        this.database.executeUpdate("UPDATE Areas SET AreaLocked = '1' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        Areastatus.setText("<b>Status=Area Locked </b>");
                        player.setAttribute("isAreaLocked", true);
                    }
                    Result233.close();
                }
                finally {
                    if (Result233 != null) {
                        Result233.close();
                    }
                }
            }
            catch (SQLException Result233) {
                void ex235;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex235);
            }
            if (player.isAdmin()) {
                try {
                    ex234 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                    try {
                        if (Result233.next()) {
                            this.database.executeUpdate("UPDATE Areas SET AreaLocked = '1' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                            Areastatus.setText("<b>Status=Area Locked </b>");
                            player.setAttribute("isAreaLocked", true);
                        }
                        Result233.close();
                    }
                    finally {
                        if (Result233 != null) {
                            Result233.close();
                        }
                    }
                }
                catch (SQLException Result234) {
                    void ex236;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex236);
                }
            } else {
                player.setAttribute("isAreaLocked", true);
                player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
            }
        }
        if (eventID == UnlockAreaID) {
            ResultSet ex236;
            try {
                void Result235;
                ex236 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result235.next()) {
                        this.database.executeUpdate("UPDATE Areas SET AreaLocked = '0' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        Areastatus.setText("<b>Status=Area Unlocked </b>");
                        player.setAttribute("isAreaLocked", false);
                    }
                    Result235.close();
                }
                finally {
                    if (Result235 != null) {
                        Result235.close();
                    }
                }
            }
            catch (SQLException Result235) {
                void ex237;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex237);
            }
            if (player.isAdmin()) {
                try {
                    ex236 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                    try {
                        if (Result235.next()) {
                            this.database.executeUpdate("UPDATE Areas SET AreaLocked = '0' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                            Areastatus.setText("<b>Status=Area Unlocked </b>");
                            player.setAttribute("isAreaLocked", false);
                        }
                        Result235.close();
                    }
                    finally {
                        if (Result235 != null) {
                            Result235.close();
                        }
                    }
                }
                catch (SQLException Result236) {
                    void ex238;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex238);
                }
            } else {
                player.setAttribute("isAreaLocked", true);
                player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
            }
        }
        if (eventID == exitSettingsWPPanelID) {
            player.setMouseCursorVisible(false);
            SettingsWPPanel.setVisible(false);
        }
        if (eventID == exitSettingsWPPanel1ID) {
            player.setMouseCursorVisible(false);
            AdminToolsWPPanel.setVisible(false);
        }
        if (eventID == exitSettingsWPPanel2ID) {
            player.setMouseCursorVisible(false);
            AdminToolsWPPanelPage2.setVisible(false);
        }
        if (eventID == exitSettingsWPPanel3ID) {
            player.setMouseCursorVisible(false);
            AdminToolsWPPanelPage3.setVisible(false);
        }
        if (eventID == exitSettingsWPPlayerPanel1ID) {
            player.setMouseCursorVisible(false);
            PlayerToolsWPPanel.setVisible(false);
        }
        if (eventID == exitSettingsWPPlayerPanel2ID) {
            player.setMouseCursorVisible(false);
            PlayerToolsWPPanelPage2.setVisible(false);
        }
        if (eventID == exitSettingsWPPlayerPanel3ID) {
            player.setMouseCursorVisible(false);
            PlayerToolsWPPanelPage3.setVisible(false);
        }
        if (eventID == DeleteWPAreaID) {
            if (player.isAdmin()) {
                this.database.executeUpdate("DELETE FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                PlotInfo.setText("Plot Owner=UnClaimed");
                AreaName.setText("Area Name=UnNamed");
                player.sendTextMessage("Area deleted");
                try {
                    void Result237;
                    ResultSet ex238 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                    try {
                        if (Result237.next()) {
                            void CountPlots5;
                            int Points6 = Result237.getInt(1);
                            player.setAttribute("CountPlots", (int)CountPlots5);
                            AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + String.valueOf(player.getAttribute("NeededPoints")));
                        }
                        Result237.close();
                    }
                    finally {
                        if (Result237 != null) {
                            Result237.close();
                        }
                    }
                }
                catch (SQLException Result237) {
                    void ex239;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex239);
                }
                return;
            }
            try {
                void Result238;
                ResultSet ex239 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result238.next()) {
                        this.database.executeUpdate("DELETE FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        PlotInfo.setText("Plot Owner=UnClaimed");
                        AreaName.setText("Area Name=UnNamed");
                        player.sendTextMessage("Area deleted");
                        try {
                            void CountResult;
                            ResultSet CountPlots5 = this.database.executeQuery("SELECT COUNT(*) FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                            try {
                                if (CountResult.next()) {
                                    void CountPlots6;
                                    int ex229 = CountResult.getInt(1);
                                    player.setAttribute("CountPlots", (int)CountPlots6);
                                    AreaAmount.setText("Areas Owned=" + String.valueOf(player.getAttribute("CountPlots")) + ", Needed points for next plot=" + String.valueOf(player.getAttribute("NeededPoints")));
                                }
                                CountResult.close();
                            }
                            finally {
                                if (CountResult != null) {
                                    CountResult.close();
                                }
                            }
                        }
                        catch (SQLException CountResult) {
                            void ex240;
                            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex240);
                        }
                    } else {
                        player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
                    }
                    Result238.close();
                }
                finally {
                    if (Result238 != null) {
                        Result238.close();
                    }
                }
            }
            catch (SQLException Result238) {
                void ex241;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex241);
            }
        }
        if (eventID == ReNameWPAreaID) {
            if (player.isAdmin()) {
                try {
                    void Result239;
                    ResultSet ex241 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                    try {
                        if (Result239.next()) {
                            WPNameTextField.getCurrentText(player, SettingsWPNameTextField -> {
                                player.setAttribute("AreaNameText", SettingsWPNameTextField);
                                this.database.executeUpdate("UPDATE Areas SET AreaName = '" + SettingsWPNameTextField + "' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "'");
                                AreaName.setText("Area Name=" + String.valueOf(player.getAttribute("AreaNameText")));
                                player.sendTextMessage("re named");
                            });
                        }
                        Result239.close();
                    }
                    finally {
                        if (Result239 != null) {
                            Result239.close();
                        }
                    }
                }
                catch (SQLException Result239) {
                    void ex242;
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex242);
                }
                return;
            }
            try {
                void Result240;
                ResultSet ex242 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result240.next()) {
                        WPNameTextField.getCurrentText(player, SettingsWPNameTextField -> {
                            player.setAttribute("AreaNameText", SettingsWPNameTextField);
                            this.database.executeUpdate("UPDATE Areas SET AreaName = '" + SettingsWPNameTextField + "' WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                            AreaName.setText("Area Name=" + String.valueOf(player.getAttribute("AreaNameText")));
                            player.sendTextMessage("re named");
                        });
                    } else {
                        player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
                    }
                    Result240.close();
                }
                finally {
                    if (Result240 != null) {
                        Result240.close();
                    }
                }
            }
            catch (SQLException Result240) {
                void ex243;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex243);
            }
        }
        if (eventID == AddFriendToWPAreaID) {
            try {
                void Result241;
                ResultSet ex243 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "'");
                try {
                    if (Result241.next()) {
                        void AreaZ2;
                        void AreaY2;
                        void AreaX2;
                        void ThisAreaName;
                        String ex240 = Result241.getString("AreaName");
                        int CountPlots6 = (Integer)Result241.getObject("AreaX");
                        int UserName = (Integer)Result241.getObject("AreaY");
                        int RowNumver = (Integer)Result241.getObject("AreaZ");
                        AddFriendToWPAreaTextField.getCurrentText(player, arg_0 -> this.lambda$onPlayerUIEClick$16(player, db, ChunkPosition, PlayerName, (String)ThisAreaName, (int)AreaX2, (int)AreaY2, (int)AreaZ2, PlayerUID, arg_0));
                    } else {
                        player.sendTextMessage("you need to own this plot to do that!!!, use the b key to claim a area");
                    }
                    Result241.close();
                }
                finally {
                    if (Result241 != null) {
                        Result241.close();
                    }
                }
            }
            catch (SQLException Result241) {
                void ex244;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex244);
            }
        }
        if (eventID == RemoveFriendFromWPAreaID) {
            AddFriendToWPAreaTextField.getCurrentText(player, SettingsAddFriendToWPAreaTextField -> {
                if (SettingsAddFriendToWPAreaTextField.equals("")) {
                    player.sendTextMessage("Error!! you need to enter a name");
                    return;
                }
                Player getname = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField);
                if (getname == null) {
                    player.sendTextMessage("Error!! the user must be online and the correct name used");
                    return;
                }
                if (!Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).equals(null)) {
                    String FriendUID = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getUID();
                    String FriendName = Server.getPlayerByName(SettingsAddFriendToWPAreaTextField).getName();
                    try (ResultSet Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "' And `AreaGuest` = '" + FriendUID + "'");){
                        if (Result.next()) {
                            this.database.executeUpdate("DELETE FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.z + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `PlayerUID` = '" + PlayerUID + "' And `AreaGuest` = '" + FriendUID + "'");
                            player.setAttribute("AreaFriendUID", "NoTClaimed");
                            player.sendTextMessage("Friend " + FriendName + " removed from this area");
                            return;
                        }
                        Result.close();
                        player.sendTextMessage("Failed to remove " + FriendName + "!!!");
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        if (eventID == ViewWPAreaID) {
            ResultSet ex244;
            try {
                void Result242;
                ex244 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` = '" + PlayerUID + "'");
                try {
                    while (Result242.next()) {
                        void SetArea;
                        void area;
                        void endPos;
                        void startPos;
                        void EndBlock;
                        void EndChunk;
                        void StartBlock;
                        void StartChunk;
                        void AreaZ;
                        void AreaY;
                        void AreaX;
                        int ThisAreaName = (Integer)Result242.getObject("AreaX");
                        int AreaX2 = (Integer)Result242.getObject("AreaY");
                        int AreaY2 = (Integer)Result242.getObject("AreaZ");
                        Vector3i AreaZ2 = new Vector3i(0, 0, 0);
                        Vector3i Rows = new Vector3i(32, 64, 32);
                        Vector3i CountRows = new Vector3i((int)AreaX, (int)AreaY, (int)AreaZ);
                        Vector3i Backclick = new Vector3i((int)AreaX, (int)AreaY, (int)AreaZ);
                        Vector3f Nextclick = Utils.ChunkUtils.getGlobalPosition((Vector3i)StartChunk, (Vector3i)StartBlock);
                        Vector3f PlayerPlantRemoveVegetation = Utils.ChunkUtils.getGlobalPosition((Vector3i)EndChunk, (Vector3i)EndBlock);
                        Area PlayerRockDestroyVegetation = new Area((Vector3f)startPos, (Vector3f)endPos);
                        Area3D PlayerRockHitVegetation = new Area3D((Area)area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.0f, 0.5f, 0.0f, 0.3f);
                        SetArea.setFrameColor(0.0f, 0.5f, 0.0f, 0.6f);
                        player.addGameObject((GameObject)SetArea);
                        player.setAttribute("UserAreas", SetArea);
                        this.UserAreas.add((Area3D)SetArea);
                        player.setAttribute("TroggleViewAreas", true);
                        HideWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
                        ViewWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 0.5f);
                    }
                    Result242.close();
                }
                finally {
                    if (Result242 != null) {
                        Result242.close();
                    }
                }
            }
            catch (SQLException Result242) {
                void ex245;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex245);
            }
            try {
                ex244 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` = 'Town'");
                try {
                    while (Result242.next()) {
                        int AreaX = (Integer)Result242.getObject("AreaX");
                        int AreaY = (Integer)Result242.getObject("AreaY");
                        int AreaZ = (Integer)Result242.getObject("AreaZ");
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(32, 64, 32);
                        Vector3i StartChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3i EndChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3f startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        Vector3f endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        Area area = new Area(startPos, endPos);
                        Area3D SetArea = new Area3D(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.5f, 0.5f, 0.5f, 0.3f);
                        SetArea.setFrameColor(9.0f, 9.0f, 9.0f, 9.0f);
                        player.addGameObject(SetArea);
                        player.setAttribute("UserAreas", SetArea);
                        this.UserAreas.add(SetArea);
                    }
                    Result242.close();
                }
                finally {
                    if (Result242 != null) {
                        Result242.close();
                    }
                }
            }
            catch (SQLException Result243) {
                void ex246;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex246);
            }
            try {
                ex244 = this.database.executeQuery("SELECT * FROM `Areas` WHERE `PlayerUID` != '" + PlayerUID + "' AND `PlayerUID` != 'Town'");
                try {
                    while (Result242.next()) {
                        int AreaX = (Integer)Result242.getObject("AreaX");
                        int AreaY = (Integer)Result242.getObject("AreaY");
                        int AreaZ = (Integer)Result242.getObject("AreaZ");
                        Vector3i StartBlock = new Vector3i(0, 0, 0);
                        Vector3i EndBlock = new Vector3i(32, 64, 32);
                        Vector3i StartChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3i EndChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3f startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        Vector3f endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        Area area = new Area(startPos, endPos);
                        Area3D SetArea = new Area3D(area);
                        SetArea.setAlwaysVisible(false);
                        SetArea.setFrameVisible(true);
                        SetArea.setColor(0.5f, 0.0f, 0.0f, 0.3f);
                        SetArea.setFrameColor(0.5f, 0.0f, 0.0f, 0.6f);
                        player.addGameObject(SetArea);
                        player.setAttribute("OtherAreas", SetArea);
                        this.OtherAreas.add(SetArea);
                    }
                    Result242.close();
                }
                finally {
                    if (Result242 != null) {
                        Result242.close();
                    }
                }
            }
            catch (SQLException Result244) {
                void ex247;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex247);
            }
            player.setAttribute("preview", true);
        }
        if (eventID == HideWPAreaID) {
            player.setAttribute("TroggleViewAreas", false);
            HideWPArea.setBackgroundColor(0.0f, 1.0f, 0.0f, 0.5f);
            ViewWPArea.setBackgroundColor(1.0f, 0.0f, 0.0f, 0.5f);
            player.setAttribute("preview", false);
            for (Area3D AreaX : this.AllPreviewAreas) {
                void previewArea;
                player.removeGameObject((GameObject)previewArea);
            }
            for (Area3D previewArea : this.OtherAreas) {
                void otherareas;
                player.removeGameObject((GameObject)otherareas);
            }
            for (Area3D otherareas : this.UserAreas) {
                void userareas;
                player.removeGameObject((GameObject)userareas);
            }
        }
        if (eventID == exitHorsePanelID) {
            void DelayUpDate;
            void DelayTimer;
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer ex247 = new Timer(0.5f, 0.5f, 1, null);
            Runnable userareas = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask((Runnable)DelayUpDate);
            DelayTimer.start();
        }
        if (eventID == RemoveHorsebuttonID) {
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            Object AreaY = player.getAttribute("OwnedHorseID");
            try {
                void Result245;
                void HorseID;
                ResultSet AreaZ = this.database.executeQuery("SELECT * FROM `HorseOwnerShip` WHERE HorseID = '" + String.valueOf(HorseID) + "' AND PlayerUID = '" + PlayerUID + "'");
                try {
                    if (Result245.next()) {
                        void npcs3;
                        Npc[] StartBlock = World.getAllNpcs();
                        for (void startPos : npcs3) {
                            void npc;
                            if (!player.getAttribute("OwnedHorseID").equals(npc.getGlobalID())) continue;
                            npc.setName("");
                            npc.setLocked(false);
                        }
                        this.database.executeUpdate("DELETE FROM `HorseOwnerShip` WHERE `HorseID` = '" + String.valueOf(HorseID) + "' AND `PlayerUID` = '" + PlayerUID + "'");
                        player.sendTextMessage("Horse now removed from your ownership");
                    } else {
                        player.sendTextMessage("Something went south!!");
                    }
                    Result245.close();
                }
                finally {
                    if (Result245 != null) {
                        Result245.close();
                    }
                }
            }
            catch (SQLException Result245) {
                void ex248;
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, (Throwable)ex248);
            }
        }
        if (eventID == ReNamebuttonID) {
            void npcs2;
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            Npc[] HorseID = World.getAllNpcs();
            for (void StartChunk : npcs2) {
                void npc;
                if (!player.getAttribute("OwnedHorseID").equals(npc.getGlobalID())) continue;
                HorseTextField.getCurrentText(player, arg_0 -> WorldProtection.lambda$onPlayerUIEClick$21(player, (Npc)npc, arg_0));
            }
        }
        if (eventID == RoambuttonID) {
            void npcs;
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            Object npcs2 = player.getAttribute("OwnedHorseID");
            Npc[] ex248 = World.getAllNpcs();
            for (void EndChunk : npcs) {
                void npc;
                void HorseID;
                if (!HorseID.equals(npc.getGlobalID())) continue;
                npc.setLocked(false);
            }
        }
        if (eventID == CallbuttonID) {
            void StopHorseUpDate;
            void StopHorseTimer;
            void HorseUpDate;
            void HorseTimer;
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            Object HorseID = player.getAttribute("OwnedHorseID");
            this.CalledNPCIDs.add(HorseID);
            player.setAttribute("SetLocation", player.getPosition());
            player.setAttribute("HorsesMoving", true);
            Timer npcs = new Timer(0.5f, 0.0f, 40, null);
            Runnable npcs3 = () -> this.lambda$onPlayerUIEClick$25(HorseID, player, (Timer)HorseTimer);
            HorseTimer.setTask((Runnable)HorseUpDate);
            HorseTimer.start();
            player.setAttribute("HorseTimer", HorseTimer);
            this.CalledNPCHorseTimer.add((Timer)HorseTimer);
            Timer EndBlock = new Timer(1.0f, 39.0f, 1, null);
            Runnable npc = () -> {
                Npc[] npcs;
                for (Npc npc : npcs = World.getAllNpcs()) {
                    if (!HorseID.equals(npc.getGlobalID())) continue;
                    npc.setLocked(true);
                    npc.setAlerted(false);
                }
            };
            StopHorseTimer.setTask((Runnable)StopHorseUpDate);
            StopHorseTimer.start();
            player.setAttribute("StopHorseTimer", StopHorseTimer);
        }
        if (eventID == FollowMebuttonID) {
            void FollowUpDate;
            void FollowTimer;
            void FollowingHorseID;
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            Object HorseID = player.getAttribute("OwnedHorseID");
            this.NPCIDs.add(FollowingHorseID);
            player.setAttribute("HorsesMoving", true);
            Timer HorseTimer = new Timer(0.5f, 0.0f, -1, null);
            Runnable HorseUpDate = () -> WorldProtection.lambda$onPlayerUIEClick$28(FollowingHorseID, (Timer)FollowTimer, player);
            FollowTimer.setTask((Runnable)FollowUpDate);
            FollowTimer.start();
            player.setAttribute("FollowTimer", FollowTimer);
            this.MYFollowTimer.add((Timer)FollowTimer);
        }
        if (eventID == StopFollowingMebuttonID) {
            player.setMouseCursorVisible(false);
            HorsePanel2.setVisible(false);
            player.setAttribute("owner", false);
            Timer DelayTimer = new Timer(1.0f, 1.0f, 1, null);
            Runnable DelayUpDate = () -> {
                player.setAttribute("MenuOpen", false);
                player.setAttribute("OwnedHorseID", 0);
            };
            DelayTimer.setTask(DelayUpDate);
            DelayTimer.start();
            player.getNpcInLineOfSight(500.0f, getnpc -> {
                for (Object follow : this.NPCIDs) {
                    if (getnpc != null && follow.equals(getnpc.getGlobalID())) {
                        for (Timer followtimer : this.MYFollowTimer) {
                            int timerIDS = (Integer)getnpc.getAttribute("TimerIDs");
                            if (followtimer.getID() != timerIDS) continue;
                            followtimer.kill();
                        }
                        getnpc.setLocked(true);
                        this.NPCIDs.remove(follow);
                    }
                    getnpc.setLocked(true);
                }
            });
        }
        FoxButtons DelayTimer = new FoxButtons(this);
        FoxButtons2.FoxButtons(event);
        UILabel DelayUpDate = (UILabel)player.getAttribute("BluePrintTextField");
        UITextField FollowingHorseID = (UITextField)player.getAttribute("BluePrintID");
        int FollowTimer = (Integer)player.getAttribute("BluePrintExitButtonID");
        if (eventID == BluePrintExitButtonID) {
            BluePrintTextField.setText("");
            BluePrintTextField.setVisible(false);
            player.setMouseCursorVisible(false);
        }
        int FollowUpDate = (Integer)player.getAttribute("BluePrintTpButtonID");
        if (eventID == BluePrintTpButtonID) {
            void BluePrintID;
            BluePrintTextField.setText("");
            BluePrintTextField.setVisible(false);
            player.setMouseCursorVisible(false);
            BluePrintID.getCurrentText(player, BluePrintIDText -> {
                player.setAttribute("BluePrintIDText", BluePrintIDText);
                try (ResultSet Result = this.database.executeQuery("SELECT * FROM `BluePrintCreater` WHERE ID = '" + BluePrintIDText + "'");){
                    if (Result.next()) {
                        String BPPosition = Result.getString("PlacedPosition");
                        Vector3f Location2 = new Vector3f().add(Vector3f.ONE).fromString(BPPosition);
                        player.setPosition(Location2);
                    } else {
                        player.sendTextMessage("something went wrong!!!");
                    }
                    Result.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        int StopHorseTimer = (Integer)player.getAttribute("BluePrintNextButtonID");
        if (eventID == BluePrintNextButtonID) {
            void BlueprintNext2;
            BluePrintTextField.setText("");
            BluePrintTextField.setVisible(false);
            BlueprintNext StopHorseUpDate = new BlueprintNext(this);
            BlueprintNext2.BlueprintNext(player);
        }
        int BlueprintNext2 = (Integer)player.getAttribute("BluePrintBackButtonID");
        if (eventID == BluePrintBackButtonID) {
            void BlueprintBack2;
            BluePrintTextField.setText("");
            BluePrintTextField.setVisible(false);
            BlueprintBack npc = new BlueprintBack(this);
            BlueprintBack2.BlueprintBack(player);
        }
        UILabel BlueprintBack2 = (UILabel)player.getAttribute("AreaTextField");
        UITextField npc = (UITextField)player.getAttribute("AreaID");
        int endPos = (Integer)player.getAttribute("AreaExitButtonID");
        if (eventID == AreaExitButtonID) {
            AreaTextField.setText("");
            AreaTextField.setVisible(false);
            player.setMouseCursorVisible(false);
        }
        int area = (Integer)player.getAttribute("AreaTpButtonID");
        if (eventID == AreaTpButtonID) {
            void AreaID;
            AreaTextField.setText("");
            AreaTextField.setVisible(false);
            player.setMouseCursorVisible(false);
            AreaID.getCurrentText(player, AreaIDText -> {
                player.setAttribute("AreaIDText", AreaIDText);
                try (ResultSet Result = this.database.executeQuery("SELECT * FROM `Areas` WHERE ID = '" + AreaIDText + "'");){
                    if (Result.next()) {
                        int AreaX = (Integer)Result.getObject("AreaX");
                        int AreaY = (Integer)Result.getObject("AreaY");
                        int AreaZ = (Integer)Result.getObject("AreaZ");
                        Vector3i StartBlock = new Vector3i(16, 32, 16);
                        Vector3i EndBlock = new Vector3i(32, 64, 32);
                        Vector3i StartChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3i EndChunk = new Vector3i(AreaX, AreaY, AreaZ);
                        Vector3f startPos = Utils.ChunkUtils.getGlobalPosition(StartChunk, StartBlock);
                        Vector3f endPos = Utils.ChunkUtils.getGlobalPosition(EndChunk, EndBlock);
                        Chunk locate = World.getChunk(EndChunk.x, EndChunk.z);
                        float SurfaceLevel = locate.getLODSurfaceLevel(0, 0, true);
                        if (player.isFlying()) {
                            player.setPosition(startPos);
                        } else {
                            player.setGravity(-1.81f);
                            player.setPosition(startPos.x, SurfaceLevel + 5.0f, startPos.z);
                            Timer GravityTimer = new Timer(1.0f, 60.0f, 0, null);
                            Runnable GravityUpDate = () -> {
                                player.setGravity(-9.81f);
                                player.setHealth(100);
                                player.sendTextMessage("Gravity Cool Down Over");
                                GravityTimer.kill();
                            };
                            GravityTimer.setTask(GravityUpDate);
                            GravityTimer.start();
                        }
                    } else {
                        player.sendTextMessage("something went wrong!!!");
                    }
                    Result.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        int SetArea = (Integer)player.getAttribute("AreaNextButtonID");
        if (eventID == AreaNextButtonID) {
            void AreaNext2;
            AreaTextField.setText("");
            AreaTextField.setVisible(false);
            AreaNext PlayerRockRemoveVegetation = new AreaNext(this);
            AreaNext2.AreaNext(player);
        }
        int AreaNext2 = (Integer)player.getAttribute("AreaBackButtonID");
        if (eventID == AreaBackButtonID) {
            void AreaBack2;
            AreaTextField.setText("");
            AreaTextField.setVisible(false);
            AreaBack PlayerClockUseObject = new AreaBack(this);
            AreaBack2.AreaBack(player);
        }
    }

    @EventMethod
    public void onPlayerMouseButtonEvent(PlayerMouseButtonEvent event) throws SQLException {
        Player player = event.getPlayer();
        String PlayerUID = player.getUID();
        MouseButton clicked = event.getButton();
        UITextField HorseTextField = (UITextField)player.getAttribute("HorseTextField");
        if (event.isPressed() && event.getButton() == MouseButton.Right) {
            TameAnimals TameAnimals2 = new TameAnimals(this);
            TameAnimals2.TameAnimals(player);
        }
        if (Boolean.FALSE.equals(player.getAttribute("MenuOpen")) && event.isPressed() && event.getButton() == MouseButton.Left && Boolean.FALSE.equals(player.getAttribute("KeyFPressed"))) {
            OpenNPCPanels OpenNPCPanels2 = new OpenNPCPanels(this);
            OpenNPCPanels2.OpenNPCPanels(player);
        }
        player.setAttribute("owner", false);
    }

    @EventMethod
    public void onPlayerCommandEvent(PlayerCommandEvent event) throws SQLException, ParseException {
        String[] cmd = event.getCommand().split(" ");
        Player player = event.getPlayer();
        String playerUID = player.getUID();
        WorldDatabase db = this.getWorldDatabase(WorldDatabase.Target.Players);
        if (cmd[0].equalsIgnoreCase("/Lock")) {
            if (player.isAdmin()) {
                ResetAllAreasProectionToOff ResetAllAreasProectionToOff2 = new ResetAllAreasProectionToOff(this);
                ResetAllAreasProectionToOff2.RunLockUpUpdate(player);
            } else {
                player.sendTextMessage("This is an admin only tool!!!");
            }
        }
        if (cmd[0].equalsIgnoreCase("/Risingworld")) {
            if (player.isAdmin()) {
                player.sendTextMessage("this is risingworld admin test");
                try (ResultSet result2 = db.executeQuery("SELECT * FROM `areas` WHERE `creator` = '" + playerUID + "'");){
                    if (result2.next()) {
                        String areaname = result2.getString("name");
                        String claimable = result2.getString("claimable");
                        player.sendTextMessage("areaname=" + areaname + " claimable=" + claimable);
                        db.executeUpdate("UPDATE areas SET claimable = '1'");
                    }
                }
                catch (SQLException result2) {}
            } else {
                player.sendTextMessage("This is an admin only tool!!!");
            }
        }
        if (cmd[0].equalsIgnoreCase("/list")) {
            OpenBluePrintPanel OpenBluePrintPanel2 = new OpenBluePrintPanel(this);
            OpenBluePrintPanel2.OpenBluePrintPanel(player);
        }
        if (cmd[0].equalsIgnoreCase("/arealist")) {
            OpenAreaPanel OpenAreaPanel2 = new OpenAreaPanel(this);
            OpenAreaPanel2.OpenAreaPanel(player);
        }
        if (cmd[0].equalsIgnoreCase("/WP")) {
            player.setMouseCursorVisible(true);
            OpenWPCommand OpenWPCommand2 = new OpenWPCommand(this);
            OpenWPCommand2.OpenWPCommand(player);
        }
        if (cmd[0].equalsIgnoreCase("/blockinfo")) {
            if (Boolean.FALSE.equals(player.getAttribute("ConstructionElementInfo"))) {
                player.setAttribute("ConstructionElementInfo", true);
                player.sendTextMessage("Block info turned on");
            } else if (Boolean.TRUE.equals(player.getAttribute("ConstructionElementInfo"))) {
                player.setAttribute("ConstructionElementInfo", false);
                player.sendTextMessage("Block info turned off");
            }
        }
    }

    private static /* synthetic */ void lambda$onPlayerUIEClick$28(Object FollowingHorseID, Timer FollowTimer, Player player) {
        Npc[] npcs;
        for (Npc npc : npcs = World.getAllNpcs()) {
            if (!FollowingHorseID.equals(npc.getGlobalID())) continue;
            npc.setLocked(false);
            npc.setAttribute("TimerIDs", FollowTimer.getID());
            player.setAttribute("HorsesPosition", npc.getPosition());
            npc.moveTo(player.getPosition());
        }
    }

    private /* synthetic */ void lambda$onPlayerUIEClick$25(Object HorseID, Player player, Timer HorseTimer) {
        Npc[] npcs;
        for (Npc npc : npcs = World.getAllNpcs()) {
            if (!HorseID.equals(npc.getGlobalID())) continue;
            player.setAttribute("HorsesPosition", npc.getPosition());
            npc.setAttribute("CalledTimerIDs", HorseTimer.getID());
            if (Boolean.TRUE.equals(player.getAttribute("HorsesMoving"))) {
                npc.setLocked(false);
                npc.moveTo(player.getPosition());
                player.setAttribute("HorsesMoving", false);
            }
            npc.setAlerted(true, 1);
            npc.moveTo(player.getPosition());
            player.getNpcInLineOfSight(4.0f, getnpc -> {
                for (Object Called : this.CalledNPCIDs) {
                    if (getnpc == null || !Called.equals(getnpc.getGlobalID())) continue;
                    getnpc.setLocked(true);
                    getnpc.setAlerted(false);
                    HorseTimer.kill();
                    for (Timer Calledfollowtimer : this.CalledNPCHorseTimer) {
                        int CalledtimerIDS = (Integer)getnpc.getAttribute("CalledTimerIDs");
                        if (Calledfollowtimer.getID() != CalledtimerIDS) continue;
                        Calledfollowtimer.kill();
                        this.CalledNPCIDs.remove(getnpc.getGlobalID());
                    }
                }
            });
        }
    }

    private static /* synthetic */ void lambda$onPlayerUIEClick$21(Player player, Npc npc, String HorseNameTextField) {
        player.setAttribute("HorseNameTextField", HorseNameTextField);
        player.sendTextMessage("New Horse Name: " + HorseNameTextField);
        npc.setName(HorseNameTextField);
    }

    private /* synthetic */ void lambda$onPlayerUIEClick$16(Player player, WorldDatabase db, Vector3i ChunkPosition, String PlayerName, String ThisAreaName, int AreaX, int AreaY, int AreaZ, String PlayerUID, String SettingsAddFriendToWPAreaTextField) {
        if (SettingsAddFriendToWPAreaTextField.equals("")) {
            player.sendTextMessage("Error!! you need to enter a name");
            return;
        }
        try (ResultSet Nameresult = db.executeQuery("SELECT * FROM `player` WHERE `name` = '" + SettingsAddFriendToWPAreaTextField + "'");){
            if (!Nameresult.next()) {
                player.sendTextMessage("Failed to get Player UID Try Again");
                player.setAttribute("NamePass", false);
                return;
            }
            String FriendUID = Nameresult.getString("uid");
            String FriendName = Nameresult.getString("name");
            player.sendTextMessage("Player UID=" + FriendUID);
            player.setAttribute("AreaFriendUID", FriendUID);
            player.setAttribute("FriendName", FriendName);
            player.setAttribute("NamePass", true);
            Nameresult.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.TRUE.equals(player.getAttribute("NamePass"))) {
            try (ResultSet FriendResult = this.database.executeQuery("SELECT * FROM `Areas` WHERE `AreaX` = '" + ChunkPosition.x + "' AND `AreaY` = '" + ChunkPosition.y + "' AND `AreaZ` = '" + ChunkPosition.z + "' AND `AreaGuest` = '" + String.valueOf(player.getAttribute("AreaFriendUID")) + "'");){
                if (FriendResult.next()) {
                    player.sendTextMessage("Error!! this user has already been added to this area");
                    return;
                }
                FriendResult.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(WorldProtection.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.database.executeUpdate("INSERT INTO `Areas` (AreaOwnerName, AreaName, AreaGuest, AreaX, AreaY, AreaZ, PlayerUID) VALUES ('" + PlayerName + "','" + ThisAreaName + "','" + String.valueOf(player.getAttribute("AreaFriendUID")) + "','" + AreaX + "','" + AreaY + "','" + AreaZ + "','" + PlayerUID + "');");
            player.sendTextMessage("friend " + String.valueOf(player.getAttribute("FriendName")) + " added to this area");
            player.setAttribute("NamePass", false);
            return;
        }
        player.sendTextMessage("Error!!!");
    }

    private static /* synthetic */ void lambda$onPlayerUIEClick$10(Player player, Area3D SetArea) {
        player.removeGameObject(SetArea);
    }
}

