/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.objects.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements._WorldElement;

class _WorldArea
extends _WorldElement {
    private Area area = null;
    private boolean alwaysVisible = true;
    private boolean frameVisible = true;
    private int color;
    private int frameColor = this.color = -120;

    public _WorldArea(Area area) {
        this.area = area;
        this.setPositionAndRotation();
    }

    public void setArea(Area area) {
        this.area = area;
        this.setPositionAndRotation();
        this.updateElement(true);
    }

    public void updateCoordinates() {
        if (this.area != null) {
            this.setPositionAndRotation();
            this.updateElement(true);
        }
    }

    public Area getArea() {
        return this.area;
    }

    public void setAlwaysVisible(boolean set) {
        if (this.alwaysVisible != set) {
            this.alwaysVisible = set;
            this.updateElement(false);
        }
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setFrameVisible(boolean set) {
        if (this.frameVisible != set) {
            this.frameVisible = set;
            this.updateElement(false);
        }
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateElement(false);
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getColor() {
        return this.color;
    }

    public void setFrameColor(int color) {
        if (this.frameColor != color) {
            this.frameColor = color;
            this.updateElement(false);
        }
    }

    public void setFrameColor(float r, float g, float b, float a) {
        this.setFrameColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getFrameColor() {
        return this.frameColor;
    }

    private void setPositionAndRotation() {
    }

    private void updateElement(boolean updateArea) {
    }
}

