/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.jiw.unity.runtime.PluginGameObjectManager;
import net.risingworld.api.objects.Area;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.GameObject;

public class Area3D
extends GameObject {
    Area area = null;
    boolean alwaysVisible = false;
    boolean frameVisible = true;
    int color = -16777080;
    int frameColor = -16776961;
    private static final int TYPE = 4;

    public Area3D(Area area) {
        if (area == null) {
            throw new NullPointerException("The provided area must not be null!");
        }
        this.area = area;
        this.setLocalPosition(area.getStartPosition());
    }

    @Override
    int getType() {
        return 4;
    }

    public void setArea(Area area) {
        if (area == null) {
            throw new UnsupportedOperationException("Area must not be null");
        }
        if (area == Area.INFINITE) {
            throw new UnsupportedOperationException("Cannot assign infinite area");
        }
        this.area = area;
        this.updateArea3D();
    }

    public Area getArea() {
        return this.area;
    }

    private long getAreaID() {
        return this.area == null ? 0L : this.area.getID();
    }

    public void updateCoordinates() {
        if (this.area != null) {
            this.updateArea3D();
        }
    }

    public void setAlwaysVisible(boolean set) {
        if (this.alwaysVisible != set) {
            this.alwaysVisible = set;
            this.updateArea3D();
        }
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setFrameVisible(boolean set) {
        if (this.frameVisible != set) {
            this.frameVisible = set;
            this.updateArea3D();
        }
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setColor(ColorRGBA color) {
        this.setColor(color.toIntRGBA());
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.updateArea3D();
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setFrameColor(float r, float g, float b, float a) {
        this.setFrameColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setFrameColor(ColorRGBA color) {
        this.setFrameColor(color.toIntRGBA());
    }

    public void setFrameColor(int color) {
        if (this.frameColor != color) {
            this.frameColor = color;
            this.updateArea3D();
        }
    }

    public int getFrameColor() {
        return this.frameColor;
    }

    private void updateArea3D() {
        PluginGameObjectManager.updateObject((GameObject)this, (int)this.id, (boolean)false);
    }
}

