/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui;

import net.jiw.unity.runtime.PluginUIManager;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.utils.Utils;

public class UITextField
extends UIElement {
    String text;
    String placeholderText;
    boolean multiline = false;
    boolean readonly = false;
    boolean isMasked = false;
    char maskedCharacter = (char)42;
    int maxCharacters = -1;
    private static final int TYPE = 2;

    public UITextField() {
        this("");
    }

    public UITextField(String initialText) {
        this.text = initialText;
    }

    public void setText(String text) {
        this.text = text;
        this.updateTextField(true);
    }

    public void setMultiLine(boolean set) {
        if (this.multiline != set) {
            this.multiline = set;
            this.updateTextField(false);
        }
    }

    public boolean isMultiLine() {
        return this.multiline;
    }

    public void setReadOnly(boolean set) {
        if (this.readonly != set) {
            this.readonly = set;
            this.updateTextField(false);
        }
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setMasked(boolean set) {
        if (this.isMasked != set) {
            this.isMasked = set;
            this.updateTextField(false);
        }
    }

    public boolean isMasked() {
        return this.isMasked;
    }

    public void setMaskedCharacter(char c) {
        if (this.maskedCharacter != c) {
            this.maskedCharacter = c;
            this.updateTextField(false);
        }
    }

    public char getMaskedCharacter() {
        return this.maskedCharacter;
    }

    public void setMaxCharacters(int length) {
        if (this.maxCharacters != length) {
            this.maxCharacters = length;
            this.updateTextField(false);
        }
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setFontSize(float size) {
        this.style.fontSize.set(size);
        this.updateStyle();
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setFontColor(int rgba) {
        this.style.color.set(rgba);
        this.updateStyle();
    }

    public void getCurrentText(Player player, Callback<String> callback) {
        if (player == null || callback == null) {
            return;
        }
        PluginUIManager.getUITextFieldText((int)player.getDbID(), (UITextField)this, (int)this.id, callback);
    }

    @Override
    int getType() {
        return 2;
    }

    void updateTextField(boolean updateText) {
        PluginUIManager.updateUITextField((UITextField)this, (int)this.id, (boolean)updateText);
    }
}

