/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.world.ObjectElement;

public abstract class PlayerObjectEvent
extends PlayerEvent
implements Cancellable {
    protected PlayerObjectEvent(long pointer) {
        super(pointer);
    }

    public long getGlobalID() {
        this.CheckIsValid();
        return this.getGlobalID(this.pointer);
    }

    public short getTypeID() {
        this.CheckIsValid();
        return this.getObjectTypeID(this.pointer);
    }

    public int getChunkPositionX() {
        this.CheckIsValid();
        return this.getChunkPositionX(this.pointer);
    }

    public int getChunkPositionY() {
        this.CheckIsValid();
        return this.getChunkPositionY(this.pointer);
    }

    public int getChunkPositionZ() {
        this.CheckIsValid();
        return this.getChunkPositionZ(this.pointer);
    }

    protected ObjectElement getObject() {
        this.CheckIsValid();
        return this.getObjectElement(this.pointer);
    }

    public Objects.ObjectDefinition getObjectDefinition() {
        return Definitions.getObjectDefinition(this.getObjectTypeID(this.pointer));
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native long getGlobalID(long var1);

    private native short getObjectTypeID(long var1);

    private native int getChunkPositionX(long var1);

    private native int getChunkPositionY(long var1);

    private native int getChunkPositionZ(long var1);

    private native ObjectElement getObjectElement(long var1);
}

