/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;

public final class Crafting {
    private Crafting() {
    }

    public final class CraftingRequirement {
        public short id;
        public String recipe;
        public int texture;
        public Requirement[] requirements;
        public String rawrequirementstring;

        private CraftingRequirement(Crafting this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.recipe = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.texture = buffer.getInt();
            int irequirements = buffer.getInt();
            if (irequirements == -1) {
                this.requirements = null;
            } else if (irequirements >= 0) {
                this.requirements = new Requirement[irequirements];
                for (int i = 0; i < irequirements; ++i) {
                    this.requirements[i] = new Requirement(this);
                    this.requirements[i].deserialize(buffer);
                }
            }
            this.rawrequirementstring = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.recipe);
            buffer.putInt(this.texture);
            if (this.requirements == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.requirements.length);
                for (int i = 0; i < this.requirements.length; ++i) {
                    this.requirements[i].serialize(buffer);
                }
            }
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.rawrequirementstring);
        }

        private int getSize() {
            int size = 8;
            size += 2;
            if (this.recipe != null) {
                size += this.recipe.length() * 2;
            }
            size += 4;
            if (this.requirements != null) {
                for (int i = 0; i < this.requirements.length; ++i) {
                    size += this.requirements[i].getSize();
                }
            }
            size += 2;
            if (this.rawrequirementstring != null) {
                size += this.rawrequirementstring.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeCraftingRequirement(this.serialize());
        }

        public final class Requirement {
            public Type type;
            public String item;
            public Items.Group group;
            public int count;

            private Requirement(CraftingRequirement this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.type = Type.get(buffer.getInt());
                this.item = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.group = Items.Group.get(buffer.getInt());
                this.count = buffer.getInt();
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.type == null) {
                    throw new IllegalArgumentException("Enumeration must not be null!");
                }
                buffer.putInt(this.type.value);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.item);
                if (this.group == null) {
                    throw new IllegalArgumentException("Enumeration must not be null!");
                }
                buffer.putInt(this.group.value);
                buffer.putInt(this.count);
            }

            private int getSize() {
                int size = 12;
                size += 2;
                if (this.item != null) {
                    size += this.item.length() * 2;
                }
                return size;
            }

            public static enum Type {
                Item(0),
                Object(1),
                Construction(2),
                Clothing(3);

                public final int value;
                private static Type[] values;

                private Type(int i) {
                    this.value = i;
                }

                public static Type get(int value) {
                    if (values == null) {
                        values = Type.values();
                    }
                    for (int i = 0; i < values.length; ++i) {
                        if (Type.values[i].value != value) continue;
                        return values[i];
                    }
                    return null;
                }
            }
        }
    }

    public final class CraftingStation {
        public short id;
        public String name;
        public CraftingStationType maintype;
        public CraftingStationType type;

        private CraftingStation(Crafting this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.maintype = CraftingStationType.get(buffer.getInt());
            this.type = CraftingStationType.get(buffer.getInt());
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.maintype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.maintype.value);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
        }

        private int getSize() {
            int size = 12;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeCraftingStation(this.serialize());
        }
    }

    public final class Recipe {
        public short id;
        public RecipeType type;
        public String name;
        public int texture;
        public int amount;
        public Category category;
        public SubCategory subCategory;
        public boolean newLine;
        public Ingredient[] ingredients;
        public CraftingStation[] requiredCraftingStations;
        public Items.ItemDefinition itemDef;
        public String rawingredientstring;
        public String rawworkbenchesstring;
        public boolean hasVariants;
        public Recipe parent;

        private Recipe(Crafting this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.type = RecipeType.get(buffer.getInt());
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.texture = buffer.getInt();
            this.amount = buffer.getInt();
            this.category = Category.get(buffer.getInt());
            this.subCategory = SubCategory.get(buffer.getInt());
            this.newLine = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            int iingredients = buffer.getInt();
            if (iingredients == -1) {
                this.ingredients = null;
            } else if (iingredients >= 0) {
                this.ingredients = new Ingredient[iingredients];
                for (int i = 0; i < iingredients; ++i) {
                    this.ingredients[i] = new Ingredient(this);
                    this.ingredients[i].deserialize(buffer);
                }
            }
            int irequiredCraftingStations = buffer.getInt();
            if (irequiredCraftingStations == -1) {
                this.requiredCraftingStations = null;
            } else if (irequiredCraftingStations >= 0) {
                this.requiredCraftingStations = new CraftingStation[irequiredCraftingStations];
                for (int i = 0; i < irequiredCraftingStations; ++i) {
                    int requiredCraftingStations_id = buffer.getInt();
                    this.requiredCraftingStations[i] = requiredCraftingStations_id == -1 ? null : Definitions.getCraftingStation(requiredCraftingStations_id);
                }
            }
            int itemDef_id = buffer.getInt();
            this.itemDef = itemDef_id == -1 ? null : Definitions.getItemDefinition(itemDef_id);
            this.rawingredientstring = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.rawworkbenchesstring = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.hasVariants = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            int parent_id = buffer.getInt();
            this.parent = parent_id == -1 ? null : Definitions.getRecipe(parent_id);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            int i;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            buffer.putInt(this.texture);
            buffer.putInt(this.amount);
            if (this.category == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.category.value);
            if (this.subCategory == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.subCategory.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.newLine);
            if (this.ingredients == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.ingredients.length);
                for (i = 0; i < this.ingredients.length; ++i) {
                    this.ingredients[i].serialize(buffer);
                }
            }
            if (this.requiredCraftingStations == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.requiredCraftingStations.length);
                for (i = 0; i < this.requiredCraftingStations.length; ++i) {
                    if (this.requiredCraftingStations[i] == null) {
                        buffer.putInt(-1);
                        continue;
                    }
                    buffer.putInt(this.requiredCraftingStations[i].id);
                }
            }
            if (this.itemDef == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.itemDef.id);
            }
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.rawingredientstring);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.rawworkbenchesstring);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasVariants);
            if (this.parent == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.parent.id);
            }
        }

        private int getSize() {
            int size = 34;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 4;
            if (this.ingredients != null) {
                for (int i = 0; i < this.ingredients.length; ++i) {
                    size += this.ingredients[i].getSize();
                }
            }
            size += 4;
            if (this.requiredCraftingStations != null) {
                size += this.requiredCraftingStations.length * 4;
            }
            size += 2;
            if (this.rawingredientstring != null) {
                size += this.rawingredientstring.length() * 2;
            }
            size += 2;
            if (this.rawworkbenchesstring != null) {
                size += this.rawworkbenchesstring.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeRecipe(this.serialize());
            if (this.requiredCraftingStations != null) {
                for (int i = 0; i < this.requiredCraftingStations.length; ++i) {
                    CraftingStation obj = this.requiredCraftingStations[i];
                    if (obj == null || synchronizedObjects.contains(obj)) continue;
                    obj.synchronize(synchronizedObjects);
                }
            }
            if (this.itemDef != null && !synchronizedObjects.contains(this.itemDef)) {
                this.itemDef.synchronize(synchronizedObjects);
            }
            if (this.parent != null && !synchronizedObjects.contains(this.parent)) {
                this.parent.synchronize(synchronizedObjects);
            }
        }

        public final class Ingredient {
            public Items.ItemDefinition itemDef;
            public Items.Group group;
            public int count;
            public int texture;
            public boolean consume;

            private Ingredient(Recipe this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int itemDef_id = buffer.getInt();
                this.itemDef = itemDef_id == -1 ? null : Definitions.getItemDefinition(itemDef_id);
                this.group = Items.Group.get(buffer.getInt());
                this.count = buffer.getInt();
                this.texture = buffer.getInt();
                this.consume = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.itemDef == null) {
                    buffer.putInt(-1);
                } else {
                    buffer.putInt(this.itemDef.id);
                }
                if (this.group == null) {
                    throw new IllegalArgumentException("Enumeration must not be null!");
                }
                buffer.putInt(this.group.value);
                buffer.putInt(this.count);
                buffer.putInt(this.texture);
                InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.consume);
            }

            private int getSize() {
                int size = 17;
                return size;
            }
        }
    }

    public static enum RecipeType {
        Item(0),
        Block(1),
        Construction(2),
        Object(3),
        Clothing(4),
        Vehicle(5),
        VehicleComponent(6),
        Food(7);

        public final int value;
        private static RecipeType[] values;

        private RecipeType(int i) {
            this.value = i;
        }

        public static RecipeType get(int value) {
            if (values == null) {
                values = RecipeType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (RecipeType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum CraftingStationType {
        None(0),
        PrimitiveWorkbench(1),
        Workbench(2),
        ModernWorkbench(4),
        Anvil(8),
        Furnace(16),
        BlueprintTable(32),
        Spinningwheel(64);

        public final int value;
        private static CraftingStationType[] values;

        private CraftingStationType(int i) {
            this.value = i;
        }

        public static CraftingStationType get(int value) {
            if (values == null) {
                values = CraftingStationType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (CraftingStationType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum SubCategory {
        None(-1),
        Resources(0),
        Survival(1),
        Workbenches(100),
        Furnaces(101),
        OtherWorkbenches(102),
        Cooking(103),
        Wood(200),
        Woodplanks(201),
        Woodother(202),
        Stone(203),
        Sandstone(204),
        Bricks(205),
        Marble(206),
        Concrete(207),
        Asphalt(208),
        Plaster(209),
        Loam(210),
        Tiles(211),
        Metal(212),
        Emissive(213),
        Glass(214),
        Roofing(215),
        Fabric(216),
        Misc(217),
        Natural(218),
        Storages(300),
        Signs(301),
        Doors(302),
        Beds(303),
        Seatings(304),
        Tables(305),
        Ladders(306),
        Lights(307),
        Barriers(308),
        Cabinets(309),
        Music(310),
        WindowFrames(311),
        Decoration(312),
        Other(313),
        PrimitiveTools(400),
        BasicTools(401),
        AdvancedTools(402),
        PrimitiveWeapons(500),
        MeleeWeapons(501),
        RangedWeapons(502),
        Firearms(503),
        Ammo(504),
        Explosives(505),
        ShootingTargets(506),
        General(600),
        Navigation(601),
        Container(602),
        Fishing(603),
        Camping(604),
        Mounts(605),
        FirstAid(700),
        Bread(800),
        Snacks(801),
        Outfits(900),
        Top(901),
        Pants(902),
        Shoes(903),
        Headgear(904),
        Accessory(905),
        Cables(1000),
        Logic(1001),
        Generators(1002),
        Batteries(1003),
        Boats(1100),
        BaseKits(1101),
        Paddles(1102),
        Engines(1103),
        VehicleStorages(1104),
        Build(1200),
        Scaffoldings(1201),
        Fun(1202),
        Fireworks(1203),
        Miscellaneous(1204);

        public final int value;
        private static SubCategory[] values;

        private SubCategory(int i) {
            this.value = i;
        }

        public static SubCategory get(int value) {
            if (values == null) {
                values = SubCategory.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (SubCategory.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Category {
        General(0),
        CraftingStations(100),
        Build(200),
        Furnishings(300),
        Tools(400),
        Weapons(500),
        Equipment(600),
        Medical(700),
        Food(800),
        Clothing(900),
        Electricity(1000),
        Vehicles(1100),
        Miscellaneous(1200);

        public final int value;
        private static Category[] values;

        private Category(int i) {
            this.value = i;
        }

        public static Category get(int value) {
            if (values == null) {
                values = Category.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Category.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

