/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import java.util.Objects;
import net.jiw.unity.runtime.PluginGameObjectManager;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.worldelements.GameObject;

public class Text3D
extends GameObject {
    String text;
    int fontColor = -1;
    float fontSize;
    TextWrappingMode textWrapping = TextWrappingMode.NoWrap;
    Vector2f textContainer = new Vector2f(0.0f, 0.0f);
    boolean alwaysVisible;
    boolean billboard;
    private static final int TYPE = 3;

    public Text3D(String text) {
        this(text, false);
    }

    public Text3D(String text, boolean billboard) {
        this.text = text;
        this.billboard = billboard;
    }

    @Override
    int getType() {
        return 3;
    }

    public void setText(String text) {
        if (!Objects.equals(this.text, text)) {
            this.text = text;
            this.updateText3D();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setFontColor(int rgba) {
        if (this.fontColor != rgba) {
            this.fontColor = rgba;
            this.updateText3D();
        }
    }

    public void setFontSize(float size) {
        if (this.fontSize != size) {
            this.fontSize = size;
            this.updateText3D();
        }
    }

    public void setTextWrappingMode(TextWrappingMode textWrap) {
        if (this.textWrapping != textWrap) {
            this.textWrapping = textWrap;
            this.updateText3D();
        }
    }

    public TextWrappingMode getTextWrappingMode() {
        return this.textWrapping;
    }

    public void setTextContainer(float width, float height) {
        if (this.textContainer.x != width || this.textContainer.y != height) {
            this.textContainer.set(width, height);
            this.updateText3D();
        }
    }

    public void setBillboard(boolean set) {
        if (this.billboard != set) {
            this.billboard = set;
            this.updateText3D();
        }
    }

    public void setAlwaysVisible(boolean set) {
        if (this.alwaysVisible != set) {
            this.alwaysVisible = set;
            this.updateText3D();
        }
    }

    private void updateText3D() {
        PluginGameObjectManager.updateObject((GameObject)this, (int)this.id, (boolean)false);
    }

    public static enum TextWrappingMode {
        NoWrap,
        Normal,
        PreserveWhitespace,
        PreserveWhitespaceNoWrap;

    }
}

