/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Vector3f;

public class Vector3i {
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f RIGHT = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f LEFT = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f DOWN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static final Vector3f FORWARD = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f BACK = new Vector3f(0.0f, 0.0f, -1.0f);
    public int x;
    public int y;
    public int z;

    public Vector3i() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(Vector3i copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Vector3i copy() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public Vector3i set(Vector3i vector) {
        return this.set(vector.x, vector.y, vector.z);
    }

    public Vector3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3i setX(int x) {
        this.x = x;
        return this;
    }

    public Vector3i setY(int y) {
        this.y = y;
        return this;
    }

    public Vector3i setZ(int z) {
        this.z = z;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public float dot(Vector3i other) {
        return this.dot(other.x, other.y, other.z);
    }

    public float dot(int x, int y, int z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(Vector3i other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y, other.z));
    }

    public float distance(int x, int y, int z) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z));
    }

    public float distanceSquared(Vector3i other) {
        return this.distanceSquared(other.x, other.y, other.z);
    }

    public float distanceSquared(int x, int y, int z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public Vector3i addLocal(Vector3i other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Vector3i addLocal(int addX, int addY, int addZ) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        return this;
    }

    public Vector3i subtractLocal(Vector3i other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public Vector3i subtractLocal(int subtractX, int subtractY, int subtractZ) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        return this;
    }

    public Vector3i multLocal(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3i multLocal(Vector3i other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        return this;
    }

    public Vector3i multLocal(int multX, int multY, int multZ) {
        this.x *= this.x;
        this.y *= this.y;
        this.z *= this.z;
        return this;
    }

    public Vector3i divideLocal(int scalar) {
        float s = 1.0f / (float)scalar;
        this.x = (int)((float)this.x * s);
        this.y = (int)((float)this.y * s);
        this.z = (int)((float)this.z * s);
        return this;
    }

    public Vector3i divideLocal(Vector3i other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        return this;
    }

    public Vector3i negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i crossLocal(Vector3i other) {
        return this.crossLocal(other.x, other.y, other.z);
    }

    public Vector3i crossLocal(int v2x, int v2y, int v2z) {
        int nx = this.y * v2z - this.z * v2y;
        int ny = this.z * v2x - this.x * v2z;
        int nz = this.x * v2y - this.y * v2x;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Vector3i normalizeLocal() {
        float l = this.length();
        this.x = (int)((float)this.x / l);
        this.y = (int)((float)this.y / l);
        this.z = (int)((float)this.z / l);
        return this;
    }

    public float angleBetween(Vector3i other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public Vector3i zero() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector3i other) {
        return this.isOrthogonal(other.x, other.y, other.z);
    }

    public boolean isOrthogonal(int x, int y, int z) {
        float dot = this.dot(x, y, z);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3i) {
            Vector3i v = (Vector3i)o;
            return this.equals(v.x, v.y, v.z);
        }
        return false;
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + this.x;
        hash = 47 * hash + this.y;
        hash = 47 * hash + this.z;
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

