/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jiw.unity.runtime.PluginUIManager;
import net.risingworld.api.ui.style.Align;
import net.risingworld.api.ui.style.DisplayStyle;
import net.risingworld.api.ui.style.FlexDirection;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.FontStyle;
import net.risingworld.api.ui.style.Justify;
import net.risingworld.api.ui.style.Overflow;
import net.risingworld.api.ui.style.OverflowClipBox;
import net.risingworld.api.ui.style.Position;
import net.risingworld.api.ui.style.ScaleMode;
import net.risingworld.api.ui.style.StyleColor;
import net.risingworld.api.ui.style.StyleEnum;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleFloat;
import net.risingworld.api.ui.style.StyleImage;
import net.risingworld.api.ui.style.StyleLength;
import net.risingworld.api.ui.style.StyleTransformOrigin;
import net.risingworld.api.ui.style.StyleTranslate;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.ui.style.Visibility;
import net.risingworld.api.ui.style.WhiteSpace;
import net.risingworld.api.ui.style.Wrap;

public class Style {
    private static int BYTES = 1024;
    public final StyleEnum<DisplayStyle> display = new StyleEnum<DisplayStyle>(DisplayStyle.Flex);
    public final StyleEnum<Visibility> visibility = new StyleEnum<Visibility>(Visibility.Visible);
    public final StyleLength left = new StyleLength();
    public final StyleLength right = new StyleLength();
    public final StyleLength top = new StyleLength();
    public final StyleLength bottom = new StyleLength();
    public final StyleLength marginLeft = new StyleLength();
    public final StyleLength marginRight = new StyleLength();
    public final StyleLength marginTop = new StyleLength();
    public final StyleLength marginBottom = new StyleLength();
    public final StyleLength paddingLeft = new StyleLength();
    public final StyleLength paddingRight = new StyleLength();
    public final StyleLength paddingTop = new StyleLength();
    public final StyleLength paddingBottom = new StyleLength();
    public final StyleLength width = new StyleLength();
    public final StyleLength height = new StyleLength();
    public final StyleLength minWidth = new StyleLength();
    public final StyleLength minHeight = new StyleLength();
    public final StyleLength maxWidth = new StyleLength();
    public final StyleLength maxHeight = new StyleLength();
    public final StyleFloat borderLeftWidth = new StyleFloat();
    public final StyleFloat borderRightWidth = new StyleFloat();
    public final StyleFloat borderTopWidth = new StyleFloat();
    public final StyleFloat borderBottomWidth = new StyleFloat();
    public final StyleColor borderLeftColor = new StyleColor();
    public final StyleColor borderRightColor = new StyleColor();
    public final StyleColor borderTopColor = new StyleColor();
    public final StyleColor borderBottomColor = new StyleColor();
    public final StyleLength borderTopLeftRadius = new StyleLength();
    public final StyleLength borderTopRightRadius = new StyleLength();
    public final StyleLength borderBottomLeftRadius = new StyleLength();
    public final StyleLength borderBottomRightRadius = new StyleLength();
    public final StyleColor color = new StyleColor();
    public final StyleColor backgroundColor = new StyleColor();
    public final StyleFloat opacity = new StyleFloat();
    public final StyleEnum<Overflow> overflow = new StyleEnum<Overflow>(Overflow.Visible);
    public final StyleEnum<OverflowClipBox> overflowClipBox = new StyleEnum<OverflowClipBox>(OverflowClipBox.PaddingBox);
    public final StyleFloat rotate = new StyleFloat();
    public final StyleTranslate translate = new StyleTranslate();
    public final StyleTransformOrigin transformOrigin = new StyleTransformOrigin();
    public final StyleEnum<Position> position = new StyleEnum<Position>(Position.Relative);
    public final StyleLength flexBasis = new StyleLength();
    public final StyleEnum<FlexDirection> flexDirection = new StyleEnum<FlexDirection>(FlexDirection.Column);
    public final StyleFloat flexGrow = new StyleFloat();
    public final StyleFloat flexShrink = new StyleFloat();
    public final StyleEnum<Wrap> flexWrap = new StyleEnum<Wrap>(Wrap.NoWrap);
    public final StyleEnum<Justify> justifyContent = new StyleEnum<Justify>(Justify.FlexStart);
    public final StyleEnum<Align> alignContent = new StyleEnum<Align>(Align.Auto);
    public final StyleEnum<Align> alignItems = new StyleEnum<Align>(Align.Auto);
    public final StyleEnum<Align> alignSelf = new StyleEnum<Align>(Align.Auto);
    public final StyleEnum<Font> font = new StyleEnum<Font>(Font.Default);
    public final StyleLength fontSize = new StyleLength();
    public final StyleEnum<FontStyle> fontStyleAndWeight = new StyleEnum<FontStyle>(FontStyle.Normal);
    public final StyleLength paragraphSpacing = new StyleLength();
    public final StyleLength letterSpacing = new StyleLength();
    public final StyleEnum<WhiteSpace> whiteSpace = new StyleEnum<WhiteSpace>(WhiteSpace.Normal);
    public final StyleEnum<TextAnchor> textAlign = new StyleEnum<TextAnchor>(TextAnchor.MiddleCenter);
    public final StyleColor textOutlineColor = new StyleColor();
    public final StyleFloat textOutlineWidth = new StyleFloat();
    public final StyleLength wordSpacing = new StyleLength();
    public final StyleColor backgroundImageTintColor = new StyleColor();
    public final StyleEnum<ScaleMode> backgroundImageScaleMode = new StyleEnum<ScaleMode>(ScaleMode.StretchToFill);
    public final StyleImage backgroundImage = new StyleImage();

    public void reset() {
        try {
            int len = PluginUIManager.StyleFields.size();
            for (int i = 0; i < len; ++i) {
                Field f = (Field)PluginUIManager.StyleFields.get(i);
                Object o = f.get(this);
                if (!(o instanceof StyleField)) continue;
                StyleField field = (StyleField)o;
                field.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] serialize(boolean force, boolean keepDirty) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(BYTES);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            boolean wasDirty = false;
            int len = PluginUIManager.StyleFields.size();
            for (int i = 0; i < len; ++i) {
                Field f = (Field)PluginUIManager.StyleFields.get(i);
                Object o = f.get(this);
                if (o instanceof StyleField) {
                    StyleField field = (StyleField)o;
                    if (force || field.isDirty) {
                        if (!keepDirty) {
                            field.isDirty = false;
                        }
                        buffer.put((byte)1);
                        field.serialize(buffer);
                        wasDirty = true;
                        continue;
                    }
                    buffer.put((byte)0);
                    continue;
                }
                buffer.put((byte)0);
            }
            if (buffer.position() == 0 || !wasDirty) {
                return null;
            }
            byte[] array = new byte[buffer.position()];
            buffer.flip();
            buffer.get(array);
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean deserialize(ByteBuffer buffer) {
        try {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int deserializedFields = 0;
            int len = PluginUIManager.StyleFields.size();
            for (int i = 0; i < len; ++i) {
                Field f = (Field)PluginUIManager.StyleFields.get(i);
                Object o = f.get(this);
                if (buffer.get() == 0 || !(o instanceof StyleField)) continue;
                StyleField field = (StyleField)o;
                field.deserialize(buffer);
                ++deserializedFields;
            }
            return deserializedFields > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

