/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Npcs;
import net.risingworld.api.objects.Clothes;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Skin;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class Npc {
    private final long handle;
    private Skin skin = null;
    private Clothes clothes = null;
    private ConcurrentHashMap<String, Object> attributes = null;

    private Npc(long handle) {
        this.handle = handle;
    }

    public long getGlobalID() {
        return this.handle;
    }

    public Npcs.NpcDefinition getDefinition() {
        return Definitions.getNpcDefinition(this.getTypeID(this.handle));
    }

    public short getTypeID() {
        return this.getTypeID(this.handle);
    }

    private native short getTypeID(long var1);

    public int getVariant() {
        return this.getVariant(this.handle);
    }

    private native int getVariant(long var1);

    public int getGroupID() {
        return this.getGroupID(this.handle);
    }

    private native int getGroupID(long var1);

    public void setGroupID(int groupID) {
        this.setGroupID(this.handle, groupID);
    }

    private native void setGroupID(long var1, int var3);

    public boolean isTransient() {
        return this.isTransient(this.handle);
    }

    private native boolean isTransient(long var1);

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(long var1, String var3);

    public int getAge() {
        return this.getAge(this.handle);
    }

    private native int getAge(long var1);

    public void setAge(int age) {
        this.setAge(this.handle, age);
    }

    private native void setAge(long var1, int var3);

    public Player getNearestPlayer() {
        return this.getNearestPlayer(this.handle);
    }

    private native Player getNearestPlayer(long var1);

    public Player getHostilePlayer() {
        return this.getHostilePlayer(this.handle);
    }

    private native Player getHostilePlayer(long var1);

    public boolean isLocked() {
        return this.isLocked(this.handle);
    }

    private native boolean isLocked(long var1);

    public void setLocked(boolean set) {
        this.setLocked(this.handle, set);
    }

    private native void setLocked(long var1, boolean var3);

    public boolean isInvincible() {
        return this.isInvincible(this.handle);
    }

    private native boolean isInvincible(long var1);

    public void setInvincible(boolean set) {
        this.setInvincible(this.handle, set);
    }

    private native void setInvincible(long var1, boolean var3);

    public Object getRider() {
        return this.getRider(this.handle);
    }

    private native Object getRider(long var1);

    public boolean transform(short typeID, int variant) {
        return this.transform(this.handle, typeID, variant);
    }

    private native boolean transform(long var1, short var3, int var4);

    public Vector3f getPosition() {
        return this.getPosition(this.handle);
    }

    private native Vector3f getPosition(long var1);

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(this.handle, x, y, z);
    }

    private native void setPosition(long var1, float var3, float var4, float var5);

    public void moveTo(Vector3f position) {
        this.moveTo(position.x, position.y, position.z);
    }

    public void moveTo(float x, float y, float z) {
        this.moveTo(this.handle, x, y, z);
    }

    private native void moveTo(long var1, float var3, float var4, float var5);

    public Quaternion getRotation() {
        return this.getRotation(this.handle);
    }

    private native Quaternion getRotation(long var1);

    public void setRotation(Quaternion quaternion) {
        this.setRotation(this.handle, quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    private native void setRotation(long var1, float var3, float var4, float var5, float var6);

    public void setRotation(float pitch, float yaw, float roll) {
        this.setRotationEuler(this.handle, pitch, yaw, roll);
    }

    private native void setRotationEuler(long var1, float var3, float var4, float var5);

    public Vector3f getViewDirection() {
        return this.getViewDirection(this.handle);
    }

    private native Vector3f getViewDirection(long var1);

    public void setViewDirection(Vector3f direction) {
        this.setViewDirection(direction.x, direction.y, direction.z);
    }

    public void setViewDirection(float dirx, float diry, float dirz) {
        this.setViewDirection(this.handle, dirx, diry, dirz);
    }

    private native void setViewDirection(long var1, float var3, float var4, float var5);

    public Vector3f getVectorToNearestPlayer() {
        return this.getVectorToNearestPlayer(this.handle);
    }

    private native Vector3f getVectorToNearestPlayer(long var1);

    public boolean isInWater() {
        return this.isInWater(this.handle);
    }

    private native boolean isInWater(long var1);

    public boolean isUnderwater() {
        return this.isUnderwater(this.handle);
    }

    private native boolean isUnderwater(long var1);

    public void setAlerted(boolean set) {
        this.setAlerted(this.handle, set, 20);
    }

    public void setAlerted(boolean set, int duration) {
        this.setAlerted(this.handle, set, duration);
    }

    private native void setAlerted(long var1, boolean var3, int var4);

    public boolean isAlerted() {
        return this.isAlerted(this.handle);
    }

    private native boolean isAlerted(long var1);

    public int getHealth() {
        return this.getHealth(this.handle);
    }

    private native int getHealth(long var1);

    public void setHealth(int health) {
        this.setHealth(this.handle, health);
    }

    private native void setHealth(long var1, int var3);

    public int getHunger() {
        return this.getHunger(this.handle);
    }

    private native int getHunger(long var1);

    public void setHunger(int hunger) {
        this.setHunger(this.handle, hunger);
    }

    private native void setHunger(long var1, int var3);

    public int getThirst() {
        return this.getThirst(this.handle);
    }

    private native int getThirst(long var1);

    public void setThirst(int thirst) {
        this.setThirst(this.handle, thirst);
    }

    private native void setThirst(long var1, int var3);

    public boolean isSleeping() {
        return this.isSleeping(this.handle);
    }

    private native boolean isSleeping(long var1);

    public boolean isDead() {
        return this.isDead(this.handle);
    }

    private native boolean isDead(long var1);

    public void kill() {
        this.kill(this.handle);
    }

    private native void kill(long var1);

    public void delete() {
        this.delete(this.handle);
    }

    private native void delete(long var1);

    public Skin getSkin() {
        if (this.skin == null) {
            this.skin = new Skin(this.handle, true);
        }
        return this.skin;
    }

    public Clothes getClothes() {
        if (this.clothes == null) {
            this.clothes = new Clothes(this.handle, true);
        }
        return this.clothes;
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean hasAttribute(String key, Class type) {
        if (this.attributes == null) {
            return false;
        }
        Object attribute = this.attributes.get(key);
        return attribute != null && attribute.getClass() == type;
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            this.attributes.remove(key);
        }
    }
}

