/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.events.player.world.PlayerConstructionEvent;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class PlayerPlaceConstructionEvent
extends PlayerConstructionEvent {
    private PlayerPlaceConstructionEvent(long pointer) {
        super(pointer);
    }

    public void setTypeID(byte id) {
        this.CheckIsValid();
        this.setConstructionTypeID(this.pointer, id);
    }

    public void setTextureID(int texture) {
        this.CheckIsValid();
        this.setConstructionTextureID(this.pointer, texture);
    }

    public void setPosition(Vector3f position) {
        this.CheckIsValid();
        if (position == null) {
            return;
        }
        this.setConstructionPosition(this.pointer, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.CheckIsValid();
        this.setConstructionPosition(this.pointer, x, y, z);
    }

    public void setRotation(Quaternion rotation) {
        this.CheckIsValid();
        this.setConstructionRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public void setRotation(float pitch, float yaw, float roll) {
        this.CheckIsValid();
        Quaternion rotation = new Quaternion().fromAngles(pitch, yaw, roll);
        this.setConstructionRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public void setSize(Vector3f size) {
        this.CheckIsValid();
        if (size == null) {
            return;
        }
        this.setConstructionSize(this.pointer, size.x, size.y, size.z);
    }

    public void setSize(float x, float y, float z) {
        this.CheckIsValid();
        this.setConstructionSize(this.pointer, x, y, z);
    }

    public void setColor(int color) {
        this.CheckIsValid();
        this.setConstructionColor(this.pointer, color);
    }

    public int getMultiPlaceRowX() {
        this.CheckIsValid();
        return this.getMultiPlaceRowX(this.pointer);
    }

    public int getMultiPlaceRowY() {
        this.CheckIsValid();
        return this.getMultiPlaceRowY(this.pointer);
    }

    public int getMultiPlaceRowZ() {
        this.CheckIsValid();
        return this.getMultiPlaceRowZ(this.pointer);
    }

    private native void setConstructionTypeID(long var1, byte var3);

    private native void setConstructionTextureID(long var1, int var3);

    private native void setConstructionPosition(long var1, float var3, float var4, float var5);

    private native void setConstructionRotation(long var1, float var3, float var4, float var5, float var6);

    private native void setConstructionSize(long var1, float var3, float var4, float var5);

    private native void setConstructionColor(long var1, int var3);

    private native int getMultiPlaceRowX(long var1);

    private native int getMultiPlaceRowY(long var1);

    private native int getMultiPlaceRowZ(long var1);
}

