/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.npc;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.Event;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class NpcSpawnEvent
extends Event
implements Cancellable {
    private NpcSpawnEvent(long pointer) {
        super(pointer);
    }

    public Npc getNpc() {
        this.CheckIsValid();
        return this.getNpc(this.pointer);
    }

    public long getGlobalID() {
        this.CheckIsValid();
        return this.getGlobalID(this.pointer);
    }

    public short getTypeID() {
        this.CheckIsValid();
        return this.getTypeID(this.pointer);
    }

    public void setTypeID(short newTypeID) {
        this.CheckIsValid();
        this.setTypeID(this.pointer, newTypeID);
    }

    public int getVariation() {
        this.CheckIsValid();
        return this.getVariation(this.pointer);
    }

    public void setVariation(int newVariation) {
        this.CheckIsValid();
        this.setVariation(this.pointer, newVariation);
    }

    public Vector3f getPosition() {
        this.CheckIsValid();
        return this.getPosition(this.pointer);
    }

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.CheckIsValid();
        this.setPosition(this.pointer, x, y, z);
    }

    public Quaternion getRotation() {
        this.CheckIsValid();
        return this.getRotation(this.pointer);
    }

    public void setRotation(Quaternion rotation) {
        this.setRotation(rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public void setRotation(float x, float y, float z, float w) {
        this.CheckIsValid();
        this.setRotation(this.pointer, x, y, z, w);
    }

    public Origin getOrigin() {
        this.CheckIsValid();
        return Origin.get(this.getOrigin(this.pointer));
    }

    public Player getRelatedPlayer() {
        this.CheckIsValid();
        return this.getRelatedPlayer(this.pointer);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native Npc getNpc(long var1);

    private native long getGlobalID(long var1);

    private native short getTypeID(long var1);

    private native void setTypeID(long var1, short var3);

    private native int getVariation(long var1);

    private native void setVariation(long var1, int var3);

    private native Vector3f getPosition(long var1);

    private native void setPosition(long var1, float var3, float var4, float var5);

    private native Quaternion getRotation(long var1);

    private native void setRotation(long var1, float var3, float var4, float var5, float var6);

    private native byte getOrigin(long var1);

    private native Player getRelatedPlayer(long var1);

    public static enum Origin {
        Natural,
        ItemDrop,
        Command,
        API;

        private static Origin[] values;

        private static Origin get(int ordinal) {
            if (values == null) {
                values = Origin.values();
            }
            return values[ordinal];
        }
    }
}

